/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommand;
import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDirectDevice;
import de.adwin.driver.DataToArrayConverter;
import de.adwin.driver.GetDataSHQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

class DataFieldTransfer {
    final InetAddress Connection;
    final DatagramSocket ds;
    final ADwinDirectDevice adw;
    public static final int PACKAGE_OVERHEAD = 8;
    public static final int BYTES_PER_PACKAGE = 1400;
    public static final int BYTES_PER_PACKAGE_WITH_OVERHEAD = 1408;

    DataFieldTransfer(InetAddress ip, DatagramSocket dgs, ADwinDirectDevice ADObject) {
        this.Connection = ip;
        this.ds = dgs;
        this.adw = ADObject;
    }

    void receive(int Length, DataToArrayConverter dtac, String NameReceived) throws ADwinCommunicationError {
        if (this.adw.adl != null) {
            this.adw.adl.enter("DataFieldTransfer.receive (" + Length + ", <DTAC>, \"" + NameReceived + "\")");
        }
        int WordsReceived = 0;
        int CurrentBlock = 0;
        int NumBlockRetryLeft = this.adw.AllowedErrors;
        byte[] DataBytes = new byte[1408];
        byte[] Confirmation = new byte[32];
        DatagramPacket dp = new DatagramPacket(DataBytes, 1408);
        DatagramPacket ConfirmationPacket = new DatagramPacket(Confirmation, 32, this.Connection, this.adw.Port);
        try {
            this.ds.setSoTimeout(this.adw.MaxPacketDelay);
        }
        catch (IOException ioe) {
            if (this.adw.adl != null) {
                this.adw.adl.leave();
            }
            throw new ADwinCommunicationError("Cannot set timeout for socket - " + ioe.getMessage(), "Kann Timeout f\u00fcr Socket nicht festlegen - " + ioe.getMessage(), this.adw.Language, 2000);
        }
        while (WordsReceived < Length) {
            int n;
            boolean[] RecvdPackets = new boolean[this.adw.DataBlockSize];
            for (int n2 = 0; n2 < this.adw.DataBlockSize; ++n2) {
                RecvdPackets[n2] = false;
            }
            int NumPacketsMissing = (Length - WordsReceived - 1) / 350 + 1;
            if (NumPacketsMissing > this.adw.DataBlockSize) {
                NumPacketsMissing = this.adw.DataBlockSize;
            }
            ++CurrentBlock;
            for (int Packet = 0; Packet < NumPacketsMissing; ++Packet) {
                boolean SomethingReceived = true;
                try {
                    this.ds.receive(dp);
                }
                catch (SocketTimeoutException ste) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("Timeout beim empfangen vom DATA", 50);
                    }
                    SomethingReceived = false;
                }
                catch (IOException ioe) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("IOException -> ADwinCommunicationError in DataFieldTransfer.receive", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Exception: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
                }
                if (!SomethingReceived) break;
                int BlockIndex = ADwinDirectDevice.extractInt(DataBytes, 0);
                if (BlockIndex < 0) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("Block index < 0 received", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("Invalid block index received when receiving " + NameReceived + ".", "Ung\u00fcltigen Blockindex beim Empfangen von " + NameReceived + " empfangen", this.adw.Language, 2000);
                }
                if (BlockIndex != CurrentBlock) {
                    --Packet;
                    if (this.adw.adl == null) continue;
                    this.adw.adl.message("Ung\u00fcltiger Block-Index (Erwartet: " + CurrentBlock + ", erhalten: " + BlockIndex + ")", 50);
                    continue;
                }
                if (dp.getLength() != 1408) {
                    --Packet;
                    if (this.adw.adl == null) continue;
                    this.adw.adl.message("Falsche Gr\u00f6\u00dfe: " + dp.getLength(), 50);
                    continue;
                }
                int PacketIndex = ADwinDirectDevice.extractInt(DataBytes, 4);
                RecvdPackets[PacketIndex] = true;
                int DataWordsCount = WordsReceived + (PacketIndex + 1) * 350 <= Length ? 350 : Length % 350;
                dtac.storeBytes(DataBytes, 8, WordsReceived + PacketIndex * 350, DataWordsCount);
            }
            int MaxIndexRecvd = NumPacketsMissing + 1;
            boolean AnythingReceived = false;
            for (n = 0; n < this.adw.DataBlockSize; ++n) {
                if (!RecvdPackets[n] && MaxIndexRecvd == NumPacketsMissing + 1) {
                    MaxIndexRecvd = n;
                }
                if (!RecvdPackets[n]) continue;
                AnythingReceived = true;
            }
            if (MaxIndexRecvd > NumPacketsMissing) {
                MaxIndexRecvd = NumPacketsMissing;
            }
            if (!AnythingReceived) {
                --CurrentBlock;
            }
            WordsReceived += MaxIndexRecvd * 350;
            if (MaxIndexRecvd == 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Keine Pakete empfangen (WordsReceived = " + WordsReceived + ")", 50);
                }
                --NumBlockRetryLeft;
            } else {
                NumBlockRetryLeft = this.adw.AllowedErrors;
            }
            if (NumBlockRetryLeft == 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Could not receive packets for " + NameReceived + ", number of timeouts exceeded AllowedErrors", "Konnte Pakete f\u00fcr " + NameReceived + " nicht empfangen, Anzahl der erlaubten Timeouts \u00fcberschritten", this.adw.Language, 2001);
            }
            if (AnythingReceived) {
                for (n = 0; n < 32; ++n) {
                    Confirmation[n] = 0;
                }
                if (MaxIndexRecvd != NumPacketsMissing) {
                    ADwinDirectDevice.setInteger(Confirmation, 0, -20);
                    ADwinDirectDevice.setInteger(Confirmation, 4, CurrentBlock);
                    ADwinDirectDevice.setInteger(Confirmation, 8, MaxIndexRecvd);
                } else {
                    ADwinDirectDevice.setInteger(Confirmation, 0, 0);
                    ADwinDirectDevice.setInteger(Confirmation, 4, CurrentBlock);
                    ADwinDirectDevice.setInteger(Confirmation, 8, 0);
                }
            }
            try {
                this.ds.send(ConfirmationPacket);
            }
            catch (IOException ioe) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
        }
        if (this.adw.adl != null) {
            this.adw.adl.leave();
        }
    }

    void receiveADwinX(int Count, DataToArrayConverter dtac, String NameReceived) throws ADwinCommunicationError {
        if (this.adw.adl != null) {
            this.adw.adl.enter("DataFieldTransfer.receiveADwinX (" + Count + ", <DTAC>, \"" + NameReceived + "\")");
        }
        int WordsReceived = 0;
        int CurrentBlock = 0;
        int NumBlockRetryLeft = this.adw.AllowedErrors;
        int bytes_per_value = this.adw.BytesPerValue(dtac.getSourceType());
        int values_per_package = bytes_per_value == 8 ? 175 : 350;
        byte[] DataBytes = new byte[1408];
        byte[] Confirmation = new byte[32];
        DatagramPacket dp = new DatagramPacket(DataBytes, 1408);
        DatagramPacket ConfirmationPacket = new DatagramPacket(Confirmation, 32, this.Connection, this.adw.Port);
        try {
            this.ds.setSoTimeout(this.adw.MaxPacketDelay);
        }
        catch (IOException ioe) {
            if (this.adw.adl != null) {
                this.adw.adl.leave();
            }
            throw new ADwinCommunicationError("Cannot set timeout for socket - " + ioe.getMessage(), "Kann Timeout f\u00fcr Socket nicht festlegen - " + ioe.getMessage(), this.adw.Language, 2000);
        }
        while (WordsReceived < Count) {
            int n;
            boolean[] RecvdPackets = new boolean[this.adw.DataBlockSize];
            for (int n2 = 0; n2 < this.adw.DataBlockSize; ++n2) {
                RecvdPackets[n2] = false;
            }
            int NumPacketsMissing = (Count - WordsReceived - 1) / values_per_package + 1;
            if (NumPacketsMissing > this.adw.DataBlockSize) {
                NumPacketsMissing = this.adw.DataBlockSize;
            }
            ++CurrentBlock;
            for (int Packet = 0; Packet < NumPacketsMissing; ++Packet) {
                boolean SomethingReceived = true;
                try {
                    this.ds.receive(dp);
                }
                catch (SocketTimeoutException ste) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("Timeout beim empfangen vom DATA", 50);
                    }
                    SomethingReceived = false;
                }
                catch (IOException ioe) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("IOException -> ADwinCommunicationError in DataFieldTransfer.receive", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Exception: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
                }
                if (!SomethingReceived) break;
                int BlockIndex = ADwinDirectDevice.extractInt(DataBytes, 0);
                if (BlockIndex < 0) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("Block index < 0 received", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("Invalid block index received when receiving " + NameReceived + ".", "Ung\u00fcltigen Blockindex beim Empfangen von " + NameReceived + " empfangen", this.adw.Language, 2000);
                }
                if (BlockIndex != CurrentBlock) {
                    --Packet;
                    if (this.adw.adl == null) continue;
                    this.adw.adl.message("Ung\u00fcltiger Block-Index (Erwartet: " + CurrentBlock + ", erhalten: " + BlockIndex + ")", 50);
                    continue;
                }
                if (dp.getLength() != 1408) {
                    --Packet;
                    if (this.adw.adl == null) continue;
                    this.adw.adl.message("Falsche Gr\u00f6\u00dfe: " + dp.getLength(), 50);
                    continue;
                }
                int PacketIndex = ADwinDirectDevice.extractInt(DataBytes, 4);
                RecvdPackets[PacketIndex] = true;
                int DataWordsCount = WordsReceived + (PacketIndex + 1) * values_per_package <= Count ? values_per_package : Count % values_per_package;
                dtac.storeBytes(DataBytes, 8, WordsReceived + PacketIndex * values_per_package, DataWordsCount);
            }
            int MaxIndexRecvd = NumPacketsMissing + 1;
            boolean AnythingReceived = false;
            for (n = 0; n < this.adw.DataBlockSize; ++n) {
                if (!RecvdPackets[n] && MaxIndexRecvd == NumPacketsMissing + 1) {
                    MaxIndexRecvd = n;
                }
                if (!RecvdPackets[n]) continue;
                AnythingReceived = true;
            }
            if (MaxIndexRecvd > NumPacketsMissing) {
                MaxIndexRecvd = NumPacketsMissing;
            }
            if (!AnythingReceived) {
                --CurrentBlock;
            }
            WordsReceived += MaxIndexRecvd * values_per_package;
            if (MaxIndexRecvd == 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Keine Pakete empfangen (WordsReceived = " + WordsReceived + ")", 50);
                }
                --NumBlockRetryLeft;
            } else {
                NumBlockRetryLeft = this.adw.AllowedErrors;
            }
            if (NumBlockRetryLeft == 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Could not receive packets for " + NameReceived + ", number of timeouts exceeded AllowedErrors", "Konnte Pakete f\u00fcr " + NameReceived + " nicht empfangen, Anzahl der erlaubten Timeouts \u00fcberschritten", this.adw.Language, 2001);
            }
            if (AnythingReceived) {
                for (n = 0; n < 32; ++n) {
                    Confirmation[n] = 0;
                }
                if (MaxIndexRecvd != NumPacketsMissing) {
                    ADwinDirectDevice.setInteger(Confirmation, 0, -20);
                    ADwinDirectDevice.setInteger(Confirmation, 4, CurrentBlock);
                    ADwinDirectDevice.setInteger(Confirmation, 8, MaxIndexRecvd);
                } else {
                    ADwinDirectDevice.setInteger(Confirmation, 0, 0);
                    ADwinDirectDevice.setInteger(Confirmation, 4, CurrentBlock);
                    ADwinDirectDevice.setInteger(Confirmation, 8, 0);
                }
            }
            try {
                this.ds.send(ConfirmationPacket);
            }
            catch (IOException ioe) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
        }
        if (this.adw.adl != null) {
            this.adw.adl.leave();
        }
    }

    int receiveFast(int Count, DataToArrayConverter dtac, int Offset, int ExpectedPacketIndex, int[] WordsReceived) throws ADwinCommunicationError {
        int n;
        byte[] PacketData = new byte[1416];
        DatagramPacket dp = new DatagramPacket(PacketData, 1416);
        int NumPacketsToReceive = (Count - 1) / 350 + 1;
        boolean[] PacketsRecvd = new boolean[NumPacketsToReceive];
        boolean SomethingReceived = true;
        try {
            this.ds.setSoTimeout(this.adw.MaxPacketDelay);
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("Cannot set timeout for socket - " + ioe.getMessage(), "Kann Timeout f\u00fcr Socket nicht festlegen - " + ioe.getMessage(), this.adw.Language, 2000);
        }
        for (n = 0; n < NumPacketsToReceive && SomethingReceived; ++n) {
            int NumDataWords;
            try {
                this.ds.receive(dp);
            }
            catch (SocketTimeoutException ste) {
                SomethingReceived = false;
            }
            catch (IOException ioe) {
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
            if (!SomethingReceived) continue;
            if (!this.adw.newTryLater() && ADwinDirectDevice.extractInt(PacketData, 0) == -10) break;
            if (ADwinDirectDevice.extractInt(PacketData, 4) != ExpectedPacketIndex) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Falscher Paket-Index empfangen, erwartet: " + ExpectedPacketIndex + ", erhalten: " + ADwinDirectDevice.extractInt(PacketData, 4), 50);
                }
                --n;
                continue;
            }
            if (ADwinDirectDevice.extractInt(PacketData, 0) != 0) break;
            int IndexBlock = ADwinDirectDevice.extractInt(PacketData, 1408);
            PacketsRecvd[IndexBlock] = true;
            if (IndexBlock == NumPacketsToReceive - 1) {
                NumDataWords = Count % 350;
                if (NumDataWords == 0) {
                    NumDataWords = 350;
                }
            } else {
                NumDataWords = 350;
            }
            if (dtac.getSourceType() == 0) {
                dtac.setSourceType(ADwinDirectDevice.extractInt(PacketData, 1412));
            }
            dtac.storeBytes(PacketData, 8, IndexBlock * 350 + Offset, NumDataWords);
        }
        for (n = 0; n < NumPacketsToReceive && PacketsRecvd[n]; ++n) {
        }
        WordsReceived[0] = n * 350;
        if (SomethingReceived) {
            return ADwinDirectDevice.extractInt(PacketData, 0);
        }
        return 0;
    }

    int receiveFastADwinX(int Count, DataToArrayConverter dtac, int Offset, int ExpectedPacketIndex, int[] WordsReceived) throws ADwinCommunicationError {
        int n;
        byte[] PacketData = new byte[1416];
        DatagramPacket dp = new DatagramPacket(PacketData, 1416);
        int NumPacketsToReceive = (Count * 2 - 1) / 350 + 1;
        boolean[] PacketsRecvd = new boolean[NumPacketsToReceive];
        boolean SomethingReceived = true;
        try {
            this.ds.setSoTimeout(this.adw.MaxPacketDelay);
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("Cannot set timeout for socket - " + ioe.getMessage(), "Kann Timeout f\u00fcr Socket nicht festlegen - " + ioe.getMessage(), this.adw.Language, 2000);
        }
        for (n = 0; n < NumPacketsToReceive && SomethingReceived; ++n) {
            int NumDataWords;
            try {
                this.ds.receive(dp);
            }
            catch (SocketTimeoutException ste) {
                SomethingReceived = false;
            }
            catch (IOException ioe) {
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
            if (!SomethingReceived) continue;
            if (!this.adw.newTryLater() && ADwinDirectDevice.extractInt(PacketData, 0) == -10) break;
            if (ADwinDirectDevice.extractInt(PacketData, 4) != ExpectedPacketIndex) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Falscher Paket-Index empfangen, erwartet: " + ExpectedPacketIndex + ", erhalten: " + ADwinDirectDevice.extractInt(PacketData, 4), 50);
                }
                --n;
                continue;
            }
            if (ADwinDirectDevice.extractInt(PacketData, 0) != 0) break;
            if (dtac.getSourceType() == 0) {
                dtac.setSourceType(ADwinDirectDevice.extractInt(PacketData, 1412));
                if (dtac.getSourceType() != 6) {
                    NumPacketsToReceive = (Count - 1) / 350 + 1;
                }
            }
            int IndexBlock = ADwinDirectDevice.extractInt(PacketData, 1408);
            PacketsRecvd[IndexBlock] = true;
            if (dtac.getSourceType() == 6) {
                if (IndexBlock == NumPacketsToReceive - 1) {
                    NumDataWords = Count % 175;
                    if (NumDataWords == 0) {
                        NumDataWords = 175;
                    }
                } else {
                    NumDataWords = 175;
                }
                dtac.storeBytes(PacketData, 8, IndexBlock * 175 + Offset, NumDataWords);
                continue;
            }
            if (IndexBlock == NumPacketsToReceive - 1) {
                NumDataWords = Count % 350;
                if (NumDataWords == 0) {
                    NumDataWords = 350;
                }
            } else {
                NumDataWords = 350;
            }
            dtac.storeBytes(PacketData, 8, IndexBlock * 350 + Offset, NumDataWords);
        }
        for (n = 0; n < NumPacketsToReceive && PacketsRecvd[n]; ++n) {
        }
        WordsReceived[0] = n * 350;
        if (SomethingReceived) {
            return ADwinDirectDevice.extractInt(PacketData, 0);
        }
        return 0;
    }

    void send(int ByteCount, byte[] Data, String NameSend, int requestPacketIndex) throws ADwinCommunicationError {
        if (this.adw.adl != null) {
            this.adw.adl.enter("DataFieldTransfer.send (" + ByteCount + ", <byte[]>, \"" + NameSend + "\")");
        }
        byte[] PacketData = new byte[1408];
        byte[] ConfirmData = new byte[32];
        DatagramPacket dp = new DatagramPacket(PacketData, PacketData.length, this.Connection, this.adw.Port);
        DatagramPacket ConfPacket = new DatagramPacket(ConfirmData, 32);
        int BytesLeftToSend = ByteCount;
        int Block = 0;
        int NumBlockErrors = 0;
        int DataIndex = 0;
        boolean InvalidBlockIndexRecvd = false;
        while (BytesLeftToSend > 0) {
            int NumPackets = (BytesLeftToSend - 1) / 1400 + 1;
            if (NumPackets > this.adw.DataBlockSize) {
                NumPackets = this.adw.DataBlockSize;
            }
            for (int Packet = 0; Packet < NumPackets && !InvalidBlockIndexRecvd; ++Packet) {
                int length;
                if (DataIndex + (Packet + 1) * 350 * 4 > ByteCount) {
                    length = BytesLeftToSend % 1400;
                    if (length == 0) {
                        length = 1400;
                    }
                } else {
                    length = 1400;
                }
                for (int n = 0; n < length; ++n) {
                    PacketData[n + 8] = Data[n + DataIndex + Packet * 350 * 4];
                }
                ADwinDirectDevice.setInteger(PacketData, 0, Block + 1);
                ADwinDirectDevice.setInteger(PacketData, 4, Packet);
                try {
                    this.ds.send(dp);
                    continue;
                }
                catch (IOException ioe) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
                }
            }
            InvalidBlockIndexRecvd = false;
            boolean ConfirmationReceived = false;
            try {
                this.ds.setSoTimeout(this.adw.MaxPacketDelay * 2 + this.adw.ADwTimeout);
                this.ds.receive(ConfPacket);
                ConfirmationReceived = true;
            }
            catch (SocketTimeoutException ste) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("SocketTimeoutException beim Warten auf Best\u00e4tigung", 50);
                }
            }
            catch (IOException ioe) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
            if (!ConfirmationReceived || ADwinDirectDevice.extractInt(ConfirmData, 4) != Block + 1) {
                if (ConfirmationReceived) {
                    int packetIndex = ADwinDirectDevice.extractInt(ConfirmData, 4);
                    int packetStatus = ADwinDirectDevice.extractInt(ConfirmData, 0);
                    if (packetIndex == requestPacketIndex) {
                        if (this.adw.adl != null) {
                            this.adw.adl.message("SetData - Paket mit BlockIndex == requestPacketIndex (= " + packetIndex + ") empfangen, Status = " + packetStatus, 50);
                        }
                        switch (packetStatus) {
                            case 1: {
                                if (this.adw.adl != null) {
                                    this.adw.adl.leave();
                                }
                                throw new ADwinCommunicationError("Timeout to link when trying to send " + NameSend, "Timeout beim Schreiben zum ADwin-System beim senden von " + NameSend, this.adw.Language, 1);
                            }
                            case 2: {
                                if (this.adw.adl != null) {
                                    this.adw.adl.leave();
                                }
                                throw new ADwinCommunicationError("Timeout from link when trying to send " + NameSend, "Timeout beim Lesen vom ADwin-System beim senden von " + NameSend, this.adw.Language, 2);
                            }
                            case 5: {
                                if (this.adw.adl != null) {
                                    this.adw.adl.leave();
                                }
                                throw new ADwinCommunicationError("Too many block errors when sending " + NameSend, "Zu viele fehlerhafte Bl\u00f6cke beim Senden von " + NameSend, this.adw.Language, 2000);
                            }
                        }
                    }
                    if (packetIndex == Block && NumBlockErrors > 1) {
                        if (this.adw.adl != null) {
                            this.adw.adl.message("Best\u00e4tigung f\u00fcr alten Block erhalten, sende den gleichen Block nochmal.", 50);
                        }
                        if (++NumBlockErrors > this.adw.AllowedErrors) {
                            if (this.adw.adl != null) {
                                this.adw.adl.message("Zu viele Fehler auf einmal -> Exception", 1);
                                this.adw.adl.leave();
                            }
                            throw new ADwinCommunicationError("Cannot send " + NameSend, "Kann " + NameSend + " nicht senden", this.adw.Language, 2000);
                        }
                        InvalidBlockIndexRecvd = true;
                        continue;
                    }
                    if (this.adw.adl != null) {
                        this.adw.adl.message("F\u00fcr Best\u00e4tigung: Erwartet: " + (Block + 1) + ", erhalten: " + ADwinDirectDevice.extractInt(ConfirmData, 4), 50);
                    }
                    InvalidBlockIndexRecvd = true;
                }
                if (++NumBlockErrors <= this.adw.AllowedErrors) continue;
                if (this.adw.adl != null) {
                    this.adw.adl.message("Zu viele Fehler auf einmal -> Exception", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Cannot send " + NameSend, "Kann " + NameSend + " nicht senden", this.adw.Language, 2000);
            }
            ++Block;
            NumBlockErrors = 0;
            if (ADwinDirectDevice.extractInt(ConfirmData, 0) == 5) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Error 5...", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Too many block errors when sending " + NameSend, "Zu viele fehlerhafte Bl\u00f6cke beim Senden von " + NameSend, this.adw.Language, 2000);
            }
            if (ADwinDirectDevice.extractInt(ConfirmData, 0) != 0) {
                int FirstPacketMissing = ADwinDirectDevice.extractInt(ConfirmData, 8);
                BytesLeftToSend -= FirstPacketMissing * 350 * 4;
                DataIndex += FirstPacketMissing * 350 * 4;
                continue;
            }
            BytesLeftToSend -= this.adw.DataBlockSize * 350 * 4;
            DataIndex += this.adw.DataBlockSize * 350 * 4;
        }
        if (this.adw.adl != null) {
            this.adw.adl.leave();
        }
    }

    void getArraySH(int packetIndex, int count, DataToArrayConverter dtac, InetAddress addr, int port) throws ADwinCommunicationError {
        GetDataSHQueue gdshq = new GetDataSHQueue(40, packetIndex, this.ds, this.adw, addr, port);
        gdshq.getArraySH(count, dtac);
    }

    void readFifo(int FifoNr, int Type2, int NumWords, DataToArrayConverter dtac, int DtacOffset) throws ADwinCommunicationError {
        if (this.adw.adl != null) {
            this.adw.adl.enter("DataFieldTransfer.readFifo (" + FifoNr + ", " + Type2 + ", " + NumWords + ", <DTAC>, " + DtacOffset + ")");
        }
        int CMD_GET_FIFO_RETRY = 124;
        int CMD_GET_FIFO = 24;
        boolean EverythingReceived = false;
        boolean Retry = false;
        int SentIndex = 0;
        int RetryIndex = 0;
        byte[] PacketData = new byte[1408];
        DatagramPacket dp = new DatagramPacket(PacketData, 1408);
        int ErrorsLeft = this.adw.AllowedErrors;
        int TryLatersLeft = this.adw.NumWaits;
        int PacketsToReceive = (NumWords - 1) / 350 + 1;
        if (dtac.getSourceType() == 6) {
            PacketsToReceive = (NumWords - 1) / 175 + 1;
        }
        while (!EverythingReceived) {
            boolean SomethingReceived;
            if (ErrorsLeft < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Too many errors", "zu viele Fehler", this.adw.Language, 2001);
            }
            if (TryLatersLeft < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Too many try-later-packets", "zu viele Try-Later-Pakete", this.adw.Language, 16);
            }
            ADwinCommand adwc = new ADwinCommand(this.adw.version, this.adw.DLLVersion, this.adw.Port);
            adwc.setPwd(this.adw.Password);
            adwc.setTimeout(this.adw.ADwTimeout);
            int[] Values = new int[]{Type2, FifoNr + (this.adw.DataBlockSize << 16), 0, NumWords};
            adwc.setValues(Values);
            if (Retry) {
                Values[2] = RetryIndex;
                adwc.setValues(Values);
                adwc.setPacketIndex(SentIndex);
                adwc.setCommand(124);
            } else {
                Values[2] = 0;
                adwc.setValues(Values);
                RetryIndex = SentIndex = this.adw.incGetCurrentIndex();
                adwc.setPacketIndex(SentIndex);
                adwc.setCommand(24);
            }
            try {
                this.ds.send(adwc.getDatagram(this.Connection));
            }
            catch (IOException ioe) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
            try {
                this.ds.setSoTimeout(this.adw.MaxPacketDelay);
                this.ds.receive(dp);
            }
            catch (SocketTimeoutException ste) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Timeout beim warten auf 1. Datenpaket", 50);
                }
                Retry = true;
                --ErrorsLeft;
                continue;
            }
            catch (IOException ioe) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
            if (ADwinDirectDevice.extractInt(PacketData, 0) == -10) {
                if (this.adw.adl != null) {
                    this.adw.adl.tryLater(SentIndex, this.adw.NumWaits - TryLatersLeft);
                }
                try {
                    Thread.sleep(this.adw.WaitTime);
                }
                catch (InterruptedException ioe) {
                    // empty catch block
                }
                --TryLatersLeft;
                ErrorsLeft = this.adw.AllowedErrors;
                continue;
            }
            TryLatersLeft = this.adw.NumWaits;
            if (ADwinDirectDevice.extractInt(PacketData, 0) == -41) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Fehler -41 => Anfrage wird nochmal verschickt", 50);
                }
                Retry = false;
                continue;
            }
            if (ADwinDirectDevice.extractInt(PacketData, 0) == -32) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("No more data in fifo", 1);
                }
                throw new ADwinCommunicationError("Not enough data in fifo", "Nicht genug Daten im Fifo", this.adw.Language, 102);
            }
            if (ADwinDirectDevice.extractInt(PacketData, 0) < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Fehler " + ADwinDirectDevice.extractInt(PacketData, 0) + " => Retry-Paket wird verschickt", 50);
                }
                Retry = true;
                --ErrorsLeft;
                continue;
            }
            Retry = false;
            boolean[] RecvdPackets = new boolean[PacketsToReceive];
            for (int n = 0; n < PacketsToReceive; ++n) {
                RecvdPackets[n] = false;
            }
            do {
                if (ADwinDirectDevice.extractInt(PacketData, 0) == SentIndex) {
                    int PacketIndex = ADwinDirectDevice.extractInt(PacketData, 4);
                    int NumDataWords = PacketIndex != PacketsToReceive - 1 ? 350 : NumWords % 350;
                    if (NumDataWords == 0) {
                        NumDataWords = 350;
                    }
                    if (dtac.getSourceType() == 6) {
                        if (NumDataWords >= 350) {
                            dtac.storeBytes(PacketData, 8, DtacOffset + PacketIndex * 175, NumDataWords / 2);
                        } else {
                            dtac.storeBytes(PacketData, 8, DtacOffset + PacketIndex * 175, NumDataWords);
                        }
                    } else {
                        dtac.storeBytes(PacketData, 8, DtacOffset + PacketIndex * 350, NumDataWords);
                    }
                    RecvdPackets[PacketIndex] = true;
                    EverythingReceived = true;
                    for (int n = 0; n < PacketsToReceive; ++n) {
                        EverythingReceived = EverythingReceived && RecvdPackets[n];
                    }
                    if (EverythingReceived) {
                        break;
                    }
                } else if (this.adw.adl != null) {
                    this.adw.adl.message("Falscher Paket-Index empfangen (erhalten: " + ADwinDirectDevice.extractInt(PacketData, 0) + ", erwartet: " + SentIndex + ")", 50);
                }
                SomethingReceived = true;
                try {
                    this.ds.receive(dp);
                }
                catch (SocketTimeoutException ste) {
                    SomethingReceived = false;
                }
                catch (IOException ioe) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
                }
            } while (SomethingReceived);
            if (EverythingReceived) continue;
            if (this.adw.adl != null) {
                this.adw.adl.message("Nicht alles empfangen => Retry", 50);
            }
            --ErrorsLeft;
            Retry = true;
        }
        if (this.adw.adl != null) {
            this.adw.adl.leave();
        }
    }

    void readFifo_angepasst(int FifoNr, int Type2, int NumWords, DataToArrayConverter dtac, int DtacOffset) throws ADwinCommunicationError {
        if (this.adw.adl != null) {
            this.adw.adl.enter("DataFieldTransfer.readFifo (" + FifoNr + ", " + Type2 + ", " + NumWords + ", <DTAC>, " + DtacOffset + ")");
        }
        int CMD_GET_FIFO_RETRY = 124;
        int CMD_GET_FIFO = 24;
        int bytes_per_value = this.adw.BytesPerValue(Type2);
        int values_per_package = bytes_per_value == 8 ? 175 : 350;
        float SizeFactor = 1.0f;
        if (bytes_per_value == 8) {
            SizeFactor = 2.0f;
        }
        boolean EverythingReceived = false;
        boolean Retry = false;
        int SentIndex = 0;
        int RetryIndex = 0;
        byte[] PacketData = new byte[1408];
        DatagramPacket dp = new DatagramPacket(PacketData, 1408);
        int ErrorsLeft = this.adw.AllowedErrors;
        int TryLatersLeft = this.adw.NumWaits;
        int PacketsToReceive = (int)(((float)NumWords * SizeFactor - 1.0f) / (float)values_per_package + 1.0f);
        while (!EverythingReceived) {
            boolean SomethingReceived;
            if (ErrorsLeft < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Too many errors", "zu viele Fehler", this.adw.Language, 2001);
            }
            if (TryLatersLeft < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Too many try-later-packets", "zu viele Try-Later-Pakete", this.adw.Language, 16);
            }
            ADwinCommand adwc = new ADwinCommand(this.adw.version, this.adw.DLLVersion, this.adw.Port);
            adwc.setPwd(this.adw.Password);
            adwc.setTimeout(this.adw.ADwTimeout);
            int[] Values = new int[]{Type2, FifoNr + (this.adw.DataBlockSize << 16), 0, NumWords};
            adwc.setValues(Values);
            if (Retry) {
                Values[2] = RetryIndex;
                adwc.setValues(Values);
                adwc.setPacketIndex(SentIndex);
                adwc.setCommand(124);
            } else {
                Values[2] = 0;
                adwc.setValues(Values);
                RetryIndex = SentIndex = this.adw.incGetCurrentIndex();
                adwc.setPacketIndex(SentIndex);
                adwc.setCommand(24);
            }
            try {
                this.ds.send(adwc.getDatagram(this.Connection));
            }
            catch (IOException ioe) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
            try {
                this.ds.setSoTimeout(this.adw.MaxPacketDelay);
                this.ds.receive(dp);
            }
            catch (SocketTimeoutException ste) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Timeout beim warten auf 1. Datenpaket", 50);
                }
                Retry = true;
                --ErrorsLeft;
                continue;
            }
            catch (IOException ioe) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
            }
            if (ADwinDirectDevice.extractInt(PacketData, 0) == -10) {
                if (this.adw.adl != null) {
                    this.adw.adl.tryLater(SentIndex, this.adw.NumWaits - TryLatersLeft);
                }
                try {
                    Thread.sleep(this.adw.WaitTime);
                }
                catch (InterruptedException ioe) {
                    // empty catch block
                }
                --TryLatersLeft;
                ErrorsLeft = this.adw.AllowedErrors;
                continue;
            }
            TryLatersLeft = this.adw.NumWaits;
            if (ADwinDirectDevice.extractInt(PacketData, 0) == -41) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Fehler -41 => Anfrage wird nochmal verschickt", 50);
                }
                Retry = false;
                continue;
            }
            if (ADwinDirectDevice.extractInt(PacketData, 0) == -32) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("No more data in fifo", 1);
                }
                throw new ADwinCommunicationError("Not enough data in fifo", "Nicht genug Daten im Fifo", this.adw.Language, 102);
            }
            if (ADwinDirectDevice.extractInt(PacketData, 0) < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Fehler " + ADwinDirectDevice.extractInt(PacketData, 0) + " => Retry-Paket wird verschickt", 50);
                }
                Retry = true;
                --ErrorsLeft;
                continue;
            }
            Retry = false;
            boolean[] RecvdPackets = new boolean[PacketsToReceive];
            for (int n = 0; n < PacketsToReceive; ++n) {
                RecvdPackets[n] = false;
            }
            do {
                if (ADwinDirectDevice.extractInt(PacketData, 0) == SentIndex) {
                    int PacketIndex = ADwinDirectDevice.extractInt(PacketData, 4);
                    int NumDataWords = PacketIndex != PacketsToReceive - 1 ? values_per_package : NumWords % values_per_package;
                    if (NumDataWords == 0) {
                        NumDataWords = values_per_package;
                    }
                    dtac.storeBytes(PacketData, 8, DtacOffset + PacketIndex * values_per_package, NumDataWords);
                    RecvdPackets[PacketIndex] = true;
                    EverythingReceived = true;
                    for (int n = 0; n < PacketsToReceive; ++n) {
                        EverythingReceived = EverythingReceived && RecvdPackets[n];
                    }
                    if (EverythingReceived) {
                        break;
                    }
                } else if (this.adw.adl != null) {
                    this.adw.adl.message("Falscher Paket-Index empfangen (erhalten: " + ADwinDirectDevice.extractInt(PacketData, 0) + ", erwartet: " + SentIndex + ")", 50);
                }
                SomethingReceived = true;
                try {
                    this.ds.receive(dp);
                }
                catch (SocketTimeoutException ste) {
                    SomethingReceived = false;
                }
                catch (IOException ioe) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.adw.Language, 2000);
                }
            } while (SomethingReceived);
            if (EverythingReceived) continue;
            if (this.adw.adl != null) {
                this.adw.adl.message("Nicht alles empfangen => Retry", 50);
            }
            --ErrorsLeft;
            Retry = true;
        }
        if (this.adw.adl != null) {
            this.adw.adl.leave();
        }
    }
}

