/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommand;
import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDebugListener;
import de.adwin.driver.ADwinDebugListenerPrioConstants;
import de.adwin.driver.DataFieldTransfer;
import de.adwin.driver.DataToArrayConverter;
import de.adwin.driver.DataToByteArray;
import de.adwin.driver.DataToDoubleArray;
import de.adwin.driver.DataToFloatArray;
import de.adwin.driver.DataToInt64Array;
import de.adwin.driver.DataToIntArray;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

class ADwinDirectDevice
implements ADwinDebugListenerPrioConstants {
    private final int k_3plus1 = 0;
    private final int k_GetPar = 1;
    private final int k_Start = 2;
    private final int k_Stop = 3;
    private final int k_lMemory = 5;
    private final int k_SetPar = 6;
    private final int k_Clear_Data = 9;
    private final int k_GetDataLength = 11;
    private final int k_MemoryAll = 12;
    private final int k_ClearProcess = 14;
    private final int k_ADC = 15;
    private final int k_DAC = 16;
    private final int k_GetDigin = 17;
    private final int k_SetDigout = 18;
    private final int k_GetDigout = 19;
    private final int k_Auslastung = 20;
    private final int k_ClearFifo = 21;
    private final int k_GetFifoEmpty = 22;
    private final int k_GetFifoCount = 23;
    private final int k_LadeBin = 4;
    private final int k_GetDataStringSize = 44;
    private final int k_GetDataInfo = 45;
    private final int k_GetDataType = 100;
    private final int k_GetData = 7;
    private final int k_GetDataShiftedHandshake = 107;
    private final int k_GetDatasmall = 207;
    private final int k_SetData = 8;
    private final int k_SetDataLastStatus = 108;
    private final int k_CreateData = 10;
    private final int k_GetParAll = 13;
    private final int k_GetFifo = 24;
    private final int k_GetFifoRetry = 124;
    private final int k_SetFifo = 25;
    private final int k_SetFifoRetry = 125;
    private final int k_Boot = 50;
    private final int k_ARMVersion = 1000;
    private final int k_TestVersion = 255;
    private final int k_Authenticate = 300;
    private final int k_GetMemoryDSP = 1000000;
    private final int k_ok = 0;
    private final int k_Data_is_to_small = 100;
    private final int k_Fifo_is_to_small = 101;
    private final int k_Fifo_to_less_data = 102;
    private final int k_Mem_Error = 150;
    private final int k_File_not_found = 200;
    private final int k_File_not_binaer = 202;
    private final int k_File_not_valid = 203;
    private final int k_File_not_btl = 204;
    private final int k_WrongBinFile = 205;
    private final int k_error_tcp_error = 2000;
    private final int k_error_tcp_timout_read = 2001;
    private final int k_error_tcp_password = 2002;
    private final int VAL_GET_PAR = 1;
    private final int CMD_GET_VERSION = 255;
    private final int CMD_GET_DATA_TYPE = 100;
    private final int CMD_VAL_GET_DATA = 7;
    private final int VAL_GET_DATA_LENGTH = 11;
    private final int CMD_GET_DATA_SMALL = 207;
    private final int CMD_LOAD_BINARY = 4;
    private final int VAL_START = 2;
    private final int VAL_STOP = 3;
    private final int CMD_BOOT = 50;
    private final int CMD_SET_DATA = 8;
    private final int VAL_SET_PAR = 6;
    private final int CMD_SET_FIFO = 25;
    private final int CMD_SET_FIFO_RETRY = 125;
    private final int CMD_VAL_WORKLOAD = 20;
    private final int VAL_MEMORY = 5;
    private final int VAL_MEMORY_ALL = 12;
    private final int VAL_CLEAR_PROCESS = 14;
    private final int CMD_GET_PAR_BLOCK = 13;
    private final int VAL_GET_FIFO_FREE = 22;
    private final int VAL_GET_FIFO_COUNT = 23;
    private final int VAL_CLEAR_FIFO = 21;
    private final int CMD_VAL_ARMVERSION = 1000;
    private final int CMD_SETDATA_STATUS = 108;
    private final int CMD_GET_DATA_SH = 107;
    private final int CMD_AUTHENTICATE = 300;
    private final DatagramSocket ds;
    private volatile int currentPacketIndex = 1;
    private final InetAddress Connection;
    final String Password;
    static final int DATATYPE_BYTE = 1;
    static final int DATATYPE_SHORT = 2;
    static final int DATATYPE_INT = 3;
    static final int DATATYPE_LONG = 4;
    static final int DATATYPE_FLOAT = 5;
    static final int DATATYPE_DOUBLE = 6;
    static final int DATATYPE_INT64 = 7;
    static final int DATATYPE_STRING = 8;
    static final int DATATYPE_PACKED_INT = 2;
    static final int GETDATASH_MIN_REQ = 6;
    static final int GETDATASH_MAX_REQ = 30;
    static final int GETDATASH_QUEUE_SIZE = 40;
    final int AllowedErrors;
    int MaxPacketDelay;
    final int DataBlockSize;
    int ADwTimeout;
    final int NumWaits;
    final int WaitTime;
    final int Hostlink;
    final int Port;
    final int PROCESSOR_T8 = 8;
    final int PROCESSOR_T9 = 9;
    final int PROCESSOR_T10 = 1010;
    final int PROCESSOR_T11 = 1011;
    final int PROCESSOR_T12 = 1012;
    ADwinDebugListener adl = null;
    int Language = 1;
    volatile int version;
    final int DLLVersion = 3000447;
    final int MY_VARIANT_EMPTY = 0;
    final int MY_VARIANT_NULL = 1;
    final int MY_VARIANT_INT16 = 2;
    final int MY_VARIANT_INT32 = 3;
    final int MY_VARIANT_FLOAT = 4;
    final int MY_VARIANT_DOUBLE = 5;
    final int SMALL_REQ_SIZE = 10240;
    final int ADWIN_TCP_MAGIC_FLAG_REQUEST = 1118650900;
    final int ADWIN_TCP_MAGIC_FLAG_RESPONSE = 1118650963;
    final int ADWIN_HTONL = 1;
    final int ADWIN_NTOHL = 2;
    volatile boolean supports_tcp = false;
    volatile boolean supports_udp = true;
    static final int ADWIN_TCP_OK = 0;
    static final int ADWIN_TCP_ERROR = 1;
    static final int ADWIN_UDP = 2;
    Date last_access = new Date(0L);
    volatile adwin_tcp_info_t ati;

    ADwinDirectDevice(InetAddress address, int port, String password, int allowedErrors, int maxPacketDelay, int dataBlockSize, int adwinTimeout, int maxTryLater, int tryLaterWaitTime, int hostlink) throws SocketException, ADwinCommunicationError {
        this.Connection = address;
        this.Port = port;
        this.Password = password;
        this.AllowedErrors = allowedErrors;
        this.MaxPacketDelay = maxPacketDelay;
        this.DataBlockSize = dataBlockSize;
        this.ADwTimeout = adwinTimeout;
        this.NumWaits = maxTryLater;
        this.WaitTime = tryLaterWaitTime;
        this.Hostlink = hostlink;
        this.ds = new DatagramSocket(0);
        this.ds.setReceiveBufferSize(140000);
        this.adwin_tcp_construct();
        try {
            this.version = this.getArmVersion();
        }
        catch (Exception e) {
            this.version = 0;
        }
    }

    boolean newTryLater() {
        int versionLocal = this.version;
        return versionLocal >= 252 && versionLocal <= 259 || versionLocal >= 264;
    }

    synchronized int incGetCurrentIndex() {
        if (this.adl != null) {
            this.adl.enter("incCurrentIndex");
        }
        int result = this.currentPacketIndex++;
        if (this.currentPacketIndex > 0x7FFFFFFE) {
            if (this.adl != null) {
                this.adl.message("Wrapping Packet-Index around...", 100);
            }
            this.currentPacketIndex = 1;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readAEIVersionIfUnknown() throws ADwinCommunicationError {
        if (this.version == 0) {
            DatagramSocket datagramSocket = this.ds;
            synchronized (datagramSocket) {
                if (this.version == 0) {
                    this.version = this.getArmVersion();
                }
            }
        }
        return this.version;
    }

    private void sendCommand(ADwinCommand adwc, int Index) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("sendCommand ( ADwinCommand: " + adwc.getCommand() + ", " + Index + ")");
        }
        adwc.setPacketIndex(Index);
        adwc.setLink(this.Hostlink);
        try {
            DatagramPacket d = adwc.getDatagram(this.Connection);
            this.ds.send(d);
        }
        catch (IOException ioe) {
            if (this.adl != null) {
                this.adl.message("IOException -> ADwinCommunicationError in sendCommand", 100);
                this.adl.leave();
            }
            throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramPacket sendAndWaitForAnswer32Byte(ADwinCommand adwc, int[] sentIndex) throws ADwinCommunicationError, SocketTimeoutException {
        if (this.adl != null) {
            this.adl.enter("sendAndWaitForAnswer32Byte ( Command: " + adwc.getCommand() + ")");
        }
        int ResultPacketIndex = 0;
        int SocketTimeouts = 0;
        boolean timeoutOccured = false;
        byte[] PacketData = new byte[32];
        for (int n = 0; n < 32; ++n) {
            PacketData[n] = 0;
        }
        DatagramPacket dp = new DatagramPacket(PacketData, 32);
        int TryLatersLeft = this.NumWaits;
        boolean TryLater = false;
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            boolean InvalidPacketIndex;
            do {
                if (timeoutOccured && !TryLater && this.adl != null) {
                    this.adl.sendAgain(ResultPacketIndex, 0, adwc.getCommand());
                }
                ResultPacketIndex = this.incGetCurrentIndex();
                this.sendCommand(adwc, ResultPacketIndex);
                InvalidPacketIndex = false;
                timeoutOccured = false;
                TryLater = false;
                try {
                    this.ds.setSoTimeout(this.MaxPacketDelay);
                    while (ADwinDirectDevice.extractInt(PacketData, 4) != ResultPacketIndex && !TryLater) {
                        this.ds.receive(dp);
                        int status = ADwinDirectDevice.extractInt(PacketData, 0);
                        int packetIndexReceived = ADwinDirectDevice.extractInt(PacketData, 4);
                        if (this.adl != null) {
                            if (status == -10) {
                                this.adl.tryLater(ResultPacketIndex, this.NumWaits - TryLatersLeft);
                            } else if (packetIndexReceived != ResultPacketIndex) {
                                this.adl.recvAgain(ResultPacketIndex, packetIndexReceived, adwc.getCommand());
                            }
                        }
                        if (!(status != -10 || this.newTryLater() && packetIndexReceived != ResultPacketIndex)) {
                            if (this.adl != null) {
                                this.adl.tryLater(packetIndexReceived, this.NumWaits - TryLatersLeft);
                            }
                            TryLater = true;
                            --TryLatersLeft;
                            try {
                                Thread.sleep(this.WaitTime);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        if (packetIndexReceived != ResultPacketIndex) {
                            if (this.adl != null) {
                                this.adl.message("Erwarteter Paket-Index: " + ResultPacketIndex + ", erhaltener P.-I.: " + ADwinDirectDevice.extractInt(PacketData, 4), 50);
                            }
                            InvalidPacketIndex = true;
                            continue;
                        }
                        if (status != 5) continue;
                        if (this.adl != null) {
                            this.adl.message("Fehler 5 aufgetreten, wird behandelt wie Socket-Timeout", 50);
                        }
                        timeoutOccured = true;
                    }
                }
                catch (SocketTimeoutException ste) {
                    if (SocketTimeouts > this.AllowedErrors) {
                        if (this.adl != null) {
                            this.adl.message("SocketTimeoutException", 1);
                            this.adl.leave();
                        }
                        throw ste;
                    }
                    if (this.adl != null) {
                        this.adl.message("Nichts empfangen....", 50);
                    }
                    timeoutOccured = true;
                    ++SocketTimeouts;
                }
                catch (IOException ioe) {
                    if (this.adl != null) {
                        this.adl.message("I/O-Error: " + ioe.getMessage(), 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                }
            } while ((timeoutOccured || TryLater) && TryLatersLeft > 0 && !InvalidPacketIndex);
        }
        if (TryLatersLeft <= 0) {
            throw new ADwinCommunicationError("Too many Try-Later Packets received", "Zu viele Try-Later-Pakete empfangen", this.Language, 16);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        if (sentIndex != null) {
            sentIndex[0] = ResultPacketIndex;
        }
        return dp;
    }

    private DatagramPacket getVersionInfo() throws ADwinCommunicationError {
        DatagramPacket dp;
        if (this.adl != null) {
            this.adl.enter("getVersionInfo ()");
        }
        int[] Values = new int[]{0, 0, 0, 0};
        ADwinCommand adwc = new ADwinCommand(this.version, 3000447, this.Port);
        adwc.setCommand(255);
        adwc.setTimeout(this.ADwTimeout);
        adwc.setValues(Values);
        adwc.setPwd(this.Password);
        try {
            dp = this.sendAndWaitForAnswer32Byte(adwc, null);
        }
        catch (SocketTimeoutException ste) {
            if (this.adl != null) {
                this.adl.message("SocketTimeoutException->ADwinCommunicationError in getVersionInfo ()", 1);
                this.adl.leave();
            }
            throw new ADwinCommunicationError("No Answer on request for version info, " + ste.getMessage(), "Keine Antwort auf die Frage nach der Versions-Info, " + ste.getMessage(), this.Language, 2001);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return dp;
    }

    static void setInteger(byte[] Buffer2, int Index, int Value) {
        for (int n = 0; n < 4; ++n) {
            Buffer2[n + Index] = (byte)(Value << (3 - n) * 8 >>> 24);
        }
    }

    static void setLong(byte[] Buffer2, int Index, long Value) {
        for (int n = 0; n < 8; ++n) {
            Buffer2[n + Index] = (byte)(Value << (7 - n) * 8 >>> 56);
        }
    }

    static int extractInt(byte[] b, int IndexFrom) {
        return (b[IndexFrom] & 0xFF) + (b[IndexFrom + 1] << 8 & 0xFF00) + (b[IndexFrom + 2] << 16 & 0xFF0000) + (b[IndexFrom + 3] << 24 & 0xFF000000);
    }

    public static long extractLong(byte[] b, int IndexFrom) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[IndexFrom + i] & 0xFF);
        }
        return result;
    }

    static int reverseByteOrder(int i) {
        int res = 0;
        for (int n = 0; n < 4; ++n) {
            byte b = (byte)(i >>> 8 * (3 - n));
            res |= b << n * 8 & 255 << n * 8;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataToArrayConverter getDataFast(int DataNr, int IndexFirst, int IndexLast, int DataType) throws ADwinCommunicationError {
        DataToArrayConverter dtac;
        if (this.adl != null) {
            this.adl.enter("getDataFast (" + DataNr + ", " + IndexFirst + ", " + IndexLast + ", " + DataType + ")");
        }
        int OrigIndexFirst = IndexFirst;
        int[] Values = new int[]{DataType, DataNr + (IndexLast - IndexFirst + 1 << 16), IndexFirst, IndexLast - IndexFirst + 1};
        ADwinCommand adwc = new ADwinCommand(this.version, 3000447, this.Port);
        adwc.setValues(Values);
        adwc.setCommand(207);
        adwc.setPwd(this.Password);
        int ErrorCode = -10;
        DataFieldTransfer dtfa = new DataFieldTransfer(this.Connection, this.ds, this);
        int[] NumWordsReceived = new int[1];
        switch (DataType) {
            case 1: {
                DataToByteArray dataToByteArray = new DataToByteArray(IndexLast - IndexFirst + 1, 0);
            }
            case 2: {
                dtac = new DataToIntArray((IndexLast - IndexFirst + 1) / 2 + 1, 0);
                break;
            }
            case 5: {
                dtac = new DataToFloatArray(IndexLast - IndexFirst + 1, 0);
                break;
            }
            default: {
                dtac = new DataToIntArray(IndexLast - IndexFirst + 1, 0);
            }
        }
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            for (int n = 0; n < this.NumWaits && ErrorCode == -10; ++n) {
                int ResultPacketIndex = this.incGetCurrentIndex();
                this.sendCommand(adwc, ResultPacketIndex);
                ErrorCode = dtfa.receiveFast(IndexLast - IndexFirst + 1, dtac, IndexFirst - OrigIndexFirst, ResultPacketIndex, NumWordsReceived);
                if (NumWordsReceived[0] >= IndexLast - IndexFirst + 1) continue;
                if (ErrorCode == -10) {
                    if (this.adl != null) {
                        this.adl.tryLater(0, ResultPacketIndex);
                    }
                    try {
                        Thread.sleep(this.WaitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (ErrorCode != 0) {
                    if (ErrorCode == -5) {
                        throw new ADwinCommunicationError("Wrong Password", "Falsches Passwort", this.Language, 2002);
                    }
                    if (ErrorCode == 1) {
                        throw new ADwinCommunicationError("timeout to link", "Timeout beim Schreiben zum Link", this.Language, 1);
                    }
                    if (ErrorCode == 2) {
                        throw new ADwinCommunicationError("timeout from link", "Timeout beim Lesen vom Link", this.Language, 2);
                    }
                    throw new ADwinCommunicationError("Error on ADwin System: " + ErrorCode, "Fehler " + ErrorCode + " auf dem ADwin-System", this.Language, ErrorCode > 0 ? ErrorCode : 2000);
                }
                Values[2] = IndexFirst += NumWordsReceived[0];
                Values[3] = IndexLast - IndexFirst + 1;
                Values[1] = DataNr + (IndexLast - IndexFirst + 1 << 16);
                adwc.setValues(Values);
                ErrorCode = -10;
                if (NumWordsReceived[0] <= 0) continue;
                n = 0;
            }
        }
        if (ErrorCode != 0) {
            if (this.adl != null) {
                this.adl.message("Error Code " + ErrorCode + " -> ADwinCommunicationError in getDataFast...", 1);
            }
            if (this.adl != null) {
                this.adl.leave();
            }
            if (ErrorCode == -5) {
                throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
            }
            if (ErrorCode == -31) {
                throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
            }
            throw new ADwinCommunicationError("Unable to load DATA_" + DataNr + " (fast method)", "Kann DATA_" + DataNr + " nicht mit schneller Methode lesen", this.Language, ErrorCode == -10 ? 16 : 2000);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return dtac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataToArrayConverter getDataFastADwinX(int DataNr, int IndexFirst, int IndexLast, int DataType) throws ADwinCommunicationError {
        DataToArrayConverter dtac;
        if (this.adl != null) {
            this.adl.enter("getDataFastADwinX (" + DataNr + ", " + IndexFirst + ", " + IndexLast + ", )");
        }
        int count = IndexLast - IndexFirst + 1;
        int bytes_per_value = this.BytesPerValue(DataType);
        int byte_count = count * bytes_per_value;
        int OrigIndexFirst = IndexFirst;
        int[] Values = new int[]{0, DataNr + (count << 16), IndexFirst, count};
        ADwinCommand adwc = new ADwinCommand(this.version, 3000447, this.Port);
        adwc.setValues(Values);
        adwc.setCommand(207);
        adwc.setPwd(this.Password);
        int ErrorCode = -10;
        DataFieldTransfer dtfa = new DataFieldTransfer(this.Connection, this.ds, this);
        int[] NumWordsReceived = new int[1];
        switch (DataType) {
            case 8: {
                dtac = new DataToByteArray(count, 0);
                break;
            }
            case 5: {
                dtac = new DataToFloatArray(count, 0);
                break;
            }
            case 6: {
                dtac = new DataToDoubleArray(count, 0);
                break;
            }
            case 7: {
                dtac = new DataToInt64Array(count, 0);
                break;
            }
            default: {
                dtac = new DataToIntArray(count, 0);
            }
        }
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            for (int n = 0; n < this.NumWaits && ErrorCode == -10; ++n) {
                int ResultPacketIndex = this.incGetCurrentIndex();
                this.sendCommand(adwc, ResultPacketIndex);
                ErrorCode = dtfa.receiveFastADwinX(count, dtac, IndexFirst - OrigIndexFirst, ResultPacketIndex, NumWordsReceived);
                if (NumWordsReceived[0] >= count) continue;
                if (ErrorCode == -10) {
                    if (this.adl != null) {
                        this.adl.tryLater(0, ResultPacketIndex);
                    }
                    try {
                        Thread.sleep(this.WaitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (ErrorCode != 0) {
                    if (ErrorCode == -5) {
                        throw new ADwinCommunicationError("Wrong Password", "Falsches Passwort", this.Language, 2002);
                    }
                    if (ErrorCode == 1) {
                        throw new ADwinCommunicationError("timeout to link", "Timeout beim Schreiben zum Link", this.Language, 1);
                    }
                    if (ErrorCode == 2) {
                        throw new ADwinCommunicationError("timeout from link", "Timeout beim Lesen vom Link", this.Language, 2);
                    }
                    throw new ADwinCommunicationError("Error on ADwin System: " + ErrorCode, "Fehler " + ErrorCode + " auf dem ADwin-System", this.Language, ErrorCode > 0 ? ErrorCode : 2000);
                }
                Values[2] = IndexFirst += NumWordsReceived[0];
                Values[3] = count;
                Values[1] = DataNr + (count << 16);
                adwc.setValues(Values);
                ErrorCode = -10;
                if (NumWordsReceived[0] <= 0) continue;
                n = 0;
            }
        }
        if (ErrorCode != 0) {
            if (this.adl != null) {
                this.adl.message("Error Code " + ErrorCode + " -> ADwinCommunicationError in getDataFast...", 1);
            }
            if (this.adl != null) {
                this.adl.leave();
            }
            if (ErrorCode == -5) {
                throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
            }
            if (ErrorCode == -31) {
                throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
            }
            throw new ADwinCommunicationError("Unable to load DATA_" + DataNr + " (fast method)", "Kann DATA_" + DataNr + " nicht mit schneller Methode lesen", this.Language, ErrorCode == -10 ? 16 : 2000);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return dtac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataToArrayConverter getData(int DataNr, int IndexFirst, int IndexLast, int PCDataType) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getData (" + DataNr + ", " + IndexFirst + ", " + IndexLast + ", " + PCDataType + ")");
        }
        int versionLocal = this.readAEIVersionIfUnknown();
        if (IndexFirst > IndexLast) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "reading DATA_" + DataNr + ": Only a positive number of elements can be retrieved!" : "Nur eine positive Anzahl von Elementen kann aus DATA_" + DataNr + " gelesen werden");
        }
        if (IndexLast - IndexFirst + 1 <= 350 * this.DataBlockSize && versionLocal >= 250) {
            DataToArrayConverter dtac = this.getDataFast(DataNr, IndexFirst, IndexLast, PCDataType);
            if (this.adl != null) {
                this.adl.leave();
            }
            return dtac;
        }
        if (versionLocal >= 266 && versionLocal < 400) {
            DataToArrayConverter dtac = this.getDataSH(DataNr, IndexFirst, IndexLast, PCDataType);
            if (this.adl != null) {
                this.adl.leave();
            }
            return dtac;
        }
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            DataToArrayConverter dtac;
            int SourceDataType = this.getDataType(DataNr);
            if (SourceDataType == 4) {
                SourceDataType = 3;
            }
            if (SourceDataType == 2) {
                SourceDataType = 3;
            }
            if (SourceDataType != 3 && SourceDataType != 5) {
                if (this.adl != null) {
                    this.adl.message("error... Unknown Data-Type of Data " + DataNr + ".", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unknown type of DATA_" + DataNr + "!", "DATA_" + DataNr + " hat keinen bekannten Datentyp", this.Language, 100);
            }
            if (PCDataType == 3) {
                dtac = new DataToIntArray(IndexLast - IndexFirst + 1, SourceDataType);
            } else if (PCDataType == 5) {
                dtac = new DataToFloatArray(IndexLast - IndexFirst + 1, SourceDataType);
            } else if (PCDataType == 2) {
                dtac = new DataToIntArray((IndexLast - IndexFirst + 1) / 2 + 1, SourceDataType);
            } else {
                throw new ADwinCommunicationError("Unknown type of DATA_" + DataNr + "!", "DATA_" + DataNr + " hat keinen bekannten Datentyp", this.Language, 100);
            }
            int[] Values = new int[]{this.is_adwinx(this.version) ? 0 : PCDataType, DataNr + (this.DataBlockSize << 16), IndexFirst, IndexLast - IndexFirst + 1};
            int RequestState = this.standardCall(7, Values, 0, "", "DATA_" + DataNr, "", "DATA_" + DataNr, false, null);
            if (RequestState != 0) {
                if (this.adl != null) {
                    this.adl.message("Fehler: " + RequestState + "... ", 1);
                    this.adl.leave();
                }
                if (RequestState == -5) {
                    throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
                }
                throw new ADwinCommunicationError("Unable to load DATA_" + DataNr, "Kann DATA_" + DataNr + " nicht laden", this.Language, RequestState == -10 ? 16 : 2000);
            }
            DataFieldTransfer dft = new DataFieldTransfer(this.Connection, this.ds, this);
            if (PCDataType == 2) {
                dft.receive((IndexLast - IndexFirst + 1) / 2, dtac, "DATA_" + DataNr);
            } else {
                dft.receive(IndexLast - IndexFirst + 1, dtac, "DATA_" + DataNr);
            }
            if (this.adl != null) {
                this.adl.leave();
            }
            return dtac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataToArrayConverter getDataADwinX(int DataNr, int IndexFirst, int IndexLast, int PCDataType) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataDoubleADwinX(" + DataNr + ", " + IndexFirst + ", " + IndexLast + ", )");
        }
        if (IndexFirst > IndexLast) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "reading DATA_" + DataNr + ": Only a positive number of elements can be retrieved!" : "Nur eine positive Anzahl von Elementen kann aus DATA_" + DataNr + " gelesen werden");
        }
        int count = IndexLast - IndexFirst + 1;
        if (count <= 175) {
            DataToArrayConverter dtac = this.getDataFastADwinX(DataNr, IndexFirst, IndexLast, PCDataType);
            if (this.adl != null) {
                this.adl.leave();
            }
            return dtac;
        }
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            DataToArrayConverter dtac;
            int SourceDataType = this.getDataType(DataNr);
            if (SourceDataType < 3 || SourceDataType > 7) {
                if (this.adl != null) {
                    this.adl.message("error... Unknown Data-Type of Data " + DataNr + ".", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unknown type of DATA_" + DataNr + "!", "DATA_" + DataNr + " hat keinen bekannten Datentyp", this.Language, 100);
            }
            switch (PCDataType) {
                case 3: {
                    dtac = new DataToIntArray(count, SourceDataType);
                    break;
                }
                case 5: {
                    dtac = new DataToFloatArray(count, SourceDataType);
                    break;
                }
                case 6: {
                    dtac = new DataToDoubleArray(count, SourceDataType);
                    break;
                }
                case 7: {
                    dtac = new DataToInt64Array(count, SourceDataType);
                    break;
                }
                default: {
                    if (this.adl != null) {
                        this.adl.message("error... Data-Type not supported.", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("Data-Type not supported.", "Datentyp wird nicht unterst\u00fctzt.", this.Language, 100);
                }
            }
            int[] Values = new int[4];
            Values[0] = 0;
            if (SourceDataType == 6) {
                Values[0] = 6;
            }
            if (SourceDataType == 7) {
                Values[0] = 7;
            }
            Values[1] = DataNr + (this.DataBlockSize << 16);
            Values[2] = IndexFirst;
            Values[3] = IndexLast - IndexFirst + 1;
            int RequestState = this.standardCall(7, Values, 0, "", "DATA_" + DataNr, "", "DATA_" + DataNr, false, null);
            if (RequestState != 0) {
                if (this.adl != null) {
                    this.adl.message("Fehler: " + RequestState + "... ", 1);
                    this.adl.leave();
                }
                if (RequestState == -5) {
                    throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
                }
                throw new ADwinCommunicationError("Unable to load DATA_" + DataNr, "Kann DATA_" + DataNr + " nicht laden", this.Language, RequestState == -10 ? 16 : 2000);
            }
            DataFieldTransfer dft = new DataFieldTransfer(this.Connection, this.ds, this);
            dft.receiveADwinX(count, dtac, "DATA_" + DataNr);
            if (this.adl != null) {
                this.adl.leave();
            }
            return dtac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataToArrayConverter getDataSH(int DataNr, int IndexFirst, int IndexLast, int DataType) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataSH (" + DataNr + ", " + IndexFirst + ", " + IndexLast + ", " + DataType + ")");
        }
        int[] values = new int[4];
        int[] sentPacketIndex = new int[1];
        values[0] = ADwinDirectDevice.reverseByteOrder(DataNr << 16 | 0x1E);
        values[1] = ADwinDirectDevice.reverseByteOrder(IndexFirst);
        values[2] = ADwinDirectDevice.reverseByteOrder(IndexLast - IndexFirst + 1);
        values[3] = 0;
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            DataToArrayConverter dtac;
            int start;
            int r1_status = this.standardCall(107, values, 0, "Unable to read DATA_" + DataNr, "DATA_" + DataNr, "Kann DATA_" + DataNr + " nicht lesen", "DATA_" + DataNr, true, sentPacketIndex);
            if (r1_status == -31) {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unable to read Data_" + DataNr, "Data_" + DataNr + " kann nicht gelesen werden", this.Language, 100);
            }
            if (r1_status != 0) {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unable to read Data_" + DataNr, "Data_" + DataNr + " kann nicht gelesen werden", this.Language, r1_status);
            }
            boolean processorT11 = ADwinDirectDevice.reverseByteOrder(values[1]) == 2;
            int sourceType = values[0];
            if (sourceType != 5) {
                sourceType = 3;
            }
            int length = IndexLast - IndexFirst + 1;
            if (processorT11) {
                int misalignment = IndexFirst - 1 & 3;
                start = IndexFirst - misalignment;
                length = 4 * (length + misalignment + 3 >>> 2);
            } else {
                start = IndexFirst;
            }
            if (DataType == 3) {
                dtac = new DataToIntArray(IndexLast - IndexFirst + 1, sourceType);
            } else if (DataType == 2) {
                dtac = new DataToIntArray((IndexLast - IndexFirst + 1) / 2 + 1, sourceType);
            } else if (DataType == 5) {
                dtac = new DataToFloatArray(IndexLast - IndexFirst + 1, sourceType);
            } else {
                throw new IllegalArgumentException("invalid data type given.");
            }
            dtac.setOffset(IndexFirst - start);
            DataFieldTransfer dft = new DataFieldTransfer(this.Connection, this.ds, this);
            if (DataType == 2) {
                dft.getArraySH(sentPacketIndex[0], length / 2, dtac, this.Connection, this.Port);
            } else {
                dft.getArraySH(sentPacketIndex[0], length, dtac, this.Connection, this.Port);
            }
            if (this.adl != null) {
                this.adl.leave();
            }
            return dtac;
        }
    }

    private int getSetDataStatus(int SetDataPacketIndex) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getSetDataStatus (" + SetDataPacketIndex + ")");
        }
        int[] Values = new int[4];
        Values[0] = SetDataPacketIndex;
        Values[3] = 0;
        Values[2] = 0;
        Values[1] = 0;
        int RetVal = this.standardCall(108, Values, 8, "Unable to read status of last Set_Data.", "Status of last Set_Data", "Kann Status vom letzten Set_Data nicht lesen", "Status vom letzten Set_Data", false, null);
        if (this.adl != null) {
            this.adl.leave();
        }
        return RetVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setData(byte[] Data, int DataNr, int IndexFirst, int IndexLast, int DataType) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setData (byte Data[], " + DataNr + ", " + IndexFirst + ", " + IndexLast + ", " + DataType + ")");
        }
        int Count = IndexLast - IndexFirst + 1;
        int versionLocal = this.readAEIVersionIfUnknown();
        if (IndexFirst > IndexLast) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + DataNr + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + DataNr + " gesetzt werden!");
        }
        int[] sentPacketIndex = new int[1];
        byte[] ConfirmationData = new byte[32];
        DatagramPacket ConfPacket = new DatagramPacket(ConfirmationData, 32);
        int TimeoutsOccured = 0;
        int NumRetriesForSending = 0;
        int bytes_per_value = this.BytesPerValue(DataType);
        int ByteCount = Count * bytes_per_value;
        int sendType = DataType;
        if (sendType == 3) {
            sendType = 2;
        }
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            do {
                int[] Values = new int[]{sendType, DataNr | this.DataBlockSize << 16, IndexFirst, Count};
                DataFieldTransfer dtfa = new DataFieldTransfer(this.Connection, this.ds, this);
                try {
                    this.standardCall(8, Values, 4, "Cannot start setting DATA_" + DataNr, "setting DATA_" + DataNr, "Kann nicht anfangen, DATA_" + DataNr + " zu setzen", "Setzen von DATA_" + DataNr, false, sentPacketIndex);
                    dtfa.send(ByteCount, Data, "DATA_" + DataNr, sentPacketIndex[0]);
                }
                catch (ADwinCommunicationError awce) {
                    if (awce.getCode() == 100) {
                        if (this.adl != null) {
                            this.adl.message("SetData DataTooSmall", 100);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("The Data is too small", "Das Data-Feld ist zu klein", this.Language, 100);
                    }
                    if (versionLocal >= 253 && versionLocal < 260 || versionLocal >= 264) {
                        int stat = this.getSetDataStatus(sentPacketIndex[0]);
                        if (stat == 1) {
                            if (this.adl != null) {
                                this.adl.message("Exception vom dtfa.sent -> getSetDataStatus war aber OK", 100);
                                this.adl.leave();
                            }
                            return;
                        }
                        if (this.adl != null) {
                            this.adl.message("Exception vom dtfa.send -> getSetDataStatus ergab " + stat, 1);
                            this.adl.leave();
                        }
                        throw awce;
                    }
                    if (this.adl != null) {
                        this.adl.message("Retry f\u00fcr's komplette Data (Exception vom dtfa.send)", 1);
                    }
                    if (NumRetriesForSending >= this.AllowedErrors) {
                        throw awce;
                    }
                    ++NumRetriesForSending;
                    ++TimeoutsOccured;
                    continue;
                }
                try {
                    this.ds.receive(ConfPacket);
                    TimeoutsOccured = 0;
                }
                catch (SocketTimeoutException ste) {
                    if (versionLocal >= 253 && versionLocal < 260 || versionLocal >= 264) {
                        int stat = this.getSetDataStatus(sentPacketIndex[0]);
                        if (stat == 1) {
                            if (this.adl != null) {
                                this.adl.message("Timeout, aber getSetDataStatus war OK", 100);
                                this.adl.leave();
                            }
                            return;
                        }
                        if (this.adl != null) {
                            this.adl.message("Timeout -> getSetDataStatus ergab " + stat, 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("DATA_" + DataNr + " could not be set, " + ste.getMessage(), "DATA_" + DataNr + " konnte nicht beschrieben werden, " + ste.getMessage(), this.Language, 2000);
                    }
                    if (this.adl != null) {
                        this.adl.message("Timeout in setData...", 1);
                    }
                    if (++TimeoutsOccured <= this.AllowedErrors) continue;
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("DATA_" + DataNr + " could not be set, " + ste.getMessage(), "DATA_" + DataNr + " konnte nicht beschrieben werden, " + ste.getMessage(), this.Language, 100);
                }
                catch (IOException ioe) {
                    if (this.adl != null) {
                        this.adl.message("IOException -> ADwinCommunicationError in setData", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                }
            } while (TimeoutsOccured > 0);
        }
        if (ADwinDirectDevice.extractInt(ConfirmationData, 0) != 0) {
            if (this.adl != null) {
                this.adl.message("Error Code " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " -> ADwinCommunicationError in setData...", 1);
                this.adl.leave();
            }
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " occured when setting DATA_" + DataNr, "Fehler " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " aufgetreten beim Setzen von DATA_" + DataNr, this.Language, ADwinDirectDevice.extractInt(ConfirmationData, 0));
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFifo(int FifoNr, int Count, DataToArrayConverter dtac, int Type) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("readFifo (" + FifoNr + ", " + Count + ", <DataToArrayConverter>, " + Type + ")");
        }
        DataFieldTransfer dft = new DataFieldTransfer(this.Connection, this.ds, this);
        switch (this.BytesPerValue(Type)) {
            case 4: {
                int NumWordsToRead;
                for (int WordsReceived = 0; WordsReceived < Count; WordsReceived += NumWordsToRead) {
                    NumWordsToRead = Count - WordsReceived > (this.DataBlockSize + 1) * 350 ? (this.DataBlockSize + 1) * 350 : (Count - WordsReceived) % ((this.DataBlockSize + 1) * 350);
                    if (NumWordsToRead == 0) {
                        NumWordsToRead = (this.DataBlockSize + 1) * 350;
                    }
                    DatagramSocket datagramSocket = this.ds;
                    synchronized (datagramSocket) {
                        if (this.is_adwinx(this.version)) {
                            dft.readFifo(FifoNr, 0, NumWordsToRead, dtac, WordsReceived);
                        } else {
                            int tmp = Type;
                            if (tmp == 3) {
                                tmp = 2;
                            }
                            dft.readFifo(FifoNr, tmp, NumWordsToRead, dtac, WordsReceived);
                        }
                        continue;
                    }
                }
                break;
            }
            case 8: {
                int NumValuesToRead;
                for (int ValuesReceived = 0; ValuesReceived < Count; ValuesReceived += NumValuesToRead) {
                    NumValuesToRead = Count - ValuesReceived > (this.DataBlockSize + 1) * 175 ? (this.DataBlockSize + 1) * 175 : (Count - ValuesReceived) % ((this.DataBlockSize + 1) * 175);
                    if (NumValuesToRead == 0) {
                        NumValuesToRead = (this.DataBlockSize + 1) * 175;
                    }
                    DatagramSocket datagramSocket = this.ds;
                    synchronized (datagramSocket) {
                        dft.readFifo(FifoNr, Type, NumValuesToRead, dtac, ValuesReceived);
                        continue;
                    }
                }
                break;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFifo(int FifoNr, int Typ, int count, int NumWords, byte[] Data, int DataOffset) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("writeFifo (" + FifoNr + ", " + Typ + ", " + NumWords + ", <byte[]>, " + DataOffset + ")");
        }
        int[] Values = new int[]{Typ, FifoNr + (this.DataBlockSize + 1 << 16), 0, count};
        ADwinCommand adwc = new ADwinCommand(this.version, 3000447, this.Port);
        adwc.setTimeout(this.ADwTimeout);
        adwc.setPwd(this.Password);
        boolean EverythingSent = false;
        boolean ConfirmationReceived = true;
        byte[] ConfirmData = new byte[32];
        int TryLatersLeft = this.NumWaits;
        int SentIndex = 0;
        int ExpectedPacketIndex = 0;
        DatagramPacket ConfirmPacket = new DatagramPacket(ConfirmData, 32);
        int NumAttemptsLeft = this.AllowedErrors;
        int NumPacketsToSend = (NumWords - 1) / 350 + 1;
        int ErrorsOccured = 0;
        boolean RetryActive = false;
        boolean IllegalPacketIndexRecvd = false;
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            while (!EverythingSent && NumAttemptsLeft >= 0) {
                if (ErrorsOccured > this.AllowedErrors) {
                    if (this.adl != null) {
                        this.adl.message("Too many errors in writeFifo...", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("Number of errors occured exceeded AllowedErrors in writeFifo when writing to fifo " + FifoNr + ".", "Anzahl der aufgetretenen Fehler \u00fcbersteigt AllowedErrors beim Schreiben in Fifo " + FifoNr + ".", this.Language, 2001);
                }
                if (TryLatersLeft <= 0) break;
                if (!IllegalPacketIndexRecvd) {
                    if (!RetryActive) {
                        adwc.setCommand(25);
                        Values[2] = 0;
                        ExpectedPacketIndex = SentIndex = this.incGetCurrentIndex();
                        adwc.setPacketIndex(SentIndex);
                    } else {
                        if (this.adl != null) {
                            this.adl.sendAgain(SentIndex, 0, 125);
                        }
                        adwc.setCommand(125);
                        Values[2] = SentIndex;
                        ExpectedPacketIndex = this.incGetCurrentIndex();
                        adwc.setPacketIndex(ExpectedPacketIndex);
                        RetryActive = false;
                    }
                    adwc.setValues(Values);
                    adwc.setLink(this.Hostlink);
                    try {
                        this.ds.send(adwc.getDatagram(this.Connection));
                    }
                    catch (IOException ioe) {
                        if (this.adl != null) {
                            this.adl.message("IOException -> ADwinCommunicationError when sending in writeFifo", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                    }
                }
                IllegalPacketIndexRecvd = false;
                ConfirmationReceived = true;
                try {
                    this.ds.setSoTimeout(this.MaxPacketDelay);
                    this.ds.receive(ConfirmPacket);
                }
                catch (SocketTimeoutException ste) {
                    if (this.adl != null) {
                        this.adl.message("Timeout...", 100);
                    }
                    ConfirmationReceived = false;
                }
                catch (IOException ioe) {
                    if (this.adl != null) {
                        this.adl.message("IOException -> ADwinCommunicationError when receiving in writeFifo", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                }
                if (ConfirmationReceived && (!this.newTryLater() && ADwinDirectDevice.extractInt(ConfirmData, 0) != -10 && ADwinDirectDevice.extractInt(ConfirmData, 4) != ExpectedPacketIndex || this.newTryLater() && ADwinDirectDevice.extractInt(ConfirmData, 4) != ExpectedPacketIndex)) {
                    if (this.adl != null) {
                        this.adl.message("Vor'm Schreiben der Datenpakete: Erwarteter Paket-Index: " + ExpectedPacketIndex + ", erhaltener: " + ADwinDirectDevice.extractInt(ConfirmData, 4) + ".", 1);
                    }
                    IllegalPacketIndexRecvd = true;
                    continue;
                }
                if (ConfirmationReceived) {
                    if (ADwinDirectDevice.extractInt(ConfirmData, 0) == -10) {
                        if (this.adl != null) {
                            this.adl.tryLater(SentIndex, this.NumWaits - TryLatersLeft);
                        }
                        try {
                            Thread.sleep(this.WaitTime);
                        }
                        catch (InterruptedException ioe) {
                            // empty catch block
                        }
                        --TryLatersLeft;
                        continue;
                    }
                    if (ADwinDirectDevice.extractInt(ConfirmData, 0) == -41) {
                        ++ErrorsOccured;
                        if (this.adl == null) continue;
                        this.adl.message("Fehler -41 beim Warten auf Best\u00e4tigung in writeFifo - wird nochmal ohne Retry versucht", 50);
                        continue;
                    }
                    if (ADwinDirectDevice.extractInt(ConfirmData, 0) == -40) {
                        if (this.adl != null) {
                            this.adl.message("Fehler -40: -> Mache weiter...", 50);
                            this.adl.leave();
                        }
                        return;
                    }
                    if (ADwinDirectDevice.extractInt(ConfirmData, 0) < 0 || ADwinDirectDevice.extractInt(ConfirmData, 0) == 5) {
                        ++ErrorsOccured;
                        RetryActive = true;
                        if (this.adl == null) continue;
                        this.adl.message("Fehler " + ADwinDirectDevice.extractInt(ConfirmData, 0) + " beim Warten auf Best\u00e4tigung zum Anfangen in writeFifo...", 50);
                        continue;
                    }
                    if (ADwinDirectDevice.extractInt(ConfirmData, 0) != 0) {
                        if (this.adl != null) {
                            this.adl.message("Error code " + ADwinDirectDevice.extractInt(ConfirmData, 0) + " -> ADwinCommunicationError", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("error " + ADwinDirectDevice.extractInt(ConfirmData, 0) + " on ADwin System when writing to fifo " + FifoNr, "Fehler " + ADwinDirectDevice.extractInt(ConfirmData, 0) + " auf dem ADwin-System beim Schreiben von Fifo " + FifoNr + ".", this.Language, ADwinDirectDevice.extractInt(ConfirmData, 0));
                    }
                    ErrorsOccured = 0;
                    byte[] FifoBytes = new byte[1408];
                    DatagramPacket dp = new DatagramPacket(FifoBytes, 1408, this.Connection, this.Port);
                    for (int Packet = 0; Packet < NumPacketsToSend; ++Packet) {
                        ADwinDirectDevice.setInteger(FifoBytes, 0, ExpectedPacketIndex);
                        ADwinDirectDevice.setInteger(FifoBytes, 4, Packet);
                        int NumDataWords = Packet != NumPacketsToSend - 1 ? 350 : NumWords % 350;
                        if (NumDataWords == 0) {
                            NumDataWords = 350;
                        }
                        for (int n = 0; n < NumDataWords * 4; ++n) {
                            FifoBytes[n + 8] = Data[n + Packet * 350 * 4 + DataOffset];
                        }
                        try {
                            this.ds.send(dp);
                            continue;
                        }
                        catch (IOException ioe) {
                            if (this.adl != null) {
                                this.adl.message("IOException -> ADwinCommunicationError when sending Data in writeFifo", 1);
                                this.adl.leave();
                            }
                            throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                        }
                    }
                    ConfirmationReceived = true;
                    try {
                        this.ds.setSoTimeout(this.MaxPacketDelay * 2 + this.ADwTimeout);
                        this.ds.receive(ConfirmPacket);
                    }
                    catch (SocketTimeoutException ste) {
                        if (this.adl != null) {
                            this.adl.message("Timeout when waiting for confirmation....", 100);
                        }
                        ConfirmationReceived = false;
                    }
                    catch (IOException ioe) {
                        if (this.adl != null) {
                            this.adl.message("IOException -> ADwinCommunicationError when receiving confirmation in writeFifo", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                    }
                    if (ConfirmationReceived && ADwinDirectDevice.extractInt(ConfirmData, 0) == -32) {
                        if (this.adl != null) {
                            this.adl.message("Fifo zu klein", 1);
                        }
                        throw new ADwinCommunicationError("There is not enough space left in fifo " + FifoNr, "Nicht genug Platz \u00fcbrig in Fifo " + FifoNr, this.Language, 101);
                    }
                    if (ConfirmationReceived && (ADwinDirectDevice.extractInt(ConfirmData, 0) < 0 || ADwinDirectDevice.extractInt(ConfirmData, 0) == 5)) {
                        if (this.adl != null) {
                            this.adl.message("Error " + ADwinDirectDevice.extractInt(ConfirmData, 0) + " in confirmation", 50);
                        }
                        --NumAttemptsLeft;
                        RetryActive = true;
                        continue;
                    }
                    if (ConfirmationReceived && ADwinDirectDevice.extractInt(ConfirmData, 0) > 0) {
                        if (this.adl != null) {
                            this.adl.message("Error " + ADwinDirectDevice.extractInt(ConfirmData, 0) + " -> ADwinCommunicationError in confirmation...", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("error on ADwin System when writing Bytes to Fifo " + FifoNr + ", - error " + ADwinDirectDevice.extractInt(ConfirmData, 0), "Fehler " + ADwinDirectDevice.extractInt(ConfirmData, 0) + " auf dem ADwin-System beim Schreiben von Fifo " + FifoNr + ".", this.Language, ADwinDirectDevice.extractInt(ConfirmData, 0));
                    }
                    if (ConfirmationReceived) {
                        EverythingSent = true;
                        continue;
                    }
                    EverythingSent = false;
                    RetryActive = true;
                    continue;
                }
                if (this.adl != null) {
                    this.adl.message("one attempt less left......", 50);
                }
                --NumAttemptsLeft;
                RetryActive = true;
                IllegalPacketIndexRecvd = false;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        if (!EverythingSent) {
            throw new ADwinCommunicationError("Could not send everything...", "Es konnte nicht alles gesendet werden...", this.Language, 2000);
        }
    }

    private int getArmVersion() throws ADwinCommunicationError {
        int supports;
        int[] Values = new int[]{1000, 0, 0, 0};
        if (this.version > 0 && this.version != 299) {
            return this.version;
        }
        if (this.version == 299) {
            this.standardCall(1000, Values, 0, "Unable to determine the version of the ethernet interface", "version of the ethernet interface", "Version des Ethernet-Interfaces konnte nicht bestimmt werden", "Version des Ethernet-Interfaces", true, null);
            this.version = Values[0];
            supports = Values[2];
        } else {
            this.version = -1;
            this.standardCall(1000, Values, 0, "Unable to determine the version of the ethernet interface", "version of the ethernet interface", "Version des Ethernet-Interfaces konnte nicht bestimmt werden", "Version des Ethernet-Interfaces", true, null);
            this.version = Values[0];
            supports = Values[2];
            if (this.version == 299) {
                this.getArmVersion();
            }
        }
        if (this.version >= 304 && this.version < 400) {
            this.supports_tcp = (supports & 1) == 1;
            this.supports_udp = (supports >> 1 & 1) == 1;
        } else {
            this.supports_udp = true;
            this.supports_tcp = false;
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getParBlock(int IndexFirst, int NumParams, DataToArrayConverter dtac) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParBlock (" + IndexFirst + ", " + NumParams + ", <DTAC>)");
        }
        int count = NumParams;
        byte[] PacketData = new byte[1008];
        if (dtac.SourceType == 6) {
            count = NumParams * 2;
        }
        int[] Values = new int[]{IndexFirst, count, 0, 0};
        ADwinCommand adwc = new ADwinCommand(this.version, 3000447, this.Port);
        adwc.setCommand(13);
        adwc.setTimeout(this.ADwTimeout);
        adwc.setValues(Values);
        adwc.setPwd(this.Password);
        DatagramPacket dp = new DatagramPacket(PacketData, 1008);
        int TryLatersLeft = this.NumWaits;
        int ErrorsOccured = 0;
        boolean SuccessfullyReceived = false;
        while (!SuccessfullyReceived) {
            boolean SomethingReceived;
            int SentIndex;
            if (TryLatersLeft <= 0) {
                if (this.adl != null) {
                    this.adl.message("Too many try-laters...", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Number of Try-Later-Packets received exceeded NumWaits", "Zu viele Try-Later-Pakete", this.Language, 16);
            }
            if (ErrorsOccured > this.AllowedErrors) {
                if (this.adl != null) {
                    this.adl.message("Too many errors...", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Too many packet errors occured", "Zu viele Paket-Fehler", this.Language, 2000);
            }
            DatagramSocket datagramSocket = this.ds;
            synchronized (datagramSocket) {
                try {
                    adwc.setLink(this.Hostlink);
                    SentIndex = this.incGetCurrentIndex();
                    adwc.setPacketIndex(SentIndex);
                    this.ds.send(adwc.getDatagram(this.Connection));
                }
                catch (IOException ioe) {
                    if (this.adl != null) {
                        this.adl.message("IOException -> ADwinCommunicationError when sending in getParBlock", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                }
                SomethingReceived = true;
                do {
                    try {
                        this.ds.setSoTimeout(this.MaxPacketDelay);
                        this.ds.receive(dp);
                    }
                    catch (SocketTimeoutException ste) {
                        if (this.adl != null) {
                            this.adl.message("Timeout when receiving...", 50);
                        }
                        ++ErrorsOccured;
                        SomethingReceived = false;
                    }
                    catch (IOException ioe) {
                        if (this.adl != null) {
                            this.adl.message("IOException -> ADwinCommunicationError when receiving in getParBlock", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                    }
                    if (!SomethingReceived || ADwinDirectDevice.extractInt(PacketData, 4) == SentIndex) continue;
                    if (this.adl != null) {
                        this.adl.message("Invalid packet index received!", 50);
                    }
                    if (ADwinDirectDevice.extractInt(PacketData, 0) != -10 || this.newTryLater()) continue;
                    ADwinDirectDevice.setInteger(PacketData, 4, SentIndex);
                } while (SomethingReceived && ADwinDirectDevice.extractInt(PacketData, 4) != SentIndex);
            }
            if (SomethingReceived) {
                if (ADwinDirectDevice.extractInt(PacketData, 0) == 0) {
                    dtac.storeBytes(PacketData, 8, 0, NumParams);
                    SuccessfullyReceived = true;
                    continue;
                }
                if (ADwinDirectDevice.extractInt(PacketData, 0) == -10) {
                    if (this.adl != null) {
                        this.adl.tryLater(SentIndex, this.NumWaits - TryLatersLeft);
                    }
                    try {
                        Thread.sleep(this.WaitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --TryLatersLeft;
                    continue;
                }
                if (this.adl != null) {
                    this.adl.message("Error (" + ADwinDirectDevice.extractInt(PacketData, 0) + ") ...", 50);
                }
                ++ErrorsOccured;
                continue;
            }
            if (this.adl != null) {
                this.adl.message("Nothing received.... ", 50);
            }
            ++ErrorsOccured;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    private int standardCall(int Command, int[] Values, int RetOffset, String ErrorMsg, String RequestString, String GerErrorMsg, String GerRequestString, boolean ReturnValues, int[] sentIndex) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("standardCall (" + Command + ", {" + Values[0] + ", " + Values[1] + ", " + Values[2] + ", " + Values[3] + "}, " + RetOffset + ", \"" + ErrorMsg + "\", \"" + RequestString + "\", \"" + GerErrorMsg + "\", \"" + GerRequestString + "\", " + ReturnValues + ")");
        }
        ADwinCommand adwc = new ADwinCommand(this.version, 3000447, this.Port);
        adwc.setCommand(Command);
        adwc.setTimeout(this.ADwTimeout);
        adwc.setValues(Values);
        adwc.setPwd(this.Password);
        DatagramPacket ResultPacket = null;
        try {
            ResultPacket = this.sendAndWaitForAnswer32Byte(adwc, sentIndex);
        }
        catch (SocketTimeoutException ste) {
            if (this.adl != null) {
                this.adl.message("ADwinCommunicationError: No answer... ", 1);
                this.adl.leave();
            }
            throw new ADwinCommunicationError("No answer on request for " + RequestString + ", " + ste.getMessage(), "Keine Antwort auf die Anfrage nach " + GerRequestString + ", " + ste.getMessage(), this.Language, 2001);
        }
        byte[] Result = ResultPacket.getData();
        int iRes = ADwinDirectDevice.extractInt(Result, 0);
        if (iRes != 0 && RetOffset != 0) {
            if (this.adl != null) {
                this.adl.message("ADwinCommunicationError: Error " + iRes + " on ADwin System", 1);
                this.adl.leave();
            }
            if (iRes == 1) {
                throw new ADwinCommunicationError("timeout to link", "Timeout beim Schreiben zum Link", this.Language, 1);
            }
            if (iRes == 2) {
                throw new ADwinCommunicationError("timeout from link", "Timeout beim Lesen vom Link", this.Language, 2);
            }
            if (iRes == -5) {
                throw new ADwinCommunicationError("Wrong Password", "Falsches Passwort", this.Language, 2002);
            }
            if (iRes == -30) {
                throw new ADwinCommunicationError("Wrong Version", "Falsche Version", this.Language, 20);
            }
            if (iRes == -31) {
                throw new ADwinCommunicationError("The Data is too small", "Das Data-Feld ist zu klein", this.Language, 100);
            }
            if (iRes == -32) {
                throw new ADwinCommunicationError("The Fifo has not enough values", "Das Fifo-Feld hat nicht genug Daten", this.Language, 102);
            }
            throw new ADwinCommunicationError("Error on ADwin System: " + iRes + " - " + ErrorMsg, "Fehler " + iRes + " auf dem ADwin-System - " + GerErrorMsg, this.Language, iRes > 0 ? iRes : 2000);
        }
        if (ReturnValues) {
            for (int n = 0; n < 4; ++n) {
                Values[n] = ADwinDirectDevice.extractInt(Result, 8 + n * 4);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return ADwinDirectDevice.extractInt(Result, RetOffset);
    }

    public synchronized int getPar(int Index) throws ADwinCommunicationError {
        int RetVal = 0;
        if (this.adl != null) {
            this.adl.enter("getPar (" + Index + ")");
        }
        if (Index > 200) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of requested parameter out of range (1 <= index <= 80)." : "Index des verlangten Parameters au\u00dferhalb des g\u00fcltigen Bereichs (1 <= Index <= 80).");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[4];
                Values[0] = 1;
                Values[1] = 1000 + Index;
                Values[3] = 0;
                Values[2] = 0;
                RetVal = this.standardCall(0, Values, 8, "Unable to load PAR_" + Index + ".", "PAR_" + Index, "Kann PAR_" + Index + " nicht laden", "PAR_" + Index, false, null);
                break;
            }
            case 0: {
                RetVal = this.adwin_tcp_get_par(Index);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return RetVal;
    }

    public synchronized float getFPar(int Index) throws ADwinCommunicationError {
        int RetVal = 0;
        if (this.adl != null) {
            this.adl.enter("getFPar (" + Index + ")");
        }
        if (Index < 1 || Index > 80) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of requested float parameter out of range (1 <= index <= 80)." : "Index des verlangten float-Parameters au\u00dferhalb des g\u00fcltigen Bereichs (1 <= Index <= 80).");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[4];
                Values[0] = 1;
                Values[1] = 1100 + Index;
                Values[3] = 0;
                Values[2] = 0;
                RetVal = this.standardCall(0, Values, 8, "Unable to load FPAR_" + Index + ".", "FPAR_" + Index, "Kann FPAR_" + Index + " nicht laden", "FPAR_" + Index, false, null);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return Float.intBitsToFloat(RetVal);
            }
            case 0: {
                float fRetVal = this.adwin_tcp_get_fpar(Index);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return fRetVal;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized double getFParDouble(int Index) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFParDouble (" + Index + ")");
        }
        if (Index < 1 || Index > 80) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of requested double parameter out of range (1 <= index <= 80)." : "Index des verlangten double-Parameters au\u00dferhalb des g\u00fcltigen Bereichs (1 <= Index <= 80).");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    int[] Values = new int[4];
                    Values[0] = 1;
                    Values[1] = 1200 + Index;
                    Values[3] = 0;
                    Values[2] = 0;
                    this.standardCall(0, Values, 4, "Unable to load FPAR_DOUBLE_" + Index + ".", "FPAR_DOUBLE_" + Index, "Kann FPAR_DOUBLE_" + Index + " nicht setzen", "FPAR_DOUBLE_" + Index, true, null);
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    int i1 = Integer.reverseBytes(Values[0]);
                    int i2 = Integer.reverseBytes(Values[1]);
                    long data = (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
                    return Double.longBitsToDouble(Long.reverseBytes(data));
                }
                int[] Values = new int[4];
                Values[0] = 1;
                Values[1] = 1100 + Index;
                Values[3] = 0;
                Values[2] = 0;
                int RetVal = this.standardCall(0, Values, 8, "Unable to load FPAR_" + Index + ".", "FPAR_" + Index, "Kann FPAR_" + Index + " nicht laden", "FPAR_" + Index, false, null);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return Float.intBitsToFloat(RetVal);
            }
            case 0: {
                double fRetVal = this.adwin_tcp_get_fpar_double(Index);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return fRetVal;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized void setPar(int Index, int NewValue) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setPar (" + Index + ", " + NewValue + ")");
        }
        if (Index > 9002) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of parameter out of range (1 <= index <= 80)." : "Index au\u00dferhalb des g\u00fcltigen Bereichs (1 <= Index <= 80)");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[4];
                Values[0] = 6;
                Values[1] = 1000 + Index;
                Values[2] = NewValue;
                this.standardCall(0, Values, 4, "Unable to set PAR_" + Index + ".", "PAR_" + Index, "Kann PAR_" + Index + " nicht setzen", "PAR_" + Index, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_set_par(Index, NewValue);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setFPar(int Index, float NewValue) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setPar (" + Index + ", " + NewValue + ")");
        }
        if (Index < 1 || Index > 80) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of parameter out of range" : "Index des Parameters au\u00dferhalb des g\u00fcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[4];
                Values[0] = 6;
                Values[1] = 1100 + Index;
                Values[2] = Float.floatToIntBits(NewValue);
                this.standardCall(0, Values, 4, "Unable to set FPAR_" + Index + ".", "FPAR_" + Index, "Kann FPAR_" + Index + " nicht setzen", "FPAR_" + Index, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_set_fpar(Index, NewValue);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setFParDouble(int Index, double NewValue) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setPar (" + Index + ", " + NewValue + ")");
        }
        if (Index < 1 || Index > 80) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of parameter out of range" : "Index des Parameters au\u00dferhalb des g\u00fcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    int[] Values = new int[4];
                    Values[0] = 6;
                    Values[1] = 1200 + Index;
                    long data = Long.reverseBytes(Double.doubleToRawLongBits(NewValue));
                    Values[2] = Integer.reverseBytes((int)(data >> 32));
                    Values[3] = Integer.reverseBytes((int)data);
                    this.standardCall(0, Values, 4, "Unable to set FPAR_" + Index + ".", "FPAR_" + Index, "Kann FPAR_" + Index + " nicht setzen", "FPAR_" + Index, false, null);
                    break;
                }
                int[] Values = new int[4];
                Values[0] = 6;
                Values[1] = 1100 + Index;
                Values[2] = Float.floatToIntBits((float)NewValue);
                this.standardCall(0, Values, 4, "Unable to set FPAR_" + Index + ".", "FPAR_" + Index, "Kann FPAR_" + Index + " nicht setzen", "FPAR_" + Index, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_set_fpar_double(Index, NewValue);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized int getProcessorType() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getProcessorType ()");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            int RetVal = this.ati.processortype;
            if (this.adl != null) {
                this.adl.leave();
            }
            return RetVal;
        }
        byte[] Result = this.getVersionInfo().getData();
        if (ADwinDirectDevice.extractInt(Result, 0) == -5) {
            throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
        }
        if (ADwinDirectDevice.extractInt(Result, 0) > 0) {
            throw new ADwinCommunicationError("Timeout on the ADwin-System", "Timeout auf dem ADwin-System", this.Language, ADwinDirectDevice.extractInt(Result, 0));
        }
        if (ADwinDirectDevice.extractInt(Result, 0) != 0) {
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(Result, 0), "Fehler " + ADwinDirectDevice.extractInt(Result, 0), this.Language, 2000);
        }
        int ProcessorType = ADwinDirectDevice.extractInt(Result, 12);
        switch (ProcessorType) {
            case 146: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 5;
            }
            case 1000: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 9;
            }
            case 1010: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 10;
            }
            case 1011: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 11;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return ProcessorType;
    }

    public synchronized int getCardType() throws ADwinCommunicationError {
        if (this.adwin_tcp_or_udp() == 0) {
            return -1;
        }
        if (this.adl != null) {
            this.adl.enter("getCardType ()");
        }
        byte[] Result = this.getVersionInfo().getData();
        if (this.adl != null) {
            this.adl.leave();
        }
        if (ADwinDirectDevice.extractInt(Result, 0) == -5) {
            throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
        }
        if (ADwinDirectDevice.extractInt(Result, 0) > 0) {
            throw new ADwinCommunicationError("Timeout on the ADwin-System", "Timeout auf dem ADwin-System", this.Language, ADwinDirectDevice.extractInt(Result, 0));
        }
        if (ADwinDirectDevice.extractInt(Result, 0) != 0) {
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(Result, 0), "Fehler " + ADwinDirectDevice.extractInt(Result, 0), this.Language, 2000);
        }
        return ADwinDirectDevice.extractInt(Result, 16);
    }

    public synchronized int getDriverVersion() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDriverVersion ()");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 0: {
                int[] values = new int[4];
                int ret = this.adwin_tcp_testversion(values);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return ret;
            }
            case 1: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 3;
            }
        }
        byte[] Result = this.getVersionInfo().getData();
        if (this.adl != null) {
            this.adl.leave();
        }
        if (ADwinDirectDevice.extractInt(Result, 0) == -5) {
            throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
        }
        if (ADwinDirectDevice.extractInt(Result, 0) > 0) {
            throw new ADwinCommunicationError("Timeout on the ADwin-System", "Timeout auf dem ADwin-System", this.Language, ADwinDirectDevice.extractInt(Result, 0));
        }
        if (ADwinDirectDevice.extractInt(Result, 0) != 0) {
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(Result, 0), "Fehler " + ADwinDirectDevice.extractInt(Result, 0), this.Language, 2000);
        }
        return ADwinDirectDevice.extractInt(Result, 20);
    }

    public synchronized int test_version() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("test_version ()");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 0: {
                int[] values = new int[4];
                int ret = this.adwin_tcp_testversion(values);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return ret;
            }
            case 1: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 3;
            }
        }
        byte[] Result = this.getVersionInfo().getData();
        if (this.adl != null) {
            this.adl.leave();
        }
        if (ADwinDirectDevice.extractInt(Result, 0) == -5) {
            throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
        }
        if (ADwinDirectDevice.extractInt(Result, 0) > 0) {
            throw new ADwinCommunicationError("Timeout on the ADwin-System", "Timeout auf dem ADwin-System", this.Language, ADwinDirectDevice.extractInt(Result, 0));
        }
        if (ADwinDirectDevice.extractInt(Result, 0) != 0) {
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(Result, 0), "Fehler " + ADwinDirectDevice.extractInt(Result, 0), this.Language, 2000);
        }
        int ret = ADwinDirectDevice.extractInt(Result, 8);
        if (ret == 118) {
            return 0;
        }
        return 3;
    }

    int adwin_tcp_testversion(int[] values) throws ADwinCommunicationError {
        this.init_ati(255);
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        resp.max = 16;
        resp.used = 0;
        resp.do_convert = 1;
        resp.data = new byte[16];
        if (this.tcp_write_request(this.ati, null) == -1) {
            return 3;
        }
        if (this.tcp_read_response(this.ati, 16, resp) == -1) {
            return 3;
        }
        for (int i = 0; i < 4; ++i) {
            values[i] = ADwinDirectDevice.extractInt(resp.data, i * 4);
        }
        if (values[0] == 118) {
            return 0;
        }
        return 3;
    }

    public synchronized int[] getDataInt(int DataNr, int IndexFirst, int IndexLast) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataInt (" + DataNr + ", " + IndexFirst + ", " + IndexLast + ")");
        }
        int count = IndexLast - IndexFirst + 1;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    DataToIntArray dtia = (DataToIntArray)this.getDataADwinX(DataNr, IndexFirst, IndexLast, 3);
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    return dtia.getArray();
                }
                DataToIntArray dtia = (DataToIntArray)this.getData(DataNr, IndexFirst, IndexLast, 3);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dtia.getArray();
            }
            case 0: {
                int[] idata = new int[count];
                this.adwin_tcp_get_data_or_fifo_int32(DataNr, idata, IndexFirst, count, 0);
                return idata;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized long[] getDataLong(int DataNr, int IndexFirst, int IndexLast) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataInt (" + DataNr + ", " + IndexFirst + ", " + IndexLast + ")");
        }
        int count = IndexLast - IndexFirst + 1;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    DataToInt64Array dtia = (DataToInt64Array)this.getDataADwinX(DataNr, IndexFirst, IndexLast, 7);
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    return dtia.getArray();
                }
                DataToIntArray dtia = (DataToIntArray)this.getData(DataNr, IndexFirst, IndexLast, 3);
                if (this.adl != null) {
                    this.adl.leave();
                }
                long[] tmp = new long[count];
                this.convert_data_from_int_to_long(dtia.getArray(), tmp, count);
                return tmp;
            }
            case 0: {
                long[] idata = new long[count];
                this.adwin_tcp_get_data_or_fifo_int64(DataNr, idata, IndexFirst, count, 0);
                return idata;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized float[] getDataFloat(int DataNr, int IndexFirst, int IndexLast) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataFloat (" + DataNr + ", " + IndexFirst + ", " + IndexLast + ")");
        }
        int count = IndexLast - IndexFirst + 1;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    DataToFloatArray dtfa = (DataToFloatArray)this.getDataADwinX(DataNr, IndexFirst, IndexLast, 5);
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    return dtfa.getArray();
                }
                DataToFloatArray dtfa = (DataToFloatArray)this.getData(DataNr, IndexFirst, IndexLast, 5);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dtfa.getArray();
            }
            case 0: {
                float[] fdata = new float[count];
                this.adwin_tcp_get_data_or_fifo_float(DataNr, fdata, IndexFirst, count, 0);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return fdata;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized double[] getDataDouble(int DataNr, int IndexFirst, int IndexLast) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataDouble (" + DataNr + ", " + IndexFirst + ", " + IndexLast + ")");
        }
        int count = IndexLast - IndexFirst + 1;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    DataToDoubleArray dtda = (DataToDoubleArray)this.getDataADwinX(DataNr, IndexFirst, IndexLast, 6);
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    return dtda.getArray();
                }
                double[] ddata = new double[count];
                DataToFloatArray dtfa = (DataToFloatArray)this.getData(DataNr, IndexFirst, IndexLast, 5);
                if (this.adl != null) {
                    this.adl.leave();
                }
                float[] fdata = dtfa.getArray();
                this.convert_data_from_float_to_double(fdata, ddata, count);
                return ddata;
            }
            case 0: {
                double[] ddata = new double[count];
                this.adwin_tcp_get_data_or_fifo_double(DataNr, ddata, IndexFirst, count, 0);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return ddata;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized int getDataType(int DataNr) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataType (" + DataNr + ")");
        }
        int DataType = 0;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[]{7, DataNr, 1, 0};
                DataType = this.standardCall(100, Values, 8, "Unable to determine type of DATA_" + DataNr + ".", "type of DATA_" + DataNr, "Kann Typ von DATA_" + DataNr + " nicht bestimmen", "Typ von DATA_" + DataNr, false, null);
                if (DataType == 4) {
                    DataType = 3;
                }
                if (DataType >= 1 && DataType <= 8) break;
                if (this.adl != null) {
                    this.adl.message("Datatype = " + DataType + " -> ADwinCommunicationError", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unable to determine type of DATA_" + DataNr + ".", "Kann Typ von DATA_" + DataNr + " nicht bestimmen.", this.Language, 100);
            }
            case 0: {
                DataType = this.adwin_tcp_get_data_type(DataNr);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return DataType;
    }

    public synchronized int getDataLength(int DataNr) throws ADwinCommunicationError {
        int RetVal = 0;
        if (this.adl != null) {
            this.adl.enter("getDatalength (" + DataNr + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[4];
                Values[0] = 11;
                Values[1] = DataNr;
                RetVal = this.standardCall(0, Values, 8, "Unable to determine length of DATA_" + DataNr + ".", "length of DATA_" + DataNr, "Kann  L\u00e4nge von DATA_" + DataNr + " nicht bestimmen", "L\u00e4nge von DATA_" + DataNr, false, null);
                if (RetVal != 0) break;
                if (this.adl != null) {
                    this.adl.message("Datalength == 0 -> ADwinCommunicationError", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unable to determine length of DATA_" + DataNr + ".", "Kann L\u00e4nge von DATA_" + DataNr + " nicht bestimmen.", this.Language, 100);
            }
            case 0: {
                RetVal = this.adwin_tcp_get_data_length(DataNr);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return RetVal;
    }

    public synchronized void startProcess(int ProcessNo) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("startProcess (" + ProcessNo + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[4];
                Values[0] = 2;
                Values[1] = ProcessNo;
                Values[2] = 0;
                this.standardCall(0, Values, 4, "Cannot start process " + ProcessNo, "starting process " + ProcessNo, "Kann Prozess " + ProcessNo + " nicht starten", "Starten von Prozess " + ProcessNo, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_start_process(ProcessNo);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void loadProcessFile(String FileName) throws IOException, ADwinCommunicationError {
        int t_pos = 3;
        if (this.is_adwinx(this.version)) {
            t_pos = 4;
        }
        if (this.adl != null) {
            this.adl.enter("loadProcess (" + FileName + ")");
        }
        char c = FileName.charAt(FileName.length() - t_pos);
        if (FileName == null || FileName.length() < 4 || c != 't' && c != 'T') {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("Filename " + FileName + " not in ADBasic executable file format (<fffff>.T<x><n> - <fff> = program name, <x> = processor, <n> = process no.)", "Dateiname " + FileName + " nicht im Format f\u00fcr ADBasic Bin\u00e4rdateien (<fffff>.T<x><n> - <fffff> = Programmname, <x> = Prozessor, <n> = Prozessnummer", this.Language, 202);
        }
        char FileProcID = FileName.charAt(FileName.length() - 2);
        if (!(FileProcID >= '0' && FileProcID <= '9' || FileProcID >= 'A' && FileProcID <= 'E' || FileProcID >= 'a' && FileProcID <= 'e')) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("Filename " + FileName + " not in ADBasic executable file format (<fffff>.T<x><n> - <fff> = program name, <x> = processor, <n> = process no.)", "Dateiname " + FileName + " nicht im Format f\u00fcr ADBasic Bin\u00e4rdateien (<fffff>.T<x><n> - <fffff> = Programmname, <x> = Prozessor, <n> = Prozessnummer", this.Language, 202);
        }
        if (this.ati.processortype == -1) {
            this.ati.processortype = this.getProcessorType();
        }
        switch (this.ati.processortype) {
            case 8: {
                if (FileProcID == '8') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00e4rdatei ist f\u00fcr den falschen Prozessor!", this.Language, 205);
            }
            case 9: {
                if (FileProcID == '9') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00e4rdatei ist f\u00fcr den falschen Prozessor!", this.Language, 205);
            }
            case 1010: {
                if (FileProcID == 'a' || FileProcID == 'A') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00e4rdatei ist f\u00fcr den falschen Prozessor!", this.Language, 205);
            }
            case 1011: {
                if (FileProcID == 'b' || FileProcID == 'B') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00e4rdatei ist f\u00fcr den falschen Prozessor!", this.Language, 205);
            }
            case 1012: {
                if (FileProcID == 'c' || FileProcID == 'C') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00e4rdatei ist f\u00fcr den falschen Prozessor!", this.Language, 205);
            }
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                FileInputStream fis = new FileInputStream(FileName);
                byte[] Binary = new byte[fis.available()];
                fis.read(Binary);
                fis.close();
                if (Binary.length == 0) {
                    return;
                }
                this.loadProcessArray(Binary, FileName);
                break;
            }
            case 0: {
                this.adwin_tcp_load_process(FileName);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadProcessArray(byte[] process, String fileName) throws ADwinCommunicationError, IOException {
        if (this.adl != null) {
            this.adl.enter("loadProcessArray (byte[], \"" + fileName + "\")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                byte[] ConfirmationData = new byte[32];
                DatagramPacket ConfPacket = new DatagramPacket(ConfirmationData, 32);
                int[] requestIndex = new int[1];
                int[] Values = new int[]{0, this.DataBlockSize << 16, 9, process.length};
                DatagramSocket datagramSocket = this.ds;
                synchronized (datagramSocket) {
                    this.standardCall(4, Values, 4, "Cannot start loading process " + fileName, "loading process " + fileName, "Kann nicht damit beginnen, Prozess " + fileName + " zu laden", "Laden von Prozess " + fileName, false, requestIndex);
                    DataFieldTransfer dft = new DataFieldTransfer(this.Connection, this.ds, this);
                    dft.send(process.length, process, "Process " + fileName, requestIndex[0]);
                    int TimeoutsOccured = 0;
                    do {
                        try {
                            this.ds.receive(ConfPacket);
                            TimeoutsOccured = 0;
                        }
                        catch (SocketTimeoutException ste) {
                            if (this.adl != null) {
                                this.adl.message("Timeout when receiving confirmation...", 50);
                            }
                            if (++TimeoutsOccured <= this.AllowedErrors) continue;
                            if (this.adl != null) {
                                this.adl.message("Too many timeouts -> ADwinCommunicationError...", 1);
                                this.adl.leave();
                            }
                            throw new ADwinCommunicationError("Process could not be loaded, " + ste.getMessage(), "Prozess konnte nicht geladen werden, " + ste.getMessage(), this.Language, 2001);
                        }
                    } while (TimeoutsOccured > 0);
                }
                if (ADwinDirectDevice.extractInt(ConfirmationData, 0) == 0) break;
                if (this.adl != null) {
                    this.adl.message("Errorcode " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " -> ADwinCommunicationError", 1);
                    this.adl.leave();
                }
                if (ADwinDirectDevice.extractInt(ConfirmationData, 0) == -35) {
                    throw new ADwinCommunicationError("The binary file has been built for different processor", "Die Binaerdatei wurde fuer einen anderen Prozessor erzeugt", this.Language, 205);
                }
                if (ADwinDirectDevice.extractInt(ConfirmationData, 0) == -100) {
                    throw new ADwinCommunicationError("Not enough memory or memory damaged", "Nicht genug Speicher frei oder Speicher besch\u00e4digt", this.Language, 150);
                }
                throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " occured after loading " + fileName + ".", "Fehler " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " nach dem Laden von " + fileName + " aufgetreten", this.Language, ADwinDirectDevice.extractInt(ConfirmationData, 0));
            }
            case 0: {
                this.adwin_tcp_load_process(process);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public boolean is_adwinx(int version) {
        return version >= 400 && version < 500;
    }

    public synchronized void setDataByteADwinX(int DataNr, byte[] DataContents, int IndexFirst, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setDataByte (" + DataNr + ", <int[]>, " + IndexFirst + ", " + Count + ")");
        }
        if (Count <= 0 || Count > DataContents.length) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "The passed array is too small for the given range" : "Das \u00fcbergebene Array ist zu klein f\u00fcr den angegebenen Bereich");
        }
        int DestType = this.getDataType(DataNr);
        if (DestType != 8 && DestType != 1) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("Data ist too small", "Data zu klein", this.Language, 100);
        }
        this.setData(DataContents, DataNr, IndexFirst, IndexFirst + Count - 1, 1);
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setDataInt(int DataNr, int[] DataContents, int IndexFirst, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setDataInt (" + DataNr + ", <int[]>, " + IndexFirst + ", " + Count + ")");
        }
        if (Count <= 0 || Count > DataContents.length) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "The passed array is too small for the given range" : "Das \u00fcbergebene Array ist zu klein f\u00fcr den angegebenen Bereich");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int DestType = this.getDataType(DataNr);
                if (DestType == 4) {
                    DestType = 3;
                }
                if (DestType < 3 || DestType > 6) {
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("Data ist too small", "Data zu klein", this.Language, 100);
                }
                byte[] DataBytes = new byte[Count * 4];
                switch (DestType) {
                    case 3: 
                    case 6: {
                        int n;
                        for (n = 0; n < Count; ++n) {
                            ADwinDirectDevice.setInteger(DataBytes, n * 4, DataContents[n]);
                        }
                        break;
                    }
                    case 5: {
                        int n;
                        for (n = 0; n < Count; ++n) {
                            ADwinDirectDevice.setInteger(DataBytes, n * 4, Float.floatToIntBits(DataContents[n]));
                        }
                        break;
                    }
                }
                if (this.is_adwinx(this.version)) {
                    int type = 0;
                    if (DestType == 6) {
                        type = 3;
                    }
                    this.setData(DataBytes, DataNr, IndexFirst, IndexFirst + Count - 1, type);
                    break;
                }
                this.setData(DataBytes, DataNr, IndexFirst, IndexFirst + Count - 1, 3);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_or_fifo_int32(DataNr, DataContents, IndexFirst, Count, 0);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setDataLong(int DataNr, long[] DataContents, int IndexFirst, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setDataLong (" + DataNr + ", <int[]>, " + IndexFirst + ", " + Count + ")");
        }
        if (Count <= 0 || Count > DataContents.length) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "The passed array is too small for the given range" : "Das \u00fcbergebene Array ist zu klein f\u00fcr den angegebenen Bereich");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int DestType = this.getDataType(DataNr);
                if (DestType == 4) {
                    DestType = 3;
                }
                if (DestType < 3 || DestType > 7) {
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("Data ist too small", "Data zu klein", this.Language, 100);
                }
                byte[] DataBytes = DestType == 6 || DestType == 7 ? new byte[Count * 8] : new byte[Count * 4];
                switch (DestType) {
                    case 3: 
                    case 6: {
                        int n;
                        for (n = 0; n < Count; ++n) {
                            ADwinDirectDevice.setInteger(DataBytes, n * 4, (int)DataContents[n]);
                        }
                        break;
                    }
                    case 5: {
                        int n;
                        for (n = 0; n < Count; ++n) {
                            ADwinDirectDevice.setInteger(DataBytes, n * 4, Float.floatToIntBits(DataContents[n]));
                        }
                        break;
                    }
                    case 7: {
                        int n;
                        for (n = 0; n < Count; ++n) {
                            ADwinDirectDevice.setLong(DataBytes, n * 8, DataContents[n]);
                        }
                        break;
                    }
                }
                if (this.is_adwinx(this.version)) {
                    int type = 0;
                    if (DestType == 6) {
                        type = 3;
                    }
                    this.setData(DataBytes, DataNr, IndexFirst, IndexFirst + Count - 1, type);
                    break;
                }
                this.setData(DataBytes, DataNr, IndexFirst, IndexFirst + Count - 1, 3);
                break;
            }
            case 0: {
                int[] tmp = new int[Count];
                this.convert_data_from_long_to_int(DataContents, tmp, Count);
                this.adwin_tcp_set_data_or_fifo_int32(DataNr, tmp, IndexFirst, Count, 0);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setDataFloat(int DataNr, float[] DataContents, int IndexFirst, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setDataFloat (" + DataNr + ", <float []>, " + IndexFirst + ", " + Count + ")");
        }
        if (Count <= 0 || Count > DataContents.length) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "The array passed is too small for the given range" : "Das \u00fcbergebene Array ist zu klein f\u00fcr den angegebenen Bereich");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int n;
                int DestType = this.getDataType(DataNr);
                if (DestType == 4) {
                    DestType = 3;
                }
                if (DestType < 3 || DestType > 6) {
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("Data ist too small", "Data zu klein", this.Language, 100);
                }
                byte[] DataBytes = new byte[Count * 4];
                if (DestType == 5 || DestType == 6) {
                    for (n = 0; n < Count; ++n) {
                        ADwinDirectDevice.setInteger(DataBytes, n * 4, Float.floatToIntBits(DataContents[n]));
                    }
                } else {
                    for (n = 0; n < Count; ++n) {
                        ADwinDirectDevice.setInteger(DataBytes, n * 4, (int)DataContents[n]);
                    }
                }
                if (this.is_adwinx(this.version)) {
                    int type = 0;
                    if (DestType == 6) {
                        type = 5;
                    }
                    this.setData(DataBytes, DataNr, IndexFirst, IndexFirst + Count - 1, type);
                    break;
                }
                this.setData(DataBytes, DataNr, IndexFirst, IndexFirst + Count - 1, 5);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_or_fifo_float(DataNr, DataContents, IndexFirst, Count, 0);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setDataDouble(int DataNr, double[] DataContents, int IndexFirst, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setDataDouble (" + DataNr + ", <double []>, " + IndexFirst + ", " + Count + ")");
        }
        if (Count <= 0 || Count > DataContents.length) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "The array passed is too small for the given range" : "Das \u00fcbergebene Array ist zu klein f\u00fcr den angegebenen Bereich");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    this.setDataDoubleADwinX(DataNr, DataContents, IndexFirst, Count);
                    break;
                }
                float[] fdata = new float[Count];
                this.convert_data_from_double_to_float(DataContents, fdata, Count);
                this.setDataFloat(DataNr, fdata, IndexFirst, Count);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_or_fifo_double(DataNr, DataContents, IndexFirst, Count, 0);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setDataDoubleADwinX(int DataNr, double[] DataContents, int IndexFirst, int Count) throws ADwinCommunicationError {
        byte[] DataBytes;
        int DestType;
        if (this.adl != null) {
            this.adl.enter("setDataFloat (" + DataNr + ", <float []>, " + IndexFirst + ", " + Count + ")");
        }
        if ((DestType = this.getDataType(DataNr)) == 4) {
            DestType = 3;
        }
        switch (DestType) {
            case 3: {
                int n;
                DataBytes = new byte[Count * 4];
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setInteger(DataBytes, n * 4, (int)DataContents[n]);
                }
                break;
            }
            case 5: {
                int n;
                DataBytes = new byte[Count * 4];
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setInteger(DataBytes, n * 4, Float.floatToIntBits((float)DataContents[n]));
                }
                break;
            }
            case 6: {
                DataBytes = new byte[Count * 8];
                this.convert_data_from_double_to_stream(DataContents, DataBytes, Count);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Data ist too small", "Data zu klein", this.Language, 100);
            }
        }
        if (this.is_adwinx(this.version)) {
            int type = 0;
            if (DestType == 6) {
                type = 6;
            }
            this.setData(DataBytes, DataNr, IndexFirst, IndexFirst + Count - 1, type);
        } else {
            this.setData(DataBytes, DataNr, IndexFirst, IndexFirst + Count - 1, 5);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized int[] getFifoInt(int FifoNr, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFifoInt (" + FifoNr + ", " + Count + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int SourceType = this.getDataType(FifoNr);
                if (SourceType == 4) {
                    SourceType = 3;
                }
                if (SourceType < 3 || SourceType > 6) {
                    throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 102);
                }
                DataToIntArray dtia = new DataToIntArray(Count, SourceType);
                if (this.is_adwinx(this.version)) {
                    int type = 0;
                    if (SourceType == 6) {
                        type = 6;
                    }
                    this.readFifo(FifoNr, Count, dtia, type);
                } else {
                    this.readFifo(FifoNr, Count, dtia, SourceType);
                }
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dtia.getArray();
            }
            case 0: {
                int[] idata = new int[Count];
                this.adwin_tcp_get_data_or_fifo_int32(FifoNr, idata, 1, Count, 1);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return idata;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized float[] getFifoFloat(int FifoNr, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFifoInt (" + FifoNr + ", " + Count + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int SourceType = this.getDataType(FifoNr);
                if (SourceType < 3 || SourceType > 6) {
                    throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 102);
                }
                if (SourceType == 4) {
                    SourceType = 3;
                }
                DataToFloatArray dtfa = new DataToFloatArray(Count, SourceType);
                if (this.is_adwinx(this.version)) {
                    if (SourceType != 6) {
                        SourceType = 0;
                    }
                    this.readFifo(FifoNr, Count, dtfa, SourceType);
                } else {
                    this.readFifo(FifoNr, Count, dtfa, SourceType);
                }
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dtfa.getArray();
            }
            case 0: {
                float[] fdata = new float[Count];
                this.adwin_tcp_get_data_or_fifo_float(FifoNr, fdata, 1, Count, 1);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return fdata;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized double[] getFifoDoubleADwinX(int FifoNr, int Count) throws ADwinCommunicationError {
        int SourceType;
        if (this.adl != null) {
            this.adl.enter("getFifoFloat (" + FifoNr + ", " + Count + ")");
        }
        if ((SourceType = this.getDataType(FifoNr)) == 4) {
            SourceType = 3;
        }
        if (SourceType < 3 || SourceType > 6) {
            throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 102);
        }
        DataToDoubleArray dtda = new DataToDoubleArray(Count, SourceType);
        this.readFifo(FifoNr, Count, dtda, SourceType);
        if (this.adl != null) {
            this.adl.leave();
        }
        return dtda.getArray();
    }

    public synchronized double[] getFifoDouble(int FifoNr, int Count) throws ADwinCommunicationError {
        double[] ddata;
        if (this.adl != null) {
            this.adl.enter("getFifoDouble (" + FifoNr + ", " + Count + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    ddata = this.getFifoDoubleADwinX(FifoNr, Count);
                    break;
                }
                ddata = new double[Count];
                float[] fdata = this.getFifoFloat(FifoNr, Count);
                this.convert_data_from_float_to_double(fdata, ddata, Count);
                break;
            }
            case 0: {
                ddata = new double[Count];
                this.adwin_tcp_get_data_or_fifo_double(FifoNr, ddata, 1, Count, 1);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return ddata;
    }

    public synchronized void setFifoInt(int FifoNr, int Count, int[] Data) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setFifoInt (" + FifoNr + ", " + Count + ", <int []>)");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            this.adwin_tcp_set_data_or_fifo_int32(FifoNr, Data, 1, Count, 1);
            if (this.adl != null) {
                this.adl.leave();
            }
            return;
        }
        int DestType = this.getDataType(FifoNr);
        if (DestType == 4) {
            DestType = 3;
        }
        if (DestType < 3 || DestType > 6) {
            throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 101);
        }
        byte[] FifoData = new byte[Count * 4];
        switch (DestType) {
            case 3: 
            case 6: {
                int n;
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setInteger(FifoData, n * 4, Data[n]);
                }
                break;
            }
            case 5: {
                int n;
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setInteger(FifoData, n * 4, Float.floatToIntBits(Data[n]));
                }
                break;
            }
        }
        int NumBlocks = (Count - 1) / ((this.DataBlockSize + 1) * 350) + 1;
        int WordsSent = 0;
        for (int n = 0; n < NumBlocks; ++n) {
            int WordsToSend = n != NumBlocks - 1 ? 350 * (this.DataBlockSize + 1) : Count % (350 * (this.DataBlockSize + 1));
            if (WordsToSend == 0) {
                WordsToSend = 350 * (this.DataBlockSize + 1);
            }
            if (this.is_adwinx(this.version)) {
                int type = 0;
                if (DestType == 6) {
                    type = 3;
                }
                this.writeFifo(FifoNr, type, WordsToSend, WordsToSend, FifoData, WordsSent * 4);
            } else {
                this.writeFifo(FifoNr, 2, WordsToSend, WordsToSend, FifoData, WordsSent * 4);
            }
            WordsSent += WordsToSend;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setFifoFloat(int FifoNr, int Count, float[] Data) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setFifoFloat (" + FifoNr + ", " + Count + ", <float[]>)");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            this.adwin_tcp_set_data_or_fifo_float(FifoNr, Data, 1, Count, 1);
            if (this.adl != null) {
                this.adl.leave();
            }
            return;
        }
        int DestType = this.getDataType(FifoNr);
        if (DestType < 3 || DestType > 6) {
            throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 101);
        }
        byte[] FifoData = new byte[Count * 4];
        switch (DestType) {
            case 3: {
                int n;
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setInteger(FifoData, n * 4, (int)Data[n]);
                }
                break;
            }
            case 5: 
            case 6: {
                int n;
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setInteger(FifoData, n * 4, Float.floatToIntBits(Data[n]));
                }
                break;
            }
        }
        int NumBlocks = (Count - 1) / ((this.DataBlockSize + 1) * 350) + 1;
        int WordsSent = 0;
        for (int n = 0; n < NumBlocks; ++n) {
            int WordsToSend = n != NumBlocks - 1 ? 350 * (this.DataBlockSize + 1) : Count % (350 * (this.DataBlockSize + 1));
            if (WordsToSend == 0) {
                WordsToSend = 350 * (this.DataBlockSize + 1);
            }
            if (this.is_adwinx(this.version)) {
                int type = 0;
                if (DestType == 6) {
                    type = 5;
                }
                this.writeFifo(FifoNr, type, WordsToSend, WordsToSend, FifoData, WordsSent * 4);
            } else {
                this.writeFifo(FifoNr, 2, WordsToSend, WordsToSend, FifoData, WordsSent * 4);
            }
            WordsSent += WordsToSend;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void setFifoDouble(int FifoNr, int Count, double[] Data) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setFifoDouble (" + FifoNr + ", " + Count + ", <double[]>)");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    this.setFifoDoubleADwinX(FifoNr, Count, Data);
                    break;
                }
                float[] fdata = new float[Count];
                this.convert_data_from_double_to_float(Data, fdata, Count);
                this.setFifoFloat(FifoNr, Count, fdata);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_or_fifo_double(FifoNr, Data, 1, Count, 1);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public int BytesPerValue(int DataType) {
        switch (DataType) {
            case 1: 
            case 8: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 6: 
            case 7: {
                return 8;
            }
        }
        return 4;
    }

    private void setFifoDoubleADwinX(int FifoNr, int Count, double[] Data) throws ADwinCommunicationError {
        int DestType;
        if (this.adl != null) {
            this.adl.enter("setFifoFloat (" + FifoNr + ", " + Count + ", <float[]>)");
        }
        if ((DestType = this.getDataType(FifoNr)) < 3 || DestType > 6) {
            throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 101);
        }
        int type = DestType;
        int bytes_per_value = this.BytesPerValue(DestType);
        float SizeFactor = 1.0f;
        if (bytes_per_value == 8) {
            SizeFactor = 2.0f;
        }
        int values_per_block = (int)((float)(350 * this.DataBlockSize) / SizeFactor);
        byte[] FifoData = new byte[Count * bytes_per_value];
        switch (DestType) {
            case 3: {
                int n;
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setInteger(FifoData, n * 4, (int)Data[n]);
                }
                type = 0;
                break;
            }
            case 5: {
                int n;
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setInteger(FifoData, n * 4, Float.floatToIntBits((float)Data[n]));
                }
                type = 0;
                break;
            }
            case 6: {
                int n;
                for (n = 0; n < Count; ++n) {
                    ADwinDirectDevice.setLong(FifoData, n * 8, Double.doubleToLongBits(Data[n]));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + DestType);
            }
        }
        int NumBlocks = (int)(((float)Count * SizeFactor - 1.0f) / (float)(this.DataBlockSize * 350) + 1.0f);
        int WordsSent = 0;
        for (int n = 0; n < NumBlocks; ++n) {
            int cnt;
            int WordsToSend;
            if (n != NumBlocks - 1) {
                WordsToSend = 350 * this.DataBlockSize;
                cnt = values_per_block;
            } else {
                WordsToSend = (int)((float)Count * SizeFactor) - n * 350 * this.DataBlockSize;
                cnt = Count % values_per_block;
                if (cnt == 0) {
                    cnt = values_per_block;
                }
            }
            if (WordsToSend == 0) {
                WordsToSend = 350 * this.DataBlockSize;
                cnt = values_per_block;
            }
            this.writeFifo(FifoNr, type, cnt, WordsToSend, FifoData, WordsSent * 4);
            WordsSent += WordsToSend;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized int getWorkload() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getWorkload ()");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[4];
                Values[0] = 20;
                Values[1] = 0;
                Values[2] = 0;
                int RetCode = this.standardCall(20, Values, 16, "Unable to read workload.", "workload", "Kann Auslaustung nicht lesen", "Auslastung", true, null);
                int processor = this.getProcessorType();
                if (this.adl != null) {
                    this.adl.leave();
                }
                if (RetCode == 0) {
                    if (processor == 11) {
                        return (int)(900.0 * (0.1111111111111111 - (double)((float)Values[0] / (float)Values[1])));
                    }
                    return (int)(400.0 * (0.25 - (double)((float)Values[0] / (float)Values[1])));
                }
                return Values[0];
            }
            case 0: {
                float RetVal = this.adwin_tcp_workload();
                if (this.adl != null) {
                    this.adl.leave();
                }
                return (int)RetVal;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized int getFreeMem(int Type) throws ADwinCommunicationError {
        int RetVal;
        if (this.adl != null) {
            this.adl.enter("getFreeMem (" + Type + ")");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            int ret = this.adwin_tcp_free_mem(Type);
            if (this.adl != null) {
                this.adl.leave();
            }
            return ret;
        }
        if (Type < 0 || Type > 6) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Type may only be 0 - 6" : "Type darf nur 0 - 6 sein");
        }
        int processor = this.getProcessorType();
        if (Type == 0) {
            int[] Values = new int[]{5, 0, 0, 0};
            RetVal = this.standardCall(0, Values, 8, "Unable to determine amount of free memory", "amount of free memory", "Kann die Gr\u00f6\u00dfe des freien Speichers nicht bestimmen", "Gr\u00f6\u00dfe des freien Speichers", false, null);
        } else {
            int[] Values = new int[]{12, Type, 0, 0};
            RetVal = this.standardCall(0, Values, 8, "Unable to determine amount of free memory", "amount of free memory", "Gr\u00f6\u00dfe des freien Speichers konnte nicht bestimmt werden", "Gr\u00f6\u00dfe des freien Speichers", false, null);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        if (Type == 1 && (processor == 9 || processor == 10)) {
            return RetVal * 6;
        }
        if (processor == 10121) {
            return RetVal;
        }
        return RetVal * 4;
    }

    public synchronized void stopProcess(int ProcessNo) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("stopProcess (" + ProcessNo + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[]{3, ProcessNo, 0, 0};
                this.standardCall(0, Values, 4, "Unable to stop process " + ProcessNo + ".", "stop process " + ProcessNo, "Prozess " + ProcessNo + " konnte nicht angehalten werden", "Process " + ProcessNo + " stoppen", false, null);
                if (this.adl == null) break;
                this.adl.leave();
                break;
            }
            case 0: {
                this.adwin_tcp_stop_process(ProcessNo);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized int getProcessState(int ProcessNo) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getProcessState (" + ProcessNo + ")");
        }
        if (ProcessNo < 1 || ProcessNo > 15) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "ProcessNo is out of range" : "ProcesssNo au\u00dferhalb des g\u00fcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[]{1, ProcessNo + 900, 0, 0};
                int RetVal = this.standardCall(0, Values, 8, "Unable to determine state of process " + ProcessNo, "state of process " + ProcessNo, "Status von Prozess " + ProcessNo + " konnte nicht bestimmt werden", "Status von Prozess " + ProcessNo, false, null);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return RetVal;
            }
            case 0: {
                int RetVal = this.adwin_tcp_process_status(ProcessNo);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return RetVal;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized void clearProcess(int ProcessNo) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("clearProcess (" + ProcessNo + ")");
        }
        if (ProcessNo < 1 || ProcessNo > 15) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "ProcessNo is out of range" : "ProcessNo ist au\u00dferhalb des g\u00fcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[]{14, ProcessNo, 0, 0};
                this.standardCall(0, Values, 8, "Unable to clear process " + ProcessNo, "clear process " + ProcessNo, "Prozess " + ProcessNo + " konnte nicht gel\u00f6scht werden ", "L\u00f6schen von Prozess " + ProcessNo, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_clear_process(ProcessNo);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized int[] getParIntBlock(int IndexFirst, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParIntBlock (" + IndexFirst + ", " + Count + ")");
        }
        if (IndexFirst < 1 || Count < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "All parameters must be positive" : "Alle Parameter m\u00fcssen positiv sein");
        }
        if (IndexFirst + Count - 1 > 80) {
            throw new IllegalArgumentException(this.Language == 1 ? "There are only 80 parameters" : "Es gibt nur 80 Parameter");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                DataToIntArray dtia = new DataToIntArray(Count, 3);
                this.getParBlock(IndexFirst, Count, dtia);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dtia.getArray();
            }
            case 0: {
                int[] pars = new int[Count];
                this.adwin_tcp_get_par_block(IndexFirst, Count, pars);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return pars;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized int[] getParIntAll() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParIntAll ()");
        }
        DataToIntArray dtia = new DataToIntArray(80, 3);
        this.getParBlock(1, 80, dtia);
        if (this.adl != null) {
            this.adl.leave();
        }
        return dtia.getArray();
    }

    public synchronized float[] getParFloatBlock(int IndexFirst, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParFloatBlock (" + IndexFirst + ", " + Count + ")");
        }
        if (IndexFirst < 1 || Count < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "All parameters must be positive" : "Alle Parameter m\u00fcssen positiv sein");
        }
        if (IndexFirst + Count - 1 > 80) {
            throw new IllegalArgumentException(this.Language == 1 ? "There are only 80 parameters" : "Es gibt nur 80 Parameter");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                DataToFloatArray dtfa = new DataToFloatArray(Count, 5);
                this.getParBlock(IndexFirst + 100, Count, dtfa);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dtfa.getArray();
            }
            case 0: {
                float[] fpars = new float[Count];
                this.adwin_tcp_get_fpar_block(IndexFirst, Count, fpars);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return fpars;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized double[] getParFloatBlockDouble(int IndexFirst, int Count) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParFloatBlockDouble (" + IndexFirst + ", " + Count + ")");
        }
        if (IndexFirst < 1 || Count < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "All parameters must be positive" : "Alle Parameter m\u00fcssen positiv sein");
        }
        if (IndexFirst + Count - 1 > 80) {
            throw new IllegalArgumentException(this.Language == 1 ? "There are only 80 parameters" : "Es gibt nur 80 Parameter");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                double[] dpars = new double[Count];
                if (this.is_adwinx(this.version)) {
                    DataToDoubleArray dtda = new DataToDoubleArray(Count, 6);
                    this.getParBlock(IndexFirst + 200, Count, dtda);
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    dpars = dtda.getArray();
                    return dpars;
                }
                DataToFloatArray dtfa = new DataToFloatArray(Count, 5);
                this.getParBlock(IndexFirst + 100, Count, dtfa);
                if (this.adl != null) {
                    this.adl.leave();
                }
                float[] fpars = dtfa.getArray();
                for (int i = 0; i < Count; ++i) {
                    dpars[i] = fpars[i];
                }
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dpars;
            }
            case 0: {
                double[] dpars = new double[Count];
                this.adwin_tcp_get_fpar_block_double(IndexFirst, Count, dpars);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dpars;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized float[] getParFloatAll() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParFloatAll ()");
        }
        DataToFloatArray dtfa = new DataToFloatArray(80, 5);
        this.getParBlock(101, 80, dtfa);
        if (this.adl != null) {
            this.adl.leave();
        }
        return dtfa.getArray();
    }

    public synchronized int getFifoFree(int FifoNo) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFifoFree (" + FifoNo + ")");
        }
        if (FifoNo < 1 || FifoNo > 200) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "FifoNo (" + FifoNo + ") is out of range" : "FifoNo (" + FifoNo + ") au\u00dferhalb des g\u00fcltigen Bereichs");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            int ret = this.adwin_tcp_fifo_empty(FifoNo);
            if (this.adl != null) {
                this.adl.leave();
            }
            return ret;
        }
        int[] Values = new int[]{22, FifoNo, 0, 0};
        int RetVal = this.standardCall(0, Values, 8, "Unable to determine number of free elements in fifo " + FifoNo, "number of free elements in fifo " + FifoNo, "Anzahl der freien Elemente in Fifo " + FifoNo + " konnte nicht bestimmt werden", "Anzahl der freien Elemente in " + FifoNo, false, null);
        if (this.adl != null) {
            this.adl.leave();
        }
        return RetVal;
    }

    public synchronized int getFifoUsed(int FifoNo) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFifoUsed (" + FifoNo + ")");
        }
        if (FifoNo < 1 || FifoNo > 200) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "FifoNo (" + FifoNo + ") is out of range" : "FifoNo (" + FifoNo + ") au\u00dferhalb des g\u00fcltigen Bereichs");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            int ret = this.adwin_tcp_fifo_full(FifoNo);
            if (this.adl != null) {
                this.adl.leave();
            }
            return ret;
        }
        int[] Values = new int[]{23, FifoNo, 0, 0};
        int RetVal = this.standardCall(0, Values, 8, "Unable to determine number of used elements in fifo " + FifoNo, "number of used elements in fifo " + FifoNo, "Anzahl der benutzen Elemente in Fifo " + FifoNo + "konnte nicht bestimmt werden", "Anzahl der benutzten Elemente in Fifo " + FifoNo, false, null);
        if (this.adl != null) {
            this.adl.leave();
        }
        return RetVal;
    }

    public synchronized void clearFifo(int FifoNo) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("clearFifo (" + FifoNo + ")");
        }
        if (FifoNo < 1 || FifoNo > 200) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "FifoNo (" + FifoNo + ") is out of range" : "FifoNo (" + FifoNo + ") ist au\u00dferhalb des g\u00fcltigen Bereichs");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            this.adwin_tcp_fifo_clear(FifoNo);
            if (this.adl != null) {
                this.adl.leave();
            }
            return;
        }
        int[] Values = new int[]{21, FifoNo, 0, 0};
        this.standardCall(0, Values, 4, "Unable to clear fifo " + FifoNo, "clear fifo " + FifoNo, "Fifo " + FifoNo + " konnte nicht gel\u00f6scht werden.", "L\u00f6schen von Fifo " + FifoNo, false, null);
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized int getStringLength(int DataNo) throws ADwinCommunicationError {
        if (DataNo < 1 || DataNo > 200) {
            throw new IllegalArgumentException(this.Language == 1 ? "DataNo is out of range" : "DataNo nicht innerhalb des g\u00fcltigen Bereichs");
        }
        if (this.adl != null) {
            this.adl.enter("getStringLength (" + DataNo + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    int[] Values = new int[4];
                    Values[0] = 44;
                    Values[1] = DataNo;
                    Values[3] = 0;
                    Values[2] = 0;
                    return this.standardCall(0, Values, 8, "Unable to get stringlength from data " + DataNo + ".", "getStringLength " + DataNo, "StringLength von Data " + DataNo + " kann nicht abgerufen werden", "Data_" + DataNo, false, null);
                }
                int[] Length = this.getDataInt(DataNo, 1, 1);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return Length[0];
            }
            case 0: {
                int ret = this.adwin_tcp_string_length(DataNo);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return ret;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized String getString(int DataNo) throws ADwinCommunicationError {
        if (DataNo < 1 || DataNo > 200) {
            throw new IllegalArgumentException(this.Language == 1 ? "DataNo is out of range" : "DataNo nicht innerhalb des g\u00fcltigen Bereichs");
        }
        if (this.adl != null) {
            this.adl.enter("getString (" + DataNo + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int DataType = this.getDataType(DataNo);
                if (this.is_adwinx(this.version)) {
                    if (DataType != 8) {
                        if (this.adl != null) {
                            this.adl.leave();
                        }
                        throw new IllegalArgumentException(this.Language == 1 ? "DATA_" + DataNo + " is not of type string" : "DATA_" + DataNo + " ist nicht vom Typ string");
                    }
                    int len = this.getStringLength(DataNo);
                    DataToByteArray dtba = (DataToByteArray)this.getDataADwinX(DataNo, 0, len, DataType);
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    return dtba.getString();
                }
                if (DataType != 3) {
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new IllegalArgumentException(this.Language == 1 ? "DATA_" + DataNo + " is not of type int" : "DATA_" + DataNo + " ist nicht vom Typ int");
                }
                DataToIntArray dtia = (DataToIntArray)this.getData(DataNo, 1, this.getStringLength(DataNo) + 1, DataType);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dtia.getString();
            }
            case 0: {
                int strlen = this.adwin_tcp_string_length(DataNo);
                String str = this.adwin_tcp_get_data_string(DataNo, strlen);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return str;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized void setString(int DataNo, String Str) throws ADwinCommunicationError {
        if (DataNo < 1 || DataNo > 200) {
            throw new IllegalArgumentException(this.Language == 1 ? "DataNo is out of range" : "DataNo nicht innerhalb des g\u00fcltigen Bereichs");
        }
        if (this.adl != null) {
            this.adl.enter("setString (" + DataNo + ", \"" + Str + "\")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                if (this.is_adwinx(this.version)) {
                    byte[] stringdata = Str.getBytes();
                    int strlen = stringdata.length + 1;
                    byte[] data = new byte[strlen];
                    System.arraycopy(stringdata, 0, data, 0, strlen - 1);
                    data[strlen - 1] = 0;
                    this.setDataByteADwinX(DataNo, data, 0, strlen);
                    break;
                }
                int[] StringData = new int[Str.length() + 2];
                StringData[0] = Str.length();
                for (int n = 0; n < Str.length(); ++n) {
                    StringData[n + 1] = Str.charAt(n);
                }
                StringData[Str.length() + 1] = 0;
                this.setDataInt(DataNo, StringData, 1, Str.length() + 2);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_string(DataNo, Str, Str.length() + 2);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized int getGlobalDelay(int ProcessNo) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getGlobalDelay (" + ProcessNo + ")");
        }
        if (ProcessNo < 1 || ProcessNo > 10) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "ProcessNo is out of range" : "ProcessNo nicht innerhalb des g\u00fcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[]{1, 910 + ProcessNo, 0, 0};
                int RetVal = this.standardCall(0, Values, 8, "Unable to load the GlobalDelay of Process " + ProcessNo + ".", "GlobalDelay of Process " + ProcessNo, "Das GlobalDelay von Prozess " + ProcessNo + " konnte nicht geladen werden.", "GlobalDelay von Prozess " + ProcessNo, false, null);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return RetVal;
            }
            case 0: {
                int RetVal = this.adwin_tcp_get_processdelay(ProcessNo);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return RetVal;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public synchronized void setGlobalDelay(int ProcessNo, int NewGlobalDelay) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setGlobalDelay (" + ProcessNo + ", " + NewGlobalDelay + ")");
        }
        if (ProcessNo < 1 || ProcessNo > 10) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "ProcessNo is out of range" : "ProcessNo nicht innerhalb des g\u00fcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] Values = new int[]{6, 910 + ProcessNo, NewGlobalDelay, 0};
                this.standardCall(0, Values, 4, "Unable to set the GlobalDelay of Process " + ProcessNo + ".", "setting GlobalDelay for Process " + ProcessNo + ".", "Das GlobalDelay f\u00fcr Prozess " + ProcessNo + " konnte nicht gesetzt werden", "Setzen des GlobalDelays von Prozess " + ProcessNo, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_set_processdelay(ProcessNo, NewGlobalDelay);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public synchronized void bootFile(String FileName, int Processor) throws ADwinCommunicationError, IOException {
        int l;
        if (this.adl != null) {
            this.adl.enter("bootFile (" + FileName + ", " + Processor + ")");
        }
        if (FileName == null || (l = FileName.length()) < 5) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("The file is not a BTL file", "Die Datei ist keine BTL-Datei", this.Language, 204);
        }
        if (FileName.charAt(l - 1) != 'l' && FileName.charAt(l - 1) != 'L' || FileName.charAt(l - 2) != 't' && FileName.charAt(l - 2) != 'T' || FileName.charAt(l - 3) != 'b' && FileName.charAt(l - 3) != 'B') {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("The file is not a BTL file", "Die Datei ist keine BTL-Datei", this.Language, 204);
        }
        if (FileName.toLowerCase().endsWith("121.btl")) {
            FileInputStream fis = new FileInputStream(FileName);
            byte[] Binary = new byte[fis.available()];
            fis.read(Binary);
            fis.close();
            if (Binary.length == 0) {
                return;
            }
            this.bootArrayADwinX(Binary, FileName, Processor);
            return;
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                FileInputStream fis = new FileInputStream(FileName);
                byte[] Binary = new byte[fis.available()];
                fis.read(Binary);
                fis.close();
                if (Binary.length == 0) {
                    return;
                }
                this.bootArray(Binary, FileName, Processor);
                break;
            }
            case 0: {
                this.adwin_tcp_boot(FileName);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public static List<NetworkInterface> getAllInterfaces() {
        ArrayList<NetworkInterface> ret = new ArrayList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                ret.add(networkInterface);
            }
        }
        catch (SocketException ex) {
            System.err.println("SocketException: " + ex);
        }
        return ret;
    }

    private void sendADwinXBootBroadcast() {
        int BufLen = 100;
        byte[] data = new byte[108];
        data[0] = 51;
        data[1] = 0;
        data[2] = 18;
        data[3] = 118;
        System.arraycopy(this.Connection.getAddress(), 0, data, 4, 4);
        data[8] = (byte)(this.Port >> 8 & 0xFF);
        data[9] = (byte)(this.Port & 0xFF);
        System.arraycopy(this.Password.getBytes(), 0, data, 10, this.Password.length());
        List<NetworkInterface> nil = ADwinDirectDevice.getAllInterfaces();
        int dev_ip_as_int = ByteBuffer.wrap(this.Connection.getAddress()).getInt();
        for (NetworkInterface ni : nil) {
            try {
                if (ni.isLoopback() || !ni.isUp()) continue;
                List<InterfaceAddress> inal = ni.getInterfaceAddresses();
                for (InterfaceAddress ia : inal) {
                    int net_ip_as_int;
                    int prefix;
                    short prefixlen = ia.getNetworkPrefixLength();
                    if (prefixlen <= 1 || prefixlen >= 32 || (dev_ip_as_int & (prefix = -1 << 32 - prefixlen)) != ((net_ip_as_int = ByteBuffer.wrap(ia.getAddress().getAddress()).getInt()) & prefix)) continue;
                    DatagramSocket socket = new DatagramSocket(new InetSocketAddress(ia.getAddress(), 0));
                    socket.setBroadcast(true);
                    socket.send(new DatagramPacket(data, BufLen, new InetSocketAddress("255.255.255.255", 7000)));
                    socket.close();
                }
            }
            catch (SocketException ex) {
                System.err.println("SocketException: " + ex);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void bootArrayADwinX(byte[] OS, String FileName, int Processor) throws ADwinCommunicationError, IOException {
        if (this.adl != null) {
            this.adl.enter("bootArrayADwinX (<byte[]>, " + FileName + ", " + Processor + ")");
        }
        int _timeout = this.MaxPacketDelay;
        this.MaxPacketDelay = 100;
        this.version = 0;
        try {
            this.getArmVersion();
            if (this.version < 400) {
                throw new ADwinCommunicationError("", "", this.Language, 205);
            }
            System.out.print(" (getArmVersion: " + this.version + ") ");
        }
        catch (ADwinCommunicationError awce) {
            if (awce.getCode() == 205) {
                if (this.adl != null) {
                    this.adl.leave();
                }
                this.MaxPacketDelay = _timeout;
                throw new ADwinCommunicationError("The binary file has been built for a different processor.", "Diese BTL ist f\u00fcr einen anderen Prozessor.", this.Language, 205);
            }
            this.MaxPacketDelay = 300;
            try {
                for (int i = 0; i < 4; ++i) {
                    this.sendADwinXBootBroadcast();
                    if (i >= 3) continue;
                    Thread.sleep(300L);
                }
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                this.MaxPacketDelay = _timeout;
                e.printStackTrace();
            }
        }
        this.MaxPacketDelay = _timeout < 1500 ? 1500 : _timeout;
        byte[] ConfirmationData = new byte[32];
        DatagramPacket ConfPacket = new DatagramPacket(ConfirmationData, 32);
        int[] requestPacketIndex = new int[1];
        int[] Values = new int[]{1000, this.DataBlockSize << 16, Processor, OS.length};
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            this.standardCall(50, Values, 4, "Unable to start booting.", "starting to boot", "Es konnte nicht mit dem Booten begonnen werden", "Start des Bootens", false, requestPacketIndex);
            DataFieldTransfer dft = new DataFieldTransfer(this.Connection, this.ds, this);
            dft.send(OS.length, OS, "operating system " + FileName, requestPacketIndex[0]);
            int TimeoutsOccured = 0;
            do {
                try {
                    this.ds.receive(ConfPacket);
                    TimeoutsOccured = 0;
                }
                catch (SocketTimeoutException ste) {
                    ++TimeoutsOccured;
                    if (this.adl != null) {
                        this.adl.message("Timeout...", 100);
                    }
                    if (TimeoutsOccured <= this.AllowedErrors) continue;
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    this.MaxPacketDelay = _timeout;
                    throw new ADwinCommunicationError("ADwin system could not be booted, " + ste.getMessage(), "ADwin-System konnte nicht gebootet werden, " + ste.getMessage(), this.Language, 2001);
                }
                catch (IOException ioe) {
                    this.MaxPacketDelay = _timeout;
                    if (this.adl != null) {
                        this.adl.message("IOException -> ADwinCommunicationError", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                }
            } while (TimeoutsOccured > 0);
        }
        if (ADwinDirectDevice.extractInt(ConfirmationData, 0) != 0) {
            if (this.adl != null) {
                this.adl.message("Error Code: " + ADwinDirectDevice.extractInt(ConfirmationData, 0), 1);
                this.adl.leave();
            }
            this.MaxPacketDelay = _timeout;
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " occured after loading operating system " + FileName + ".", "Fehler " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " nach dem Laden von Betriebssystem " + FileName + " aufgetreten", this.Language, ADwinDirectDevice.extractInt(ConfirmationData, 0));
        }
        this.MaxPacketDelay = _timeout;
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void bootArray(byte[] OS, String FileName, int Processor) throws ADwinCommunicationError, IOException {
        if (this.adl != null) {
            this.adl.enter("bootArray (<byte[]>, " + FileName + ", " + Processor + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                byte[] ConfirmationData = new byte[32];
                DatagramPacket ConfPacket = new DatagramPacket(ConfirmationData, 32);
                int[] requestPacketIndex = new int[1];
                int[] Values = new int[]{1000, this.DataBlockSize << 16, Processor, OS.length};
                DatagramSocket datagramSocket = this.ds;
                synchronized (datagramSocket) {
                    this.standardCall(50, Values, 4, "Unable to start booting.", "starting to boot", "Es konnte nicht mit dem Booten begonnen werden", "Start des Bootens", false, requestPacketIndex);
                    DataFieldTransfer dft = new DataFieldTransfer(this.Connection, this.ds, this);
                    dft.send(OS.length, OS, "operating system " + FileName, requestPacketIndex[0]);
                    int TimeoutsOccured = 0;
                    do {
                        try {
                            this.ds.receive(ConfPacket);
                            TimeoutsOccured = 0;
                        }
                        catch (SocketTimeoutException ste) {
                            ++TimeoutsOccured;
                            if (this.adl != null) {
                                this.adl.message("Timeout...", 100);
                            }
                            if (TimeoutsOccured <= this.AllowedErrors) continue;
                            if (this.adl != null) {
                                this.adl.leave();
                            }
                            throw new ADwinCommunicationError("ADwin system could not be booted, " + ste.getMessage(), "ADwin-System konnte nicht gebootet werden, " + ste.getMessage(), this.Language, 2001);
                        }
                        catch (IOException ioe) {
                            if (this.adl != null) {
                                this.adl.message("IOException -> ADwinCommunicationError", 1);
                                this.adl.leave();
                            }
                            throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.Language, 2000);
                        }
                    } while (TimeoutsOccured > 0);
                }
                if (ADwinDirectDevice.extractInt(ConfirmationData, 0) == 0) break;
                if (this.adl != null) {
                    this.adl.message("Error Code: " + ADwinDirectDevice.extractInt(ConfirmationData, 0), 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " occured after loading operating system " + FileName + ".", "Fehler " + ADwinDirectDevice.extractInt(ConfirmationData, 0) + " nach dem Laden von Betriebssystem " + FileName + " aufgetreten", this.Language, ADwinDirectDevice.extractInt(ConfirmationData, 0));
            }
            case 0: {
                this.adwin_tcp_boot(OS);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    void new_socket() throws SocketException {
        this.ati.socket = new Socket();
        this.ati.socket.setSendBufferSize(131072);
        this.ati.socket.setReceiveBufferSize(131072);
        this.ati.socket.setSoTimeout(this.ati.timeout_ms);
        this.ati.socket.setTcpNoDelay(true);
    }

    final void adwin_tcp_construct() throws SocketException {
        this.ati = new adwin_tcp_info_t();
        this.ati.server_addr = this.Connection;
        this.ati.req = new adwin_tcp_buffer_t();
        this.ati.resp = new adwin_tcp_buffer_t();
        this.ati.error_number = 0;
        this.ati.firmware_version = 0;
        this.ati.firmware_version_beta = 0;
        this.ati.processortype = -1;
        this.ati.initialized = true;
        this.ati.timeout_size = 0xA00000;
        this.ati.req.max = 10240;
        this.ati.req.data = new byte[this.ati.req.max + 4];
        ADwinDirectDevice.setInteger(this.ati.req.data, 10240, 305432421);
        this.ati.resp.max = 10240;
        this.ati.resp.data = new byte[this.ati.resp.max + 4];
        ADwinDirectDevice.setInteger(this.ati.resp.data, 10240, 573785173);
        this.ati.dll_version = 1;
        this.ati.timeout_ms = this.ADwTimeout;
        this.new_socket();
    }

    void init_ati(int command) {
        this.ati.command = command;
        if (ADwinDirectDevice.extractInt(this.ati.req.data, 10240) != 305432421) {
            // empty if block
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 10240) != 573785173) {
            // empty if block
        }
        this.ati.req.do_convert = 1;
        this.ati.req.used = 0;
        this.ati.resp.do_convert = 2;
        this.ati.resp.used = 0;
        this.ati.status = -1111;
    }

    int check_tcp_ret(int ret, int ref) throws ADwinCommunicationError {
        if (ret == ref) {
            return 0;
        }
        try {
            this.ati.stream_in.close();
            this.ati.stream_out.close();
            this.ati.socket.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            this.ati.connected = false;
            throw new ADwinCommunicationError("I/O-Error: " + e.getMessage(), "E/A-Fehler: " + e.getMessage(), this.Language, 2000);
        }
        this.ati.connected = false;
        return 1;
    }

    public int htonl(int value) {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return value;
        }
        return Integer.reverseBytes(value);
    }

    public int ntohl(int value) {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return value;
        }
        return Integer.reverseBytes(value);
    }

    int tcp_discard_pending(adwin_tcp_info_t ati) throws ADwinCommunicationError {
        if (ati.rx_pending == 0) {
            return 0;
        }
        adwin_tcp_buffer_t tmp = new adwin_tcp_buffer_t();
        tmp.max = ati.rx_pending;
        tmp.used = 0;
        tmp.do_convert = 0;
        tmp.data = new byte[ati.rx_pending];
        return this.tcp_read_pending(ati, ati.rx_pending, tmp);
    }

    public synchronized void adwin_tcp_connect() throws ADwinCommunicationError {
        InetSocketAddress isa = new InetSocketAddress(this.Connection, this.Port);
        this.ati.connected = false;
        try {
            this.new_socket();
            this.ati.socket.connect(isa, 1000);
        }
        catch (IOException e) {
            this.check_tcp_ret(0, 1);
            return;
        }
        this.init_ati(300);
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, this.htonl(this.ati.dll_version));
        ADwinDirectDevice.setInteger(this.ati.req.data, 16, this.htonl(5 * this.ati.timeout_ms));
        ADwinDirectDevice.setInteger(this.ati.req.data, 20, this.htonl(this.ati.timeout_size));
        for (int n = 0; n < 10 && n < this.Password.length(); ++n) {
            this.ati.req.data[n + 4] = (byte)this.Password.charAt(n);
        }
        this.ati.req.data[n + 4] = 0;
        this.ati.req.used = 24;
        this.ati.req.do_convert = 0;
        try {
            this.ati.stream_in = this.ati.socket.getInputStream();
            this.ati.stream_out = this.ati.socket.getOutputStream();
        }
        catch (IOException e) {
            this.check_tcp_ret(0, 1);
            throw new ADwinCommunicationError("socket-error: " + e.getMessage(), "Socket-Fehler: " + e.getMessage(), this.Language, 2000);
        }
        if (this.tcp_write_request(this.ati, null) == -1) {
            this.check_tcp_ret(0, 1);
            return;
        }
        if (this.tcp_read_response(this.ati, 16, null) == -1) {
            this.check_tcp_ret(0, 1);
            return;
        }
        this.ati.processortype = ADwinDirectDevice.extractInt(this.ati.resp.data, 0) + 9;
        int connectCount = ADwinDirectDevice.extractInt(this.ati.resp.data, 4);
        this.ati.firmware_version = ADwinDirectDevice.extractInt(this.ati.resp.data, 8);
        this.ati.firmware_version_beta = ADwinDirectDevice.extractInt(this.ati.resp.data, 12);
        switch (this.ati.processortype) {
            case 9: {
                this.ati.processortype = 9;
                break;
            }
            case 10: {
                this.ati.processortype = 1010;
                break;
            }
            case 11: {
                this.ati.processortype = 1011;
                break;
            }
            case 12: {
                this.ati.processortype = 1012;
            }
        }
        this.ati.connected = this.ati.error_number == 0;
    }

    public synchronized int adwin_tcp_or_udp() throws ADwinCommunicationError {
        Date now = new Date();
        if (this.ati.initialized && this.ati.connected && this.last_access.getTime() + 5000L > now.getTime()) {
            return 0;
        }
        if ((this.version == 0 || this.last_access.getTime() == 0L || this.last_access.getTime() + 5000L > now.getTime()) && this.getArmVersion() == 0) {
            return 1;
        }
        this.last_access = now;
        if (this.supports_tcp) {
            if (!this.ati.initialized) {
                return 1;
            }
            if (!this.ati.connected) {
                this.adwin_tcp_connect();
            }
            if (this.ati.connected) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    void do_convert(adwin_tcp_buffer_t buf) {
        if (buf == null) {
            return;
        }
        switch (buf.do_convert) {
            case 2: {
                for (int i = 0; i < buf.used / 4; ++i) {
                    ADwinDirectDevice.setInteger(buf.data, i * 4, this.ntohl(ADwinDirectDevice.extractInt(buf.data, i * 4)));
                }
                break;
            }
            case 1: {
                for (int i = 0; i < buf.used / 4; ++i) {
                    ADwinDirectDevice.setInteger(buf.data, i * 4, this.ntohl(ADwinDirectDevice.extractInt(buf.data, i * 4)));
                }
                break;
            }
        }
    }

    int tcp_write_request(adwin_tcp_info_t ati, adwin_tcp_buffer_t buf) throws ADwinCommunicationError {
        adwin_tcp_buffer_t tmp = new adwin_tcp_buffer_t();
        if (buf == null) {
            buf = tmp;
        }
        ++ati.req_count;
        int req_len = ati.req.used + buf.used;
        int bytes_already_send = 0;
        this.do_convert(ati.req);
        this.do_convert(buf);
        int bytes_current_transfer = Math.min(buf.used, ati.timeout_size);
        int header_len = 16 + ati.req.used;
        byte[] buffers = new byte[header_len];
        ADwinDirectDevice.setInteger(buffers, 0, this.htonl(1118650900));
        ADwinDirectDevice.setInteger(buffers, 4, this.htonl(ati.req_count));
        ADwinDirectDevice.setInteger(buffers, 8, this.htonl(req_len));
        ADwinDirectDevice.setInteger(buffers, 12, this.htonl(ati.command));
        System.arraycopy(ati.req.data, 0, buffers, 16, ati.req.used);
        try {
            ati.stream_out.write(buffers, 0, header_len);
        }
        catch (IOException ex) {
            this.check_tcp_ret(0, 1);
            throw new ADwinCommunicationError("Network-error: " + ex.getMessage(), "Netzwerk-Fehler: " + ex.getMessage(), this.Language, 2000);
        }
        if (bytes_current_transfer > 0) {
            try {
                ati.stream_out.write(buf.data, 0, bytes_current_transfer);
            }
            catch (IOException ex) {
                this.check_tcp_ret(0, 1);
                throw new ADwinCommunicationError("Network-error: " + ex.getMessage(), "Netzwerk-Fehler: " + ex.getMessage(), this.Language, 2000);
            }
            for (bytes_already_send = bytes_current_transfer; bytes_already_send < buf.used; bytes_already_send += bytes_current_transfer) {
                bytes_current_transfer = bytes_already_send + ati.timeout_size <= buf.used ? ati.timeout_size : buf.used - bytes_already_send;
                try {
                    ati.stream_out.write(buf.data, bytes_already_send, bytes_current_transfer);
                    continue;
                }
                catch (IOException ex) {
                    this.check_tcp_ret(0, 1);
                    throw new ADwinCommunicationError("Network-error: " + ex.getMessage(), "Netzwerk-Fehler: " + ex.getMessage(), this.Language, 2000);
                }
            }
        }
        return 0;
    }

    int tcp_read_response(adwin_tcp_info_t ati, int min_bytes, adwin_tcp_buffer_t buf) throws ADwinCommunicationError {
        int ret;
        byte[] mybytearray = new byte[40];
        adwin_tcp_header_t ath = new adwin_tcp_header_t();
        adwin_tcp_buffer_t resp = buf == null ? ati.resp : buf;
        try {
            ret = ati.stream_in.read(mybytearray, 0, 16);
            if (this.check_tcp_ret(ret, 16) == 1) {
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        catch (IOException ex) {
            throw new ADwinCommunicationError("Network-error: " + ex.getMessage(), "Netzwerk-Fehler: " + ex.getMessage(), this.Language, 2000);
        }
        ath.magic_flag = this.ntohl(ADwinDirectDevice.extractInt(mybytearray, 0));
        ath.req_count = this.ntohl(ADwinDirectDevice.extractInt(mybytearray, 4));
        ath.length = this.ntohl(ADwinDirectDevice.extractInt(mybytearray, 8));
        ath.command_or_status = this.ntohl(ADwinDirectDevice.extractInt(mybytearray, 12));
        if (this.check_tcp_ret(ath.magic_flag, 1118650963) == 1) {
            throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
        }
        ati.rx_pending = ath.length;
        ati.status = this.map_error_code(ath.command_or_status);
        ret = this.tcp_read_pending(ati, min_bytes, resp);
        if (ati.status != 0) {
            if (ati.status == -5) {
                throw new ADwinCommunicationError("Wrong Password", "Falsches Passwort", this.Language, 2002);
            }
            if (ati.status == -30) {
                throw new ADwinCommunicationError("Wrong Version", "Falsche Version", this.Language, 20);
            }
            if (ati.status == 1) {
                throw new ADwinCommunicationError("Timeout to link", "Timeout beim Schreiben zum Link", this.Language, 1);
            }
            if (ati.status == 2) {
                throw new ADwinCommunicationError("Timeout from link", "Timeout beim Lesen vom Link", this.Language, 2);
            }
            if (ati.status == 100) {
                throw new ADwinCommunicationError("The Data is too small", "Das Data ist zu klein", this.Language, 100);
            }
            if (ati.status == 101) {
                throw new ADwinCommunicationError("There is not enough space left in fifo", "Nicht genug Platz \u00fcbrig in Fifo", this.Language, 101);
            }
            if (ati.status == 102) {
                throw new ADwinCommunicationError("The Fifo has not enough values", "Das Fifo-Feld hat nicht genug Daten", this.Language, 102);
            }
            throw new ADwinCommunicationError("status error: " + ati.status, "Status-Fehler: " + ati.status, this.Language, ati.status);
        }
        return ret;
    }

    public static int readInputStreamWithTimeout(InputStream is, byte[] b, int offset, int timeoutMillis, int maxBytes) throws IOException {
        int bufferOffset;
        int readResult;
        long maxTimeMillis = System.currentTimeMillis() + (long)timeoutMillis;
        for (bufferOffset = 0; System.currentTimeMillis() < maxTimeMillis && bufferOffset < maxBytes; bufferOffset += readResult) {
            int readLength = Math.min(is.available(), maxBytes - bufferOffset);
            readResult = is.read(b, bufferOffset + offset, readLength = Math.min(readLength, maxBytes));
            if (readResult == -1) break;
        }
        return bufferOffset;
    }

    int tcp_read_pending(adwin_tcp_info_t ati, int min_bytes, adwin_tcp_buffer_t buf) throws ADwinCommunicationError {
        int bytes_already_read;
        int bytes_current_transfer;
        adwin_tcp_buffer_t resp = buf == null ? ati.resp : buf;
        if (resp.max < min_bytes) {
            throw new ADwinCommunicationError("memory-error: not enough room in destination memory", "Speicher-Fehler!", this.Language, 0);
        }
        if (ati.rx_pending < min_bytes) {
            System.err.println("*** error: read pending ");
            throw new ADwinCommunicationError("memory-error: not enough room in destination memory", "Speicher-Fehler!", this.Language, 0);
        }
        for (bytes_already_read = 0; min_bytes > bytes_already_read; bytes_already_read += bytes_current_transfer) {
            bytes_current_transfer = min_bytes > bytes_already_read + ati.timeout_size ? ati.timeout_size : min_bytes - bytes_already_read;
            try {
                int ret = ADwinDirectDevice.readInputStreamWithTimeout(ati.stream_in, resp.data, bytes_already_read, ati.timeout_ms, bytes_current_transfer);
                if (this.check_tcp_ret(ret, bytes_current_transfer) != 1) continue;
                System.err.println("*** readInputStreamWithTimeout returned: " + ret + " expected " + bytes_current_transfer);
                throw new ADwinCommunicationError("Network timeout", "Netzwerk Timeout: ", this.Language, 2001);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                return -1;
            }
        }
        resp.used = bytes_already_read;
        ati.rx_pending -= bytes_already_read;
        this.do_convert(resp);
        return 0;
    }

    void adwin_tcp_boot(String filename) throws IOException, ADwinCommunicationError {
        this.boot_or_loadprocess(filename, 50);
    }

    void adwin_tcp_boot(byte[] Binary) throws IOException, ADwinCommunicationError {
        this.boot_or_loadprocess(Binary, 50);
    }

    void adwin_tcp_load_process(String filename) throws IOException, ADwinCommunicationError {
        this.boot_or_loadprocess(filename, 4);
    }

    void adwin_tcp_load_process(byte[] Binary) throws IOException, ADwinCommunicationError {
        this.boot_or_loadprocess(Binary, 4);
    }

    void boot_or_loadprocess(String filename, int command) throws IOException, ADwinCommunicationError {
        adwin_tcp_buffer_t req = new adwin_tcp_buffer_t();
        req.max = 0;
        req.used = 0;
        req.do_convert = 0;
        req.data = null;
        this.init_ati(command);
        FileInputStream fis = new FileInputStream(filename);
        byte[] Binary = new byte[fis.available()];
        fis.read(Binary);
        fis.close();
        if (Binary.length == 0) {
            return;
        }
        req.data = Binary;
        req.max = req.used = Binary.length;
        if (this.tcp_write_request(this.ati, req) == -1) {
            this.check_tcp_ret(0, 1);
            return;
        }
        this.ati.resp.do_convert = 0;
        this.tcp_read_response(this.ati, 0, null);
    }

    void boot_or_loadprocess(byte[] Binary, int command) throws IOException, ADwinCommunicationError {
        adwin_tcp_buffer_t req = new adwin_tcp_buffer_t();
        req.max = 0;
        req.used = 0;
        req.do_convert = 0;
        req.data = null;
        this.init_ati(command);
        if (Binary.length == 0) {
            return;
        }
        req.data = Binary;
        req.max = req.used = Binary.length;
        if (this.tcp_write_request(this.ati, req) == -1) {
            this.check_tcp_ret(0, 1);
            return;
        }
        this.ati.resp.do_convert = 0;
        this.tcp_read_response(this.ati, 0, null);
    }

    void command_4p4(int[] to_values, int[] from_values) throws ADwinCommunicationError {
        adwin_tcp_buffer_t req = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        req.max = 16;
        req.used = 16;
        req.do_convert = 1;
        req.data = new byte[16];
        ADwinDirectDevice.setInteger(req.data, 0, to_values[0]);
        ADwinDirectDevice.setInteger(req.data, 4, to_values[1]);
        ADwinDirectDevice.setInteger(req.data, 8, to_values[2]);
        ADwinDirectDevice.setInteger(req.data, 12, to_values[3]);
        resp.max = 16;
        resp.used = 0;
        resp.do_convert = 2;
        resp.data = new byte[16];
        this.init_ati(0);
        if (this.tcp_write_request(this.ati, req) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 16, resp) == -1) {
            return;
        }
        from_values[0] = ADwinDirectDevice.extractInt(resp.data, 0);
        from_values[1] = ADwinDirectDevice.extractInt(resp.data, 4);
        from_values[2] = ADwinDirectDevice.extractInt(resp.data, 8);
        from_values[3] = ADwinDirectDevice.extractInt(resp.data, 12);
    }

    void adwin_tcp_start_process(int processnumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{2, processnumber, 0, 0};
        this.command_4p4(to_values, from_values);
    }

    void adwin_tcp_stop_process(int processnumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{3, processnumber, 0, 0};
        this.command_4p4(to_values, from_values);
    }

    void adwin_tcp_clear_process(int processnumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{14, processnumber, 0, 0};
        this.command_4p4(to_values, from_values);
    }

    int adwin_tcp_process_status(int processnumber) throws ADwinCommunicationError {
        return this.adwin_tcp_get_par(-100 + processnumber);
    }

    int adwin_tcp_get_processdelay(int processnumber) throws ADwinCommunicationError {
        return this.adwin_tcp_get_par(-90 + processnumber);
    }

    void adwin_tcp_set_processdelay(int processnumber, int delay) throws ADwinCommunicationError {
        this.adwin_tcp_set_par(-90 + processnumber, delay);
    }

    float adwin_tcp_workload() throws ADwinCommunicationError {
        float workload = -1.0f;
        this.init_ati(20);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return -1.0f;
        }
        if (this.tcp_read_response(this.ati, 16, null) == -1) {
            return -1.0f;
        }
        if (this.ati.processortype != 1012) {
            int val1 = ADwinDirectDevice.extractInt(this.ati.resp.data, 0);
            int t1 = ADwinDirectDevice.extractInt(this.ati.resp.data, 4);
            int workload_calculated_by_dsp = ADwinDirectDevice.extractInt(this.ati.resp.data, 8);
            if (workload_calculated_by_dsp == 0) {
                if (t1 == 0) {
                    return 100.0f;
                }
                float help1 = (float)val1 / (float)t1;
                if (help1 == 0.0f) {
                    return 100.0f;
                }
                workload = this.ati.processortype == 1011 ? 100.0f * ((0.11111111f - help1) * 9.0f) : 100.0f * ((0.25f - help1) / 0.25f);
            } else {
                workload = val1;
            }
        } else {
            workload = ADwinDirectDevice.extractInt(this.ati.resp.data, 0);
        }
        if (workload > 100.0f) {
            return 100.0f;
        }
        if (workload < 0.0f) {
            return 0.0f;
        }
        return workload;
    }

    int adwin_tcp_get_par(int par_no) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{1, par_no + 1000, 0, 0};
        this.command_4p4(to_values, from_values);
        return from_values[0];
    }

    void adwin_tcp_set_par(int par_no, int value) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{6, par_no + 1000, value, 0};
        this.command_4p4(to_values, from_values);
    }

    float adwin_tcp_get_fpar(int par_no) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{1, par_no + 1100, 0, 0};
        this.command_4p4(to_values, from_values);
        return Float.intBitsToFloat(from_values[0]);
    }

    void adwin_tcp_set_fpar(int par_no, float value) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{6, par_no + 1100, Float.floatToIntBits(value), 0};
        this.command_4p4(to_values, from_values);
    }

    double adwin_tcp_get_fpar_double(int par_no) throws ADwinCommunicationError {
        if (this.ati.processortype != 1012) {
            return this.adwin_tcp_get_fpar(par_no);
        }
        byte[] bdata = new byte[8];
        int[] from_values = new int[4];
        int[] to_values = new int[]{1, par_no + 1200, 0, 0};
        this.command_4p4(to_values, from_values);
        ADwinDirectDevice.setInteger(bdata, 0, from_values[0]);
        ADwinDirectDevice.setInteger(bdata, 4, from_values[1]);
        return ByteBuffer.wrap(bdata).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    void adwin_tcp_set_fpar_double(int par_no, double value) throws ADwinCommunicationError {
        if (this.ati.processortype != 1012) {
            this.adwin_tcp_set_fpar(par_no, (float)value);
            return;
        }
        int[] from_values = new int[4];
        long dummy = Double.doubleToLongBits(value);
        int[] to_values = new int[]{6, par_no + 1200, (int)(dummy >> 32), (int)dummy};
        this.command_4p4(to_values, from_values);
    }

    void adwin_tcp_get_par_block(int start, int count, int[] pars) throws ADwinCommunicationError {
        this.init_ati(13);
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, count);
        this.ati.req.used = 8;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        resp.data = new byte[count * 4];
        resp.max = count * 4;
        resp.used = 0;
        resp.do_convert = 0;
        if (this.tcp_read_response(this.ati, resp.max, resp) == -1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            pars[i] = ADwinDirectDevice.extractInt(resp.data, i * 4);
        }
    }

    void adwin_tcp_get_par_all(int[] pars) throws ADwinCommunicationError {
        this.adwin_tcp_get_par_block(1, 80, pars);
    }

    void adwin_tcp_get_fpar_block(int start, int count, float[] fpars) throws ADwinCommunicationError {
        int[] idummy = new int[count];
        this.adwin_tcp_get_par_block(100 + start, count, idummy);
        for (int i = 0; i < count; ++i) {
            fpars[i] = Float.intBitsToFloat(idummy[i]);
        }
    }

    void adwin_tcp_get_fpar_all(float[] fpars) throws ADwinCommunicationError {
        int[] idummy = new int[80];
        this.adwin_tcp_get_par_block(101, 80, idummy);
        for (int i = 0; i < 80; ++i) {
            fpars[i] = Float.intBitsToFloat(idummy[i]);
        }
    }

    void adwin_tcp_get_fpar_block_double(int start, int count, double[] dpars) throws ADwinCommunicationError {
        if (this.ati.processortype != 1012) {
            int[] pars = new int[count];
            this.adwin_tcp_get_par_block(100 + start, count, pars);
            for (int i = 0; i < count; ++i) {
                dpars[i] = Float.intBitsToFloat(pars[i]);
            }
        } else {
            this.init_ati(13);
            ADwinDirectDevice.setInteger(this.ati.req.data, 0, 200 + start);
            ADwinDirectDevice.setInteger(this.ati.req.data, 4, count * 2);
            this.ati.req.used = 8;
            if (this.tcp_write_request(this.ati, null) == -1) {
                return;
            }
            adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
            resp.data = new byte[count * 8];
            resp.max = count * 8;
            resp.used = 0;
            resp.do_convert = 0;
            if (this.tcp_read_response(this.ati, resp.max, resp) == -1) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                dpars[i] = ByteBuffer.wrap(resp.data, i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            }
        }
    }

    void adwin_tcp_get_fpar_all_double(double[] dpars) throws ADwinCommunicationError {
        if (this.ati.processortype != 1012) {
            int[] pars = new int[80];
            this.adwin_tcp_get_par_block(101, 80, pars);
            for (int i = 0; i < 80; ++i) {
                dpars[i] = Float.intBitsToFloat(pars[i]);
            }
        } else {
            this.adwin_tcp_get_fpar_block_double(1, 80, dpars);
        }
    }

    int adwin_tcp_free_mem(int mem_spec) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{12, mem_spec, 0, 0};
        this.command_4p4(to_values, from_values);
        return from_values[0];
    }

    void adwin_tcp_peek(int address, int count, int[] pc_array) throws ADwinCommunicationError {
        this.init_ati(1000000);
        this.ati.req.used = 8;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, address);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, count);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        resp.data = new byte[count * 4];
        resp.max = count * 4;
        resp.used = 0;
        resp.do_convert = 0;
        if (this.tcp_read_response(this.ati, resp.max, resp) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            pc_array[i] = ADwinDirectDevice.extractInt(resp.data, i * 4);
        }
    }

    int bytes_per_value(adwin_data_type_t adt) {
        switch (adt) {
            case ADWIN_BYTE: 
            case ADWIN_STRING: {
                return 1;
            }
            case ADWIN_SHORT: {
                return 2;
            }
            case ADWIN_LONG: 
            case ADWIN_INTEGER: 
            case ADWIN_FLOAT: {
                return 4;
            }
            case ADWIN_DOUBLE: 
            case ADWIN_INT64: {
                return 8;
            }
        }
        return -1;
    }

    adwin_data_type_t int_to_adwin_data_type(int type) {
        switch (type) {
            case 1: {
                return adwin_data_type_t.ADWIN_BYTE;
            }
            case 2: {
                return adwin_data_type_t.ADWIN_SHORT;
            }
            case 3: {
                return adwin_data_type_t.ADWIN_LONG;
            }
            case 4: {
                return adwin_data_type_t.ADWIN_INTEGER;
            }
            case 5: {
                return adwin_data_type_t.ADWIN_FLOAT;
            }
            case 6: {
                return adwin_data_type_t.ADWIN_DOUBLE;
            }
            case 7: {
                return adwin_data_type_t.ADWIN_INT64;
            }
            case 8: {
                return adwin_data_type_t.ADWIN_STRING;
            }
            case 20: {
                return adwin_data_type_t.ADWIN_VARIANT;
            }
        }
        return adwin_data_type_t.ADWIN_DATA_TYPE_INVALID;
    }

    int adwin_tcp_get_data_type(int datanumber) throws ADwinCommunicationError {
        this.init_ati(100);
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        this.ati.req.used = 4;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return 0;
        }
        if (this.tcp_read_response(this.ati, 4, null) == -1) {
            return 0;
        }
        return ADwinDirectDevice.extractInt(this.ati.resp.data, 0);
    }

    int adwin_tcp_get_data_length(int datanumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{11, datanumber, 0, 0};
        this.command_4p4(to_values, from_values);
        return from_values[0];
    }

    void adwin_tcp_clear_data(int datanumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{9, datanumber, 0, 0};
        this.command_4p4(to_values, from_values);
    }

    int adwin_tcp_fifo_full(int datanumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{23, datanumber, 0, 0};
        this.command_4p4(to_values, from_values);
        return from_values[0];
    }

    int adwin_tcp_fifo_empty(int datanumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{22, datanumber, 0, 0};
        this.command_4p4(to_values, from_values);
        return from_values[0];
    }

    void adwin_tcp_fifo_clear(int datanumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        int[] to_values = new int[]{21, datanumber, 0, 0};
        this.command_4p4(to_values, from_values);
    }

    void adwin_tcp_get_data_or_fifo_int32(int datanumber, int[] data, int start, int count, int get_fifo) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (get_fifo == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        this.ati.req.max = count * 4;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_datatype = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        int count_b = count * this.bytes_per_value(adwin_datatype);
        if (this.bytes_per_value(adwin_datatype) < 0) {
            this.ati.status = 150;
            this.tcp_discard_pending(this.ati);
            return;
        }
        byte[] buf = resp.data = new byte[count_b];
        if (resp.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        resp.max = count_b;
        resp.do_convert = 0;
        resp.used = 0;
        if (this.tcp_read_pending(this.ati, count_b, resp) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        switch (adwin_datatype) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                this.convert_data_from_stream_to_int(buf, data, count);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fdata = new float[count];
                this.convert_data_from_stream_to_float(buf, fdata, count);
                this.convert_data_from_float_to_int(fdata, data, count);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] ddata = new double[count];
                this.convert_data_from_stream_to_double(buf, ddata, count);
                this.convert_data_from_double_to_int(ddata, data, count);
            }
        }
    }

    void adwin_tcp_get_data_or_fifo_int64(int datanumber, long[] data, int start, int count, int get_fifo) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (get_fifo == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        this.ati.req.max = count * 4;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_datatype = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        int count_b = count * this.bytes_per_value(adwin_datatype);
        if (this.bytes_per_value(adwin_datatype) < 0) {
            this.ati.status = 150;
            this.tcp_discard_pending(this.ati);
            return;
        }
        byte[] buf = resp.data = new byte[count_b];
        if (resp.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        resp.max = count_b;
        resp.do_convert = 0;
        resp.used = 0;
        if (this.tcp_read_pending(this.ati, count_b, resp) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        switch (adwin_datatype) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] idata = new int[count];
                this.convert_data_from_stream_to_int(buf, idata, count);
                this.convert_data_from_int_to_long(idata, data, count);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fdata = new float[count];
                this.convert_data_from_stream_to_float(buf, fdata, count);
                this.convert_data_from_float_to_long(fdata, data, count);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] ddata = new double[count];
                this.convert_data_from_stream_to_double(buf, ddata, count);
                this.convert_data_from_double_to_long(ddata, data, count);
                break;
            }
        }
    }

    void adwin_tcp_get_data_or_fifo_int8(int datanumber, byte[] data, int start, int count, int get_fifo) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (get_fifo == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_datatype = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        if (this.bytes_per_value(adwin_datatype) != 1) {
            return;
        }
        int count_b = count;
        byte[] buf = resp.data = new byte[count_b];
        if (resp.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        resp.max = count_b;
        resp.do_convert = 0;
        resp.used = 0;
        if (this.tcp_read_pending(this.ati, count_b, resp) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        System.arraycopy(buf, 0, data, 0, count);
    }

    void adwin_tcp_get_data_or_fifo_float(int datanumber, float[] data, int start, int count, int get_fifo) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (get_fifo == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_datatype = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        int count_b = count * this.bytes_per_value(adwin_datatype);
        if (this.bytes_per_value(adwin_datatype) < 0) {
            this.ati.status = 150;
            this.tcp_discard_pending(this.ati);
            return;
        }
        byte[] buf = resp.data = new byte[count_b];
        if (resp.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        resp.max = count_b;
        resp.do_convert = 0;
        resp.used = 0;
        if (this.tcp_read_pending(this.ati, count_b, resp) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        switch (adwin_datatype) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] idata = new int[count];
                this.convert_data_from_stream_to_int(buf, idata, count);
                this.convert_data_from_int_to_float(idata, data, count);
                break;
            }
            case ADWIN_FLOAT: {
                this.convert_data_from_stream_to_float(buf, data, count);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] ddata = new double[count];
                this.convert_data_from_stream_to_double(buf, ddata, count);
                this.convert_data_from_double_to_float(ddata, data, count);
            }
        }
    }

    void adwin_tcp_get_data_or_fifo_double(int datanumber, double[] data, int start, int count, int get_fifo) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t resp = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (get_fifo == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_datatype = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        int count_b = count * this.bytes_per_value(adwin_datatype);
        if (this.bytes_per_value(adwin_datatype) < 0) {
            this.ati.status = 150;
            this.tcp_discard_pending(this.ati);
            return;
        }
        byte[] buf = resp.data = new byte[count_b];
        if (resp.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        resp.max = count_b;
        resp.do_convert = 0;
        resp.used = 0;
        if (this.tcp_read_pending(this.ati, count_b, resp) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        switch (adwin_datatype) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] idata = new int[count];
                this.convert_data_from_stream_to_int(buf, idata, count);
                this.convert_data_from_int_to_double(idata, data, count);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fdata = new float[count];
                this.convert_data_from_stream_to_float(buf, fdata, count);
                this.convert_data_from_float_to_double(fdata, data, count);
                break;
            }
            case ADWIN_DOUBLE: {
                this.convert_data_from_stream_to_double(buf, data, count);
            }
        }
    }

    String adwin_tcp_get_data_string(int datanumber, int max_count) throws ADwinCommunicationError {
        int i;
        byte[] str = new byte[max_count];
        if (max_count < 1) {
            return "";
        }
        if (this.ati.processortype == 1012) {
            this.adwin_tcp_get_data_or_fifo_int8(datanumber, str, 0, max_count, 0);
            return new String(str);
        }
        str = new byte[4 * (max_count + 1)];
        int[] idata = new int[max_count + 1];
        this.adwin_tcp_get_data_or_fifo_int32(datanumber, idata, 1, max_count + 1, 0);
        for (i = 0; i < max_count + 1; ++i) {
            str[i] = (byte)idata[i];
        }
        int strlen = str[0];
        byte[] tmp = new byte[strlen];
        for (i = 0; i < strlen; ++i) {
            byte val = str[i * 4 + 3];
            if (val <= 0 || val >= 256) {
                tmp[i] = 0;
                break;
            }
            tmp[i] = val;
        }
        tmp[strlen - 1] = 0;
        return new String(tmp);
    }

    int adwin_tcp_string_length(int datanumber) throws ADwinCommunicationError {
        int[] from_values = new int[4];
        if (this.ati.processortype == 1012) {
            int[] to_values = new int[]{44, datanumber, 0, 0};
            this.command_4p4(to_values, from_values);
        } else {
            this.adwin_tcp_get_data_or_fifo_int32(datanumber, from_values, 1, 1, 0);
        }
        return from_values[0];
    }

    void adwin_tcp_get_data_info(int datanumber, int[] values) throws ADwinCommunicationError {
        this.init_ati(45);
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        this.ati.req.used = 4;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 16, null) == -1) {
            return;
        }
        values[0] = ADwinDirectDevice.extractInt(this.ati.resp.data, 0);
        values[1] = ADwinDirectDevice.extractInt(this.ati.resp.data, 4);
        values[2] = ADwinDirectDevice.extractInt(this.ati.resp.data, 8);
        values[3] = ADwinDirectDevice.extractInt(this.ati.resp.data, 12);
    }

    void adwin_tcp_set_data_or_fifo_int8(int datanumber, byte[] data, int start, int count, int set_fifo) throws ADwinCommunicationError {
        adwin_tcp_buffer_t req = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + datanumber + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + datanumber + " gesetzt werden!");
        }
        int[] info = new int[4];
        this.adwin_tcp_get_data_info(datanumber, info);
        if (this.ati.error_number != 0) {
            return;
        }
        adwin_data_type_t adt = this.int_to_adwin_data_type(info[0]);
        int data_size = info[1];
        int is_fifo = info[2];
        int fifo_full = info[3];
        if (data_size < start - 1 + count) {
            throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
        }
        if (this.ati.processortype == 1012) {
            if (is_fifo == 1 && set_fifo == 1 && count > data_size - fifo_full) {
                throw new ADwinCommunicationError("There is not enough space left in fifo " + datanumber, "Nicht genug Platz \u00fcbrig in Fifo " + datanumber, this.Language, 101);
            }
            if (set_fifo == 1 && is_fifo == 0) {
                throw new ADwinCommunicationError("Data " + datanumber + " isn't a fifo!", "Data " + datanumber + " ist nicht als FIFO deklariert!", this.Language, 101);
            }
        }
        int count_b = count * this.bytes_per_value(adt);
        req.data = new byte[count_b];
        switch (adt) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] idata = new int[count];
                this.convert_data_from_byte_to_int(data, idata, count);
                this.convert_data_from_int_to_stream(idata, req.data, count);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fdata = new float[count];
                for (int i = 0; i < count; ++i) {
                    fdata[i] = data[i];
                }
                this.convert_data_from_float_to_stream(fdata, req.data, count);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] ddata = new double[count];
                for (int i = 0; i < count; ++i) {
                    ddata[i] = data[i];
                }
                this.convert_data_from_double_to_stream(ddata, req.data, count);
                break;
            }
            case ADWIN_BYTE: 
            case ADWIN_STRING: {
                req.data = data;
                break;
            }
        }
        if (set_fifo == 1) {
            this.init_ati(25);
        } else {
            this.init_ati(8);
        }
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        ADwinDirectDevice.setInteger(this.ati.req.data, 12, info[0]);
        this.ati.req.used = 16;
        req.do_convert = 0;
        req.used = count_b;
        if (this.tcp_write_request(this.ati, req) == -1) {
            return;
        }
        this.tcp_read_response(this.ati, 0, null);
    }

    void adwin_tcp_set_data_or_fifo_int32(int datanumber, int[] data, int start, int count, int set_fifo) throws ADwinCommunicationError {
        adwin_tcp_buffer_t req = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + datanumber + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + datanumber + " gesetzt werden!");
        }
        int[] info = new int[4];
        this.adwin_tcp_get_data_info(datanumber, info);
        if (this.ati.error_number != 0) {
            return;
        }
        adwin_data_type_t adt = this.int_to_adwin_data_type(info[0]);
        int data_size = info[1];
        int is_fifo = info[2];
        int fifo_full = info[3];
        if (adt == adwin_data_type_t.ADWIN_DATA_TYPE_INVALID) {
            throw new ADwinCommunicationError("The Data array is not declared", "Das Data ist nicht deklariert", this.Language, 103);
        }
        if (data_size < start - 1 + count) {
            if (set_fifo == 0) {
                throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
            }
            throw new ADwinCommunicationError("The Fifo is too small or not enough values", "Das Fifo-Feld ist zu klein oder nicht genug Daten", this.Language, 101);
        }
        if (this.ati.processortype == 1012) {
            if (is_fifo == 1 && set_fifo == 1 && count > data_size - fifo_full) {
                throw new ADwinCommunicationError("The Fifo is too small or not enough values", "Das Fifo-Feld ist zu klein oder nicht genug Daten", this.Language, 101);
            }
            if (set_fifo == 1 && is_fifo == 0) {
                throw new ADwinCommunicationError("Data " + datanumber + " isn't a fifo!", "Data " + datanumber + " ist nicht als FIFO deklariert!", this.Language, 101);
            }
        }
        int count_b = count * this.bytes_per_value(adt);
        req.data = new byte[count_b];
        switch (adt) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                this.convert_data_from_int_to_stream(data, req.data, count);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fdata = new float[count];
                for (int i = 0; i < count; ++i) {
                    fdata[i] = data[i];
                }
                this.convert_data_from_float_to_stream(fdata, req.data, count);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] ddata = new double[count];
                for (int i = 0; i < count; ++i) {
                    ddata[i] = data[i];
                }
                this.convert_data_from_double_to_stream(ddata, req.data, count);
                break;
            }
        }
        if (set_fifo == 1) {
            this.init_ati(25);
        } else {
            this.init_ati(8);
        }
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        ADwinDirectDevice.setInteger(this.ati.req.data, 12, info[0]);
        this.ati.req.used = 16;
        req.do_convert = 0;
        req.used = count_b;
        if (this.tcp_write_request(this.ati, req) == -1) {
            return;
        }
        this.tcp_read_response(this.ati, 0, null);
    }

    void adwin_tcp_set_data_or_fifo_float(int datanumber, float[] data, int start, int count, int set_fifo) throws ADwinCommunicationError {
        adwin_tcp_buffer_t req = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + datanumber + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + datanumber + " gesetzt werden!");
        }
        int[] info = new int[4];
        this.adwin_tcp_get_data_info(datanumber, info);
        if (this.ati.error_number != 0) {
            return;
        }
        adwin_data_type_t adt = this.int_to_adwin_data_type(info[0]);
        int data_size = info[1];
        int is_fifo = info[2];
        int fifo_full = info[3];
        if (data_size < start - 1 + count) {
            throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
        }
        if (this.ati.processortype == 1012) {
            if (is_fifo == 1 && set_fifo == 1 && count > data_size - fifo_full) {
                throw new ADwinCommunicationError("There is not enough space left in fifo " + datanumber, "Nicht genug Platz \u00fcbrig in Fifo " + datanumber, this.Language, 101);
            }
            if (set_fifo == 1 && is_fifo == 0) {
                throw new ADwinCommunicationError("Data " + datanumber + " isn't a fifo!", "Data " + datanumber + " ist nicht als FIFO deklariert!", this.Language, 101);
            }
        }
        int count_b = count * this.bytes_per_value(adt);
        req.data = new byte[count_b];
        switch (adt) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] idata = new int[count];
                this.convert_data_from_float_to_int(data, idata, count);
                this.convert_data_from_int_to_stream(idata, req.data, count);
                break;
            }
            case ADWIN_FLOAT: {
                this.convert_data_from_float_to_stream(data, req.data, count);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] ddata = new double[count];
                this.convert_data_from_float_to_double(data, ddata, count);
                this.convert_data_from_double_to_stream(ddata, req.data, count);
                break;
            }
        }
        if (set_fifo == 1) {
            this.init_ati(25);
        } else {
            this.init_ati(8);
        }
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        ADwinDirectDevice.setInteger(this.ati.req.data, 12, info[0]);
        this.ati.req.used = 16;
        req.do_convert = 0;
        req.used = count_b;
        if (this.tcp_write_request(this.ati, req) == -1) {
            return;
        }
        this.tcp_read_response(this.ati, 0, null);
    }

    void adwin_tcp_set_data_or_fifo_double(int datanumber, double[] data, int start, int count, int set_fifo) throws ADwinCommunicationError {
        adwin_tcp_buffer_t req = new adwin_tcp_buffer_t();
        if (count < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + datanumber + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + datanumber + " gesetzt werden!");
        }
        int[] info = new int[4];
        this.adwin_tcp_get_data_info(datanumber, info);
        if (this.ati.error_number != 0) {
            return;
        }
        adwin_data_type_t adt = this.int_to_adwin_data_type(info[0]);
        int data_size = info[1];
        int is_fifo = info[2];
        int fifo_full = info[3];
        if (data_size < start - 1 + count) {
            throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
        }
        if (this.ati.processortype == 1012) {
            if (is_fifo == 1 && set_fifo == 1 && count > data_size - fifo_full) {
                throw new ADwinCommunicationError("There is not enough space left in fifo " + datanumber, "Nicht genug Platz \u00fcbrig in Fifo " + datanumber, this.Language, 101);
            }
            if (set_fifo == 1 && is_fifo == 0) {
                throw new ADwinCommunicationError("Data " + datanumber + " isn't a fifo!", "Data " + datanumber + " ist nicht als FIFO deklariert!", this.Language, 101);
            }
        }
        int count_b = count * this.bytes_per_value(adt);
        req.data = new byte[count_b];
        switch (adt) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] idata = new int[count];
                for (int i = 0; i < count; ++i) {
                    idata[i] = (int)data[i];
                }
                this.convert_data_from_int_to_stream(idata, req.data, count);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fdata = new float[count];
                this.convert_data_from_double_to_float(data, fdata, count);
                this.convert_data_from_float_to_stream(fdata, req.data, count);
                break;
            }
            case ADWIN_DOUBLE: {
                this.convert_data_from_double_to_stream(data, req.data, count);
                break;
            }
        }
        if (set_fifo == 1) {
            this.init_ati(25);
        } else {
            this.init_ati(8);
        }
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, datanumber);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, start);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, count);
        ADwinDirectDevice.setInteger(this.ati.req.data, 12, info[0]);
        this.ati.req.used = 16;
        req.do_convert = 0;
        req.used = count_b;
        if (this.tcp_write_request(this.ati, req) == -1) {
            return;
        }
        this.tcp_read_response(this.ati, 0, null);
    }

    void adwin_tcp_set_data_string(int datanumber, String s, int max_count) throws ADwinCommunicationError {
        int length = s.length();
        if (length > max_count) {
            length = max_count;
        }
        if (this.ati.processortype == 1012) {
            byte[] stringdata = s.getBytes();
            int strlen = stringdata.length + 1;
            byte[] data = new byte[strlen];
            System.arraycopy(stringdata, 0, data, 0, strlen - 1);
            data[strlen - 1] = 0;
            this.adwin_tcp_set_data_or_fifo_int8(datanumber, data, 0, strlen, 0);
        } else {
            int[] data = new int[length + 2];
            data[0] = length;
            for (int i = 0; i < length; ++i) {
                data[i + 1] = s.charAt(i);
            }
            data[length + 1] = 0;
            this.adwin_tcp_set_data_or_fifo_int32(datanumber, data, 1, length + 2, 0);
        }
    }

    void convert_data_from_stream_to_int(byte[] from_data, int[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = ADwinDirectDevice.extractInt(from_data, i * 4);
        }
    }

    void convert_data_from_stream_to_long(byte[] from_data, long[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = ADwinDirectDevice.extractLong(from_data, i * 8);
        }
    }

    void convert_data_from_stream_to_float(byte[] from_data, float[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = Float.intBitsToFloat(ADwinDirectDevice.extractInt(from_data, i * 4));
        }
    }

    void convert_data_from_stream_to_double(byte[] from_data, double[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = ByteBuffer.wrap(from_data, i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        }
    }

    void convert_data_from_int_to_stream(int[] from_data, byte[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            ADwinDirectDevice.setInteger(to_data, i * 4, from_data[i]);
        }
    }

    void convert_data_from_long_to_stream(long[] from_data, byte[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            ADwinDirectDevice.setLong(to_data, i * 8, from_data[i]);
        }
    }

    void convert_data_from_float_to_stream(float[] from_data, byte[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            ADwinDirectDevice.setInteger(to_data, i * 4, Float.floatToIntBits(from_data[i]));
        }
    }

    void convert_data_from_double_to_stream(double[] from_data, byte[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            ByteBuffer.wrap(to_data, i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).putDouble(from_data[i]);
        }
    }

    void convert_data_from_float_to_int(float[] from_data, int[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = (int)from_data[i];
        }
    }

    void convert_data_from_float_to_long(float[] from_data, long[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = (long)from_data[i];
        }
    }

    void convert_data_from_float_to_double(float[] from_data, double[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = from_data[i];
        }
    }

    void convert_data_from_byte_to_int(byte[] from_data, int[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = from_data[i];
        }
    }

    void convert_data_from_int_to_byte(int[] from_data, byte[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = (byte)from_data[i];
        }
    }

    void convert_data_from_int_to_float(int[] from_data, float[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = from_data[i];
        }
    }

    void convert_data_from_int_to_double(int[] from_data, double[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = from_data[i];
        }
    }

    void convert_data_from_int_to_long(int[] from_data, long[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = from_data[i];
        }
    }

    void convert_data_from_long_to_int(long[] from_data, int[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = (int)from_data[i];
        }
    }

    void convert_data_from_double_to_float(double[] from_data, float[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = (float)from_data[i];
        }
    }

    void convert_data_from_double_to_int(double[] from_data, int[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = (int)from_data[i];
        }
    }

    void convert_data_from_double_to_long(double[] from_data, long[] to_data, int count) {
        for (int i = 0; i < count; ++i) {
            to_data[i] = (long)from_data[i];
        }
    }

    int map_error_code(int adwin_error) {
        switch (adwin_error) {
            case -1: {
                return 2001;
            }
            case -5: {
                return 2002;
            }
            case -100: 
            case -31: {
                return 100;
            }
            case -32: {
                return 102;
            }
            case -35: {
                return 205;
            }
        }
        return adwin_error;
    }

    public class adwin_tcp_info_t {
        public InetAddress server_addr;
        public int firmware_version;
        public int firmware_version_beta;
        public int error_number;
        public int processortype;
        public boolean connected;
        public boolean initialized;
        public Socket socket;
        public int timeout_ms;
        public int timeout_size;
        public int dll_version;
        public int req_count;
        public int command;
        public int status;
        public adwin_tcp_buffer_t req;
        public int rx_pending;
        public adwin_tcp_buffer_t resp;
        InputStream stream_in;
        OutputStream stream_out;
    }

    public class adwin_tcp_buffer_t {
        public int max;
        public int used;
        public int do_convert;
        public byte[] data;
        public boolean as_char;
    }

    public class adwin_tcp_header_t {
        public int magic_flag;
        public int req_count;
        public int length;
        public int command_or_status;
    }

    static enum adwin_data_type_t {
        ADWIN_DATA_TYPE_INVALID,
        ADWIN_BYTE,
        ADWIN_SHORT,
        ADWIN_LONG,
        ADWIN_INTEGER,
        ADWIN_FLOAT,
        ADWIN_DOUBLE,
        ADWIN_INT64,
        ADWIN_STRING,
        ADWIN_VARIANT;

    }

    public class myVARIANT {
        public short typ;
        public int idummy;
        public short sdummy;
        public long val;
    }
}

