/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinDirectDevice;
import de.adwin.driver.DataToArrayConverter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class DataToIntArray
extends DataToArrayConverter {
    protected int[] Array;

    DataToIntArray(int Size, int SourceType) {
        super(Size);
        this.Array = new int[Size];
        this.SourceType = SourceType;
    }

    int[] getArray() {
        return this.Array;
    }

    @Override
    void storeBytesImpl(byte[] Bytes, int BytesIndex, int IndexStart, int Amount) {
        switch (this.SourceType) {
            case 2: 
            case 3: 
            case 8: {
                for (int i = 0; i < Amount; ++i) {
                    this.Array[IndexStart + i] = ADwinDirectDevice.extractInt(Bytes, BytesIndex + i * 4);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < Amount; ++i) {
                    this.Array[IndexStart + i] = (int)Float.intBitsToFloat(ADwinDirectDevice.extractInt(Bytes, BytesIndex + i * 4));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < Amount; ++i) {
                    this.Array[IndexStart + i] = (int)ByteBuffer.wrap(Bytes, BytesIndex + i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                }
                break;
            }
            case 7: {
                for (int i = 0; i < Amount; ++i) {
                    this.Array[IndexStart + i] = (int)ByteBuffer.wrap(Bytes, BytesIndex + i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
                }
                break;
            }
        }
    }

    String getString() {
        StringBuilder Str = new StringBuilder(0);
        for (int n = 1; n < this.Array.length && this.Array[n] != 0; ++n) {
            Str.append((char)this.Array[n]);
        }
        return Str.toString();
    }
}

