/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommunicationError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class NamedMutex {
    private final int LangID;
    private final RandomAccessFile LockFile;
    private final FileChannel fch;
    private FileLock CurrentLock = null;

    public NamedMutex(int Slot, int LangID) throws ADwinCommunicationError {
        this.LangID = LangID;
        String LockFileName = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "ADwinDevice" + Slot + "_Lock";
        try {
            this.LockFile = new RandomAccessFile(LockFileName, "rw");
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("Error when synchronizing on the ADwin system (" + ioe + ")", "Fehler beim Synchronisieren des Zugriffs auf das ADwin-System (" + ioe + ")", LangID, 4000);
        }
        if (this.LockFile == null) {
            throw new ADwinCommunicationError("Error when synchronizing on the ADwin system, File " + LockFileName + " cannot be created", "Fehler beim Synchronisieren des Zugriffs auf das ADwin-System, Datei " + LockFileName + " kann nicht erstellt werden", LangID, 4000);
        }
        this.fch = this.LockFile.getChannel();
    }

    public synchronized void enter() throws ADwinCommunicationError {
        try {
            this.CurrentLock = this.fch.lock();
        }
        catch (Exception e) {
            throw new ADwinCommunicationError("Error when synchronizing on the ADwin system (" + e + ")", "Fehler beim Synchronisieren des Zugriffs auf das ADwin-System (" + e + ")", this.LangID, 4000);
        }
        if (this.CurrentLock == null) {
            throw new ADwinCommunicationError("The underlying operating system does not support file locks", "Das Betriebssystem unterst\u00fctzt keine file locks", this.LangID, 4000);
        }
    }

    public synchronized void leave() throws ADwinCommunicationError {
        try {
            this.CurrentLock.release();
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("Error when synchronizing on the ADwin system (" + ioe + ")", "Fehler beim Synchronisieren des Zugriffs auf das ADwin-System (" + ioe + ")", this.LangID, 4000);
        }
        finally {
            this.CurrentLock = null;
        }
    }

    public void close() {
        try {
            this.LockFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.close();
    }
}

