/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDirectDevice;
import de.adwin.driver.DataToArrayConverter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;

class GetDataSHQueue {
    private final int[] queue;
    private int requestNumber;
    private int lastReceived;
    private final int packetIndex;
    private int queueInsertPointer;
    private int queueDeletePointer;
    private final DatagramSocket ds;
    private final ADwinDirectDevice add;
    private final InetAddress addr;
    private final int port;

    GetDataSHQueue(int n, int n2, DatagramSocket datagramSocket, ADwinDirectDevice aDwinDirectDevice, InetAddress inetAddress, int n3) {
        this.queue = new int[n];
        this.packetIndex = n2;
        this.requestNumber = 0;
        this.ds = datagramSocket;
        this.add = aDwinDirectDevice;
        this.addr = inetAddress;
        this.port = n3;
    }

    private int getMin() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.queue.length; ++n) {
            if (this.queue[n] == 0) continue;
            n2 = this.queue[n];
            break;
        }
        if (n2 == 0) {
            return 0;
        }
        while (n < this.queue.length) {
            if (this.queue[n] != 0 && this.queue[n] < n2) {
                n2 = this.queue[n];
            }
            ++n;
        }
        return n2;
    }

    private void deleteAll() {
        Arrays.fill(this.queue, 0);
    }

    private boolean deleteItem(int n) {
        if (this.queue[this.queueDeletePointer] == n) {
            this.queue[this.queueDeletePointer] = 0;
            ++this.queueDeletePointer;
            if (this.queueDeletePointer >= this.queue.length) {
                this.queueDeletePointer = 0;
            }
            return false;
        }
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] != n) continue;
            this.queue[i] = 0;
            this.queueDeletePointer = i + 1;
            if (this.queueDeletePointer >= this.queue.length) {
                this.queueDeletePointer = 0;
            }
            return false;
        }
        return true;
    }

    private boolean insertItem(int n) {
        int n2 = 0;
        do {
            if (this.queue[this.queueInsertPointer] == 0) {
                this.queue[this.queueInsertPointer] = n;
                ++this.queueInsertPointer;
                if (this.queueInsertPointer >= this.queue.length) {
                    this.queueInsertPointer = 0;
                }
                return true;
            }
            ++this.queueInsertPointer;
            if (this.queueInsertPointer < this.queue.length) continue;
            this.queueInsertPointer = 0;
        } while (++n2 != this.queue.length);
        return false;
    }

    private void sendRequest(int n, int n2, int n3, boolean bl) throws ADwinCommunicationError {
        GetDataSHRequest getDataSHRequest;
        int n4 = 0;
        if (n != 2) {
            n4 = this.getMin();
            n4 = n4 == 0 ? this.lastReceived : --n4;
        }
        switch (n) {
            case 0: {
                getDataSHRequest = new GetDataSHRequest(this.packetIndex, ++this.requestNumber, n4, n2);
                break;
            }
            case 1: {
                getDataSHRequest = new GetDataSHRequest(this.packetIndex, ++this.requestNumber, n4, n2, n3);
                break;
            }
            case 2: {
                getDataSHRequest = new GetDataSHRequest(this.packetIndex, ++this.requestNumber);
                break;
            }
            default: {
                throw new RuntimeException("invalid parameter isRange (" + n + ")");
            }
        }
        if (bl) {
            if (n == 1) {
                for (int i = n2; i <= n3; ++i) {
                    this.insertItem(i);
                }
            } else if (n == 0) {
                this.insertItem(n2);
            }
        }
        DatagramPacket datagramPacket = getDataSHRequest.getPacket(this.addr, this.port);
        try {
            this.ds.send(datagramPacket);
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.add.Language, 2000);
        }
    }

    private void sendAll() throws ADwinCommunicationError {
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] == 0) continue;
            this.sendRequest(0, this.queue[i], 0, false);
        }
    }

    private void sendAllLessThan(int n) throws ADwinCommunicationError {
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] >= n || this.queue[i] == 0) continue;
            this.sendRequest(0, this.queue[i], 0, false);
        }
    }

    void getArraySH(int n, DataToArrayConverter dataToArrayConverter, int n2, int n3) throws ADwinCommunicationError {
        int n4;
        int n5 = 0;
        int n6 = n / 336;
        if (n % 336 != 0) {
            ++n6;
        }
        this.deleteAll();
        int n7 = 1;
        int n8 = 1;
        int n9 = n6 <= n3 ? n6 : n3;
        int n10 = n9;
        for (n4 = 1; n4 <= n10; ++n4) {
            this.insertItem(n4);
        }
        int n11 = n10;
        n4 = 0;
        byte[] byArray = new byte[1500];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 1500);
        while (n11 > 0) {
            GetDataSHData getDataSHData;
            try {
                this.ds.setSoTimeout(this.add.MaxPacketDelay);
                this.ds.receive(datagramPacket);
                n4 = 0;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (++n4 > this.add.AllowedErrors) {
                    throw new ADwinCommunicationError("timeout when waiting for the data field", "Timeout beim Warten auf das Data", this.add.Language, 2001);
                }
            }
            catch (IOException iOException) {
                throw new ADwinCommunicationError("I/O error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.add.Language, 2000);
            }
            if (n4 != 0) {
                this.sendAll();
            } else if (datagramPacket.getLength() == 1356 && (getDataSHData = new GetDataSHData(datagramPacket)).getPacketIndex() == this.packetIndex && !this.deleteItem(n5 = getDataSHData.getPacketNumber())) {
                --n11;
                dataToArrayConverter.storeBytes(byArray, 12, (n5 - 1) * 336, 336);
            }
            if (n11 != n2 || n9 == n6) continue;
            n8 = n9 + 1;
            if (n6 - n9 >= n3 - n2) {
                n10 = n9 + n3 - n2;
                n11 += n3 - n2;
            } else if (n9 < n6) {
                n10 = n6;
                n11 += n6 - n9;
            }
            this.sendAllLessThan(n9 - n2);
            n9 = n10;
            n7 = n8 == n10 ? 0 : 1;
            this.sendRequest(n7, n8, n10, true);
        }
        try {
            this.sendRequest(2, 0, 0, false);
        }
        catch (ADwinCommunicationError aDwinCommunicationError) {
            // empty catch block
        }
    }

    class GetDataSHData {
        static final int PACKAGE_SIZE = 1344;
        static final int PARAM_SIZE = 12;
        static final int PACKET_SIZE = 1356;
        byte[] packetData;
        int packetIndex = 0;

        GetDataSHData(DatagramPacket datagramPacket) {
            this.packetData = datagramPacket.getData();
        }

        int getPacketIndex() {
            return ADwinDirectDevice.reverseByteOrder(ADwinDirectDevice.extractInt(this.packetData, 0));
        }

        int getPacketNumber() {
            return ADwinDirectDevice.reverseByteOrder(ADwinDirectDevice.extractInt(this.packetData, 4));
        }
    }

    class GetDataSHRequest {
        static final int REQ_SINGLE = 0;
        static final int REQ_RANGE = 1;
        static final int REQ_END = 2;
        int isRange = 0;
        int p1_firstRequested = 0;
        int p2_lastRequested = 0;
        int packetIndex = 0;
        int requestNumber = 0;
        int completePackets = 0;

        GetDataSHRequest() {
        }

        GetDataSHRequest(int n, int n2, int n3, int n4) {
            this.isRange = 0;
            this.p1_firstRequested = n4;
            this.packetIndex = n;
            this.requestNumber = n2;
            this.completePackets = n3;
        }

        GetDataSHRequest(int n, int n2, int n3, int n4, int n5) {
            this.isRange = 1;
            this.p1_firstRequested = n4;
            this.p2_lastRequested = n5;
            this.packetIndex = n;
            this.requestNumber = n2;
            this.completePackets = n3;
        }

        GetDataSHRequest(int n, int n2) {
            this.isRange = 2;
            this.requestNumber = n2;
            this.packetIndex = n;
        }

        DatagramPacket getPacket(InetAddress inetAddress, int n) {
            byte[] byArray = new byte[64];
            Arrays.fill(byArray, (byte)0);
            ADwinDirectDevice.setInteger(byArray, 0, ADwinDirectDevice.reverseByteOrder(this.packetIndex));
            ADwinDirectDevice.setInteger(byArray, 4, ADwinDirectDevice.reverseByteOrder(this.requestNumber));
            ADwinDirectDevice.setInteger(byArray, 8, ADwinDirectDevice.reverseByteOrder(this.completePackets));
            ADwinDirectDevice.setInteger(byArray, 12, ADwinDirectDevice.reverseByteOrder(this.isRange));
            ADwinDirectDevice.setInteger(byArray, 16, ADwinDirectDevice.reverseByteOrder(this.p1_firstRequested));
            ADwinDirectDevice.setInteger(byArray, 20, ADwinDirectDevice.reverseByteOrder(this.p2_lastRequested));
            return new DatagramPacket(byArray, 64, inetAddress, n);
        }
    }
}

