/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommunicationError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class NamedMutex {
    private final int LangID;
    private RandomAccessFile LockFile;
    private final FileChannel fch;
    private FileLock CurrentLock = null;

    public NamedMutex(int n, int n2) throws ADwinCommunicationError {
        this.LangID = n2;
        String string = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "ADwinDevice" + n + "_Lock";
        try {
            this.LockFile = new RandomAccessFile(string, "rw");
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("Error when synchronizing on the ADwin system (" + iOException.toString() + ")", "Fehler beim Synchronisieren des Zugriffs auf das ADwin-System (" + iOException.toString() + ")", n2, 4000);
        }
        if (this.LockFile == null) {
            throw new ADwinCommunicationError("Error when synchronizing on the ADwin system, File " + string + " cannot be created", "Fehler beim Synchronisieren des Zugriffs auf das ADwin-System, Datei " + string + " kann nicht erstellt werden", n2, 4000);
        }
        this.fch = this.LockFile.getChannel();
    }

    public synchronized void enter() throws ADwinCommunicationError {
        try {
            this.CurrentLock = this.fch.lock();
        }
        catch (Exception exception) {
            throw new ADwinCommunicationError("Error when synchronizing on the ADwin system (" + exception.toString() + ")", "Fehler beim Synchronisieren des Zugriffs auf das ADwin-System (" + exception.toString() + ")", this.LangID, 4000);
        }
        if (this.CurrentLock == null) {
            throw new ADwinCommunicationError("The underlying operating system does not support file locks", "Das Betriebssystem unterst\u00c3\u00bctzt keine file locks", this.LangID, 4000);
        }
    }

    public synchronized void leave() throws ADwinCommunicationError {
        try {
            this.CurrentLock.release();
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("Error when synchronizing on the ADwin system (" + iOException.toString() + ")", "Fehler beim Synchronisieren des Zugriffs auf das ADwin-System (" + iOException.toString() + ")", this.LangID, 4000);
        }
        finally {
            this.CurrentLock = null;
        }
    }

    public void close() {
        try {
            this.LockFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.close();
    }
}

