/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinDirectDevice;
import java.net.DatagramPacket;
import java.net.InetAddress;

class ADwinCommand {
    private final byte[] Data;
    private int Version = 0;
    private final int Port;

    public ADwinCommand(int n, int n2, int n3) {
        this.Version = n;
        this.Port = n3;
        this.Data = new byte[n >= 252 && n <= 259 || n >= 264 ? 56 : 52];
        this.setTimeout(1000);
        this.setPwd("");
        if (this.Data.length == 56) {
            for (int i = 0; i < 4; ++i) {
                this.Data[i + 52] = (byte)(n2 << (3 - i) * 8 >>> 24);
            }
        }
        this.Data[44] = 32;
    }

    public int getCommand() {
        return ADwinDirectDevice.extractInt(this.Data, 0);
    }

    public void setCommand(int n) {
        for (int i = 0; i < 4; ++i) {
            this.Data[i] = (byte)(n << (3 - i) * 8 >>> 24);
        }
    }

    public void setPacketIndex(int n) {
        for (int i = 0; i < 4; ++i) {
            this.Data[i + 4] = (byte)(n << (3 - i) * 8 >>> 24);
        }
    }

    public final void setPwd(String string) {
        int n = 0;
        for (n = 0; n < 9 && n < string.length(); ++n) {
            this.Data[n + 8] = (byte)string.charAt(n);
        }
        this.Data[n + 8] = 0;
    }

    public void setValues(int[] nArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.Data[j + 20 + i * 4] = (byte)(nArray[i] << (3 - j) * 8 >>> 24);
            }
        }
    }

    public void setLink(int n) {
        for (int i = 0; i < 4; ++i) {
            this.Data[i + 36] = (byte)(n << (3 - i) * 8 >>> 24);
        }
    }

    public final void setTimeout(int n) {
        for (int i = 0; i < 4; ++i) {
            this.Data[i + 40] = (byte)(n << (3 - i) * 8 >>> 24);
        }
    }

    public DatagramPacket getDatagram(InetAddress inetAddress) {
        return new DatagramPacket(this.Data, this.Version >= 252 && this.Version <= 259 || this.Version >= 264 ? 56 : 52, inetAddress, this.Port);
    }
}

