/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDebugListener;
import de.adwin.driver.ADwinDirectDevice;
import de.adwin.driver.NamedMutex;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;

public class ADwinDevice {
    public static final int LANGID_ENGLISH = 1;
    public static final int LANGID_GERMAN = 2;
    public static final int LANGID_SYSDEFAULT = 0;
    private static HashMap Devices = new HashMap();
    private int LangID = 1;
    private NamedMutex nm = null;
    private int CurrentDeviceNo = 0;
    private ADwinDirectDevice add = null;
    private boolean UseFileLocks = false;

    public ADwinDevice() {
        try {
            this.LangID = Locale.getDefault().getISO3Language().compareTo("deu") != 0 ? 1 : 2;
        }
        catch (MissingResourceException missingResourceException) {
            this.LangID = 1;
        }
    }

    public void Add_Entry(int n, InetAddress inetAddress, String string, int n2, int n3) {
        this.Add_Entry(n, inetAddress, string, 1000, 1000, 3, 20, 100, 5, n2, n3);
    }

    public void Add_Entry(int n, InetAddress inetAddress, String string, int n2, int n3, int n4) {
        this.Add_Entry(n, inetAddress, string, n4, n4, 3, 20, 100, 5, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Add_Entry(int n, InetAddress inetAddress, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws IllegalArgumentException {
        HashMap hashMap = Devices;
        synchronized (hashMap) {
            if (n < 0) {
                throw new IllegalArgumentException("Only positive device numbers are allowed");
            }
            if (Devices.get(new Integer(n)) != null) {
                throw new IllegalArgumentException("Device-No " + n + " already exists");
            }
            Dev dev = new Dev();
            dev.IP = inetAddress;
            dev.Password = string;
            dev.Timeout = n2;
            dev.ADTimeout = n3;
            dev.AllowedErrors = n4;
            dev.NumWaits = 10000000;
            dev.WaitTime = n6;
            dev.Blocksize = n7;
            dev.Hostlink = n8;
            dev.Port = n9;
            Devices.put(new Integer(n), dev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Remove_Entry(int n) {
        HashMap hashMap = Devices;
        synchronized (hashMap) {
            return Devices.remove(new Integer(n)) != null;
        }
    }

    public void Use_FileLocks(boolean bl) throws ADwinCommunicationError {
        this.UseFileLocks = bl;
        if (!this.UseFileLocks && this.nm != null) {
            this.nm.close();
            this.nm = null;
        } else if (this.UseFileLocks && this.nm == null && this.CurrentDeviceNo > 0) {
            this.nm = new NamedMutex(this.CurrentDeviceNo, this.LangID);
        }
    }

    public void Set_Language(int n) {
        try {
            this.LangID = n != 1 && n != 2 ? (Locale.getDefault().getISO3Language().compareTo("deu") != 0 ? 1 : 2) : n;
        }
        catch (MissingResourceException missingResourceException) {
            this.LangID = 1;
        }
        if (this.add != null) {
            this.add.Language = this.LangID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] Get_Known_DeviceNo() {
        int[] nArray;
        HashMap hashMap = Devices;
        synchronized (hashMap) {
            Object[] objectArray = Devices.keySet().toArray();
            nArray = new int[Devices.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)objectArray[i];
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Set_DeviceNo(int n) throws ADwinCommunicationError {
        HashMap hashMap = Devices;
        synchronized (hashMap) {
            Dev dev = (Dev)Devices.get(new Integer(n));
            if (dev == null) {
                throw new IllegalArgumentException(this.LangID == 2 ? "Device " + n + " nicht in der Device-Tabelle" : "Device " + n + " is not in the device table");
            }
            if (this.UseFileLocks && this.CurrentDeviceNo != n) {
                if (this.nm != null) {
                    this.nm.close();
                }
                this.nm = new NamedMutex(n, this.LangID);
            }
            this.CurrentDeviceNo = n;
            try {
                if (this.UseFileLocks) {
                    this.nm.enter();
                }
                this.add = new ADwinDirectDevice(dev.IP, dev.Port, dev.Password, dev.AllowedErrors, dev.Timeout, dev.Blocksize, dev.ADTimeout, dev.NumWaits, dev.WaitTime, dev.Hostlink);
            }
            catch (SocketException socketException) {
                throw new ADwinCommunicationError("The socket used to communicate with the ADwin system could not be created (" + socketException.toString() + ")", "Der Socket, der zur Kommunikation mit dem ADwin-System verwendet wird, konnte nicht erstellt werden (" + socketException.toString() + ")", this.LangID, 2000);
            }
            finally {
                if (this.UseFileLocks) {
                    this.nm.leave();
                }
            }
            this.add.Language = this.LangID;
        }
    }

    public int Get_DeviceNo() {
        return this.CurrentDeviceNo;
    }

    public int Get_Par(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n2 = 0;
        try {
            n2 = this.add.getPar(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Packed(int n, int[] nArray, int n2, int n3) throws ADwinCommunicationError {
        if (n3 <= 0) {
            return;
        }
        if (nArray.length < n3) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n4 = n3 / 2 + (n2 % 2 | n3 % 2);
        int n5 = n2 / 2;
        try {
            int[] nArray2 = this.add.getDataInt(n, n5, n5 + n4 - 1);
            for (int i = 0; i < n3; ++i) {
                nArray[i] = nArray2[(n2 % 2 & i % 2) + i / 2] << (n2 + i + 1) % 2 * 16 >> 16;
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFifo_Packed(int n, int[] nArray, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (nArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n3 = n2 / 2 + n2 % 2;
        try {
            int[] nArray2 = this.add.getFifoInt(n, n3);
            for (int i = 0; i < n2; ++i) {
                nArray[i] = nArray2[i / 2] << (i + 1) % 2 * 16 >> 16;
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Processor_Type() throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n = 0;
        try {
            n = this.add.getProcessorType();
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Long(int n, int[] nArray, int n2, int n3) throws ADwinCommunicationError {
        if (n3 <= 0) {
            return;
        }
        if (nArray.length < n3) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] nArray2 = null;
        try {
            nArray2 = this.add.getDataInt(n, n2, n2 + n3 - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n3; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Float(int n, float[] fArray, int n2, int n3) throws ADwinCommunicationError {
        if (n3 <= 0) {
            return;
        }
        if (fArray.length < n3) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float[] fArray2 = null;
        try {
            fArray2 = this.add.getDataFloat(n, n2, n2 + n3 - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n3; ++i) {
            fArray[i] = fArray2[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Double(int n, double[] dArray, int n2, int n3) throws ADwinCommunicationError {
        if (n3 <= 0) {
            return;
        }
        if (dArray.length < n3) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double[] dArray2 = null;
        try {
            dArray2 = this.add.getDataDouble(n, n2, n2 + n3 - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n3; ++i) {
            dArray[i] = dArray2[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Long(int n, int[] nArray, int n2, int n3) throws ADwinCommunicationError {
        if (n3 <= 0) {
            return;
        }
        if (nArray.length < n3) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setDataInt(n, nArray, n2, n3);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Float(int n, float[] fArray, int n2, int n3) throws ADwinCommunicationError {
        if (n3 <= 0) {
            return;
        }
        if (fArray.length < n3) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setDataFloat(n, fArray, n2, n3);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Double(int n, double[] dArray, int n2, int n3) throws ADwinCommunicationError {
        if (n3 <= 0) {
            return;
        }
        if (dArray.length < n3) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setDataDouble(n, dArray, n2, n3);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Set_Par(int n, int n2) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setPar(n, n2);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_Par_Block(int[] nArray, int n, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (nArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] nArray2 = null;
        try {
            nArray2 = this.add.getParIntBlock(n, n2);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_FPar_Block(float[] fArray, int n, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (fArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float[] fArray2 = null;
        try {
            fArray2 = this.add.getParFloatBlock(n, n2);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n2; ++i) {
            fArray[i] = fArray2[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_FPar_Block_Double(double[] dArray, int n, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (dArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double[] dArray2 = null;
        try {
            dArray2 = this.add.getParFloatBlockDouble(n, n2);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n2; ++i) {
            dArray[i] = dArray2[i];
        }
    }

    public int Data_Length(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n2 = 0;
        try {
            n2 = this.add.getDataLength(n) - 1;
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    public int Fifo_Empty(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n2 = 0;
        try {
            n2 = this.add.getFifoFree(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    public int Fifo_Full(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n2 = 0;
        try {
            n2 = this.add.getFifoUsed(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    public void Fifo_Clear(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.clearFifo(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetFifo_Long(int n, int[] nArray, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (nArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFifoInt(n, n2, nArray);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetFifo_Float(int n, float[] fArray, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (fArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFifoFloat(n, n2, fArray);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetFifo_Double(int n, double[] dArray, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (dArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFifoDouble(n, n2, dArray);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Get_Par_All(int[] nArray) throws ADwinCommunicationError {
        this.Get_Par_Block(nArray, 1, 80);
    }

    public void Get_FPar_All(float[] fArray) throws ADwinCommunicationError {
        this.Get_FPar_Block(fArray, 1, 80);
    }

    public void Get_FPar_All_Double(double[] dArray) throws ADwinCommunicationError {
        this.Get_FPar_Block_Double(dArray, 1, 80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFifo_Long(int n, int[] nArray, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (nArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] nArray2 = null;
        try {
            nArray2 = this.add.getFifoInt(n, n2);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFifo_Float(int n, float[] fArray, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (fArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float[] fArray2 = null;
        try {
            fArray2 = this.add.getFifoFloat(n, n2);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n2; ++i) {
            fArray[i] = fArray2[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFifo_Double(int n, double[] dArray, int n2) throws ADwinCommunicationError {
        if (n2 <= 0) {
            return;
        }
        if (dArray.length < n2) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double[] dArray2 = null;
        try {
            dArray2 = this.add.getFifoDouble(n, n2);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        for (int i = 0; i < n2; ++i) {
            dArray[i] = dArray2[i];
        }
    }

    public float Get_FPar(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float f = 0.0f;
        try {
            f = this.add.getFPar(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double Get_FPar_Double(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double d = 0.0;
        try {
            d = this.add.getFParDouble(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return d;
    }

    public void Set_FPar(int n, float f) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFPar(n, f);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Set_FPar_Double(int n, double d) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFParDouble(n, d);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Workload() throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n = 0;
        try {
            n = this.add.getWorkload();
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n;
    }

    public int Free_Mem(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n2 = 0;
        try {
            n2 = this.add.getFreeMem(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    public void Load_Process(String string) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        if (!new File(string).isFile()) {
            throw new ADwinCommunicationError("File not Found - " + string, "Datei nicht gefunden - " + string, this.LangID, 200);
        }
        try {
            this.add.loadProcessFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ADwinCommunicationError("File not Found - " + string, "Datei nicht gefunden - " + string, this.LangID, 200);
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("Error when reading " + string + "(" + iOException.getMessage() + ")", "Fehler beim Lesen von " + string + "(" + iOException.getMessage() + ")", this.LangID, 200);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Start_Process(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.startProcess(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Stop_Process(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.stopProcess(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Clear_Process(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.clearProcess(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Process_Status(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n2 = 0;
        try {
            n2 = this.add.getProcessState(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    public void Boot(String string) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        char c = string.charAt(string.length() - 5);
        int n = 0;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'A' && c <= 'Z') {
            n = c - 65;
        } else if (c >= 'a' && c <= 'z') {
            n = c - 97;
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.bootFile(string, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ADwinCommunicationError("File " + string + " not found", "Datei " + string + " nicht gefunden", this.LangID, 200);
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("Error when reading " + string + "(" + iOException.getMessage() + ")", "Fehler beim Lesen von " + string + "(" + iOException.getMessage() + ")", this.LangID, 205);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public String GetData_String(int n) throws ADwinCommunicationError {
        String string;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            string = this.add.getString(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetData_String(int n, char[] cArray, int n2) throws ADwinCommunicationError {
        if (cArray.length < n2) {
            return 0;
        }
        int n3 = 0;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            String string = this.add.getString(n);
            for (n3 = 0; n3 < n2 && n3 < string.length(); ++n3) {
                cArray[n3] = string.charAt(n3);
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n3;
    }

    public void SetData_String(int n, String string) throws ADwinCommunicationError {
        if (string.length() == 0) {
            return;
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setString(n, string);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int String_Length(int n) throws ADwinCommunicationError {
        int n2;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            n2 = this.add.getStringLength(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    public void Set_Globaldelay(int n, int n2) throws ADwinCommunicationError {
        this.Set_Processdelay(n, n2);
    }

    public void Set_Processdelay(int n, int n2) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setGlobalDelay(n, n2);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Get_Globaldelay(int n) throws ADwinCommunicationError {
        return this.Get_Processdelay(n);
    }

    public int Get_Processdelay(int n) throws ADwinCommunicationError {
        int n2;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            n2 = this.add.getGlobalDelay(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    public void setDebugListener(ADwinDebugListener aDwinDebugListener) {
        this.add.adl = aDwinDebugListener;
    }

    public int Test_Version() throws ADwinCommunicationError {
        int n;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            n = this.add.getDriverVersion();
        }
        catch (ADwinCommunicationError aDwinCommunicationError) {
            n = 3;
        }
        if (this.UseFileLocks) {
            this.nm.leave();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Data2File(String string, int n, int n2, int n3, int n4) throws ADwinCommunicationError {
        block22: {
            if (this.CurrentDeviceNo <= 0) {
                throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
            }
            FileOutputStream fileOutputStream = null;
            if (n4 != 0 && n4 != 1) {
                throw new IllegalArgumentException(this.LangID == 1 ? "Mode must be 0 or 1" : "Mode muss 0 oder 1 sein");
            }
            try {
                fileOutputStream = new FileOutputStream(string, n4 != 0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ADwinCommunicationError("File not Found (" + fileNotFoundException.getMessage() + ")", "Datei nicht gefunden (" + fileNotFoundException.getMessage() + ")", this.LangID, 200);
            }
            if (n3 <= 0) {
                throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
            }
            if (this.UseFileLocks) {
                this.nm.enter();
            }
            try {
                int n5 = this.add.getDataType(n);
                if (n5 == 5) {
                    float[] fArray = this.add.getDataFloat(n, n2, n2 + n3 - 1);
                    byte[] byArray = new byte[n3 * 4];
                    for (int i = 0; i < n3; ++i) {
                        ADwinDirectDevice.setInteger(byArray, i * 4, Float.floatToIntBits(fArray[i]));
                    }
                    try {
                        fileOutputStream.write(byArray, 0, n3 * 4);
                        break block22;
                    }
                    catch (IOException iOException) {
                        throw new ADwinCommunicationError("Error when writing to file " + string, "Fehler beim Schreiben zur Datei " + string, this.LangID, 205);
                    }
                }
                if (n5 == 3) {
                    int[] nArray = this.add.getDataInt(n, n2, n2 + n3 - 1);
                    byte[] byArray = new byte[n3 * 4];
                    for (int i = 0; i < n3; ++i) {
                        ADwinDirectDevice.setInteger(byArray, i * 4, nArray[i]);
                    }
                    try {
                        fileOutputStream.write(byArray, 0, n3 * 4);
                        break block22;
                    }
                    catch (IOException iOException) {
                        throw new ADwinCommunicationError("Error when writing to file " + string, "Fehler beim Schreiben zur Datei " + string, this.LangID, 205);
                    }
                }
                throw new ADwinCommunicationError("Invalid Type of Data_" + n, "Data_" + n + " hat einen ung\u00c3\u00bcltigen Typ", this.LangID, 100);
            }
            finally {
                if (this.UseFileLocks) {
                    this.nm.leave();
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.LangID, 205);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void File2Data(String string, int n, int n2, int n3) throws ADwinCommunicationError, IllegalArgumentException {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            byte[] byArray;
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                if (byArray.length == 0) {
                    throw new ADwinCommunicationError("The file is not valid.", "Die Datei ist ung\u00c3\u00bcltig.", this.LangID, 203);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ADwinCommunicationError("File not found.", "Datei konnte nicht gefunden werden.", this.LangID, 200);
            }
            catch (IOException iOException) {
                throw new ADwinCommunicationError("The file is not valid.", "Die Datei ist ung\u00c3\u00bcltig.", this.LangID, 203);
            }
            switch (n) {
                case 3: {
                    int n4 = byArray.length / 4;
                    int[] nArray = new int[n4];
                    this.add.convert_data_from_stream_to_int(byArray, nArray, n4);
                    this.add.setDataInt(n2, nArray, 1, n4);
                    return;
                }
                case 5: {
                    int n5 = byArray.length / 4;
                    float[] fArray = new float[n5];
                    this.add.convert_data_from_stream_to_float(byArray, fArray, n5);
                    this.add.setDataFloat(n2, fArray, 1, n5);
                    return;
                }
                case 6: {
                    int n6 = byArray.length / 8;
                    double[] dArray = new double[n6];
                    this.add.convert_data_from_stream_to_double(byArray, dArray, n6);
                    this.add.setDataDouble(n2, dArray, 1, n6);
                    return;
                }
                default: {
                    throw new IllegalArgumentException(this.LangID == 2 ? "Als DataType 3, 5 oder 6 angeben!" : "DataType must be 3, 5 or 6!");
                }
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Data_Type(int n) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int n2 = 0;
        try {
            n2 = this.add.getDataType(n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n2;
    }

    public ADwinDevice Get_Copy() {
        ADwinDevice aDwinDevice = new ADwinDevice();
        aDwinDevice.Set_Language(this.LangID);
        try {
            aDwinDevice.Use_FileLocks(this.UseFileLocks);
        }
        catch (ADwinCommunicationError aDwinCommunicationError) {
            System.out.println(aDwinCommunicationError.getMessage());
        }
        return aDwinDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Boot(byte[] byArray, String string) throws ADwinCommunicationError, IOException {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        char c = string.charAt(string.length() - 5);
        int n = 0;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'A' && c <= 'Z') {
            n = c - 65;
        } else if (c >= 'a' && c <= 'z') {
            n = c - 97;
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.bootArray(byArray, string, n);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Load_Process(byte[] byArray, String string) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.loadProcessArray(byArray, string);
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.LangID, 2000);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Boot(URL uRL) throws ADwinCommunicationError, IOException {
        this.Boot(this.loadURL(uRL), uRL.toString());
    }

    public void Load_Process(URL uRL) throws ADwinCommunicationError {
        this.Load_Process(this.loadURL(uRL), uRL.toString());
    }

    private byte[] loadURL(URL uRL) throws ADwinCommunicationError {
        try {
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[inputStream.available()];
            int n = 0;
            int n2 = 0;
            do {
                n2 = inputStream.read(byArray, n, byArray.length - n);
                n += n2;
            } while (n2 > 0);
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.LangID, 200);
        }
    }

    private static class Dev {
        InetAddress IP;
        String Password;
        int Timeout;
        int ADTimeout;
        int AllowedErrors;
        int WaitTime;
        int Blocksize;
        int NumWaits = 10000000;
        int Hostlink;
        int Port;

        private Dev() {
        }
    }
}

