/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommand;
import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDebugListener;
import de.adwin.driver.ADwinDebugListenerPrioConstants;
import de.adwin.driver.DataFieldTransfer;
import de.adwin.driver.DataToArrayConverter;
import de.adwin.driver.DataToFloatArray;
import de.adwin.driver.DataToIntArray;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;

class ADwinDirectDevice
implements ADwinDebugListenerPrioConstants {
    private final int k_3plus1 = 0;
    private final int k_GetPar = 1;
    private final int k_Start = 2;
    private final int k_Stop = 3;
    private final int k_lMemory = 5;
    private final int k_SetPar = 6;
    private final int k_Clear_Data = 9;
    private final int k_GetDataLength = 11;
    private final int k_MemoryAll = 12;
    private final int k_ClearProcess = 14;
    private final int k_ADC = 15;
    private final int k_DAC = 16;
    private final int k_GetDigin = 17;
    private final int k_SetDigout = 18;
    private final int k_GetDigout = 19;
    private final int k_Auslastung = 20;
    private final int k_ClearFifo = 21;
    private final int k_GetFifoEmpty = 22;
    private final int k_GetFifoCount = 23;
    private final int k_LadeBin = 4;
    private final int k_GetDataStringSize = 44;
    private final int k_GetDataInfo = 45;
    private final int k_GetDataType = 100;
    private final int k_GetData = 7;
    private final int k_GetDataShiftedHandshake = 107;
    private final int k_GetDatasmall = 207;
    private final int k_SetData = 8;
    private final int k_SetDataLastStatus = 108;
    private final int k_CreateData = 10;
    private final int k_GetParAll = 13;
    private final int k_GetFifo = 24;
    private final int k_GetFifoRetry = 124;
    private final int k_SetFifo = 25;
    private final int k_SetFifoRetry = 125;
    private final int k_Boot = 50;
    private final int k_ARMVersion = 1000;
    private final int k_TestVersion = 255;
    private final int k_Authenticate = 300;
    private final int k_GetMemoryDSP = 1000000;
    private final int k_ok = 0;
    private final int k_Data_is_to_small = 100;
    private final int k_Fifo_is_to_small = 101;
    private final int k_Fifo_to_less_data = 102;
    private final int k_Mem_Error = 150;
    private final int k_File_not_found = 200;
    private final int k_File_not_binaer = 202;
    private final int k_File_not_valid = 203;
    private final int k_File_not_btl = 204;
    private final int k_WrongBinFile = 205;
    private final int k_error_tcp_error = 2000;
    private final int k_error_tcp_timout_read = 2001;
    private final int k_error_tcp_password = 2002;
    private final int VAL_GET_PAR = 1;
    private final int CMD_GET_VERSION = 255;
    private final int CMD_GET_DATA_TYPE = 100;
    private final int CMD_VAL_GET_DATA = 7;
    private final int VAL_GET_DATA_LENGTH = 11;
    private final int CMD_GET_DATA_SMALL = 207;
    private final int CMD_LOAD_BINARY = 4;
    private final int VAL_START = 2;
    private final int VAL_STOP = 3;
    private final int CMD_BOOT = 50;
    private final int CMD_SET_DATA = 8;
    private final int VAL_SET_PAR = 6;
    private final int CMD_SET_FIFO = 25;
    private final int CMD_SET_FIFO_RETRY = 125;
    private final int CMD_VAL_WORKLOAD = 20;
    private final int VAL_MEMORY = 5;
    private final int VAL_MEMORY_ALL = 12;
    private final int VAL_CLEAR_PROCESS = 14;
    private final int CMD_GET_PAR_BLOCK = 13;
    private final int VAL_GET_FIFO_FREE = 22;
    private final int VAL_GET_FIFO_COUNT = 23;
    private final int VAL_CLEAR_FIFO = 21;
    private final int CMD_VAL_ARMVERSION = 1000;
    private final int CMD_SETDATA_STATUS = 108;
    private final int CMD_GET_DATA_SH = 107;
    private final int CMD_AUTHENTICATE = 300;
    private final DatagramSocket ds;
    private volatile int currentPacketIndex = 1;
    private final InetAddress Connection;
    final String Password;
    static final int DATATYPE_INT = 3;
    static final int DATATYPE_LONG = 4;
    static final int DATATYPE_FLOAT = 5;
    static final int DATATYPE_DOUBLE = 6;
    static final int DATATYPE_PACKED_INT = 2;
    static final int GETDATASH_MIN_REQ = 6;
    static final int GETDATASH_MAX_REQ = 30;
    static final int GETDATASH_QUEUE_SIZE = 40;
    final int AllowedErrors;
    final int MaxPacketDelay;
    final int DataBlockSize;
    final int ADwTimeout;
    final int NumWaits;
    final int WaitTime;
    final int Hostlink;
    final int Port;
    final int PROCESSOR_T2 = 2;
    final int PROCESSOR_T4 = 4;
    final int PROCESSOR_T5 = 5;
    final int PROCESSOR_T8 = 8;
    final int PROCESSOR_T9 = 9;
    final int PROCESSOR_T10 = 1010;
    final int PROCESSOR_T11 = 1011;
    final int PROCESSOR_T12 = 1012;
    ADwinDebugListener adl = null;
    int Language = 1;
    volatile int version = 0;
    final int DLLVersion = 3000447;
    final int MY_VARIANT_EMPTY = 0;
    final int MY_VARIANT_NULL = 1;
    final int MY_VARIANT_INT16 = 2;
    final int MY_VARIANT_INT32 = 3;
    final int MY_VARIANT_FLOAT = 4;
    final int MY_VARIANT_DOUBLE = 5;
    final int SMALL_REQ_SIZE = 10240;
    final int ADWIN_TCP_MAGIC_FLAG_REQUEST = 1118650900;
    final int ADWIN_TCP_MAGIC_FLAG_RESPONSE = 1118650963;
    final int ADWIN_HTONL = 1;
    final int ADWIN_NTOHL = 2;
    volatile boolean supports_tcp = false;
    volatile boolean supports_udp = true;
    static final int ADWIN_TCP_OK = 0;
    static final int ADWIN_TCP_ERROR = 1;
    static final int ADWIN_UDP = 2;
    Date last_access = new Date(0L);
    int tcp_status;
    volatile adwin_tcp_info_t ati;

    ADwinDirectDevice(InetAddress inetAddress, int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws SocketException, ADwinCommunicationError {
        this.Connection = inetAddress;
        this.Port = n;
        this.Password = string;
        this.AllowedErrors = n2;
        this.MaxPacketDelay = n3;
        this.DataBlockSize = n4;
        this.ADwTimeout = n5;
        this.NumWaits = n6;
        this.WaitTime = n7;
        this.Hostlink = n8;
        this.ds = new DatagramSocket(0);
        this.ds.setReceiveBufferSize(140000);
        this.adwin_tcp_construct();
        this.version = this.getArmVersion();
    }

    boolean newTryLater() {
        int n = this.version;
        return n >= 252 && n <= 259 || n >= 264;
    }

    synchronized int incGetCurrentIndex() {
        if (this.adl != null) {
            this.adl.enter("incCurrentIndex");
        }
        int n = this.currentPacketIndex++;
        if (this.currentPacketIndex > 0x7FFFFFFE) {
            if (this.adl != null) {
                this.adl.message("Wrapping Packet-Index around...", 100);
            }
            this.currentPacketIndex = 1;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readAEIVersionIfUnknown() throws ADwinCommunicationError {
        if (this.version == 0) {
            DatagramSocket datagramSocket = this.ds;
            synchronized (datagramSocket) {
                if (this.version == 0) {
                    this.version = this.getArmVersion();
                }
            }
        }
        return this.version;
    }

    private void sendCommand(ADwinCommand aDwinCommand, int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("sendCommand ( ADwinCommand: " + aDwinCommand.getCommand() + ", " + n + ")");
        }
        aDwinCommand.setPacketIndex(n);
        aDwinCommand.setLink(this.Hostlink);
        try {
            DatagramPacket datagramPacket = aDwinCommand.getDatagram(this.Connection);
            this.ds.send(datagramPacket);
        }
        catch (IOException iOException) {
            if (this.adl != null) {
                this.adl.message("IOException -> ADwinCommunicationError in sendCommand", 100);
                this.adl.leave();
            }
            throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramPacket sendAndWaitForAnswer32Byte(ADwinCommand aDwinCommand, int[] nArray) throws ADwinCommunicationError, SocketTimeoutException {
        if (this.adl != null) {
            this.adl.enter("sendAndWaitForAnswer32Byte ( Command: " + aDwinCommand.getCommand() + ")");
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        byte[] byArray = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray[i] = 0;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 32);
        int n3 = this.NumWaits;
        boolean bl2 = false;
        boolean bl3 = false;
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            do {
                if (bl && !bl2 && this.adl != null) {
                    this.adl.sendAgain(n, 0, aDwinCommand.getCommand());
                }
                if (!bl3) {
                    n = this.incGetCurrentIndex();
                    this.sendCommand(aDwinCommand, n);
                }
                bl3 = false;
                bl = false;
                bl2 = false;
                try {
                    this.ds.setSoTimeout(this.MaxPacketDelay);
                    while (ADwinDirectDevice.extractInt(byArray, 4) != n && !bl2) {
                        this.ds.receive(datagramPacket);
                        int n4 = ADwinDirectDevice.extractInt(byArray, 0);
                        int n5 = ADwinDirectDevice.extractInt(byArray, 4);
                        if (this.adl != null) {
                            if (n4 == -10) {
                                this.adl.tryLater(n, this.NumWaits - n3);
                            } else if (n5 != n) {
                                this.adl.recvAgain(n, n5, aDwinCommand.getCommand());
                            }
                        }
                        if (!(n4 != -10 || this.newTryLater() && n5 != n)) {
                            if (this.adl != null) {
                                this.adl.tryLater(n5, this.NumWaits - n3);
                            }
                            bl2 = true;
                            --n3;
                            try {
                                Thread.sleep(this.WaitTime);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        if (n5 != n) {
                            if (this.adl != null) {
                                this.adl.message("Erwarteter Paket-Index: " + n + ", erhaltener P.-I.: " + ADwinDirectDevice.extractInt(byArray, 4), 50);
                            }
                            bl3 = true;
                            continue;
                        }
                        if (n4 != 5) continue;
                        if (this.adl != null) {
                            this.adl.message("Fehler 5 aufgetreten, wird behandelt wie Socket-Timeout", 50);
                        }
                        bl = true;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (n2 > this.AllowedErrors) {
                        if (this.adl != null) {
                            this.adl.message("SocketTimeoutException", 1);
                            this.adl.leave();
                        }
                        throw socketTimeoutException;
                    }
                    if (this.adl != null) {
                        this.adl.message("Nichts empfangen....", 50);
                    }
                    bl = true;
                    ++n2;
                }
                catch (IOException iOException) {
                    if (this.adl != null) {
                        this.adl.message("I/O-Error: " + iOException.getMessage(), 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                }
            } while ((bl || bl2) && n3 > 0 && !bl3);
        }
        if (n3 <= 0) {
            throw new ADwinCommunicationError("Too many Try-Later Packets received", "Zu viele Try-Later-Pakete empfangen", this.Language, 16);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        if (nArray != null) {
            nArray[0] = n;
        }
        return datagramPacket;
    }

    private DatagramPacket getVersionInfo() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getVersionInfo ()");
        }
        int[] nArray = new int[]{0, 0, 0, 0};
        ADwinCommand aDwinCommand = new ADwinCommand(this.version, 3000447, this.Port);
        aDwinCommand.setCommand(255);
        aDwinCommand.setTimeout(this.ADwTimeout);
        aDwinCommand.setValues(nArray);
        aDwinCommand.setPwd(this.Password);
        DatagramPacket datagramPacket = null;
        try {
            datagramPacket = this.sendAndWaitForAnswer32Byte(aDwinCommand, null);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (this.adl != null) {
                this.adl.message("SocketTimeoutException->ADwinCommunicationError in getVersionInfo ()", 1);
                this.adl.leave();
            }
            throw new ADwinCommunicationError("No Answer on request for version info, " + socketTimeoutException.getMessage(), "Keine Antwort auf die Frage nach der Versions-Info, " + socketTimeoutException.getMessage(), this.Language, 2001);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return datagramPacket;
    }

    static void setInteger(byte[] byArray, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            byArray[i + n] = (byte)(n2 << (3 - i) * 8 >>> 24);
        }
    }

    static void setLong(byte[] byArray, int n, long l) {
        for (int i = 0; i < 8; ++i) {
            byArray[i + n] = (byte)(l << (7 - i) * 8 >>> 56);
        }
    }

    static int extractInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + (byArray[n + 1] << 8 & 0xFF00) + (byArray[n + 2] << 16 & 0xFF0000) + (byArray[n + 3] << 24 & 0xFF000000);
    }

    public static long extractLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    static int reverseByteOrder(int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            byte by = (byte)(n >>> 8 * (3 - i));
            n2 |= by << i * 8 & 255 << i * 8;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataToArrayConverter getDataFast(int n, int n2, int n3, int n4) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataFast (" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        int n5 = n2;
        int[] nArray = new int[]{n4, n + (n3 - n2 + 1 << 16), n2, n3 - n2 + 1};
        ADwinCommand aDwinCommand = new ADwinCommand(this.version, 3000447, this.Port);
        aDwinCommand.setValues(nArray);
        aDwinCommand.setCommand(207);
        aDwinCommand.setPwd(this.Password);
        int n6 = -10;
        DataFieldTransfer dataFieldTransfer = new DataFieldTransfer(this.Connection, this.ds, this);
        int[] nArray2 = new int[]{0};
        DataToArrayConverter dataToArrayConverter = null;
        dataToArrayConverter = n4 == 3 || n4 == 4 ? new DataToIntArray(n3 - n2 + 1, 0) : (n4 == 5 ? new DataToFloatArray(n3 - n2 + 1, 0) : new DataToIntArray((n3 - n2 + 1) / 2 + 1, 0));
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            for (int i = 0; i < this.NumWaits && n6 == -10; ++i) {
                int n7 = this.incGetCurrentIndex();
                this.sendCommand(aDwinCommand, n7);
                n6 = dataFieldTransfer.receiveFast(n3 - n2 + 1, dataToArrayConverter, n2 - n5, n7, nArray2);
                if (nArray2[0] >= n3 - n2 + 1) continue;
                if (n6 == -10) {
                    if (this.adl != null) {
                        this.adl.tryLater(0, n7);
                    }
                    try {
                        Thread.sleep(this.WaitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (n6 != 0) {
                    if (n6 == -5) {
                        throw new ADwinCommunicationError("Wrong Password", "Falsches Passwort", this.Language, 2002);
                    }
                    if (n6 == 1) {
                        throw new ADwinCommunicationError("timeout to link", "Timeout beim Schreiben zum Link", this.Language, 1);
                    }
                    if (n6 == 2) {
                        throw new ADwinCommunicationError("timeout from link", "Timeout beim Lesen vom Link", this.Language, 2);
                    }
                    throw new ADwinCommunicationError("Error on ADwin System: " + n6, "Fehler " + n6 + " auf dem ADwin-System", this.Language, n6 > 0 ? n6 : 2000);
                }
                nArray[2] = n2 += nArray2[0];
                nArray[3] = n3 - n2 + 1;
                nArray[1] = n + (n3 - n2 + 1 << 16);
                aDwinCommand.setValues(nArray);
                n6 = -10;
                if (nArray2[0] <= 0) continue;
                i = 0;
            }
        }
        if (n6 != 0) {
            if (this.adl != null) {
                this.adl.message("Error Code " + n6 + " -> ADwinCommunicationError in getDataFast...", 1);
            }
            if (this.adl != null) {
                this.adl.leave();
            }
            if (n6 == -5) {
                throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
            }
            if (n6 == -31) {
                throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
            }
            throw new ADwinCommunicationError("Unable to load DATA_" + n + " (fast method)", "Kann DATA_" + n + " nicht mit schneller Methode lesen", this.Language, n6 == -10 ? 16 : 2000);
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return dataToArrayConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataToArrayConverter getData(int n, int n2, int n3, int n4) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getData (" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        int n5 = this.readAEIVersionIfUnknown();
        if (n2 > n3) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "reading DATA_" + n + ": Only a positive number of elements can be retrieved!" : "Nur eine positive Anzahl von Elementen kann aus DATA_" + n + " gelesen werden");
        }
        if (n3 - n2 + 1 <= 350 * this.DataBlockSize && n5 >= 250) {
            DataToArrayConverter dataToArrayConverter = this.getDataFast(n, n2, n3, n4);
            if (this.adl != null) {
                this.adl.leave();
            }
            return dataToArrayConverter;
        }
        if (n5 >= 266) {
            DataToArrayConverter dataToArrayConverter = this.getDataSH(n, n2, n3, n4);
            if (this.adl != null) {
                this.adl.leave();
            }
            return dataToArrayConverter;
        }
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            int n6 = this.getDataType(n);
            if (n6 == 4) {
                n6 = 3;
            }
            if (n6 == 2) {
                n6 = 3;
            }
            if (n6 != 3 && n6 != 5) {
                if (this.adl != null) {
                    this.adl.message("error... Unknown Data-Type of Data " + n + ".", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unknown type of DATA_" + n + "!", "DATA_" + n + " hat keinen bekannten Datentyp", this.Language, 100);
            }
            DataToArrayConverter dataToArrayConverter = null;
            if (n4 == 3) {
                dataToArrayConverter = new DataToIntArray(n3 - n2 + 1, n6);
            } else if (n4 == 5) {
                dataToArrayConverter = new DataToFloatArray(n3 - n2 + 1, n6);
            } else if (n4 == 2) {
                dataToArrayConverter = new DataToIntArray((n3 - n2 + 1) / 2 + 1, n6);
            } else {
                throw new ADwinCommunicationError("Unknown type of DATA_" + n + "!", "DATA_" + n + " hat keinen bekannten Datentyp", this.Language, 100);
            }
            int[] nArray = new int[]{n4, n + (this.DataBlockSize << 16), n2, n3 - n2 + 1};
            int n7 = this.standardCall(7, nArray, 0, "", "DATA_" + n, "", "DATA_" + n, false, null);
            if (n7 != 0) {
                if (this.adl != null) {
                    this.adl.message("Fehler: " + n7 + "... ", 1);
                    this.adl.leave();
                }
                if (n7 == -5) {
                    throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
                }
                throw new ADwinCommunicationError("Unable to load DATA_" + n, "Kann DATA_" + n + " nicht laden", this.Language, n7 == -10 ? 16 : 2000);
            }
            DataFieldTransfer dataFieldTransfer = new DataFieldTransfer(this.Connection, this.ds, this);
            if (n4 == 2) {
                dataFieldTransfer.receive((n3 - n2 + 1) / 2, dataToArrayConverter, "DATA_" + n);
            } else {
                dataFieldTransfer.receive(n3 - n2 + 1, dataToArrayConverter, "DATA_" + n);
            }
            if (this.adl != null) {
                this.adl.leave();
            }
            return dataToArrayConverter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataToArrayConverter getDataSH(int n, int n2, int n3, int n4) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataSH (" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[1];
        nArray[0] = ADwinDirectDevice.reverseByteOrder(n << 16 | 0x1E);
        nArray[1] = ADwinDirectDevice.reverseByteOrder(n2);
        nArray[2] = ADwinDirectDevice.reverseByteOrder(n3 - n2 + 1);
        nArray[3] = 0;
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            DataToArrayConverter dataToArrayConverter;
            int n5;
            int n6 = this.standardCall(107, nArray, 0, "Unable to read DATA_" + n, "DATA_" + n, "Kann DATA_" + n + " nicht lesen", "DATA_" + n, true, nArray2);
            if (n6 == -31) {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unable to read Data_" + n, "Data_" + n + " kann nicht gelesen werden", this.Language, 100);
            }
            if (n6 != 0) {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unable to read Data_" + n, "Data_" + n + " kann nicht gelesen werden", this.Language, n6);
            }
            boolean bl = ADwinDirectDevice.reverseByteOrder(nArray[1]) == 2;
            int n7 = nArray[0];
            if (n7 != 5) {
                n7 = 3;
            }
            int n8 = n3 - n2 + 1;
            if (bl) {
                int n9 = n2 - 1 & 3;
                n5 = n2 - n9;
                if ((n8 = 4 * (n8 + n9 + 3 >>> 2)) % 4 != 0) {
                    n8 = n8 / 4 * 4 + 4;
                }
            } else {
                n5 = n2;
            }
            if (n4 == 3) {
                dataToArrayConverter = new DataToIntArray(n3 - n2 + 1, n7);
            } else if (n4 == 2) {
                dataToArrayConverter = new DataToIntArray((n3 - n2 + 1) / 2 + 1, n7);
            } else if (n4 == 5) {
                dataToArrayConverter = new DataToFloatArray(n3 - n2 + 1, n7);
            } else {
                throw new IllegalArgumentException("invalid data type given.");
            }
            dataToArrayConverter.setOffset(n2 - n5);
            DataFieldTransfer dataFieldTransfer = new DataFieldTransfer(this.Connection, this.ds, this);
            if (n4 == 2) {
                dataFieldTransfer.getArraySH(nArray2[0], n8 / 2, dataToArrayConverter, 6, 30, this.Connection, this.Port);
            } else {
                dataFieldTransfer.getArraySH(nArray2[0], n8, dataToArrayConverter, 6, 30, this.Connection, this.Port);
            }
            if (this.adl != null) {
                this.adl.leave();
            }
            return dataToArrayConverter;
        }
    }

    private int getSetDataStatus(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getSetDataStatus (" + n + ")");
        }
        int[] nArray = new int[4];
        nArray[0] = n;
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        int n2 = this.standardCall(108, nArray, 8, "Unable to read status of last Set_Data.", "Status of last Set_Data", "Kann Status vom letzten Set_Data nicht lesen", "Status vom letzten Set_Data", false, null);
        if (this.adl != null) {
            this.adl.leave();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setData(byte[] byArray, int n, int n2, int n3, int n4) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setData (byte Data[], " + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        int n5 = this.readAEIVersionIfUnknown();
        if (n2 > n3) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + n + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + n + " gesetzt werden!");
        }
        int[] nArray = new int[1];
        byte[] byArray2 = new byte[32];
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, 32);
        int n6 = 0;
        int n7 = 0;
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            do {
                int[] nArray2 = new int[]{n4, n | this.DataBlockSize << 16, n2, n3 - n2 + 1};
                DataFieldTransfer dataFieldTransfer = new DataFieldTransfer(this.Connection, this.ds, this);
                try {
                    this.standardCall(8, nArray2, 4, "Cannot start setting DATA_" + n, "setting DATA_" + n, "Kann nicht anfangen, DATA_" + n + " zu setzen", "Setzen von DATA_" + n, false, nArray);
                    dataFieldTransfer.send((n3 - n2 + 1) * 4, byArray, "DATA_" + n, nArray[0]);
                }
                catch (ADwinCommunicationError aDwinCommunicationError) {
                    if (n5 >= 253 && n5 < 260 || n5 >= 264) {
                        int n8 = this.getSetDataStatus(nArray[0]);
                        if (n8 == 1) {
                            if (this.adl != null) {
                                this.adl.message("Exception vom dtfa.sent -> getSetDataStatus war aber OK", 100);
                                this.adl.leave();
                            }
                            return;
                        }
                        if (this.adl != null) {
                            this.adl.message("Exception vom dtfa.send -> getSetDataStatus ergab " + n8, 1);
                            this.adl.leave();
                        }
                        throw aDwinCommunicationError;
                    }
                    if (this.adl != null) {
                        this.adl.message("Retry f\u00c3\u00bcr's komplette Data (Exception vom dtfa.send)", 1);
                    }
                    if (n7 >= this.AllowedErrors) {
                        throw aDwinCommunicationError;
                    }
                    ++n7;
                    ++n6;
                    continue;
                }
                try {
                    this.ds.receive(datagramPacket);
                    n6 = 0;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (n5 >= 253 && n5 < 260 || n5 >= 264) {
                        int n9 = this.getSetDataStatus(nArray[0]);
                        if (n9 == 1) {
                            if (this.adl != null) {
                                this.adl.message("Timeout, aber getSetDataStatus war OK", 100);
                                this.adl.leave();
                            }
                            return;
                        }
                        if (this.adl != null) {
                            this.adl.message("Timeout -> getSetDataStatus ergab " + n9, 1);
                            this.adl.leave();
                        }
                        System.out.println("getSetDataStatus = " + n9);
                        throw new ADwinCommunicationError("DATA_" + n + " could not be set, " + socketTimeoutException.getMessage(), "DATA_" + n + " konnte nicht beschrieben werden, " + socketTimeoutException.getMessage(), this.Language, 2000);
                    }
                    if (this.adl != null) {
                        this.adl.message("Timeout in setData...", 1);
                    }
                    if (++n6 <= this.AllowedErrors) continue;
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("DATA_" + n + " could not be set, " + socketTimeoutException.getMessage(), "DATA_" + n + " konnte nicht beschrieben werden, " + socketTimeoutException.getMessage(), this.Language, 100);
                }
                catch (IOException iOException) {
                    if (this.adl != null) {
                        this.adl.message("IOException -> ADwinCommunicationError in setData", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                }
            } while (n6 > 0);
        }
        if (ADwinDirectDevice.extractInt(byArray2, 0) != 0) {
            if (this.adl != null) {
                this.adl.message("Error Code " + ADwinDirectDevice.extractInt(byArray2, 0) + " -> ADwinCommunicationError in setData...", 1);
                this.adl.leave();
            }
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(byArray2, 0) + " occured when setting DATA_" + n, "Fehler " + ADwinDirectDevice.extractInt(byArray2, 0) + " aufgetreten beim Setzen von DATA_" + n, this.Language, ADwinDirectDevice.extractInt(byArray2, 0));
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFifo(int n, int n2, DataToArrayConverter dataToArrayConverter, int n3) throws ADwinCommunicationError {
        int n4;
        if (this.adl != null) {
            this.adl.enter("readFifo (" + n + ", " + n2 + ", <DataToArrayConverter>, " + n3 + ")");
        }
        DataFieldTransfer dataFieldTransfer = new DataFieldTransfer(this.Connection, this.ds, this);
        for (int i = 0; i < n2; i += n4) {
            n4 = n2 - i > (this.DataBlockSize + 1) * 350 ? (this.DataBlockSize + 1) * 350 : (n2 - i) % ((this.DataBlockSize + 1) * 350);
            if (n4 == 0) {
                n4 = (this.DataBlockSize + 1) * 350;
            }
            DatagramSocket datagramSocket = this.ds;
            synchronized (datagramSocket) {
                dataFieldTransfer.readFifo(n, n3, n4, dataToArrayConverter, i);
                continue;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFifo(int n, int n2, int n3, byte[] byArray, int n4) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("writeFifo (" + n + ", " + n2 + ", " + n3 + ", <byte[]>, " + n4 + ")");
        }
        int[] nArray = new int[]{n2, n + (this.DataBlockSize + 2 << 16), 0, n3};
        ADwinCommand aDwinCommand = new ADwinCommand(this.version, 3000447, this.Port);
        aDwinCommand.setTimeout(this.ADwTimeout);
        aDwinCommand.setPwd(this.Password);
        boolean bl = false;
        boolean bl2 = true;
        byte[] byArray2 = new byte[32];
        int n5 = this.NumWaits;
        int n6 = 0;
        int n7 = 0;
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, 32);
        int n8 = this.AllowedErrors;
        int n9 = (n3 - 1) / 350 + 1;
        int n10 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        DatagramSocket datagramSocket = this.ds;
        synchronized (datagramSocket) {
            while (!bl && n8 >= 0) {
                if (n10 > this.AllowedErrors) {
                    if (this.adl != null) {
                        this.adl.message("Too many errors in writeFifo...", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("Number of errors occured exceeded AllowedErrors in writeFifo when writing to fifo " + n + ".", "Anzahl der aufgetretenen Fehler \u00c3\u00bcbersteigt AllowedErrors beim Schreiben in Fifo " + n + ".", this.Language, 2001);
                }
                if (n5 <= 0) break;
                if (!bl4) {
                    if (!bl3) {
                        aDwinCommand.setCommand(25);
                        nArray[2] = 0;
                        n7 = n6 = this.incGetCurrentIndex();
                        aDwinCommand.setPacketIndex(n6);
                    } else {
                        if (this.adl != null) {
                            this.adl.sendAgain(n6, 0, 125);
                        }
                        aDwinCommand.setCommand(125);
                        nArray[2] = n6;
                        n7 = this.incGetCurrentIndex();
                        aDwinCommand.setPacketIndex(n7);
                        bl3 = false;
                    }
                    aDwinCommand.setValues(nArray);
                    aDwinCommand.setLink(this.Hostlink);
                    try {
                        this.ds.send(aDwinCommand.getDatagram(this.Connection));
                    }
                    catch (IOException iOException) {
                        if (this.adl != null) {
                            this.adl.message("IOException -> ADwinCommunicationError when sending in writeFifo", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                    }
                }
                bl4 = false;
                bl2 = true;
                try {
                    this.ds.setSoTimeout(this.MaxPacketDelay);
                    this.ds.receive(datagramPacket);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (this.adl != null) {
                        this.adl.message("Timeout...", 100);
                    }
                    bl2 = false;
                }
                catch (IOException iOException) {
                    if (this.adl != null) {
                        this.adl.message("IOException -> ADwinCommunicationError when receiving in writeFifo", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                }
                if (bl2 && (!this.newTryLater() && ADwinDirectDevice.extractInt(byArray2, 0) != -10 && ADwinDirectDevice.extractInt(byArray2, 4) != n7 || this.newTryLater() && ADwinDirectDevice.extractInt(byArray2, 4) != n7)) {
                    if (this.adl != null) {
                        this.adl.message("Vor'm Schreiben der Datenpakete: Erwarteter Paket-Index: " + n7 + ", erhaltener: " + ADwinDirectDevice.extractInt(byArray2, 4) + ".", 1);
                    }
                    bl4 = true;
                    continue;
                }
                bl4 = false;
                if (bl2) {
                    if (ADwinDirectDevice.extractInt(byArray2, 0) == -10) {
                        if (this.adl != null) {
                            this.adl.tryLater(n6, this.NumWaits - n5);
                        }
                        try {
                            Thread.sleep(this.WaitTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        --n5;
                        continue;
                    }
                    if (ADwinDirectDevice.extractInt(byArray2, 0) == -41) {
                        ++n10;
                        if (this.adl == null) continue;
                        this.adl.message("Fehler -41 beim Warten auf Best\u00c3\u00a4tigung in writeFifo - wird nochmal ohne Retry versucht", 50);
                        continue;
                    }
                    if (ADwinDirectDevice.extractInt(byArray2, 0) == -40) {
                        if (this.adl != null) {
                            this.adl.message("Fehler -40: -> Mache weiter...", 50);
                            this.adl.leave();
                        }
                        return;
                    }
                    if (ADwinDirectDevice.extractInt(byArray2, 0) < 0 || ADwinDirectDevice.extractInt(byArray2, 0) == 5) {
                        ++n10;
                        bl3 = true;
                        if (this.adl == null) continue;
                        this.adl.message("Fehler " + ADwinDirectDevice.extractInt(byArray2, 0) + " beim Warten auf Best\u00c3\u00a4tigung zum Anfangen in writeFifo...", 50);
                        continue;
                    }
                    if (ADwinDirectDevice.extractInt(byArray2, 0) != 0) {
                        if (this.adl != null) {
                            this.adl.message("Error code " + ADwinDirectDevice.extractInt(byArray2, 0) + " -> ADwinCommunicationError", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("error " + ADwinDirectDevice.extractInt(byArray2, 0) + " on ADwin System when writing to fifo " + n, "Fehler " + ADwinDirectDevice.extractInt(byArray2, 0) + " auf dem ADwin-System beim Schreiben von Fifo " + n + ".", this.Language, ADwinDirectDevice.extractInt(byArray2, 0));
                    }
                    n10 = 0;
                    byte[] byArray3 = new byte[1408];
                    DatagramPacket datagramPacket2 = new DatagramPacket(byArray3, 1408, this.Connection, this.Port);
                    for (int i = 0; i < n9; ++i) {
                        ADwinDirectDevice.setInteger(byArray3, 0, n7);
                        ADwinDirectDevice.setInteger(byArray3, 4, i);
                        int n11 = i != n9 - 1 ? 350 : n3 % 350;
                        if (n11 == 0) {
                            n11 = 350;
                        }
                        for (int j = 0; j < n11 * 4; ++j) {
                            byArray3[j + 8] = byArray[j + i * 350 * 4 + n4];
                        }
                        try {
                            this.ds.send(datagramPacket2);
                            continue;
                        }
                        catch (IOException iOException) {
                            if (this.adl != null) {
                                this.adl.message("IOException -> ADwinCommunicationError when sending Data in writeFifo", 1);
                                this.adl.leave();
                            }
                            throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                        }
                    }
                    bl2 = true;
                    try {
                        this.ds.setSoTimeout(this.MaxPacketDelay * 2 + this.ADwTimeout);
                        this.ds.receive(datagramPacket);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        if (this.adl != null) {
                            this.adl.message("Timeout when waiting for confirmation....", 100);
                        }
                        bl2 = false;
                    }
                    catch (IOException iOException) {
                        if (this.adl != null) {
                            this.adl.message("IOException -> ADwinCommunicationError when receiving confirmation in writeFifo", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                    }
                    if (bl2 && ADwinDirectDevice.extractInt(byArray2, 0) == -32) {
                        if (this.adl != null) {
                            this.adl.message("Fifo zu klein", 1);
                        }
                        throw new ADwinCommunicationError("There is not enough space left in fifo " + n, "Nicht genug Platz \u00c3\u00bcbrig in Fifo " + n, this.Language, 101);
                    }
                    if (bl2 && (ADwinDirectDevice.extractInt(byArray2, 0) < 0 || ADwinDirectDevice.extractInt(byArray2, 0) == 5)) {
                        if (this.adl != null) {
                            this.adl.message("Error " + ADwinDirectDevice.extractInt(byArray2, 0) + " in confirmation", 50);
                        }
                        --n8;
                        bl3 = true;
                        continue;
                    }
                    if (bl2 && ADwinDirectDevice.extractInt(byArray2, 0) > 0) {
                        if (this.adl != null) {
                            this.adl.message("Error " + ADwinDirectDevice.extractInt(byArray2, 0) + " -> ADwinCommunicationError in confirmation...", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("error on ADwin System when writing Bytes to Fifo " + n + ", - error " + ADwinDirectDevice.extractInt(byArray2, 0), "Fehler " + ADwinDirectDevice.extractInt(byArray2, 0) + " auf dem ADwin-System beim Schreiben von Fifo " + n + ".", this.Language, ADwinDirectDevice.extractInt(byArray2, 0));
                    }
                    if (bl2) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    bl3 = true;
                    continue;
                }
                if (bl2) continue;
                if (this.adl != null) {
                    this.adl.message("one attempt less left......", 50);
                }
                --n8;
                bl3 = true;
                bl4 = false;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        if (!bl) {
            throw new ADwinCommunicationError("Could not send everything...", "Es konnte nicht alles gesendet werden...", this.Language, 2000);
        }
    }

    private int getArmVersion() throws ADwinCommunicationError {
        int n;
        int[] nArray = new int[]{1000, 0, 0, 0};
        if (this.version > 0 && this.version != 299) {
            return this.version;
        }
        if (this.version == 299) {
            this.standardCall(1000, nArray, 0, "Unable to determine the version of the ethernet interface", "version of the ethernet interface", "Version des Ethernet-Interfaces konnte nicht bestimmt werden", "Version des Ethernet-Interfaces", true, null);
            this.version = nArray[0];
            n = nArray[2];
        } else {
            this.version = -1;
            this.standardCall(1000, nArray, 0, "Unable to determine the version of the ethernet interface", "version of the ethernet interface", "Version des Ethernet-Interfaces konnte nicht bestimmt werden", "Version des Ethernet-Interfaces", true, null);
            this.version = nArray[0];
            n = nArray[2];
            if (this.version == 299) {
                this.getArmVersion();
            }
        }
        if (this.version >= 304) {
            this.supports_tcp = (n & 1) == 1;
            this.supports_udp = (n >> 1 & 1) == 1;
        } else {
            this.supports_udp = true;
            this.supports_tcp = false;
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getParBlock(int n, int n2, DataToArrayConverter dataToArrayConverter) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParBlock (" + n + ", " + n2 + ", <DTAC>)");
        }
        byte[] byArray = new byte[1008];
        int[] nArray = new int[]{n, n2, 0, 0};
        ADwinCommand aDwinCommand = new ADwinCommand(this.version, 3000447, this.Port);
        aDwinCommand.setCommand(13);
        aDwinCommand.setTimeout(this.ADwTimeout);
        aDwinCommand.setValues(nArray);
        aDwinCommand.setPwd(this.Password);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 1008);
        int n3 = this.NumWaits;
        int n4 = 0;
        boolean bl = false;
        while (!bl) {
            boolean bl2;
            int n5;
            if (n3 <= 0) {
                if (this.adl != null) {
                    this.adl.message("Too many try-laters...", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Number of Try-Later-Packets received exceeded NumWaits", "Zu viele Try-Later-Pakete", this.Language, 16);
            }
            if (n4 > this.AllowedErrors) {
                if (this.adl != null) {
                    this.adl.message("Too many errors...", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Too many packet errors occured", "Zu viele Paket-Fehler", this.Language, 2000);
            }
            DatagramSocket datagramSocket = this.ds;
            synchronized (datagramSocket) {
                try {
                    aDwinCommand.setLink(this.Hostlink);
                    n5 = this.incGetCurrentIndex();
                    aDwinCommand.setPacketIndex(n5);
                    this.ds.send(aDwinCommand.getDatagram(this.Connection));
                }
                catch (IOException iOException) {
                    if (this.adl != null) {
                        this.adl.message("IOException -> ADwinCommunicationError when sending in getParBlock", 1);
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                }
                bl2 = true;
                do {
                    try {
                        this.ds.setSoTimeout(this.MaxPacketDelay);
                        this.ds.receive(datagramPacket);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        if (this.adl != null) {
                            this.adl.message("Timeout when receiving...", 50);
                        }
                        ++n4;
                        bl2 = false;
                    }
                    catch (IOException iOException) {
                        if (this.adl != null) {
                            this.adl.message("IOException -> ADwinCommunicationError when receiving in getParBlock", 1);
                            this.adl.leave();
                        }
                        throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                    }
                    if (!bl2 || ADwinDirectDevice.extractInt(byArray, 4) == n5) continue;
                    if (this.adl != null) {
                        this.adl.message("Invalid packet index received!", 50);
                    }
                    if (ADwinDirectDevice.extractInt(byArray, 0) != -10 || this.newTryLater()) continue;
                    ADwinDirectDevice.setInteger(byArray, 4, n5);
                } while (bl2 && ADwinDirectDevice.extractInt(byArray, 4) != n5);
            }
            if (bl2) {
                if (ADwinDirectDevice.extractInt(byArray, 0) == 0) {
                    dataToArrayConverter.storeBytes(byArray, 8, 0, n2);
                    bl = true;
                    continue;
                }
                if (ADwinDirectDevice.extractInt(byArray, 0) == -10) {
                    if (this.adl != null) {
                        this.adl.tryLater(n5, this.NumWaits - n3);
                    }
                    try {
                        Thread.sleep(this.WaitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --n3;
                    continue;
                }
                if (this.adl != null) {
                    this.adl.message("Error (" + ADwinDirectDevice.extractInt(byArray, 0) + ") ...", 50);
                }
                ++n4;
                continue;
            }
            if (this.adl != null) {
                this.adl.message("Nothing received.... ", 50);
            }
            ++n4;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    private int standardCall(int n, int[] nArray, int n2, String string, String string2, String string3, String string4, boolean bl, int[] nArray2) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("standardCall (" + n + ", {" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ", " + nArray[3] + "}, " + n2 + ", \"" + string + "\", \"" + string2 + "\", \"" + string3 + "\", \"" + string4 + "\", " + bl + ")");
        }
        ADwinCommand aDwinCommand = new ADwinCommand(this.version, 3000447, this.Port);
        aDwinCommand.setCommand(n);
        aDwinCommand.setTimeout(this.ADwTimeout);
        aDwinCommand.setValues(nArray);
        aDwinCommand.setPwd(this.Password);
        DatagramPacket datagramPacket = null;
        try {
            datagramPacket = this.sendAndWaitForAnswer32Byte(aDwinCommand, nArray2);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (this.adl != null) {
                this.adl.message("ADwinCommunicationError: No answer... ", 1);
                this.adl.leave();
            }
            throw new ADwinCommunicationError("No answer on request for " + string2 + ", " + socketTimeoutException.getMessage(), "Keine Antwort auf die Anfrage nach " + string4 + ", " + socketTimeoutException.getMessage(), this.Language, 2001);
        }
        byte[] byArray = datagramPacket.getData();
        int n3 = ADwinDirectDevice.extractInt(byArray, 0);
        if (n3 != 0 && n2 != 0) {
            if (this.adl != null) {
                this.adl.message("ADwinCommunicationError: Error " + n3 + " on ADwin System", 1);
                this.adl.leave();
            }
            if (n3 == 1) {
                throw new ADwinCommunicationError("timeout to link", "Timeout beim Schreiben zum Link", this.Language, 1);
            }
            if (n3 == 2) {
                throw new ADwinCommunicationError("timeout from link", "Timeout beim Lesen vom Link", this.Language, 2);
            }
            if (n3 == -5) {
                throw new ADwinCommunicationError("Wrong Password", "Falsches Passwort", this.Language, 2002);
            }
            if (n3 == -30) {
                throw new ADwinCommunicationError("Wrong Version", "Falsche Version", this.Language, 20);
            }
            if (n3 == -31) {
                throw new ADwinCommunicationError("The Data is too small", "Das Data-Feld ist zu klein", this.Language, 100);
            }
            if (n3 == -32) {
                throw new ADwinCommunicationError("The Fifo has not enough values", "Das Fifo-Feld hat nicht genug Daten", this.Language, 102);
            }
            throw new ADwinCommunicationError("Error on ADwin System: " + n3 + " - " + string, "Fehler " + n3 + " auf dem ADwin-System - " + string3, this.Language, n3 > 0 ? n3 : 2000);
        }
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                nArray[i] = ADwinDirectDevice.extractInt(byArray, 8 + i * 4);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return ADwinDirectDevice.extractInt(byArray, n2);
    }

    public int getPar(int n) throws ADwinCommunicationError {
        int n2 = 0;
        if (this.adl != null) {
            this.adl.enter("getPar (" + n + ")");
        }
        if (n > 200) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of requested parameter out of range (1 <= index <= 80)." : "Index des verlangten Parameters au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs (1 <= Index <= 80).");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 1;
                nArray[1] = 1000 + n;
                nArray[3] = 0;
                nArray[2] = 0;
                n2 = this.standardCall(0, nArray, 8, "Unable to load PAR_" + n + ".", "PAR_" + n, "Kann PAR_" + n + " nicht laden", "PAR_" + n, false, null);
                break;
            }
            case 0: {
                n2 = this.adwin_tcp_get_par(n);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return n2;
    }

    public float getFPar(int n) throws ADwinCommunicationError {
        int n2 = 0;
        if (this.adl != null) {
            this.adl.enter("getFPar (" + n + ")");
        }
        if (n < 1 || n > 80) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of requested float parameter out of range (1 <= index <= 80)." : "Index des verlangten float-Parameters au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs (1 <= Index <= 80).");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 1;
                nArray[1] = 1100 + n;
                nArray[3] = 0;
                nArray[2] = 0;
                n2 = this.standardCall(0, nArray, 8, "Unable to load FPAR_" + n + ".", "FPAR_" + n, "Kann FPAR_" + n + " nicht laden", "FPAR_" + n, false, null);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return Float.intBitsToFloat(n2);
            }
            case 0: {
                float f = this.adwin_tcp_get_fpar(n);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return f;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public double getFParDouble(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFParDouble (" + n + ")");
        }
        if (n < 1 || n > 80) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of requested double parameter out of range (1 <= index <= 80)." : "Index des verlangten double-Parameters au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs (1 <= Index <= 80).");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 1;
                nArray[1] = 1100 + n;
                nArray[3] = 0;
                nArray[2] = 0;
                int n2 = this.standardCall(0, nArray, 8, "Unable to load FPAR_" + n + ".", "FPAR_" + n, "Kann FPAR_" + n + " nicht laden", "FPAR_" + n, false, null);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return Float.intBitsToFloat(n2);
            }
            case 0: {
                double d = this.adwin_tcp_get_fpar_double(n);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return d;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public void setPar(int n, int n2) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setPar (" + n + ", " + n2 + ")");
        }
        if (n > 9002) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of parameter out of range (1 <= index <= 80)." : "Index au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs (1 <= Index <= 80)");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 6;
                nArray[1] = 1000 + n;
                nArray[2] = n2;
                this.standardCall(0, nArray, 4, "Unable to set PAR_" + n + ".", "PAR_" + n, "Kann PAR_" + n + " nicht setzen", "PAR_" + n, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_set_par(n, n2);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void setFPar(int n, float f) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setPar (" + n + ", " + f + ")");
        }
        if (n < 1 || n > 80) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of parameter out of range" : "Index des Parameters au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 6;
                nArray[1] = 1100 + n;
                nArray[2] = Float.floatToIntBits(f);
                this.standardCall(0, nArray, 4, "Unable to set FPAR_" + n + ".", "FPAR_" + n, "Kann FPAR_" + n + " nicht setzen", "FPAR_" + n, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_set_fpar(n, f);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void setFParDouble(int n, double d) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setPar (" + n + ", " + d + ")");
        }
        if (n < 1 || n > 80) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Index of parameter out of range" : "Index des Parameters au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 6;
                nArray[1] = 1100 + n;
                nArray[2] = Float.floatToIntBits((float)d);
                this.standardCall(0, nArray, 4, "Unable to set FPAR_" + n + ".", "FPAR_" + n, "Kann FPAR_" + n + " nicht setzen", "FPAR_" + n, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_set_fpar_double(n, d);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public int getProcessorType() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getProcessorType ()");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            int n = this.ati.processortype;
            if (this.adl != null) {
                this.adl.leave();
            }
            return n;
        }
        byte[] byArray = this.getVersionInfo().getData();
        if (ADwinDirectDevice.extractInt(byArray, 0) == -5) {
            throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
        }
        if (ADwinDirectDevice.extractInt(byArray, 0) > 0) {
            throw new ADwinCommunicationError("Timeout on the ADwin-System", "Timeout auf dem ADwin-System", this.Language, ADwinDirectDevice.extractInt(byArray, 0));
        }
        if (ADwinDirectDevice.extractInt(byArray, 0) != 0) {
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(byArray, 0), "Fehler " + ADwinDirectDevice.extractInt(byArray, 0), this.Language, 2000);
        }
        int n = ADwinDirectDevice.extractInt(byArray, 12);
        switch (n) {
            case 146: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 5;
            }
            case 1000: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 9;
            }
            case 1010: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 10;
            }
            case 1011: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 11;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return n;
    }

    public int getCardType() throws ADwinCommunicationError {
        if (this.adwin_tcp_or_udp() == 0) {
            return -1;
        }
        if (this.adl != null) {
            this.adl.enter("getCardType ()");
        }
        byte[] byArray = this.getVersionInfo().getData();
        if (this.adl != null) {
            this.adl.leave();
        }
        if (ADwinDirectDevice.extractInt(byArray, 0) == -5) {
            throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
        }
        if (ADwinDirectDevice.extractInt(byArray, 0) > 0) {
            throw new ADwinCommunicationError("Timeout on the ADwin-System", "Timeout auf dem ADwin-System", this.Language, ADwinDirectDevice.extractInt(byArray, 0));
        }
        if (ADwinDirectDevice.extractInt(byArray, 0) != 0) {
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(byArray, 0), "Fehler " + ADwinDirectDevice.extractInt(byArray, 0), this.Language, 2000);
        }
        return ADwinDirectDevice.extractInt(byArray, 16);
    }

    public int getDriverVersion() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDriverVersion ()");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 0: {
                int[] nArray = new int[4];
                int n = this.adwin_tcp_testversion(nArray);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return n;
            }
            case 1: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                return 3;
            }
        }
        byte[] byArray = this.getVersionInfo().getData();
        if (this.adl != null) {
            this.adl.leave();
        }
        if (ADwinDirectDevice.extractInt(byArray, 0) == -5) {
            throw new ADwinCommunicationError("Wrong password", "Falsches Passwort", this.Language, 2002);
        }
        if (ADwinDirectDevice.extractInt(byArray, 0) > 0) {
            throw new ADwinCommunicationError("Timeout on the ADwin-System", "Timeout auf dem ADwin-System", this.Language, ADwinDirectDevice.extractInt(byArray, 0));
        }
        if (ADwinDirectDevice.extractInt(byArray, 0) != 0) {
            throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(byArray, 0), "Fehler " + ADwinDirectDevice.extractInt(byArray, 0), this.Language, 2000);
        }
        return ADwinDirectDevice.extractInt(byArray, 20);
    }

    int adwin_tcp_testversion(int[] nArray) throws ADwinCommunicationError {
        this.init_ati(255);
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t2.max = 16;
        adwin_tcp_buffer_t2.used = 0;
        adwin_tcp_buffer_t2.do_convert = 1;
        adwin_tcp_buffer_t2.data = new byte[16];
        if (this.tcp_write_request(this.ati, null) == -1) {
            return 3;
        }
        if (this.tcp_read_response(this.ati, 16, adwin_tcp_buffer_t2) == -1) {
            return 3;
        }
        for (int i = 0; i < 4; ++i) {
            nArray[i] = ADwinDirectDevice.extractInt(adwin_tcp_buffer_t2.data, i * 4);
        }
        if (nArray[0] == 118) {
            return 0;
        }
        return 3;
    }

    public int[] getDataInt(int n, int n2, int n3) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataInt (" + n + ", " + n2 + ", " + n3 + ")");
        }
        int n4 = n3 - n2 + 1;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                DataToIntArray dataToIntArray = (DataToIntArray)this.getData(n, n2, n3, 3);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dataToIntArray.getArray();
            }
            case 0: {
                int[] nArray = new int[n4];
                this.adwin_tcp_get_data_or_fifo_int32(n, nArray, n2, n4, 0);
                return nArray;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public float[] getDataFloat(int n, int n2, int n3) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataFloat (" + n + ", " + n2 + ", " + n3 + ")");
        }
        int n4 = n3 - n2 + 1;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                DataToFloatArray dataToFloatArray = (DataToFloatArray)this.getData(n, n2, n3, 5);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dataToFloatArray.getArray();
            }
            case 0: {
                float[] fArray = new float[n4];
                this.adwin_tcp_get_data_or_fifo_float(n, fArray, n2, n4, 0);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return fArray;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public double[] getDataDouble(int n, int n2, int n3) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataDouble (" + n + ", " + n2 + ", " + n3 + ")");
        }
        int n4 = n3 - n2 + 1;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                DataToFloatArray dataToFloatArray = (DataToFloatArray)this.getData(n, n2, n3, 5);
                if (this.adl != null) {
                    this.adl.leave();
                }
                double[] dArray = new double[n4];
                float[] fArray = dataToFloatArray.getArray();
                this.convert_data_from_float_to_double(fArray, dArray, n4);
                return dArray;
            }
            case 0: {
                double[] dArray = new double[n4];
                this.adwin_tcp_get_data_or_fifo_double(n, dArray, n2, n4, 0);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dArray;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public int getDataType(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getDataType (" + n + ")");
        }
        int n2 = 0;
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[]{7, n, 1, 0};
                n2 = this.standardCall(100, nArray, 8, "Unable to determine type of DATA_" + n + ".", "type of DATA_" + n, "Kann Typ von DATA_" + n + " nicht bestimmen", "Typ von DATA_" + n, false, null);
                if (n2 == 4) {
                    n2 = 3;
                }
                if (n2 == 3 || n2 == 5 || n2 == 2) break;
                if (this.adl != null) {
                    this.adl.message("Datatype = " + n2 + " -> ADwinCommunicationError", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unable to determine type of DATA_" + n + ".", "Kann Typ von DATA_" + n + " nicht bestimen.", this.Language, 100);
            }
            case 0: {
                n2 = this.adwin_tcp_get_data_type(n);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return n2;
    }

    public int getDataLength(int n) throws ADwinCommunicationError {
        int n2 = 0;
        if (this.adl != null) {
            this.adl.enter("getDatalength (" + n + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 11;
                nArray[1] = n;
                n2 = this.standardCall(0, nArray, 8, "Unable to determine length of DATA_" + n + ".", "length of DATA_" + n, "Kann  L\u00c3\u00a4nge von DATA_" + n + " nicht bestimmen", "L\u00c3\u00a4nge von DATA_" + n, false, null);
                if (n2 != 0) break;
                if (this.adl != null) {
                    this.adl.message("Datalength == 0 -> ADwinCommunicationError", 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Unable to determine length of DATA_" + n + ".", "Kann L\u00c3\u00a4nge von DATA_" + n + " nicht bestimmen.", this.Language, 100);
            }
            case 0: {
                n2 = this.adwin_tcp_get_data_length(n);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return n2;
    }

    public void startProcess(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("startProcess (" + n + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[1] = n;
                nArray[2] = 0;
                this.standardCall(0, nArray, 4, "Cannot start process " + n, "starting process " + n, "Kann Prozess " + n + " nicht starten", "Starten von Prozess " + n, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_start_process(n);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void loadProcessFile(String string) throws FileNotFoundException, IOException, ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("loadProcess (" + string + ")");
        }
        if (string == null || string.length() < 4 || string.charAt(string.length() - 3) != 't' && string.charAt(string.length() - 3) != 'T') {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("Filename " + string + " not in ADBasic executable file format (<fffff>.T<x><n> - <fff> = program name, <x> = processor, <n> = process no.)", "Dateiname " + string + " nicht im Format f\u00c3\u00bcr ADBasic Bin\u00c3\u00a4rdateien (<fffff>.T<x><n> - <fffff> = Programmname, <x> = Prozessor, <n> = Prozessnummer", this.Language, 202);
        }
        char c = string.charAt(string.length() - 2);
        if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'E' || c >= 'a' && c <= 'e')) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("Filename " + string + " not in ADBasic executable file format (<fffff>.T<x><n> - <fff> = program name, <x> = processor, <n> = process no.)", "Dateiname " + string + " nicht im Format f\u00c3\u00bcr ADBasic Bin\u00c3\u00a4rdateien (<fffff>.T<x><n> - <fffff> = Programmname, <x> = Prozessor, <n> = Prozessnummer", this.Language, 202);
        }
        if (this.ati.processortype == -1) {
            this.ati.processortype = this.getProcessorType();
        }
        switch (this.ati.processortype) {
            case 8: {
                if (c == '8') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00c3\u00a4rdatei ist f\u00c3\u00bcr den falschen Prozessor!", this.Language, 205);
            }
            case 9: {
                if (c == '9') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00c3\u00a4rdatei ist f\u00c3\u00bcr den falschen Prozessor!", this.Language, 205);
            }
            case 1010: {
                if (c == 'a' || c == 'A') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00c3\u00a4rdatei ist f\u00c3\u00bcr den falschen Prozessor!", this.Language, 205);
            }
            case 1011: {
                if (c == 'b' || c == 'B') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00c3\u00a4rdatei ist f\u00c3\u00bcr den falschen Prozessor!", this.Language, 205);
            }
            case 1012: {
                if (c == 'c' || c == 'C') break;
                throw new ADwinCommunicationError("ADbasic-file is for another processor-type!", "ADbasic-Bin\u00c3\u00a4rdatei ist f\u00c3\u00bcr den falschen Prozessor!", this.Language, 205);
            }
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                FileInputStream fileInputStream = new FileInputStream(string);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                if (byArray.length == 0) {
                    return;
                }
                this.loadProcessArray(byArray, string);
                break;
            }
            case 0: {
                this.adwin_tcp_load_process(string);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProcessArray(byte[] byArray, String string) throws ADwinCommunicationError, IOException {
        if (this.adl != null) {
            this.adl.enter("loadProcessArray (byte[], \"" + string + "\")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                byte[] byArray2 = new byte[32];
                DatagramPacket datagramPacket = new DatagramPacket(byArray2, 32);
                int[] nArray = new int[1];
                int[] nArray2 = new int[]{0, this.DataBlockSize << 16, 9, byArray.length};
                DatagramSocket datagramSocket = this.ds;
                synchronized (datagramSocket) {
                    this.standardCall(4, nArray2, 4, "Cannot start loading process " + string, "loading process " + string, "Kann nicht damit beginnen, Prozess " + string + " zu laden", "Laden von Prozess " + string, false, nArray);
                    DataFieldTransfer dataFieldTransfer = new DataFieldTransfer(this.Connection, this.ds, this);
                    dataFieldTransfer.send(byArray.length, byArray, "Process " + string, nArray[0]);
                    int n = 0;
                    do {
                        try {
                            this.ds.receive(datagramPacket);
                            n = 0;
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            if (this.adl != null) {
                                this.adl.message("Timeout when receiving confirmation...", 50);
                            }
                            if (++n <= this.AllowedErrors) continue;
                            if (this.adl != null) {
                                this.adl.message("Too many timeouts -> ADwinCommunicationError...", 1);
                                this.adl.leave();
                            }
                            throw new ADwinCommunicationError("Process could not be loaded, " + socketTimeoutException.getMessage(), "Prozess konnte nicht geladen werden, " + socketTimeoutException.getMessage(), this.Language, 2001);
                        }
                    } while (n > 0);
                }
                if (ADwinDirectDevice.extractInt(byArray2, 0) == 0) break;
                if (this.adl != null) {
                    this.adl.message("Errorcode " + ADwinDirectDevice.extractInt(byArray2, 0) + " -> ADwinCommunicationError", 1);
                    this.adl.leave();
                }
                if (ADwinDirectDevice.extractInt(byArray2, 0) == -35) {
                    throw new ADwinCommunicationError("The binary file has been built for different processor", "Die Binaerdatei wurde fuer einen anderen Prozessor erzeugt", this.Language, 205);
                }
                if (ADwinDirectDevice.extractInt(byArray2, 0) == -100) {
                    throw new ADwinCommunicationError("Not enough memory or memory damaged", "Nicht genug Speicher frei oder Speicher besch\u00c3\u00a4digt", this.Language, 150);
                }
                throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(byArray2, 0) + " occured after loading " + string + ".", "Fehler " + ADwinDirectDevice.extractInt(byArray2, 0) + " nach dem Laden von " + string + " aufgetreten", this.Language, ADwinDirectDevice.extractInt(byArray2, 0));
            }
            case 0: {
                this.adwin_tcp_load_process(byArray);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void setDataInt(int n, int[] nArray, int n2, int n3) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setDataInt (" + n + ", <int[]>, " + n2 + ", " + n3 + ")");
        }
        if (n3 <= 0 || n3 > nArray.length) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "The passed array is too small for the given range" : "Das \u00c3\u00bcbergebene Array ist zu klein f\u00c3\u00bcr den angegebenen Bereich");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int n4 = this.getDataType(n);
                if (n4 == 4) {
                    n4 = 3;
                }
                if (n4 != 3 && n4 != 5) {
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("Data ist too small", "Data zu klein", this.Language, 100);
                }
                byte[] byArray = new byte[n3 * 4];
                if (n4 == 3) {
                    for (int i = 0; i < n3; ++i) {
                        ADwinDirectDevice.setInteger(byArray, i * 4, nArray[i]);
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        ADwinDirectDevice.setInteger(byArray, i * 4, Float.floatToIntBits(nArray[i]));
                    }
                }
                this.setData(byArray, n, n2, n2 + n3 - 1, 2);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_or_fifo_int32(n, nArray, n2, n3, 0);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void setDataFloat(int n, float[] fArray, int n2, int n3) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setDataFloat (" + n + ", <float []>, " + n2 + ", " + n3 + ")");
        }
        if (n3 <= 0 || n3 > fArray.length) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "The array passed is too small for the given range" : "Das \u00c3\u00bcbergebene Array ist zu klein f\u00c3\u00bcr den angegebenen Bereich");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int n4 = this.getDataType(n);
                if (n4 == 4) {
                    n4 = 3;
                }
                if (n4 != 3 && n4 != 5) {
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new ADwinCommunicationError("Data ist too small", "Data zu klein", this.Language, 100);
                }
                byte[] byArray = new byte[n3 * 4];
                if (n4 == 5) {
                    for (int i = 0; i < n3; ++i) {
                        ADwinDirectDevice.setInteger(byArray, i * 4, Float.floatToIntBits(fArray[i]));
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        ADwinDirectDevice.setInteger(byArray, i * 4, (int)fArray[i]);
                    }
                }
                this.setData(byArray, n, n2, n2 + n3 - 1, 5);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_or_fifo_float(n, fArray, n2, n3, 0);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void setDataDouble(int n, double[] dArray, int n2, int n3) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setDataDouble (" + n + ", <double []>, " + n2 + ", " + n3 + ")");
        }
        if (n3 <= 0 || n3 > dArray.length) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "The array passed is too small for the given range" : "Das \u00c3\u00bcbergebene Array ist zu klein f\u00c3\u00bcr den angegebenen Bereich");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                float[] fArray = new float[n3];
                this.convert_data_from_double_to_float(dArray, fArray, n3);
                this.setDataFloat(n, fArray, n2, n3);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_or_fifo_double(n, dArray, n2, n3, 0);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public int[] getFifoInt(int n, int n2) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFifoInt (" + n + ", " + n2 + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int n3 = this.getDataType(n);
                if (n3 == 4) {
                    n3 = 3;
                }
                if (n3 != 3 && n3 != 5) {
                    throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 102);
                }
                DataToIntArray dataToIntArray = new DataToIntArray(n2, n3);
                this.readFifo(n, n2, dataToIntArray, n3 == 3 ? 2 : 5);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dataToIntArray.getArray();
            }
            case 0: {
                int[] nArray = new int[n2];
                this.adwin_tcp_get_data_or_fifo_int32(n, nArray, 1, n2, 1);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return nArray;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public float[] getFifoFloat(int n, int n2) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFifoFloat (" + n + ", " + n2 + ")");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            float[] fArray = new float[n2];
            this.adwin_tcp_get_data_or_fifo_float(n, fArray, 1, n2, 1);
            if (this.adl != null) {
                this.adl.leave();
            }
            return fArray;
        }
        int n3 = this.getDataType(n);
        if (n3 == 4) {
            n3 = 3;
        }
        if (n3 != 3 && n3 != 5) {
            throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 102);
        }
        DataToFloatArray dataToFloatArray = new DataToFloatArray(n2, n3);
        this.readFifo(n, n2, dataToFloatArray, n3 == 3 ? 2 : 5);
        if (this.adl != null) {
            this.adl.leave();
        }
        return dataToFloatArray.getArray();
    }

    public double[] getFifoDouble(int n, int n2) throws ADwinCommunicationError {
        double[] dArray;
        if (this.adl != null) {
            this.adl.enter("getFifoDouble (" + n + ", " + n2 + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                dArray = new double[n2];
                float[] fArray = this.getFifoFloat(n, n2);
                this.convert_data_from_float_to_double(fArray, dArray, n2);
                break;
            }
            case 0: {
                dArray = new double[n2];
                this.adwin_tcp_get_data_or_fifo_double(n, dArray, 1, n2, 1);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        return dArray;
    }

    public void setFifoInt(int n, int n2, int[] nArray) throws ADwinCommunicationError {
        int n3;
        if (this.adl != null) {
            this.adl.enter("setFifoInt (" + n + ", " + n2 + ", <int []>)");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            this.adwin_tcp_set_data_or_fifo_int32(n, nArray, 1, n2, 1);
            if (this.adl != null) {
                this.adl.leave();
            }
            return;
        }
        int n4 = this.getDataType(n);
        if (n4 == 4) {
            n4 = 3;
        }
        if (n4 != 3 && n4 != 5) {
            throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 101);
        }
        byte[] byArray = new byte[n2 * 4];
        if (n4 == 3) {
            for (n3 = 0; n3 < n2; ++n3) {
                ADwinDirectDevice.setInteger(byArray, n3 * 4, nArray[n3]);
            }
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                ADwinDirectDevice.setInteger(byArray, n3 * 4, Float.floatToIntBits(nArray[n3]));
            }
        }
        n3 = (n2 - 1) / ((this.DataBlockSize + 2) * 350) + 1;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            int n6 = i != n3 - 1 ? 350 * (this.DataBlockSize + 2) : n2 % (350 * (this.DataBlockSize + 2));
            if (n6 == 0) {
                n6 = 350 * (this.DataBlockSize + 2);
            }
            this.writeFifo(n, 2, n6, byArray, n5 * 4);
            n5 += n6;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void setFifoFloat(int n, int n2, float[] fArray) throws ADwinCommunicationError {
        int n3;
        if (this.adl != null) {
            this.adl.enter("setFifoFloat (" + n + ", " + n2 + ", <float[]>)");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            this.adwin_tcp_set_data_or_fifo_float(n, fArray, 1, n2, 1);
            if (this.adl != null) {
                this.adl.leave();
            }
            return;
        }
        int n4 = this.getDataType(n);
        if (n4 != 3 && n4 != 5) {
            throw new ADwinCommunicationError("Fifo ist too small", "Fifo zu klein", this.Language, 101);
        }
        byte[] byArray = new byte[n2 * 4];
        if (n4 == 5) {
            for (n3 = 0; n3 < n2; ++n3) {
                ADwinDirectDevice.setInteger(byArray, n3 * 4, Float.floatToIntBits(fArray[n3]));
            }
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                ADwinDirectDevice.setInteger(byArray, n3 * 4, (int)fArray[n3]);
            }
        }
        n3 = (n2 - 1) / ((this.DataBlockSize + 2) * 350) + 1;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            int n6 = i != n3 - 1 ? 350 * (this.DataBlockSize + 2) : n2 % (350 * (this.DataBlockSize + 2));
            if (n6 == 0) {
                n6 = 350 * (this.DataBlockSize + 2);
            }
            this.writeFifo(n, 2, n6, byArray, n5 * 4);
            n5 += n6;
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void setFifoDouble(int n, int n2, double[] dArray) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setFifoDouble (" + n + ", " + n2 + ", <double[]>)");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                float[] fArray = new float[n2];
                this.convert_data_from_double_to_float(dArray, fArray, n2);
                this.setFifoFloat(n, n2, fArray);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_or_fifo_double(n, dArray, 1, n2, 1);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public int getWorkload() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getWorkload ()");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[4];
                nArray[0] = 20;
                nArray[1] = 0;
                nArray[2] = 0;
                int n = this.standardCall(20, nArray, 16, "Unable to read workload.", "workload", "Kann Auslaustung nicht lesen", "Auslastung", true, null);
                int n2 = this.getProcessorType();
                if (this.adl != null) {
                    this.adl.leave();
                }
                if (n == 0) {
                    if (n2 == 11) {
                        return (int)(900.0 * (0.1111111111111111 - (double)((float)nArray[0] / (float)nArray[1])));
                    }
                    return (int)(400.0 * (0.25 - (double)((float)nArray[0] / (float)nArray[1])));
                }
                return nArray[0];
            }
            case 0: {
                float f = this.adwin_tcp_workload();
                if (this.adl != null) {
                    this.adl.leave();
                }
                return (int)f;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public int getFreeMem(int n) throws ADwinCommunicationError {
        int n2;
        if (this.adl != null) {
            this.adl.enter("getFreeMem (" + n + ")");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            int n3 = this.adwin_tcp_free_mem(n);
            if (this.adl != null) {
                this.adl.leave();
            }
            return n3;
        }
        if (n < 0 || n > 4) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "Type may only be 0, 1, 3 or 4" : "Type darf nur 0, 1, 3 oder 4 sein");
        }
        int n4 = this.getProcessorType();
        if (n == 0) {
            int[] nArray = new int[]{5, 0, 0, 0};
            n2 = this.standardCall(0, nArray, 8, "Unable to determine amount of free memory", "amount of free memory", "Kann die Gr\u00c3\u00b6\u00c3\u0178e des freien Speichers nicht bestimmen", "Gr\u00c3\u00b6\u00c3\u0178e des freien Speichers", false, null);
            if (this.adl != null) {
                this.adl.leave();
            }
        } else {
            int[] nArray = new int[]{12, n, 0, 0};
            n2 = this.standardCall(0, nArray, 8, "Unable to determine amount of free memory", "amount of free memory", "Gr\u00c3\u00b6\u00c3\u0178e des freien Speichers konnte nicht bestimmt werden", "Gr\u00c3\u00b6\u00c3\u0178e des freien Speichers", false, null);
            if (this.adl != null) {
                this.adl.leave();
            }
        }
        if (n == 1 && (n4 == 9 || n4 == 10)) {
            return n2 * 6;
        }
        return n2 * 4;
    }

    public void stopProcess(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("stopProcess (" + n + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[]{3, n, 0, 0};
                this.standardCall(0, nArray, 4, "Unable to stop process " + n + ".", "stop process " + n, "Prozess " + n + " konnte nicht angehalten werden", "Process " + n + " stoppen", false, null);
                if (this.adl == null) break;
                this.adl.leave();
                break;
            }
            case 0: {
                this.adwin_tcp_stop_process(n);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public int getProcessState(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getProcessState (" + n + ")");
        }
        if (n < 1 || n > 15) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "ProcessNo is out of range" : "ProcesssNo au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[]{1, n + 900, 0, 0};
                int n2 = this.standardCall(0, nArray, 8, "Unable to determine state of process " + n, "state of process " + n, "Status von Prozess " + n + " konnte nicht bestimmt werden", "Status von Prozess " + n, false, null);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return n2;
            }
            case 0: {
                int n3 = this.adwin_tcp_process_status(n);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return n3;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public void clearProcess(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("clearProcess (" + n + ")");
        }
        if (n < 1 || n > 15) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "ProcessNo is out of range" : "ProcessNo ist au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[]{14, n, 0, 0};
                this.standardCall(0, nArray, 8, "Unable to clear process " + n, "clear process " + n, "Prozess " + n + " konnte nicht gel\u00c3\u00b6scht werden ", "L\u00c3\u00b6schen von Prozess " + n, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_clear_process(n);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public int[] getParIntBlock(int n, int n2) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParIntBlock (" + n + ", " + n2 + ")");
        }
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "All parameters must be positive" : "Alle Parameter m\u00c3\u00bcssen positiv sein");
        }
        if (n + n2 - 1 > 80) {
            throw new IllegalArgumentException(this.Language == 1 ? "There are only 80 parameters" : "Es gibt nur 80 Parameter");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                DataToIntArray dataToIntArray = new DataToIntArray(n2, 3);
                this.getParBlock(n, n2, dataToIntArray);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dataToIntArray.getArray();
            }
            case 0: {
                int[] nArray = new int[n2];
                this.adwin_tcp_get_par_block(n, n2, nArray);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return nArray;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public int[] getParIntAll() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParIntAll ()");
        }
        DataToIntArray dataToIntArray = new DataToIntArray(80, 3);
        this.getParBlock(1, 80, dataToIntArray);
        if (this.adl != null) {
            this.adl.leave();
        }
        return dataToIntArray.getArray();
    }

    public float[] getParFloatBlock(int n, int n2) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParFloatBlock (" + n + ", " + n2 + ")");
        }
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "All parameters must be positive" : "Alle Parameter m\u00c3\u00bcssen positiv sein");
        }
        if (n + n2 - 1 > 80) {
            throw new IllegalArgumentException(this.Language == 1 ? "There are only 80 parameters" : "Es gibt nur 80 Parameter");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                DataToFloatArray dataToFloatArray = new DataToFloatArray(n2, 5);
                this.getParBlock(n + 100, n2, dataToFloatArray);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dataToFloatArray.getArray();
            }
            case 0: {
                float[] fArray = new float[n2];
                this.adwin_tcp_get_fpar_block(n, n2, fArray);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return fArray;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public double[] getParFloatBlockDouble(int n, int n2) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParFloatBlockDouble (" + n + ", " + n2 + ")");
        }
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "All parameters must be positive" : "Alle Parameter m\u00c3\u00bcssen positiv sein");
        }
        if (n + n2 - 1 > 80) {
            throw new IllegalArgumentException(this.Language == 1 ? "There are only 80 parameters" : "Es gibt nur 80 Parameter");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                DataToFloatArray dataToFloatArray = new DataToFloatArray(n2, 5);
                this.getParBlock(n + 100, n2, dataToFloatArray);
                if (this.adl != null) {
                    this.adl.leave();
                }
                float[] fArray = dataToFloatArray.getArray();
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = fArray[i];
                }
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dArray;
            }
            case 0: {
                double[] dArray = new double[n2];
                this.adwin_tcp_get_fpar_block_double(n, n2, dArray);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dArray;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public float[] getParFloatAll() throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getParFloatAll ()");
        }
        DataToFloatArray dataToFloatArray = new DataToFloatArray(80, 5);
        this.getParBlock(101, 80, dataToFloatArray);
        if (this.adl != null) {
            this.adl.leave();
        }
        return dataToFloatArray.getArray();
    }

    public int getFifoFree(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFifoFree (" + n + ")");
        }
        if (n < 1 || n > 200) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "FifoNo (" + n + ") is out of range" : "FifoNo (" + n + ") au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            int n2 = this.adwin_tcp_fifo_empty(n);
            if (this.adl != null) {
                this.adl.leave();
            }
            return n2;
        }
        int[] nArray = new int[]{22, n, 0, 0};
        int n3 = this.standardCall(0, nArray, 8, "Unable to determine number of free elements in fifo " + n, "number of free elements in fifo " + n, "Anzahl der freien Elemente in Fifo " + n + " konnte nicht bestimmt werden", "Anzahl der freien Elemente in " + n, false, null);
        if (this.adl != null) {
            this.adl.leave();
        }
        return n3;
    }

    public int getFifoUsed(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getFifoUsed (" + n + ")");
        }
        if (n < 1 || n > 200) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "FifoNo (" + n + ") is out of range" : "FifoNo (" + n + ") au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            int n2 = this.adwin_tcp_fifo_full(n);
            if (this.adl != null) {
                this.adl.leave();
            }
            return n2;
        }
        int[] nArray = new int[]{23, n, 0, 0};
        int n3 = this.standardCall(0, nArray, 8, "Unable to determine number of used elements in fifo " + n, "number of used elements in fifo " + n, "Anzahl der benutzen Elemente in Fifo " + n + "konnte nicht bestimmt werden", "Anzahl der benutzten Elemente in Fifo " + n, false, null);
        if (this.adl != null) {
            this.adl.leave();
        }
        return n3;
    }

    public void clearFifo(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("clearFifo (" + n + ")");
        }
        if (n < 1 || n > 200) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "FifoNo (" + n + ") is out of range" : "FifoNo (" + n + ") ist au\u00c3\u0178erhalb des g\u00c3\u00bcltigen Bereichs");
        }
        if (this.adwin_tcp_or_udp() == 0) {
            this.adwin_tcp_fifo_clear(n);
            if (this.adl != null) {
                this.adl.leave();
            }
            return;
        }
        int[] nArray = new int[]{21, n, 0, 0};
        this.standardCall(0, nArray, 4, "Unable to clear fifo " + n, "clear fifo " + n, "Fifo " + n + " konnte nicht gel\u00c3\u00b6scht werden.", "L\u00c3\u00b6schen von Fifo " + n, false, null);
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public int getStringLength(int n) throws ADwinCommunicationError {
        if (n < 1 || n > 200) {
            throw new IllegalArgumentException(this.Language == 1 ? "DataNo is out of range" : "DataNo nicht innerhalb des g\u00c3\u00bcltigen Bereichs");
        }
        if (this.adl != null) {
            this.adl.enter("getStringLength (" + n + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = this.getDataInt(n, 1, 1);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return nArray[0];
            }
            case 0: {
                int n2 = this.adwin_tcp_string_length(n);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return n2;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public String getString(int n) throws ADwinCommunicationError {
        if (n < 1 || n > 200) {
            throw new IllegalArgumentException(this.Language == 1 ? "DataNo is out of range" : "DataNo nicht innerhalb des g\u00c3\u00bcltigen Bereichs");
        }
        if (this.adl != null) {
            this.adl.enter("getString (" + n + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int n2 = this.getDataType(n);
                if (n2 != 3) {
                    if (this.adl != null) {
                        this.adl.leave();
                    }
                    throw new IllegalArgumentException(this.Language == 1 ? "DATA_" + n + " is not of type int" : "DATA_" + n + " ist nicht vom Typ int");
                }
                DataToIntArray dataToIntArray = (DataToIntArray)this.getData(n, 1, this.getStringLength(n) + 1, n2);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return dataToIntArray.getString();
            }
            case 0: {
                int n3 = this.adwin_tcp_string_length(n);
                String string = this.adwin_tcp_get_data_string(n, n3);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return string;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public void setString(int n, String string) throws ADwinCommunicationError {
        if (n < 1 || n > 200) {
            throw new IllegalArgumentException(this.Language == 1 ? "DataNo is out of range" : "DataNo nicht innerhalb des g\u00c3\u00bcltigen Bereichs");
        }
        if (this.adl != null) {
            this.adl.enter("setString (" + n + ", \"" + string + "\")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[string.length() + 2];
                nArray[0] = string.length();
                for (int i = 0; i < string.length(); ++i) {
                    nArray[i + 1] = string.charAt(i);
                }
                nArray[string.length() + 1] = 0;
                this.setDataInt(n, nArray, 1, string.length() + 2);
                break;
            }
            case 0: {
                this.adwin_tcp_set_data_string(n, string, string.length() + 2);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public int getGlobalDelay(int n) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("getGlobalDelay (" + n + ")");
        }
        if (n < 1 || n > 10) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "ProcessNo is out of range" : "ProcessNo nicht innerhalb des g\u00c3\u00bcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[]{1, 910 + n, 0, 0};
                int n2 = this.standardCall(0, nArray, 8, "Unable to load the GlobalDelay of Process " + n + ".", "GlobalDelay of Process " + n, "Das GlobalDelay von Prozess " + n + " konnte nicht geladen werden.", "GlobalDelay von Prozess " + n, false, null);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return n2;
            }
            case 0: {
                int n3 = this.adwin_tcp_get_processdelay(n);
                if (this.adl != null) {
                    this.adl.leave();
                }
                return n3;
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
        throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
    }

    public void setGlobalDelay(int n, int n2) throws ADwinCommunicationError {
        if (this.adl != null) {
            this.adl.enter("setGlobalDelay (" + n + ", " + n2 + ")");
        }
        if (n < 1 || n > 10) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new IllegalArgumentException(this.Language == 1 ? "ProcessNo is out of range" : "ProcessNo nicht innerhalb des g\u00c3\u00bcltigen Bereichs");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                int[] nArray = new int[]{6, 910 + n, n2, 0};
                this.standardCall(0, nArray, 4, "Unable to set the GlobalDelay of Process " + n + ".", "setting GlobalDelay for Process " + n + ".", "Das GlobalDelay f\u00c3\u00bcr Prozess " + n + " konnte nicht gesetzt werden", "Setzen des GlobalDelays von Prozess " + n, false, null);
                break;
            }
            case 0: {
                this.adwin_tcp_set_processdelay(n, n2);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    public void bootFile(String string, int n) throws ADwinCommunicationError, FileNotFoundException, IOException {
        int n2;
        if (this.adl != null) {
            this.adl.enter("bootFile (" + string + ", " + n + ")");
        }
        if (string == null || (n2 = string.length()) < 5) {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("The file is not a BTL file", "Die Datei ist keine BTL-Datei", this.Language, 204);
        }
        if (string.charAt(n2 - 1) != 'l' && string.charAt(n2 - 1) != 'L' || string.charAt(n2 - 2) != 't' && string.charAt(n2 - 2) != 'T' || string.charAt(n2 - 3) != 'b' && string.charAt(n2 - 3) != 'B') {
            if (this.adl != null) {
                this.adl.leave();
            }
            throw new ADwinCommunicationError("The file is not a BTL file", "Die Datei ist keine BTL-Datei", this.Language, 204);
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                FileInputStream fileInputStream = new FileInputStream(string);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                if (byArray.length == 0) {
                    return;
                }
                this.bootArray(byArray, string, n);
                break;
            }
            case 0: {
                this.adwin_tcp_boot(string);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootArray(byte[] byArray, String string, int n) throws ADwinCommunicationError, IOException {
        if (this.adl != null) {
            this.adl.enter("bootArray (<byte[]>, " + string + ", " + n + ")");
        }
        switch (this.adwin_tcp_or_udp()) {
            case 2: {
                byte[] byArray2 = new byte[32];
                DatagramPacket datagramPacket = new DatagramPacket(byArray2, 32);
                int[] nArray = new int[1];
                int[] nArray2 = new int[]{1000, this.DataBlockSize << 16, n, byArray.length};
                DatagramSocket datagramSocket = this.ds;
                synchronized (datagramSocket) {
                    this.standardCall(50, nArray2, 4, "Unable to start booting.", "starting to boot", "Es konnte nicht mit dem Booten begonnen werden", "Start des Bootens", false, nArray);
                    DataFieldTransfer dataFieldTransfer = new DataFieldTransfer(this.Connection, this.ds, this);
                    dataFieldTransfer.send(byArray.length, byArray, "operating system " + string, nArray[0]);
                    int n2 = 0;
                    do {
                        try {
                            this.ds.receive(datagramPacket);
                            n2 = 0;
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            ++n2;
                            if (this.adl != null) {
                                this.adl.message("Timeout...", 100);
                            }
                            if (n2 <= this.AllowedErrors) continue;
                            if (this.adl != null) {
                                this.adl.leave();
                            }
                            throw new ADwinCommunicationError("ADwin system could not be booted, " + socketTimeoutException.getMessage(), "ADwin-System konnte nicht gebootet werden, " + socketTimeoutException.getMessage(), this.Language, 2001);
                        }
                        catch (IOException iOException) {
                            if (this.adl != null) {
                                this.adl.message("IOException -> ADwinCommunicationError", 1);
                                this.adl.leave();
                            }
                            throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
                        }
                    } while (n2 > 0);
                }
                if (ADwinDirectDevice.extractInt(byArray2, 0) == 0) break;
                if (this.adl != null) {
                    this.adl.message("Error Code: " + ADwinDirectDevice.extractInt(byArray2, 0), 1);
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Error " + ADwinDirectDevice.extractInt(byArray2, 0) + " occured after loading operating system " + string + ".", "Fehler " + ADwinDirectDevice.extractInt(byArray2, 0) + " nach dem Laden von Betriebssystem " + string + " aufgetreten", this.Language, ADwinDirectDevice.extractInt(byArray2, 0));
            }
            case 0: {
                this.adwin_tcp_boot(byArray);
                break;
            }
            default: {
                if (this.adl != null) {
                    this.adl.leave();
                }
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        if (this.adl != null) {
            this.adl.leave();
        }
    }

    void new_socket() throws SocketException {
        this.ati.socket = new Socket();
        this.ati.socket.setSendBufferSize(131072);
        this.ati.socket.setReceiveBufferSize(131072);
        this.ati.socket.setSoTimeout(this.ati.timeout_ms);
    }

    final void adwin_tcp_construct() throws SocketException {
        this.ati = new adwin_tcp_info_t();
        this.ati.server_addr = this.Connection;
        this.ati.req = new adwin_tcp_buffer_t();
        this.ati.resp = new adwin_tcp_buffer_t();
        this.ati.error_number = 0;
        this.ati.firmware_version = 0;
        this.ati.firmware_version_beta = 0;
        this.ati.processortype = -1;
        this.ati.initialized = true;
        this.ati.timeout_size = 0xA00000;
        this.ati.req.max = 10240;
        this.ati.req.data = new byte[this.ati.req.max + 4];
        ADwinDirectDevice.setInteger(this.ati.req.data, 10240, 305432421);
        this.ati.resp.max = 10240;
        this.ati.resp.data = new byte[this.ati.resp.max + 4];
        ADwinDirectDevice.setInteger(this.ati.resp.data, 10240, 573785173);
        this.ati.dll_version = 1;
        this.ati.timeout_ms = this.ADwTimeout;
        this.new_socket();
    }

    void init_ati(int n) {
        this.ati.command = n;
        if (ADwinDirectDevice.extractInt(this.ati.req.data, 10240) != 305432421) {
            // empty if block
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 10240) != 573785173) {
            // empty if block
        }
        this.ati.req.do_convert = 1;
        this.ati.req.used = 0;
        this.ati.resp.do_convert = 2;
        this.ati.resp.used = 0;
        this.ati.status = -1111;
    }

    int check_tcp_ret(int n, int n2) throws ADwinCommunicationError {
        if (n == n2) {
            return 0;
        }
        try {
            this.ati.stream_in.close();
            this.ati.stream_out.close();
            this.ati.socket.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            this.ati.connected = false;
            throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.Language, 2000);
        }
        this.ati.connected = false;
        return 1;
    }

    public int htonl(int n) {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return n;
        }
        return Integer.reverseBytes(n);
    }

    public int ntohl(int n) {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return n;
        }
        return Integer.reverseBytes(n);
    }

    int tcp_discard_pending(adwin_tcp_info_t adwin_tcp_info_t2) throws ADwinCommunicationError {
        if (adwin_tcp_info_t2.rx_pending == 0) {
            return 0;
        }
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t2.max = adwin_tcp_info_t2.rx_pending;
        adwin_tcp_buffer_t2.used = 0;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.data = new byte[adwin_tcp_info_t2.rx_pending];
        int n = this.tcp_read_pending(adwin_tcp_info_t2, adwin_tcp_info_t2.rx_pending, adwin_tcp_buffer_t2);
        return n;
    }

    public void adwin_tcp_connect() throws ADwinCommunicationError {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.Connection, this.Port);
        this.ati.connected = false;
        try {
            this.new_socket();
            this.ati.socket.connect(inetSocketAddress, 1000);
        }
        catch (IOException iOException) {
            this.check_tcp_ret(0, 1);
            return;
        }
        this.init_ati(300);
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, this.htonl(this.ati.dll_version));
        ADwinDirectDevice.setInteger(this.ati.req.data, 16, this.htonl(5 * this.ati.timeout_ms));
        ADwinDirectDevice.setInteger(this.ati.req.data, 20, this.htonl(this.ati.timeout_size));
        for (int i = 0; i < 9 && i < this.Password.length(); ++i) {
            this.ati.req.data[i + 4] = (byte)this.Password.charAt(i);
        }
        this.ati.req.data[i + 4] = 0;
        this.ati.req.used = 24;
        this.ati.req.do_convert = 0;
        try {
            this.ati.stream_in = this.ati.socket.getInputStream();
            this.ati.stream_out = this.ati.socket.getOutputStream();
        }
        catch (IOException iOException) {
            this.check_tcp_ret(0, 1);
            throw new ADwinCommunicationError("socket-error: " + iOException.getMessage(), "Socket-Fehler: " + iOException.getMessage(), this.Language, 2000);
        }
        if (this.tcp_write_request(this.ati, null) == -1) {
            this.check_tcp_ret(0, 1);
            return;
        }
        if (this.tcp_read_response(this.ati, 16, null) == -1) {
            this.check_tcp_ret(0, 1);
            return;
        }
        this.ati.processortype = ADwinDirectDevice.extractInt(this.ati.resp.data, 0) + 9;
        int n = ADwinDirectDevice.extractInt(this.ati.resp.data, 4);
        this.ati.firmware_version = ADwinDirectDevice.extractInt(this.ati.resp.data, 8);
        this.ati.firmware_version_beta = ADwinDirectDevice.extractInt(this.ati.resp.data, 12);
        switch (this.ati.processortype) {
            case 9: {
                this.ati.processortype = 9;
                break;
            }
            case 10: {
                this.ati.processortype = 1010;
                break;
            }
            case 11: {
                this.ati.processortype = 1011;
                break;
            }
            case 12: {
                this.ati.processortype = 1012;
            }
        }
        this.ati.connected = this.ati.error_number == 0;
    }

    public int adwin_tcp_or_udp() throws ADwinCommunicationError {
        Date date = new Date();
        if (this.ati.initialized && this.ati.connected && this.last_access.getTime() + 5000L > date.getTime()) {
            return 0;
        }
        if ((this.version == 0 || this.last_access.getTime() == 0L || this.last_access.getTime() + 5000L > date.getTime()) && this.getArmVersion() == 0) {
            System.out.println("ATOU: Get_Version_TcpIp error\n");
            return 1;
        }
        this.last_access = date;
        if (this.supports_tcp) {
            if (!this.ati.initialized) {
                return 1;
            }
            if (!this.ati.connected) {
                this.adwin_tcp_connect();
            }
            if (this.ati.connected) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    void do_convert(adwin_tcp_buffer_t adwin_tcp_buffer_t2) {
        if (adwin_tcp_buffer_t2 == null) {
            return;
        }
        switch (adwin_tcp_buffer_t2.do_convert) {
            case 2: {
                for (int i = 0; i < adwin_tcp_buffer_t2.used / 4; ++i) {
                    ADwinDirectDevice.setInteger(adwin_tcp_buffer_t2.data, i * 4, this.ntohl(ADwinDirectDevice.extractInt(adwin_tcp_buffer_t2.data, i * 4)));
                }
                break;
            }
            case 1: {
                for (int i = 0; i < adwin_tcp_buffer_t2.used / 4; ++i) {
                    ADwinDirectDevice.setInteger(adwin_tcp_buffer_t2.data, i * 4, this.ntohl(ADwinDirectDevice.extractInt(adwin_tcp_buffer_t2.data, i * 4)));
                }
                break;
            }
        }
    }

    int tcp_write_request(adwin_tcp_info_t adwin_tcp_info_t2, adwin_tcp_buffer_t adwin_tcp_buffer_t2) throws ADwinCommunicationError {
        adwin_tcp_buffer_t adwin_tcp_buffer_t3 = new adwin_tcp_buffer_t();
        if (adwin_tcp_buffer_t2 == null) {
            adwin_tcp_buffer_t2 = adwin_tcp_buffer_t3;
        }
        ++adwin_tcp_info_t2.req_count;
        int n = adwin_tcp_info_t2.req.used + adwin_tcp_buffer_t2.used;
        int n2 = 0;
        this.do_convert(adwin_tcp_info_t2.req);
        this.do_convert(adwin_tcp_buffer_t2);
        int n3 = adwin_tcp_buffer_t2.used > adwin_tcp_info_t2.timeout_size ? adwin_tcp_info_t2.timeout_size : adwin_tcp_buffer_t2.used;
        int n4 = 16 + adwin_tcp_info_t2.req.used;
        byte[] byArray = new byte[n4];
        ADwinDirectDevice.setInteger(byArray, 0, this.htonl(1118650900));
        ADwinDirectDevice.setInteger(byArray, 4, this.htonl(adwin_tcp_info_t2.req_count));
        ADwinDirectDevice.setInteger(byArray, 8, this.htonl(n));
        ADwinDirectDevice.setInteger(byArray, 12, this.htonl(adwin_tcp_info_t2.command));
        System.arraycopy(adwin_tcp_info_t2.req.data, 0, byArray, 16, adwin_tcp_info_t2.req.used);
        try {
            adwin_tcp_info_t2.stream_out.write(byArray, 0, n4);
        }
        catch (IOException iOException) {
            this.check_tcp_ret(0, 1);
            throw new ADwinCommunicationError("Network-error: " + iOException.getMessage(), "Netzwerk-Fehler: " + iOException.getMessage(), this.Language, 2000);
        }
        if (n3 > 0) {
            try {
                adwin_tcp_info_t2.stream_out.write(adwin_tcp_buffer_t2.data, 0, n3);
            }
            catch (IOException iOException) {
                this.check_tcp_ret(0, 1);
                throw new ADwinCommunicationError("Network-error: " + iOException.getMessage(), "Netzwerk-Fehler: " + iOException.getMessage(), this.Language, 2000);
            }
            for (n2 = n3; n2 < adwin_tcp_buffer_t2.used; n2 += n3) {
                n3 = n2 + adwin_tcp_info_t2.timeout_size <= adwin_tcp_buffer_t2.used ? adwin_tcp_info_t2.timeout_size : adwin_tcp_buffer_t2.used - n2;
                try {
                    adwin_tcp_info_t2.stream_out.write(adwin_tcp_buffer_t2.data, n2, n3);
                    continue;
                }
                catch (IOException iOException) {
                    this.check_tcp_ret(0, 1);
                    throw new ADwinCommunicationError("Network-error: " + iOException.getMessage(), "Netzwerk-Fehler: " + iOException.getMessage(), this.Language, 2000);
                }
            }
        }
        return 0;
    }

    int tcp_read_response(adwin_tcp_info_t adwin_tcp_info_t2, int n, adwin_tcp_buffer_t adwin_tcp_buffer_t2) throws ADwinCommunicationError {
        int n2;
        byte[] byArray = new byte[40];
        adwin_tcp_header_t adwin_tcp_header_t2 = new adwin_tcp_header_t();
        adwin_tcp_buffer_t adwin_tcp_buffer_t3 = adwin_tcp_buffer_t2 == null ? adwin_tcp_info_t2.resp : adwin_tcp_buffer_t2;
        try {
            n2 = adwin_tcp_info_t2.stream_in.read(byArray, 0, 16);
            if (this.check_tcp_ret(n2, 16) == 1) {
                throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
            }
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("Network-error: " + iOException.getMessage(), "Netzwerk-Fehler: " + iOException.getMessage(), this.Language, 2000);
        }
        adwin_tcp_header_t2.magic_flag = this.ntohl(ADwinDirectDevice.extractInt(byArray, 0));
        adwin_tcp_header_t2.req_count = this.ntohl(ADwinDirectDevice.extractInt(byArray, 4));
        adwin_tcp_header_t2.length = this.ntohl(ADwinDirectDevice.extractInt(byArray, 8));
        adwin_tcp_header_t2.command_or_status = this.ntohl(ADwinDirectDevice.extractInt(byArray, 12));
        if (this.check_tcp_ret(adwin_tcp_header_t2.magic_flag, 1118650963) == 1) {
            throw new ADwinCommunicationError("Network-error!", "Netzwerk-Fehler!", this.Language, 2000);
        }
        adwin_tcp_info_t2.rx_pending = adwin_tcp_header_t2.length;
        adwin_tcp_info_t2.status = this.map_error_code(adwin_tcp_header_t2.command_or_status);
        n2 = this.tcp_read_pending(adwin_tcp_info_t2, n, adwin_tcp_buffer_t3);
        if (adwin_tcp_info_t2.status != 0) {
            if (adwin_tcp_info_t2.status == -5) {
                throw new ADwinCommunicationError("Wrong Password", "Falsches Passwort", this.Language, 2002);
            }
            if (adwin_tcp_info_t2.status == -30) {
                throw new ADwinCommunicationError("Wrong Version", "Falsche Version", this.Language, 20);
            }
            if (adwin_tcp_info_t2.status == 1) {
                throw new ADwinCommunicationError("Timeout to link", "Timeout beim Schreiben zum Link", this.Language, 1);
            }
            if (adwin_tcp_info_t2.status == 2) {
                throw new ADwinCommunicationError("Timeout from link", "Timeout beim Lesen vom Link", this.Language, 2);
            }
            if (adwin_tcp_info_t2.status == 101) {
                throw new ADwinCommunicationError("There is not enough space left in fifo", "Nicht genug Platz \u00c3\u00bcbrig in Fifo", this.Language, 101);
            }
            if (adwin_tcp_info_t2.status == 102) {
                throw new ADwinCommunicationError("The Fifo has not enough values", "Das Fifo-Feld hat nicht genug Daten", this.Language, 102);
            }
            System.err.println("*** ati.status: " + adwin_tcp_info_t2.status);
            throw new ADwinCommunicationError("status error: " + adwin_tcp_info_t2.status, "Status-Fehler: " + adwin_tcp_info_t2.status, this.Language, adwin_tcp_info_t2.status);
        }
        return n2;
    }

    public static int readInputStreamWithTimeout(InputStream inputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        long l = System.currentTimeMillis() + (long)n2;
        for (n4 = 0; System.currentTimeMillis() < l && n4 < n3; n4 += n5) {
            int n6 = Math.min(inputStream.available(), n3 - n4);
            n5 = inputStream.read(byArray, n4 + n, n6 = Math.min(n6, n3));
            if (n5 == -1) break;
        }
        return n4;
    }

    int tcp_read_pending(adwin_tcp_info_t adwin_tcp_info_t2, int n, adwin_tcp_buffer_t adwin_tcp_buffer_t2) throws ADwinCommunicationError {
        int n2;
        int n3;
        adwin_tcp_buffer_t adwin_tcp_buffer_t3 = adwin_tcp_buffer_t2 == null ? adwin_tcp_info_t2.resp : adwin_tcp_buffer_t2;
        if (adwin_tcp_buffer_t3.max < n) {
            throw new ADwinCommunicationError("memory-error: not enough room in destination memory", "Speicher-Fehler!", this.Language, 0);
        }
        if (adwin_tcp_info_t2.rx_pending < n) {
            System.err.println("*** error: read pending ");
            throw new ADwinCommunicationError("memory-error: not enough room in destination memory", "Speicher-Fehler!", this.Language, 0);
        }
        for (n2 = 0; n > n2; n2 += n3) {
            n3 = n > n2 + adwin_tcp_info_t2.timeout_size ? adwin_tcp_info_t2.timeout_size : n - n2;
            try {
                int n4 = ADwinDirectDevice.readInputStreamWithTimeout(adwin_tcp_info_t2.stream_in, adwin_tcp_buffer_t3.data, n2, adwin_tcp_info_t2.timeout_ms, n3);
                if (this.check_tcp_ret(n4, n3) != 1) continue;
                System.err.println("*** readInputStreamWithTimeout returned: " + n4 + " expected " + n3);
                throw new ADwinCommunicationError("Network timeout", "Netzwerk Timeout: ", this.Language, 2001);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                return -1;
            }
        }
        adwin_tcp_buffer_t3.used = n2;
        adwin_tcp_info_t2.rx_pending -= n2;
        this.do_convert(adwin_tcp_buffer_t3);
        return 0;
    }

    void adwin_tcp_boot(String string) throws FileNotFoundException, IOException, ADwinCommunicationError {
        this.boot_or_loadprocess(string, 50);
    }

    void adwin_tcp_boot(byte[] byArray) throws FileNotFoundException, IOException, ADwinCommunicationError {
        this.boot_or_loadprocess(byArray, 50);
    }

    void adwin_tcp_load_process(String string) throws FileNotFoundException, IOException, ADwinCommunicationError {
        this.boot_or_loadprocess(string, 4);
    }

    void adwin_tcp_load_process(byte[] byArray) throws FileNotFoundException, IOException, ADwinCommunicationError {
        this.boot_or_loadprocess(byArray, 4);
    }

    void boot_or_loadprocess(String string, int n) throws FileNotFoundException, IOException, ADwinCommunicationError {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t2.max = 0;
        adwin_tcp_buffer_t2.used = 0;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.data = null;
        this.init_ati(n);
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        if (byArray.length == 0) {
            return;
        }
        adwin_tcp_buffer_t2.data = byArray;
        adwin_tcp_buffer_t2.max = adwin_tcp_buffer_t2.used = byArray.length;
        if (this.tcp_write_request(this.ati, adwin_tcp_buffer_t2) == -1) {
            this.check_tcp_ret(0, 1);
            return;
        }
        this.ati.resp.do_convert = 0;
        this.tcp_read_response(this.ati, 0, null);
    }

    void boot_or_loadprocess(byte[] byArray, int n) throws FileNotFoundException, IOException, ADwinCommunicationError {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t2.max = 0;
        adwin_tcp_buffer_t2.used = 0;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.data = null;
        this.init_ati(n);
        if (byArray.length == 0) {
            return;
        }
        adwin_tcp_buffer_t2.data = byArray;
        adwin_tcp_buffer_t2.max = adwin_tcp_buffer_t2.used = byArray.length;
        if (this.tcp_write_request(this.ati, adwin_tcp_buffer_t2) == -1) {
            this.check_tcp_ret(0, 1);
            return;
        }
        this.ati.resp.do_convert = 0;
        this.tcp_read_response(this.ati, 0, null);
    }

    void command_4p4(int[] nArray, int[] nArray2) throws ADwinCommunicationError {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t adwin_tcp_buffer_t3 = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t2.max = 16;
        adwin_tcp_buffer_t2.used = 16;
        adwin_tcp_buffer_t2.do_convert = 1;
        adwin_tcp_buffer_t2.data = new byte[16];
        ADwinDirectDevice.setInteger(adwin_tcp_buffer_t2.data, 0, nArray[0]);
        ADwinDirectDevice.setInteger(adwin_tcp_buffer_t2.data, 4, nArray[1]);
        ADwinDirectDevice.setInteger(adwin_tcp_buffer_t2.data, 8, nArray[2]);
        ADwinDirectDevice.setInteger(adwin_tcp_buffer_t2.data, 12, nArray[3]);
        adwin_tcp_buffer_t3.max = 16;
        adwin_tcp_buffer_t3.used = 0;
        adwin_tcp_buffer_t3.do_convert = 2;
        adwin_tcp_buffer_t3.data = new byte[16];
        this.init_ati(0);
        if (this.tcp_write_request(this.ati, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 16, adwin_tcp_buffer_t3) == -1) {
            return;
        }
        nArray2[0] = ADwinDirectDevice.extractInt(adwin_tcp_buffer_t3.data, 0);
        nArray2[1] = ADwinDirectDevice.extractInt(adwin_tcp_buffer_t3.data, 4);
        nArray2[2] = ADwinDirectDevice.extractInt(adwin_tcp_buffer_t3.data, 8);
        nArray2[3] = ADwinDirectDevice.extractInt(adwin_tcp_buffer_t3.data, 12);
    }

    void adwin_tcp_start_process(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{2, n, 0, 0};
        this.command_4p4(nArray2, nArray);
    }

    void adwin_tcp_stop_process(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{3, n, 0, 0};
        this.command_4p4(nArray2, nArray);
    }

    void adwin_tcp_clear_process(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{14, n, 0, 0};
        this.command_4p4(nArray2, nArray);
    }

    int adwin_tcp_process_status(int n) throws ADwinCommunicationError {
        return this.adwin_tcp_get_par(-100 + n);
    }

    int adwin_tcp_get_processdelay(int n) throws ADwinCommunicationError {
        return this.adwin_tcp_get_par(-90 + n);
    }

    void adwin_tcp_set_processdelay(int n, int n2) throws ADwinCommunicationError {
        this.adwin_tcp_set_par(-90 + n, n2);
    }

    float adwin_tcp_workload() throws ADwinCommunicationError {
        float f = -1.0f;
        this.init_ati(20);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return -1.0f;
        }
        if (this.tcp_read_response(this.ati, 16, null) == -1) {
            return -1.0f;
        }
        if (this.ati.processortype != 1012) {
            int n = ADwinDirectDevice.extractInt(this.ati.resp.data, 0);
            int n2 = ADwinDirectDevice.extractInt(this.ati.resp.data, 4);
            int n3 = ADwinDirectDevice.extractInt(this.ati.resp.data, 8);
            if (n3 == 0) {
                if (n2 == 0) {
                    return 100.0f;
                }
                float f2 = (float)n / (float)n2;
                if (f2 == 0.0f) {
                    return 100.0f;
                }
                f = this.ati.processortype == 1011 ? 100.0f * ((0.11111111f - f2) * 9.0f) : 100.0f * ((0.25f - f2) / 0.25f);
            } else {
                f = n;
            }
        } else {
            f = ADwinDirectDevice.extractInt(this.ati.resp.data, 0);
        }
        if (f > 100.0f) {
            return 100.0f;
        }
        if (f < 0.0f) {
            return 0.0f;
        }
        return f;
    }

    int adwin_tcp_get_par(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{1, n + 1000, 0, 0};
        this.command_4p4(nArray2, nArray);
        return nArray[0];
    }

    void adwin_tcp_set_par(int n, int n2) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{6, n + 1000, n2, 0};
        this.command_4p4(nArray2, nArray);
    }

    float adwin_tcp_get_fpar(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{1, n + 1100, 0, 0};
        this.command_4p4(nArray2, nArray);
        return Float.intBitsToFloat(nArray[0]);
    }

    void adwin_tcp_set_fpar(int n, float f) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{6, n + 1100, Float.floatToIntBits(f), 0};
        this.command_4p4(nArray2, nArray);
    }

    double adwin_tcp_get_fpar_double(int n) throws ADwinCommunicationError {
        if (this.ati.processortype != 1012) {
            return this.adwin_tcp_get_fpar(n);
        }
        byte[] byArray = new byte[8];
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{1, n + 1200, 0, 0};
        this.command_4p4(nArray2, nArray);
        ADwinDirectDevice.setInteger(byArray, 0, nArray[0]);
        ADwinDirectDevice.setInteger(byArray, 4, nArray[1]);
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    void adwin_tcp_set_fpar_double(int n, double d) throws ADwinCommunicationError {
        if (this.ati.processortype != 1012) {
            this.adwin_tcp_set_fpar(n, (float)d);
            return;
        }
        int[] nArray = new int[4];
        long l = Double.doubleToLongBits(d);
        int[] nArray2 = new int[]{6, n + 1200, (int)(l >> 32), (int)l};
        this.command_4p4(nArray2, nArray);
    }

    void adwin_tcp_get_par_block(int n, int n2, int[] nArray) throws ADwinCommunicationError {
        this.init_ati(13);
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        this.ati.req.used = 8;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t2.data = new byte[n2 * 4];
        adwin_tcp_buffer_t2.max = n2 * 4;
        adwin_tcp_buffer_t2.used = 0;
        adwin_tcp_buffer_t2.do_convert = 0;
        if (this.tcp_read_response(this.ati, adwin_tcp_buffer_t2.max, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i] = ADwinDirectDevice.extractInt(adwin_tcp_buffer_t2.data, i * 4);
        }
    }

    void adwin_tcp_get_par_all(int[] nArray) throws ADwinCommunicationError {
        this.adwin_tcp_get_par_block(1, 80, nArray);
    }

    void adwin_tcp_get_fpar_block(int n, int n2, float[] fArray) throws ADwinCommunicationError {
        int[] nArray = new int[n2];
        this.adwin_tcp_get_par_block(100 + n, n2, nArray);
        for (int i = 0; i < n2; ++i) {
            fArray[i] = Float.intBitsToFloat(nArray[i]);
        }
    }

    void adwin_tcp_get_fpar_all(float[] fArray) throws ADwinCommunicationError {
        int[] nArray = new int[80];
        this.adwin_tcp_get_par_block(101, 80, nArray);
        for (int i = 0; i < 80; ++i) {
            fArray[i] = Float.intBitsToFloat(nArray[i]);
        }
    }

    void adwin_tcp_get_fpar_block_double(int n, int n2, double[] dArray) throws ADwinCommunicationError {
        if (this.ati.processortype != 1012) {
            int[] nArray = new int[n2];
            this.adwin_tcp_get_par_block(100 + n, n2, nArray);
            for (int i = 0; i < n2; ++i) {
                dArray[i] = Float.intBitsToFloat(nArray[i]);
            }
        } else {
            this.init_ati(13);
            ADwinDirectDevice.setInteger(this.ati.req.data, 0, 200 + n);
            ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2 * 2);
            this.ati.req.used = 8;
            if (this.tcp_write_request(this.ati, null) == -1) {
                return;
            }
            adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
            adwin_tcp_buffer_t2.data = new byte[n2 * 8];
            adwin_tcp_buffer_t2.max = n2 * 8;
            adwin_tcp_buffer_t2.used = 0;
            adwin_tcp_buffer_t2.do_convert = 0;
            if (this.tcp_read_response(this.ati, adwin_tcp_buffer_t2.max, adwin_tcp_buffer_t2) == -1) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                dArray[i] = ByteBuffer.wrap(adwin_tcp_buffer_t2.data, i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            }
        }
    }

    void adwin_tcp_get_fpar_all_double(double[] dArray) throws ADwinCommunicationError {
        if (this.ati.processortype != 1012) {
            int[] nArray = new int[80];
            this.adwin_tcp_get_par_block(101, 80, nArray);
            for (int i = 0; i < 80; ++i) {
                dArray[i] = Float.intBitsToFloat(nArray[i]);
            }
        } else {
            this.adwin_tcp_get_fpar_block_double(1, 80, dArray);
        }
    }

    int adwin_tcp_free_mem(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{12, n, 0, 0};
        this.command_4p4(nArray2, nArray);
        return nArray[0];
    }

    void adwin_tcp_peek(int n, int n2, int[] nArray) throws ADwinCommunicationError {
        this.init_ati(1000000);
        this.ati.req.used = 8;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        adwin_tcp_buffer_t2.data = new byte[n2 * 4];
        adwin_tcp_buffer_t2.max = n2 * 4;
        adwin_tcp_buffer_t2.used = 0;
        adwin_tcp_buffer_t2.do_convert = 0;
        if (this.tcp_read_response(this.ati, adwin_tcp_buffer_t2.max, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i] = ADwinDirectDevice.extractInt(adwin_tcp_buffer_t2.data, i * 4);
        }
    }

    int bytes_per_value(adwin_data_type_t adwin_data_type_t2) {
        switch (adwin_data_type_t2) {
            case ADWIN_BYTE: {
                return 1;
            }
            case ADWIN_SHORT: {
                return 2;
            }
            case ADWIN_LONG: {
                return 4;
            }
            case ADWIN_INTEGER: {
                return 4;
            }
            case ADWIN_FLOAT: {
                return 4;
            }
            case ADWIN_DOUBLE: {
                return 8;
            }
            case ADWIN_INT64: {
                return 8;
            }
            case ADWIN_STRING: {
                return 1;
            }
        }
        return -1;
    }

    adwin_data_type_t int_to_adwin_data_type(int n) {
        switch (n) {
            case 1: {
                return adwin_data_type_t.ADWIN_BYTE;
            }
            case 2: {
                return adwin_data_type_t.ADWIN_SHORT;
            }
            case 3: {
                return adwin_data_type_t.ADWIN_LONG;
            }
            case 4: {
                return adwin_data_type_t.ADWIN_INTEGER;
            }
            case 5: {
                return adwin_data_type_t.ADWIN_FLOAT;
            }
            case 6: {
                return adwin_data_type_t.ADWIN_DOUBLE;
            }
            case 7: {
                return adwin_data_type_t.ADWIN_INT64;
            }
            case 8: {
                return adwin_data_type_t.ADWIN_STRING;
            }
            case 20: {
                return adwin_data_type_t.ADWIN_VARIANT;
            }
        }
        return adwin_data_type_t.ADWIN_DATA_TYPE_INVALID;
    }

    int adwin_tcp_get_data_type(int n) throws ADwinCommunicationError {
        this.init_ati(100);
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        this.ati.req.used = 4;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return 0;
        }
        if (this.tcp_read_response(this.ati, 4, null) == -1) {
            return 0;
        }
        return ADwinDirectDevice.extractInt(this.ati.resp.data, 0);
    }

    int adwin_tcp_get_data_length(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{11, n, 0, 0};
        this.command_4p4(nArray2, nArray);
        return nArray[0];
    }

    void adwin_tcp_clear_data(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{9, n, 0, 0};
        this.command_4p4(nArray2, nArray);
    }

    int adwin_tcp_fifo_full(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{23, n, 0, 0};
        this.command_4p4(nArray2, nArray);
        return nArray[0];
    }

    int adwin_tcp_fifo_empty(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{22, n, 0, 0};
        this.command_4p4(nArray2, nArray);
        return nArray[0];
    }

    void adwin_tcp_fifo_clear(int n) throws ADwinCommunicationError {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{21, n, 0, 0};
        this.command_4p4(nArray2, nArray);
    }

    void adwin_tcp_get_data_or_fifo_int32(int n, int[] nArray, int n2, int n3, int n4) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        if (n3 < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (n4 == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, n3);
        this.ati.req.max = n3 * 4;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_data_type_t2 = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        int n5 = n3 * this.bytes_per_value(adwin_data_type_t2);
        if (this.bytes_per_value(adwin_data_type_t2) < 0) {
            this.ati.status = 150;
            this.tcp_discard_pending(this.ati);
            return;
        }
        byte[] byArray = adwin_tcp_buffer_t2.data = new byte[n5];
        if (adwin_tcp_buffer_t2.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        adwin_tcp_buffer_t2.max = n5;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.used = 0;
        if (this.tcp_read_pending(this.ati, n5, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        switch (adwin_data_type_t2) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                this.convert_data_from_stream_to_int(byArray, nArray, n3);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fArray = new float[n3];
                this.convert_data_from_stream_to_float(byArray, fArray, n3);
                this.convert_data_from_float_to_int(fArray, nArray, n3);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] dArray = new double[n3];
                this.convert_data_from_stream_to_double(byArray, dArray, n3);
                this.convert_data_from_double_to_int(dArray, nArray, n3);
            }
        }
    }

    void adwin_tcp_get_data_or_fifo_int8(int n, byte[] byArray, int n2, int n3, int n4) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        if (n3 < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (n4 == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, n3);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_data_type_t2 = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        if (this.bytes_per_value(adwin_data_type_t2) != 1) {
            return;
        }
        int n5 = n3;
        byte[] byArray2 = adwin_tcp_buffer_t2.data = new byte[n5];
        if (adwin_tcp_buffer_t2.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        adwin_tcp_buffer_t2.max = n5;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.used = 0;
        if (this.tcp_read_pending(this.ati, n5, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        System.arraycopy(byArray2, 0, byArray, 0, n3);
    }

    void adwin_tcp_get_data_or_fifo_float(int n, float[] fArray, int n2, int n3, int n4) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        if (n3 < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (n4 == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, n3);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_data_type_t2 = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        int n5 = n3 * this.bytes_per_value(adwin_data_type_t2);
        if (this.bytes_per_value(adwin_data_type_t2) < 0) {
            this.ati.status = 150;
            this.tcp_discard_pending(this.ati);
            return;
        }
        byte[] byArray = adwin_tcp_buffer_t2.data = new byte[n5];
        if (adwin_tcp_buffer_t2.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        adwin_tcp_buffer_t2.max = n5;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.used = 0;
        if (this.tcp_read_pending(this.ati, n5, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        switch (adwin_data_type_t2) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] nArray = new int[n3];
                this.convert_data_from_stream_to_int(byArray, nArray, n3);
                this.convert_data_from_int_to_float(nArray, fArray, n3);
                break;
            }
            case ADWIN_FLOAT: {
                this.convert_data_from_stream_to_float(byArray, fArray, n3);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] dArray = new double[n3];
                this.convert_data_from_stream_to_double(byArray, dArray, n3);
                this.convert_data_from_double_to_float(dArray, fArray, n3);
            }
        }
    }

    void adwin_tcp_get_data_or_fifo_double(int n, double[] dArray, int n2, int n3, int n4) throws ADwinCommunicationError, IllegalArgumentException {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        if (n3 < 1) {
            throw new IllegalArgumentException("get_data count < 1");
        }
        if (n4 == 1) {
            this.init_ati(24);
        } else {
            this.init_ati(7);
        }
        this.ati.req.used = 12;
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, n3);
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 12, null) == -1) {
            return;
        }
        adwin_data_type_t adwin_data_type_t2 = this.int_to_adwin_data_type(ADwinDirectDevice.extractInt(this.ati.resp.data, 0));
        int n5 = n3 * this.bytes_per_value(adwin_data_type_t2);
        if (this.bytes_per_value(adwin_data_type_t2) < 0) {
            this.ati.status = 150;
            this.tcp_discard_pending(this.ati);
            return;
        }
        byte[] byArray = adwin_tcp_buffer_t2.data = new byte[n5];
        if (adwin_tcp_buffer_t2.data == null) {
            throw new ADwinCommunicationError("Not enough memory or memory access error.", "Nicht genug Speicher oder Speicherzugriffsfehler.", this.Language, 150);
        }
        adwin_tcp_buffer_t2.max = n5;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.used = 0;
        if (this.tcp_read_pending(this.ati, n5, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        if (this.tcp_read_pending(this.ati, 4, null) == -1) {
            return;
        }
        if (ADwinDirectDevice.extractInt(this.ati.resp.data, 0) != 0) {
            return;
        }
        switch (adwin_data_type_t2) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] nArray = new int[n3];
                this.convert_data_from_stream_to_int(byArray, nArray, n3);
                this.convert_data_from_int_to_double(nArray, dArray, n3);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fArray = new float[n3];
                this.convert_data_from_stream_to_float(byArray, fArray, n3);
                this.convert_data_from_float_to_double(fArray, dArray, n3);
                break;
            }
            case ADWIN_DOUBLE: {
                this.convert_data_from_stream_to_double(byArray, dArray, n3);
            }
        }
    }

    String adwin_tcp_get_data_string(int n, int n2) throws ADwinCommunicationError {
        int n3;
        byte[] byArray = new byte[n2];
        if (n2 < 1) {
            return "";
        }
        if (this.ati.processortype == 1012) {
            this.adwin_tcp_get_data_or_fifo_int8(n, byArray, 0, n2, 0);
            return new String(byArray);
        }
        byArray = new byte[4 * (n2 + 1)];
        int[] nArray = new int[n2 + 1];
        this.adwin_tcp_get_data_or_fifo_int32(n, nArray, 1, n2 + 1, 0);
        for (n3 = 0; n3 < n2 + 1; ++n3) {
            byArray[n3] = (byte)nArray[n3];
        }
        int n4 = byArray[0];
        byte[] byArray2 = new byte[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            byte by = byArray[n3 * 4 + 3];
            if (by <= 0 || by >= 256) {
                byArray2[n3] = 0;
                break;
            }
            byArray2[n3] = by;
        }
        byArray2[n4 - 1] = 0;
        return new String(byArray2);
    }

    int adwin_tcp_string_length(int n) throws ADwinCommunicationError {
        if (this.ati.processortype == 1012) {
            int[] nArray = new int[4];
            int[] nArray2 = new int[]{44, n, 0, 0};
            this.command_4p4(nArray2, nArray);
            return nArray[0];
        }
        int[] nArray = new int[4];
        this.adwin_tcp_get_data_or_fifo_int32(n, nArray, 1, 1, 0);
        return nArray[0];
    }

    void adwin_tcp_get_data_info(int n, int[] nArray) throws ADwinCommunicationError {
        this.init_ati(45);
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        this.ati.req.used = 4;
        if (this.tcp_write_request(this.ati, null) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 16, null) == -1) {
            return;
        }
        nArray[0] = ADwinDirectDevice.extractInt(this.ati.resp.data, 0);
        nArray[1] = ADwinDirectDevice.extractInt(this.ati.resp.data, 4);
        nArray[2] = ADwinDirectDevice.extractInt(this.ati.resp.data, 8);
        nArray[3] = ADwinDirectDevice.extractInt(this.ati.resp.data, 12);
    }

    void adwin_tcp_set_data_or_fifo_int8(int n, byte[] byArray, int n2, int n3, int n4) throws ADwinCommunicationError {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        if (n3 < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + n + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + n + " gesetzt werden!");
        }
        int[] nArray = new int[4];
        this.adwin_tcp_get_data_info(n, nArray);
        if (this.ati.error_number != 0) {
            return;
        }
        adwin_data_type_t adwin_data_type_t2 = this.int_to_adwin_data_type(nArray[0]);
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        if (n5 < n2 - 1 + n3) {
            throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
        }
        if (this.ati.processortype == 1012) {
            if (n6 == 1 && n4 == 1 && n3 > n5 - n7) {
                throw new ADwinCommunicationError("There is not enough space left in fifo " + n, "Nicht genug Platz \u00c3\u00bcbrig in Fifo " + n, this.Language, 101);
            }
            if (n4 == 1 && n6 == 0) {
                throw new ADwinCommunicationError("Data " + n + " isn't a fifo!", "Data " + n + " ist nicht als FIFO deklariert!", this.Language, 101);
            }
        }
        int n8 = n3 * this.bytes_per_value(adwin_data_type_t2);
        adwin_tcp_buffer_t2.data = new byte[n8];
        switch (adwin_data_type_t2) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] nArray2 = new int[n3];
                this.convert_data_from_byte_to_int(byArray, nArray2, n3);
                this.convert_data_from_int_to_stream(nArray2, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fArray = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    fArray[i] = byArray[i];
                }
                this.convert_data_from_float_to_stream(fArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = byArray[i];
                }
                this.convert_data_from_double_to_stream(dArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_BYTE: 
            case ADWIN_STRING: {
                adwin_tcp_buffer_t2.data = byArray;
                break;
            }
        }
        if (n4 == 1) {
            this.init_ati(25);
        } else {
            this.init_ati(8);
        }
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, n3);
        ADwinDirectDevice.setInteger(this.ati.req.data, 12, nArray[0]);
        this.ati.req.used = 16;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.used = n8;
        if (this.tcp_write_request(this.ati, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 0, null) == -1) {
            return;
        }
    }

    void adwin_tcp_set_data_or_fifo_int32(int n, int[] nArray, int n2, int n3, int n4) throws ADwinCommunicationError {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        if (n3 < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + n + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + n + " gesetzt werden!");
        }
        int[] nArray2 = new int[4];
        this.adwin_tcp_get_data_info(n, nArray2);
        if (this.ati.error_number != 0) {
            return;
        }
        adwin_data_type_t adwin_data_type_t2 = this.int_to_adwin_data_type(nArray2[0]);
        int n5 = nArray2[1];
        int n6 = nArray2[2];
        int n7 = nArray2[3];
        if (adwin_data_type_t2 == adwin_data_type_t.ADWIN_DATA_TYPE_INVALID) {
            throw new ADwinCommunicationError("The Data array is not declared", "Das Data ist nicht deklariert", this.Language, 103);
        }
        if (n5 < n2 - 1 + n3) {
            if (n4 == 0) {
                throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
            }
            throw new ADwinCommunicationError("The Fifo is too small or not enough values", "Das Fifo-Feld ist zu klein oder nicht genug Daten", this.Language, 101);
        }
        if (this.ati.processortype == 1012) {
            if (n6 == 1 && n4 == 1 && n3 > n5 - n7) {
                throw new ADwinCommunicationError("The Fifo is too small or not enough values", "Das Fifo-Feld ist zu klein oder nicht genug Daten", this.Language, 101);
            }
            if (n4 == 1 && n6 == 0) {
                throw new ADwinCommunicationError("Data " + n + " isn't a fifo!", "Data " + n + " ist nicht als FIFO deklariert!", this.Language, 101);
            }
        }
        int n8 = n3 * this.bytes_per_value(adwin_data_type_t2);
        adwin_tcp_buffer_t2.data = new byte[n8];
        switch (adwin_data_type_t2) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                this.convert_data_from_int_to_stream(nArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fArray = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    fArray[i] = nArray[i];
                }
                this.convert_data_from_float_to_stream(fArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = nArray[i];
                }
                this.convert_data_from_double_to_stream(dArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
        }
        if (n4 == 1) {
            this.init_ati(25);
        } else {
            this.init_ati(8);
        }
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, n3);
        ADwinDirectDevice.setInteger(this.ati.req.data, 12, nArray2[0]);
        this.ati.req.used = 16;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.used = n8;
        if (this.tcp_write_request(this.ati, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        if (this.tcp_read_response(this.ati, 0, null) == -1) {
            return;
        }
    }

    void adwin_tcp_set_data_or_fifo_float(int n, float[] fArray, int n2, int n3, int n4) throws ADwinCommunicationError {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        if (n3 < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + n + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + n + " gesetzt werden!");
        }
        int[] nArray = new int[4];
        this.adwin_tcp_get_data_info(n, nArray);
        if (this.ati.error_number != 0) {
            return;
        }
        adwin_data_type_t adwin_data_type_t2 = this.int_to_adwin_data_type(nArray[0]);
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        if (n5 < n2 - 1 + n3) {
            throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
        }
        if (this.ati.processortype == 1012) {
            if (n6 == 1 && n4 == 1 && n3 > n5 - n7) {
                throw new ADwinCommunicationError("There is not enough space left in fifo " + n, "Nicht genug Platz \u00c3\u00bcbrig in Fifo " + n, this.Language, 101);
            }
            if (n4 == 1 && n6 == 0) {
                throw new ADwinCommunicationError("Data " + n + " isn't a fifo!", "Data " + n + " ist nicht als FIFO deklariert!", this.Language, 101);
            }
        }
        int n8 = n3 * this.bytes_per_value(adwin_data_type_t2);
        adwin_tcp_buffer_t2.data = new byte[n8];
        switch (adwin_data_type_t2) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] nArray2 = new int[n3];
                this.convert_data_from_float_to_int(fArray, nArray2, n3);
                this.convert_data_from_int_to_stream(nArray2, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_FLOAT: {
                this.convert_data_from_float_to_stream(fArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_DOUBLE: {
                double[] dArray = new double[n3];
                this.convert_data_from_float_to_double(fArray, dArray, n3);
                this.convert_data_from_double_to_stream(dArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
        }
        if (n4 == 1) {
            this.init_ati(25);
        } else {
            this.init_ati(8);
        }
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, n3);
        ADwinDirectDevice.setInteger(this.ati.req.data, 12, nArray[0]);
        this.ati.req.used = 16;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.used = n8;
        if (this.tcp_write_request(this.ati, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        this.tcp_read_response(this.ati, 0, null);
    }

    void adwin_tcp_set_data_or_fifo_double(int n, double[] dArray, int n2, int n3, int n4) throws ADwinCommunicationError {
        adwin_tcp_buffer_t adwin_tcp_buffer_t2 = new adwin_tcp_buffer_t();
        if (n3 < 1) {
            throw new IllegalArgumentException(this.Language == 1 ? "setting DATA_" + n + ": Only a positive Number of elements can be set!" : "Nur eine positive Anzahl von Elementen kann bei DATA_" + n + " gesetzt werden!");
        }
        int[] nArray = new int[4];
        this.adwin_tcp_get_data_info(n, nArray);
        if (this.ati.error_number != 0) {
            return;
        }
        adwin_data_type_t adwin_data_type_t2 = this.int_to_adwin_data_type(nArray[0]);
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        if (n5 < n2 - 1 + n3) {
            throw new ADwinCommunicationError("Data is too small", "Data zu klein", this.Language, 100);
        }
        if (this.ati.processortype == 1012) {
            if (n6 == 1 && n4 == 1 && n3 > n5 - n7) {
                throw new ADwinCommunicationError("There is not enough space left in fifo " + n, "Nicht genug Platz \u00c3\u00bcbrig in Fifo " + n, this.Language, 101);
            }
            if (n4 == 1 && n6 == 0) {
                throw new ADwinCommunicationError("Data " + n + " isn't a fifo!", "Data " + n + " ist nicht als FIFO deklariert!", this.Language, 101);
            }
        }
        int n8 = n3 * this.bytes_per_value(adwin_data_type_t2);
        adwin_tcp_buffer_t2.data = new byte[n8];
        switch (adwin_data_type_t2) {
            case ADWIN_LONG: 
            case ADWIN_INTEGER: {
                int[] nArray2 = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray2[i] = (int)dArray[i];
                }
                this.convert_data_from_int_to_stream(nArray2, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_FLOAT: {
                float[] fArray = new float[n3];
                this.convert_data_from_double_to_float(dArray, fArray, n3);
                this.convert_data_from_float_to_stream(fArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
            case ADWIN_DOUBLE: {
                this.convert_data_from_double_to_stream(dArray, adwin_tcp_buffer_t2.data, n3);
                break;
            }
        }
        if (n4 == 1) {
            this.init_ati(25);
        } else {
            this.init_ati(8);
        }
        ADwinDirectDevice.setInteger(this.ati.req.data, 0, n);
        ADwinDirectDevice.setInteger(this.ati.req.data, 4, n2);
        ADwinDirectDevice.setInteger(this.ati.req.data, 8, n3);
        ADwinDirectDevice.setInteger(this.ati.req.data, 12, nArray[0]);
        this.ati.req.used = 16;
        adwin_tcp_buffer_t2.do_convert = 0;
        adwin_tcp_buffer_t2.used = n8;
        if (this.tcp_write_request(this.ati, adwin_tcp_buffer_t2) == -1) {
            return;
        }
        this.tcp_read_response(this.ati, 0, null);
    }

    void adwin_tcp_set_data_string(int n, String string, int n2) throws ADwinCommunicationError {
        int n3 = string.length();
        if (n3 > n2) {
            n3 = n2;
        }
        if (this.ati.processortype == 1012) {
            byte[] byArray = string.getBytes();
            int n4 = byArray.length + 1;
            byte[] byArray2 = new byte[n4];
            for (int i = 0; i < n4 - 1; ++i) {
                byArray2[i] = byArray[i];
            }
            byArray2[n4 - 1] = 0;
            this.adwin_tcp_set_data_or_fifo_int8(n, byArray2, 0, n4, 0);
        } else {
            int[] nArray = new int[n3 + 2];
            nArray[0] = n3;
            for (int i = 0; i < n3; ++i) {
                nArray[i + 1] = string.charAt(i);
            }
            nArray[n3 + 1] = 0;
            this.adwin_tcp_set_data_or_fifo_int32(n, nArray, 1, n3 + 2, 0);
        }
    }

    void convert_data_from_stream_to_int(byte[] byArray, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = ADwinDirectDevice.extractInt(byArray, i * 4);
        }
    }

    void convert_data_from_stream_to_long(byte[] byArray, long[] lArray, int n) {
        for (int i = 0; i < n; ++i) {
            lArray[i] = ADwinDirectDevice.extractLong(byArray, i * 8);
        }
    }

    void convert_data_from_stream_to_float(byte[] byArray, float[] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.intBitsToFloat(ADwinDirectDevice.extractInt(byArray, i * 4));
        }
    }

    void convert_data_from_stream_to_double(byte[] byArray, double[] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            dArray[i] = ByteBuffer.wrap(byArray, i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        }
    }

    void convert_data_from_int_to_stream(int[] nArray, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            ADwinDirectDevice.setInteger(byArray, i * 4, nArray[i]);
        }
    }

    void convert_data_from_long_to_stream(long[] lArray, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            ADwinDirectDevice.setLong(byArray, i * 8, lArray[i]);
        }
    }

    void convert_data_from_float_to_stream(float[] fArray, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            ADwinDirectDevice.setInteger(byArray, i * 4, Float.floatToIntBits(fArray[i]));
        }
    }

    void convert_data_from_double_to_stream(double[] dArray, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            ByteBuffer.wrap(byArray, i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).putDouble(dArray[i]);
        }
    }

    void convert_data_from_float_to_int(float[] fArray, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)fArray[i];
        }
    }

    void convert_data_from_float_to_long(float[] fArray, long[] lArray, int n) {
        for (int i = 0; i < n; ++i) {
            lArray[i] = Float.floatToIntBits(fArray[i]);
        }
    }

    void convert_data_from_float_to_double(float[] fArray, double[] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            dArray[i] = fArray[i];
        }
    }

    void convert_data_from_byte_to_int(byte[] byArray, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = byArray[i];
        }
    }

    void convert_data_from_int_to_byte(int[] nArray, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)nArray[i];
        }
    }

    void convert_data_from_int_to_float(int[] nArray, float[] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            fArray[i] = nArray[i];
        }
    }

    void convert_data_from_int_to_double(int[] nArray, double[] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            dArray[i] = nArray[i];
        }
    }

    void convert_data_from_double_to_float(double[] dArray, float[] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)dArray[i];
        }
    }

    void convert_data_from_double_to_int(double[] dArray, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)dArray[i];
        }
    }

    int map_error_code(int n) {
        switch (n) {
            case -1: {
                return 2001;
            }
            case -5: {
                return 2002;
            }
            case -31: {
                return 100;
            }
            case -32: {
                return 102;
            }
            case -35: {
                return 205;
            }
        }
        return n;
    }

    public class adwin_tcp_info_t {
        public InetAddress server_addr;
        public int firmware_version;
        public int firmware_version_beta;
        public int error_number;
        public int processortype;
        public boolean connected;
        public boolean initialized;
        public Socket socket;
        public int timeout_ms;
        public int timeout_size;
        public int dll_version;
        public int req_count;
        public int command;
        public int status;
        public adwin_tcp_buffer_t req;
        public int rx_pending;
        public adwin_tcp_buffer_t resp;
        InputStream stream_in;
        OutputStream stream_out;
    }

    public class adwin_tcp_buffer_t {
        public int max;
        public int used;
        public int do_convert;
        public byte[] data;
        public boolean as_char;
    }

    public class adwin_tcp_header_t {
        public int magic_flag;
        public int req_count;
        public int length;
        public int command_or_status;
    }

    static enum adwin_data_type_t {
        ADWIN_DATA_TYPE_INVALID,
        ADWIN_BYTE,
        ADWIN_SHORT,
        ADWIN_LONG,
        ADWIN_INTEGER,
        ADWIN_FLOAT,
        ADWIN_DOUBLE,
        ADWIN_INT64,
        ADWIN_STRING,
        ADWIN_VARIANT;

    }

    public class myVARIANT {
        public short typ;
        public int idummy;
        public short sdummy;
        public long val;
    }
}

