/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommand;
import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDirectDevice;
import de.adwin.driver.DataToArrayConverter;
import de.adwin.driver.GetDataSHQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

class DataFieldTransfer {
    private final int CMD_GET_FIFO_RETRY = 124;
    private final int CMD_GET_FIFO = 24;
    final InetAddress Connection;
    final DatagramSocket ds;
    final ADwinDirectDevice adw;

    DataFieldTransfer(InetAddress inetAddress, DatagramSocket datagramSocket, ADwinDirectDevice aDwinDirectDevice) {
        this.Connection = inetAddress;
        this.ds = datagramSocket;
        this.adw = aDwinDirectDevice;
    }

    void receive(int n, DataToArrayConverter dataToArrayConverter, String string) throws ADwinCommunicationError {
        if (this.adw.adl != null) {
            this.adw.adl.enter("DataFieldTransfer.receive (" + n + ", <DTAC>, \"" + string + "\")");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.adw.AllowedErrors;
        byte[] byArray = new byte[1408];
        byte[] byArray2 = new byte[32];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 1408);
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, 32, this.Connection, this.adw.Port);
        try {
            this.ds.setSoTimeout(this.adw.MaxPacketDelay);
        }
        catch (IOException iOException) {
            if (this.adw.adl != null) {
                this.adw.adl.leave();
            }
            throw new ADwinCommunicationError("Cannot set timeout for socket - " + iOException.getMessage(), "Kann Timeout f\u00c3\u00bcr Socket nicht festlegen - " + iOException.getMessage(), this.adw.Language, 2000);
        }
        while (n2 < n) {
            int n5;
            int n6;
            int n7;
            int n8;
            boolean[] blArray = new boolean[this.adw.DataBlockSize];
            for (n8 = 0; n8 < this.adw.DataBlockSize; ++n8) {
                blArray[n8] = false;
            }
            n8 = (n - n2 - 1) / 350 + 1;
            if (n8 > this.adw.DataBlockSize) {
                n8 = this.adw.DataBlockSize;
            }
            ++n3;
            for (n7 = 0; n7 < n8; ++n7) {
                boolean bl = true;
                try {
                    this.ds.receive(datagramPacket);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("Timeout beim empfangen vom DATA", 50);
                    }
                    bl = false;
                }
                catch (IOException iOException) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("IOException -> ADwinCommunicationError in DataFieldTransfer.receive", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Exception: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.adw.Language, 2000);
                }
                if (!bl) break;
                n6 = ADwinDirectDevice.extractInt(byArray, 0);
                if (n6 < 0) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("Block index < 0 received", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("Invalid block index received when receiving " + string + ".", "Ung\u00c3\u00bcltigen Blockindex beim Empfangen von " + string + " empfangen", this.adw.Language, 2000);
                }
                if (n6 != n3) {
                    --n7;
                    if (this.adw.adl == null) continue;
                    this.adw.adl.message("Ung\u00c3\u00bcltiger Block-Index (Erwartet: " + n3 + ", erhalten: " + n6 + ")", 50);
                    continue;
                }
                if (datagramPacket.getLength() != 1408) {
                    --n7;
                    if (this.adw.adl == null) continue;
                    this.adw.adl.message("Falsche Gr\u00c3\u00b6\u00c3\u0178e: " + datagramPacket.getLength(), 50);
                    continue;
                }
                n5 = ADwinDirectDevice.extractInt(byArray, 4);
                blArray[n5] = true;
                int n9 = n2 + (n5 + 1) * 350 <= n ? 350 : n % 350;
                dataToArrayConverter.storeBytes(byArray, 8, n2 + n5 * 350, n9);
            }
            n7 = n8 + 1;
            n6 = 0;
            for (n5 = 0; n5 < this.adw.DataBlockSize; ++n5) {
                if (!blArray[n5] && n7 == n8 + 1) {
                    n7 = n5;
                }
                if (!blArray[n5]) continue;
                n6 = 1;
            }
            if (n7 > n8) {
                n7 = n8;
            }
            if (n6 == 0) {
                --n3;
            }
            n2 += n7 * 350;
            if (n7 == 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Keine Pakete empfangen (WordsReceived = " + n2 + ")", 50);
                }
                --n4;
            } else {
                n4 = this.adw.AllowedErrors;
            }
            if (n4 == 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Could not receive packets for " + string + ", number of timeouts exceeded AllowedErrors", "Konnte Pakete f\u00c3\u00bcr " + string + " nicht empfangen, Anzahl der erlaubten Timeouts \u00c3\u00bcberschritten", this.adw.Language, 2001);
            }
            if (n6 != 0) {
                for (n5 = 0; n5 < 32; ++n5) {
                    byArray2[n5] = 0;
                }
                if (n7 != n8) {
                    ADwinDirectDevice.setInteger(byArray2, 0, -20);
                    ADwinDirectDevice.setInteger(byArray2, 4, n3);
                    ADwinDirectDevice.setInteger(byArray2, 8, n7);
                } else {
                    ADwinDirectDevice.setInteger(byArray2, 0, 0);
                    ADwinDirectDevice.setInteger(byArray2, 4, n3);
                    ADwinDirectDevice.setInteger(byArray2, 8, 0);
                }
            }
            try {
                this.ds.send(datagramPacket2);
            }
            catch (IOException iOException) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.adw.Language, 2000);
            }
        }
        if (this.adw.adl != null) {
            this.adw.adl.leave();
        }
    }

    int receiveFast(int n, DataToArrayConverter dataToArrayConverter, int n2, int n3, int[] nArray) throws ADwinCommunicationError {
        int n4;
        byte[] byArray = new byte[1416];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 1416);
        int n5 = (n - 1) / 350 + 1;
        boolean[] blArray = new boolean[n5];
        boolean bl = true;
        try {
            this.ds.setSoTimeout(this.adw.MaxPacketDelay);
        }
        catch (IOException iOException) {
            throw new ADwinCommunicationError("Cannot set timeout for socket - " + iOException.getMessage(), "Kann Timeout f\u00c3\u00bcr Socket nicht festlegen - " + iOException.getMessage(), this.adw.Language, 2000);
        }
        for (n4 = 0; n4 < n5 && bl; ++n4) {
            int n6;
            bl = true;
            try {
                this.ds.receive(datagramPacket);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                bl = false;
            }
            catch (IOException iOException) {
                throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.adw.Language, 2000);
            }
            if (!bl) continue;
            if (!this.adw.newTryLater() && ADwinDirectDevice.extractInt(byArray, 0) == -10) break;
            if (ADwinDirectDevice.extractInt(byArray, 4) != n3) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Falscher Paket-Index empfangen, erwartet: " + n3 + ", erhalten: " + ADwinDirectDevice.extractInt(byArray, 4), 50);
                }
                --n4;
                continue;
            }
            if (ADwinDirectDevice.extractInt(byArray, 0) != 0) break;
            int n7 = ADwinDirectDevice.extractInt(byArray, 1408);
            blArray[n7] = true;
            if (n7 == n5 - 1) {
                n6 = n % 350;
                if (n6 == 0) {
                    n6 = 350;
                }
            } else {
                n6 = 350;
            }
            if (dataToArrayConverter.getSourceType() == 0) {
                dataToArrayConverter.setSourceType(ADwinDirectDevice.extractInt(byArray, 1412));
            }
            dataToArrayConverter.storeBytes(byArray, 8, n7 * 350 + n2, n6);
        }
        for (n4 = 0; n4 < n5 && blArray[n4]; ++n4) {
        }
        nArray[0] = n4 * 350;
        if (bl) {
            return ADwinDirectDevice.extractInt(byArray, 0);
        }
        return 0;
    }

    void send(int n, byte[] byArray, String string, int n2) throws ADwinCommunicationError {
        if (this.adw.adl != null) {
            this.adw.adl.enter("DataFieldTransfer.send (" + n + ", <byte[]>, \"" + string + "\")");
        }
        byte[] byArray2 = new byte[1408];
        byte[] byArray3 = new byte[32];
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, this.Connection, this.adw.Port);
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray3, 32);
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        while (n3 > 0) {
            int n7;
            int n8;
            int n9 = (n3 - 1) / 1400 + 1;
            if (n9 > this.adw.DataBlockSize) {
                n9 = this.adw.DataBlockSize;
            }
            for (n8 = 0; n8 < n9 && !bl; ++n8) {
                int n10;
                if (n6 + (n8 + 1) * 350 * 4 > n) {
                    n10 = n3 % 1400;
                    if (n10 == 0) {
                        n10 = 1400;
                    }
                } else {
                    n10 = 1400;
                }
                for (n7 = 0; n7 < n10; ++n7) {
                    byArray2[n7 + 8] = byArray[n7 + n6 + n8 * 350 * 4];
                }
                ADwinDirectDevice.setInteger(byArray2, 0, n4 + 1);
                ADwinDirectDevice.setInteger(byArray2, 4, n8);
                try {
                    this.ds.send(datagramPacket);
                    continue;
                }
                catch (IOException iOException) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.adw.Language, 2000);
                }
            }
            bl = false;
            n8 = 0;
            try {
                this.ds.setSoTimeout(this.adw.MaxPacketDelay * 2 + this.adw.ADwTimeout);
                this.ds.receive(datagramPacket2);
                n8 = 1;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("SocketTimeoutException beim Warten auf Best\u00c3\u00a4tigung", 50);
                }
            }
            catch (IOException iOException) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.adw.Language, 2000);
            }
            if (n8 == 0 || ADwinDirectDevice.extractInt(byArray3, 4) != n4 + 1) {
                if (n8 != 0) {
                    int n11 = ADwinDirectDevice.extractInt(byArray3, 4);
                    n7 = ADwinDirectDevice.extractInt(byArray3, 0);
                    if (n11 == n2) {
                        if (this.adw.adl != null) {
                            this.adw.adl.message("SetData - Paket mit BlockIndex == requestPacketIndex (= " + n11 + ") empfangen, Status = " + n7, 50);
                        }
                        switch (n7) {
                            case 1: {
                                if (this.adw.adl != null) {
                                    this.adw.adl.leave();
                                }
                                throw new ADwinCommunicationError("Timeout to link when trying to send " + string, "Timeout beim Schreiben zum ADwin-System beim senden von " + string, this.adw.Language, 1);
                            }
                            case 2: {
                                if (this.adw.adl != null) {
                                    this.adw.adl.leave();
                                }
                                throw new ADwinCommunicationError("Timeout from link when trying to send " + string, "Timeout beim Lesen vom ADwin-System beim senden von " + string, this.adw.Language, 2);
                            }
                            case 5: {
                                if (this.adw.adl != null) {
                                    this.adw.adl.leave();
                                }
                                throw new ADwinCommunicationError("Too many block errors when sending " + string, "Zu viele fehlerhafte Bl\u00c3\u00b6cke beim Senden von " + string, this.adw.Language, 2000);
                            }
                        }
                    }
                    if (n11 == n4 && n5 > 1) {
                        if (this.adw.adl != null) {
                            this.adw.adl.message("Best\u00c3\u00a4tigung f\u00c3\u00bcr alten Block erhalten, sende den gleichen Block nochmal.", 50);
                        }
                        if (++n5 > this.adw.AllowedErrors) {
                            if (this.adw.adl != null) {
                                this.adw.adl.message("Zu viele Fehler auf einmal -> Exception", 1);
                                this.adw.adl.leave();
                            }
                            throw new ADwinCommunicationError("Cannot send " + string, "Kann " + string + " nicht senden", this.adw.Language, 2000);
                        }
                        bl = true;
                        continue;
                    }
                    if (this.adw.adl != null) {
                        this.adw.adl.message("F\u00c3\u00bcr Best\u00c3\u00a4tigung: Erwartet: " + (n4 + 1) + ", erhalten: " + ADwinDirectDevice.extractInt(byArray3, 4), 50);
                    }
                    bl = true;
                }
                if (++n5 <= this.adw.AllowedErrors) continue;
                if (this.adw.adl != null) {
                    this.adw.adl.message("Zu viele Fehler auf einmal -> Exception", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Cannot send " + string, "Kann " + string + " nicht senden", this.adw.Language, 2000);
            }
            ++n4;
            n5 = 0;
            if (ADwinDirectDevice.extractInt(byArray3, 0) == 5) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Error 5...", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Too many block errors when sending " + string, "Zu viele fehlerhafte Bl\u00c3\u00b6cke beim Senden von " + string, this.adw.Language, 2000);
            }
            if (ADwinDirectDevice.extractInt(byArray3, 0) != 0) {
                int n12 = ADwinDirectDevice.extractInt(byArray3, 8);
                n3 -= n12 * 350 * 4;
                n6 += n12 * 350 * 4;
                continue;
            }
            n3 -= this.adw.DataBlockSize * 350 * 4;
            n6 += this.adw.DataBlockSize * 350 * 4;
        }
        if (this.adw.adl != null) {
            this.adw.adl.leave();
        }
    }

    void getArraySH(int n, int n2, DataToArrayConverter dataToArrayConverter, int n3, int n4, InetAddress inetAddress, int n5) throws ADwinCommunicationError {
        GetDataSHQueue getDataSHQueue = new GetDataSHQueue(40, n, this.ds, this.adw, inetAddress, n5);
        getDataSHQueue.getArraySH(n2, dataToArrayConverter, n3, n4);
    }

    void readFifo(int n, int n2, int n3, DataToArrayConverter dataToArrayConverter, int n4) throws ADwinCommunicationError {
        if (this.adw.adl != null) {
            this.adw.adl.enter("DataFieldTransfer.readFifo (" + n + ", " + n2 + ", " + n3 + ", <DTAC>, " + n4 + ")");
        }
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray = new byte[1408];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 1408);
        int n7 = this.adw.AllowedErrors;
        int n8 = this.adw.NumWaits;
        int n9 = (n3 - 1) / 350 + 1;
        while (!bl) {
            int n10;
            if (n7 < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Too many errors", "zu viele Fehler", this.adw.Language, 2001);
            }
            if (n8 < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("Too many try-later-packets", "zu viele Try-Later-Pakete", this.adw.Language, 16);
            }
            ADwinCommand aDwinCommand = new ADwinCommand(this.adw.version, this.adw.DLLVersion, this.adw.Port);
            aDwinCommand.setPwd(this.adw.Password);
            aDwinCommand.setTimeout(this.adw.ADwTimeout);
            int[] nArray = new int[]{n2, n + (this.adw.DataBlockSize << 16), 0, n3};
            aDwinCommand.setValues(nArray);
            if (bl2) {
                nArray[2] = n6;
                aDwinCommand.setValues(nArray);
                aDwinCommand.setPacketIndex(n5);
                aDwinCommand.setCommand(124);
            } else {
                nArray[2] = 0;
                aDwinCommand.setValues(nArray);
                n6 = n5 = this.adw.incGetCurrentIndex();
                aDwinCommand.setPacketIndex(n5);
                aDwinCommand.setCommand(24);
            }
            try {
                this.ds.send(aDwinCommand.getDatagram(this.Connection));
            }
            catch (IOException iOException) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.adw.Language, 2000);
            }
            try {
                this.ds.setSoTimeout(this.adw.MaxPacketDelay);
                this.ds.receive(datagramPacket);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Timeout beim warten auf 1. Datenpaket", 50);
                }
                bl2 = true;
                --n7;
                continue;
            }
            catch (IOException iOException) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                    this.adw.adl.leave();
                }
                throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.adw.Language, 2000);
            }
            if (ADwinDirectDevice.extractInt(byArray, 0) == -10) {
                if (this.adw.adl != null) {
                    this.adw.adl.tryLater(n5, this.adw.NumWaits - n8);
                }
                try {
                    Thread.sleep(this.adw.WaitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --n8;
                n7 = this.adw.AllowedErrors;
                continue;
            }
            n8 = this.adw.NumWaits;
            if (ADwinDirectDevice.extractInt(byArray, 0) == -41) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Fehler -41 => Anfrage wird nochmal verschickt", 50);
                }
                bl2 = false;
                continue;
            }
            if (ADwinDirectDevice.extractInt(byArray, 0) == -32) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("No more data in fifo", 1);
                }
                throw new ADwinCommunicationError("Not enough data in fifo", "Nicht genug Daten im Fifo", this.adw.Language, 102);
            }
            if (ADwinDirectDevice.extractInt(byArray, 0) < 0) {
                if (this.adw.adl != null) {
                    this.adw.adl.message("Fehler " + ADwinDirectDevice.extractInt(byArray, 0) + " => Retry-Paket wird verschickt", 50);
                }
                bl2 = true;
                --n7;
                continue;
            }
            bl2 = false;
            boolean[] blArray = new boolean[n9];
            for (n10 = 0; n10 < n9; ++n10) {
                blArray[n10] = false;
            }
            do {
                if (ADwinDirectDevice.extractInt(byArray, 0) == n5) {
                    int n11 = ADwinDirectDevice.extractInt(byArray, 4);
                    int n12 = n11 != n9 - 1 ? 350 : n3 % 350;
                    if (n12 == 0) {
                        n12 = 350;
                    }
                    dataToArrayConverter.storeBytes(byArray, 8, n4 + n11 * 350, n12);
                    blArray[n11] = true;
                    bl = true;
                    for (int i = 0; i < n9; ++i) {
                        bl = bl && blArray[i];
                    }
                    if (bl) {
                        break;
                    }
                } else if (this.adw.adl != null) {
                    this.adw.adl.message("Falscher Paket-Index empfangen (erhalten: " + ADwinDirectDevice.extractInt(byArray, 0) + ", erwartet: " + n5 + ")", 50);
                }
                n10 = 1;
                try {
                    this.ds.receive(datagramPacket);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    n10 = 0;
                }
                catch (IOException iOException) {
                    if (this.adw.adl != null) {
                        this.adw.adl.message("IOException -> ADwinCommunicationError", 1);
                        this.adw.adl.leave();
                    }
                    throw new ADwinCommunicationError("I/O-Error: " + iOException.getMessage(), "E/A-Fehler: " + iOException.getMessage(), this.adw.Language, 2000);
                }
            } while (n10 != 0);
            if (bl) continue;
            if (this.adw.adl != null) {
                this.adw.adl.message("Nicht alles empfangen => Retry", 50);
            }
            --n7;
            bl2 = true;
        }
        if (this.adw.adl != null) {
            this.adw.adl.leave();
        }
    }
}

