/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.examples;

import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDevice;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Demo
extends JApplet
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    boolean runningAsApplet = false;
    private JTextField fTextfieldIP;
    private JTextField fTextfieldPAR1;
    private JRadioButton fRadioT9;
    private JRadioButton fRadioT10;
    private JRadioButton fRadioT11;
    private JRadioButton fRadioT12;
    private ADwinDevice fADwin;
    private boolean fADwinBooted;

    @Override
    public void init() {
        this.runningAsApplet = true;
        this.showUIapplet();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block27: {
            if (actionEvent.getActionCommand().equals("boot")) {
                this.fADwinBooted = false;
                try {
                    String string;
                    String string2;
                    if (this.fADwin == null) {
                        this.fADwin = new ADwinDevice();
                    }
                    if ((string2 = this.fTextfieldIP.getText()).equals("")) break block27;
                    this.fADwin.Remove_Entry(1);
                    this.fADwin.Add_Entry(1, InetAddress.getByName(string2), "", 1000, 6543);
                    this.fADwin.Set_DeviceNo(1);
                    if (new File("/etc/adwin/ADWINDIR").exists()) {
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new FileReader("/etc/adwin/ADWINDIR"));
                            string = bufferedReader.readLine() + "/share/btl/";
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(this, "I/O-Error when reading from /etc/adwin/ADWINDIR -\n" + iOException.getMessage(), "Error", 0);
                            return;
                        }
                    } else {
                        string = new File("/opt/adwin/share/btl").exists() ? "/opt/adwin/share/btl/" : "c:\\adwin\\";
                    }
                    try {
                        if (this.fRadioT9.isSelected()) {
                            this.fADwin.Boot(string + "adwin9.btl");
                        } else if (this.fRadioT10.isSelected()) {
                            this.fADwin.Boot(string + "adwin10.btl");
                        } else if (this.fRadioT11.isSelected()) {
                            this.fADwin.Boot(string + "adwin11.btl");
                        } else {
                            this.fADwin.Boot(string + "adwin12.btl");
                        }
                    }
                    catch (ADwinCommunicationError aDwinCommunicationError) {
                        if (aDwinCommunicationError.getCode() != 200) {
                            throw aDwinCommunicationError;
                        }
                        this.bootFromJARFile();
                    }
                    this.fADwinBooted = true;
                }
                catch (UnknownHostException unknownHostException) {
                    JOptionPane.showMessageDialog(this, unknownHostException, "Error", 0);
                }
                catch (ADwinCommunicationError aDwinCommunicationError) {
                    JOptionPane.showMessageDialog(this, aDwinCommunicationError, "Error", 0);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, iOException, "Error", 0);
                }
                catch (SecurityException securityException) {
                    try {
                        this.bootFromJARFile();
                        this.fADwinBooted = true;
                    }
                    catch (ADwinCommunicationError aDwinCommunicationError) {
                        JOptionPane.showMessageDialog(this, aDwinCommunicationError, "Error", 0);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, iOException, "Error", 0);
                    }
                }
            } else if (actionEvent.getActionCommand().equals("SetPar") && this.fADwinBooted) {
                try {
                    this.fADwin.Set_Par(1, Integer.parseInt(this.fTextfieldPAR1.getText()));
                }
                catch (ADwinCommunicationError aDwinCommunicationError) {
                    JOptionPane.showMessageDialog(this, "Error when setting PAR_1 - " + aDwinCommunicationError.getMessage(), "Error", 0);
                    this.fADwinBooted = false;
                }
            }
        }
    }

    void bootFromJARFile() throws ADwinCommunicationError, IOException {
        URL uRL = this.fRadioT9.isSelected() ? this.getClass().getClassLoader().getResource("adwin9.btl") : (this.fRadioT10.isSelected() ? this.getClass().getClassLoader().getResource("adwin10.btl") : (this.fRadioT11.isSelected() ? this.getClass().getClassLoader().getResource("adwin11.btl") : this.getClass().getClassLoader().getResource("adwin12.btl")));
        if (uRL == null) {
            JOptionPane.showMessageDialog(this, "BTL files could neither be found on your disk nor in the JAR archive\nPlease check your ADwin installation", "Error", 0);
            return;
        }
        this.fADwin.Boot(uRL);
    }

    private void showUIapplet() {
        Container container = this.getContentPane();
        this.showUI(container);
    }

    private void showUIapplication() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setLocation(100, 100);
        jFrame.setTitle("ADwin Java Demo");
        Container container = jFrame.getContentPane();
        this.showUI(container);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private void showUI(Container container) {
        this.fADwinBooted = false;
        GridBagLayout gridBagLayout = new GridBagLayout();
        Insets insets = new Insets(4, 4, 4, 4);
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("IP address");
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.fTextfieldIP = new JTextField(16);
        container.add((Component)this.fTextfieldIP, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 1, insets, 0, 0));
        jLabel = new JLabel("Processor");
        container.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        JPanel jPanel = new JPanel();
        this.fRadioT9 = new JRadioButton("T9");
        this.fRadioT9.setActionCommand("T9");
        this.fRadioT9.addActionListener(this);
        this.fRadioT9.setSelected(true);
        jPanel.add(this.fRadioT9);
        this.fRadioT10 = new JRadioButton("T10");
        this.fRadioT10.setActionCommand("T10");
        this.fRadioT10.addActionListener(this);
        jPanel.add(this.fRadioT10);
        this.fRadioT11 = new JRadioButton("T11");
        this.fRadioT11.setActionCommand("T11");
        this.fRadioT11.addActionListener(this);
        jPanel.add(this.fRadioT11);
        this.fRadioT12 = new JRadioButton("T12");
        this.fRadioT12.setActionCommand("T12");
        this.fRadioT12.addActionListener(this);
        jPanel.add(this.fRadioT12);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fRadioT9);
        buttonGroup.add(this.fRadioT10);
        buttonGroup.add(this.fRadioT11);
        buttonGroup.add(this.fRadioT12);
        container.add((Component)jPanel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        JButton jButton = new JButton("Boot");
        jButton.setActionCommand("boot");
        jButton.addActionListener(this);
        container.add((Component)jButton, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        jLabel = new JLabel("PAR_1");
        container.add((Component)jLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.fTextfieldPAR1 = new JTextField(10);
        this.fTextfieldPAR1.addFocusListener(this);
        container.add((Component)this.fTextfieldPAR1, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0));
        JButton jButton2 = new JButton("Set");
        jButton2.setActionCommand("SetPar");
        jButton2.addActionListener(this);
        container.add((Component)jButton2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        DemoTimerTask demoTimerTask = new DemoTimerTask();
        Timer timer = new Timer();
        timer.schedule((TimerTask)demoTimerTask, 0L, 1000L);
    }

    public static void main(String[] stringArray) {
        Demo demo = new Demo();
        demo.showUIapplication();
    }

    class DemoTimerTask
    extends TimerTask {
        DemoTimerTask() {
        }

        @Override
        public void run() {
            try {
                if (Demo.this.fADwinBooted && !Demo.this.fTextfieldPAR1.hasFocus()) {
                    Demo.this.fTextfieldPAR1.setText(Integer.toString(Demo.this.fADwin.Get_Par(1)));
                }
            }
            catch (ADwinCommunicationError aDwinCommunicationError) {
                Demo.this.fADwinBooted = false;
                aDwinCommunicationError.printStackTrace();
            }
        }
    }
}

