package de.adwin.examples;

import java.util.*;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.File;
import java.io.FileReader;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import de.adwin.driver.*;

public class Demo extends JApplet implements ActionListener, FocusListener
{
    private final static long serialVersionUID = 1;
    boolean runningAsApplet = false;

    class DemoTimerTask extends TimerTask
    {
        public void run()
        {
            try {
                if (fADwinBooted == true) {
                    if (fTextfieldPAR1.hasFocus() == false) {
                        fTextfieldPAR1.setText(Integer.toString(fADwin.Get_Par(1)));
                    }
                }
            } catch (ADwinCommunicationError ex) {
                fADwinBooted = false;
                ex.printStackTrace ();
            }
        }
    }

    private JTextField fTextfieldIP;
    private JTextField fTextfieldPAR1;
    private JRadioButton fRadioT9;
    private JRadioButton fRadioT10;
    private JRadioButton fRadioT11;
    private JRadioButton fRadioT12;

    private ADwinDevice fADwin;
    private boolean fADwinBooted;

    public void init()
    {
        runningAsApplet = true;
        showUIapplet();
    }

    public void start()
    {
    }

    public void stop()
    {
    }

    public void destroy()
    {
    }

    public void focusLost(FocusEvent e)
    {
    }

    public void focusGained(FocusEvent e)
    {
    }

    public void actionPerformed(ActionEvent e)
    {
        // boot

        final String basePathName;
        
        if (e.getActionCommand().equals("boot")) {
            fADwinBooted = false;
            // the following code first tries to load a matching BTL file from disk (depending on the
            // underlaying OS, there are many possibilities where they can be).
            // If it does not work, the code assumes it is in a JAR file, tries to load the
            // BTL as a resource and uses an undocumented version of the Boot method to boot the ADwin system
            try {
                if (fADwin == null) {
                    fADwin = new ADwinDevice();
                }

                String ip = fTextfieldIP.getText();
                if (!ip.equals("")) {
                    fADwin.Remove_Entry(0x01);
                    fADwin.Add_Entry(0x01, InetAddress.getByName(ip), "", 1000, 6543);
                    fADwin.Set_DeviceNo(0x01);

                    if (new File ("/etc/adwin/ADWINDIR").exists ()) {   // See where the BTL files are....
                        // (Linux new)
                        try {
                            final BufferedReader reader = new BufferedReader (new FileReader ("/etc/adwin/ADWINDIR"));
                            basePathName = reader.readLine () + "/share/btl/";
                            reader.close ();
                        } catch (IOException ioe) {
                            JOptionPane.showMessageDialog  (this, "I/O-Error when reading from /etc/adwin/ADWINDIR -\n" + ioe.getMessage (), "Error", JOptionPane.ERROR_MESSAGE);
                            return;
                        }
                    } else if (new File ("/opt/adwin/share/btl").exists ())
                        basePathName = "/opt/adwin/share/btl/";         // (Linux old)
                    else
                        basePathName = "c:\\adwin\\";                   // Windows

                    try {
                        if (fRadioT9.isSelected ())                     // T9
                            fADwin.Boot (basePathName + "adwin9.btl");
                        else if (fRadioT10.isSelected ())               // T10
                            fADwin.Boot (basePathName + "adwin10.btl");
                        else if (fRadioT11.isSelected ())               // T11
                            fADwin.Boot (basePathName + "adwin11.btl");
                        else                                            // T12
                            fADwin.Boot (basePathName + "adwin12.btl");
                    } catch (ADwinCommunicationError ace) {
                        if (ace.getCode () != 200) throw ace;
                        // couldn't load the file from disk, so try to load as a resource
                        bootFromJARFile ();
                    }
                    fADwinBooted = true;
                }
            } catch (UnknownHostException ex) {
                JOptionPane.showMessageDialog  (this, ex, "Error", JOptionPane.ERROR_MESSAGE);
            } catch (ADwinCommunicationError ex) {
                JOptionPane.showMessageDialog  (this, ex, "Error", JOptionPane.ERROR_MESSAGE);
            } catch (IOException ex) {
                JOptionPane.showMessageDialog  (this, ex, "Error", JOptionPane.ERROR_MESSAGE);
            } catch (SecurityException ex) {
                try {
                    bootFromJARFile ();
                    fADwinBooted = true;
                } catch (ADwinCommunicationError ace) {
                    JOptionPane.showMessageDialog  (this, ace, "Error", JOptionPane.ERROR_MESSAGE);
                } catch (IOException ioex) {
                    JOptionPane.showMessageDialog  (this, ioex, "Error", JOptionPane.ERROR_MESSAGE);
                }
            }
        } else if (e.getActionCommand().equals("SetPar")) {
            if (fADwinBooted == true) {
                try {
                    fADwin.Set_Par(1, Integer.parseInt(fTextfieldPAR1.getText()));
                } catch (ADwinCommunicationError ex) {
                    JOptionPane.showMessageDialog  (this, "Error when setting PAR_1 - " + ex.getMessage (), "Error", JOptionPane.ERROR_MESSAGE);
                    fADwinBooted = false;
                }
            }
        }
    }

    void bootFromJARFile () throws ADwinCommunicationError, IOException
    {
        URL resURL;
        if (fRadioT9.isSelected() == true) // T9
            resURL = getClass ().getClassLoader ().getResource ("adwin9.btl");
        else if (fRadioT10.isSelected ())   // T10
            resURL = getClass ().getClassLoader ().getResource ("adwin10.btl");
        else if (fRadioT11.isSelected ())   // T11
            resURL = getClass ().getClassLoader ().getResource ("adwin11.btl");
        else                                // T12
            resURL = getClass ().getClassLoader ().getResource ("adwin12.btl");

        if (resURL == null) {
            JOptionPane.showMessageDialog  (this, "BTL files could neither be found on your disk nor in the JAR archive\n" +
                                            "Please check your ADwin installation", "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }
        // Function is not officially documented. It uses an URL instead of a file name.
        fADwin.Boot (resURL);
    }


    private void showUIapplet()
    {
        Container cp = this.getContentPane();
        showUI(cp);
    }

    private void showUIapplication()
    {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        frame.setLocation(100, 100);

        frame.setTitle("ADwin Java Demo");

        Container cp = frame.getContentPane();
        showUI(cp);

        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }

    private void showUI(Container cp)
    {
        fADwinBooted = false;

        //

        final GridBagLayout gb = new GridBagLayout();
        final Insets insets = new Insets(4, 4, 4, 4);

        cp.setLayout(gb);

        //

        // GridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady)

        JLabel label = new JLabel("IP address");
        cp.add(label, new GridBagConstraints(0, 0, 1, 1, 0, 0, GridBagConstraints.EAST, GridBagConstraints.NONE, insets, 0, 0));

        fTextfieldIP = new JTextField(16);
        cp.add(fTextfieldIP, new GridBagConstraints(1, 0, 2, 1, 1.0, 0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, insets, 0, 0));

        //

        label = new JLabel("Processor");
        cp.add(label, new GridBagConstraints(0, 1, 1, 1, 0, 0, GridBagConstraints.EAST, GridBagConstraints.NONE, insets, 0, 0));

        JPanel panel = new JPanel();

        fRadioT9 = new JRadioButton("T9");
        fRadioT9.setActionCommand("T9");
        fRadioT9.addActionListener(this);
        fRadioT9.setSelected(true);
        panel.add(fRadioT9);

        fRadioT10 = new JRadioButton("T10");
        fRadioT10.setActionCommand("T10");
        fRadioT10.addActionListener(this);
        panel.add(fRadioT10);

        fRadioT11 = new JRadioButton("T11");
        fRadioT11.setActionCommand("T11");
        fRadioT11.addActionListener(this);
        panel.add(fRadioT11);

        fRadioT12 = new JRadioButton("T12");
        fRadioT12.setActionCommand("T12");
        fRadioT12.addActionListener(this);
        panel.add(fRadioT12);

        ButtonGroup group = new ButtonGroup();
        group.add(fRadioT9);
        group.add(fRadioT10);
        group.add(fRadioT11);
        group.add(fRadioT12);

        cp.add(panel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0, GridBagConstraints.WEST, GridBagConstraints.NONE, insets, 0, 0));

        //

        JButton button = new JButton("Boot");
        button.setActionCommand("boot");
        button.addActionListener(this);
        cp.add(button, new GridBagConstraints(1, 2, 2, 1, 1.0, 0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, insets, 0, 0));

        //

        label = new JLabel("PAR_1");
        cp.add(label, new GridBagConstraints(0, 3, 1, 1, 0, 0, GridBagConstraints.EAST, GridBagConstraints.NONE, insets, 0, 0));

        fTextfieldPAR1 = new JTextField(10);
        fTextfieldPAR1.addFocusListener(this);
        cp.add(fTextfieldPAR1, new GridBagConstraints(1, 3, 1, 1, 1.0, 0, GridBagConstraints.WEST, GridBagConstraints.BOTH, insets, 0, 0));

        JButton jb = new JButton ("Set");
        jb.setActionCommand ("SetPar");
        jb.addActionListener (this);
        cp.add (jb, new GridBagConstraints (2, 3, 1, 1, 0, 0, GridBagConstraints.WEST, GridBagConstraints.NONE, insets, 0, 0));

        //


        DemoTimerTask demott = new DemoTimerTask();

        java.util.Timer timer = new java.util.Timer();
        timer.schedule(demott, 0, 1000);
    }

    public static void main(String[] args)
    {
        Demo demo = new Demo();
        demo.showUIapplication();
    }

} // class DEMO
