// simple example application:
// demonstrates the use of device tables, how to boot, load a process and read a data field.

package de.adwin.examples;

import java.io.File;
import java.net.*;
import java.io.IOException;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import de.adwin.driver.ADwinDevice;
import de.adwin.driver.ADwinCommunicationError;

public class Simple
{
    public static void main (String[] args)
    {
        final String basePathName;
        
        try {
//			InetAddress ia = InetAddress.getByName("10.10.65.2");
			Socket socket = new Socket("10.10.65.2", 6543);	        
	        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
	        
	        // dos.write(b, off, len);
	        
	        
	        
		} catch (UnknownHostException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
        
        
        

        if (args.length != 2) {
            System.err.println ("Please specify an IP address and the processor\nof an ADwin System on the command line");
            System.err.println ("\nExample: java de.adwin.examples.simple 192.168.1.1 T9");
            return;
        }

        if (new File ("/etc/adwin/ADWINDIR").exists ()) {   // See where the BTL files are....
            // (Linux new)
            try {
                final BufferedReader reader = new BufferedReader (new FileReader ("/etc/adwin/ADWINDIR"));
                basePathName = reader.readLine () + "/share/btl/";
                reader.close ();
            } catch (IOException ioe) {
                System.err.println ("I/O-Error when reading from /etc/adwin/ADWINDIR - " + ioe.getMessage ());
                return;
            }
        } else if (new File ("/opt/adwin/share/btl").exists ())
            basePathName = "/opt/adwin/share/btl/";         // (Linux old)
        else
            basePathName = "c:\\adwin\\";                   // Windows

        final ADwinDevice ad = new ADwinDevice ();
        try {                               // Add the given ADwin System to the device table,
            ad.Add_Entry (1, InetAddress.getByName (args[0]), "", 3, 6543);
        } catch (UnknownHostException uhe) {
            System.err.println ("IP address " + args[0] + " is invalid - " + uhe.getMessage ());
            return;
        }

        try {
            ad.Set_DeviceNo (1);            // select it,
            // boot it with the right BTL file
            if (args[1].compareTo ("T9") == 0 || args[1].compareTo ("t9") == 0) {
                ad.Boot (basePathName + "adwin9.btl");
                ad.Load_Process ("simple.T91");
            } else if (args[1].compareTo ("T10") == 0 || args[1].compareTo ("t10") == 0) {
                ad.Boot (basePathName + "adwin10.btl");
                ad.Load_Process ("simple.TA1");
            } else if (args[1].compareTo ("T11") == 0 || args[1].compareTo ("t11") == 0) {
                ad.Boot (basePathName + "adwin11.btl");
                ad.Load_Process ("simple.TB1");
            } else if (args[1].compareTo ("T12") == 0 || args[1].compareTo ("t12") == 0) {
                ad.Boot (basePathName + "adwin12.btl");
                ad.Load_Process ("simple.TC1");   
            } else {
                System.err.println ("Sorry, only T9, T10, T11 and T12 are supported at the moment.");
                return;
            }

            ad.Start_Process (1);           // This process sets Par_1 when it has finished initializing,
            while (ad.Get_Par (1) != 1);    // please see the simple.bas file for details.

            String s = ad.GetData_String (1);   // Read a string from the ADwin system and display it
            System.out.println ("String read:   \"" + s + "\"");

            int IntData[] = new int[10];        // Read an integer data field
            ad.GetData_Long (2, IntData, 1, 10);
            System.out.print ("Integers read: ");
            for (int n = 0; n < 9; n++)
                System.out.print (IntData[n] + ", ");
            System.out.println (IntData[9]);
        } catch (ADwinCommunicationError ace) {
            ace.printStackTrace ();
            if (ace.getCode () == 200)                  // (File not found)
                System.out.println ("\nPossible reasons: The ADwin software (especially the BTL files) is not\n" +
                                    "correctly installed, or the process file (simple.T91, simple.TA1 or simple.TB1)\n" +
                                    "is not in the current directory");
            else if (ace.getCode () == 2001)            // (Network timeout)
                System.out.println ("\nPlease check if your ADwin system is properly connected and that you\n" +
                                    "did not mistype its IP address");
            else if (ace.getCode () == 1 || ace.getCode () == 2)    // (Timeout from or to link)
                System.out.println ("\nPossible reasons: The simple.* files are corrupted, BTL files are invalid or\n" +
                                    "wrong processor specified");
        }
    }
}
