/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDirectDevice;
import de.adwin.driver.DataToArrayConverter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;

class GetDataSHQueue {
    private final int[] queue;
    private int requestNumber;
    private int lastReceived;
    private final int packetIndex;
    private int queueInsertPointer;
    private int queueDeletePointer;
    private final DatagramSocket ds;
    private final ADwinDirectDevice add;
    private final InetAddress addr;
    private final int port;

    GetDataSHQueue(int size, int sentPacketIndex, DatagramSocket ds, ADwinDirectDevice add, InetAddress addr, int port) {
        this.queue = new int[size];
        this.packetIndex = sentPacketIndex;
        this.requestNumber = 0;
        this.ds = ds;
        this.add = add;
        this.addr = addr;
        this.port = port;
    }

    private int getMin() {
        int i;
        int min = 0;
        for (i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] == 0) continue;
            min = this.queue[i];
            break;
        }
        if (min == 0) {
            return 0;
        }
        while (i < this.queue.length) {
            if (this.queue[i] != 0 && this.queue[i] < min) {
                min = this.queue[i];
            }
            ++i;
        }
        return min;
    }

    private void deleteAll() {
        Arrays.fill(this.queue, 0);
    }

    private boolean deleteItem(int item) {
        if (this.queue[this.queueDeletePointer] == item) {
            this.queue[this.queueDeletePointer] = 0;
            ++this.queueDeletePointer;
            if (this.queueDeletePointer >= this.queue.length) {
                this.queueDeletePointer = 0;
            }
            return false;
        }
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] != item) continue;
            this.queue[i] = 0;
            this.queueDeletePointer = i + 1;
            if (this.queueDeletePointer >= this.queue.length) {
                this.queueDeletePointer = 0;
            }
            return false;
        }
        return true;
    }

    private boolean insertItem(int item) {
        int full = 0;
        do {
            if (this.queue[this.queueInsertPointer] == 0) {
                this.queue[this.queueInsertPointer] = item;
                ++this.queueInsertPointer;
                if (this.queueInsertPointer >= this.queue.length) {
                    this.queueInsertPointer = 0;
                }
                return true;
            }
            ++this.queueInsertPointer;
            if (this.queueInsertPointer < this.queue.length) continue;
            this.queueInsertPointer = 0;
        } while (++full != this.queue.length);
        return false;
    }

    private void sendRequest(int isRange, int p1, int p2, boolean enlist) throws ADwinCommunicationError {
        GetDataSHRequest gdshr;
        int min = 0;
        if (isRange != 2) {
            min = this.getMin();
            min = min == 0 ? this.lastReceived : --min;
        }
        switch (isRange) {
            case 0: {
                gdshr = new GetDataSHRequest(this.packetIndex, ++this.requestNumber, min, p1);
                break;
            }
            case 1: {
                gdshr = new GetDataSHRequest(this.packetIndex, ++this.requestNumber, min, p1, p2);
                break;
            }
            case 2: {
                gdshr = new GetDataSHRequest(this.packetIndex, ++this.requestNumber);
                break;
            }
            default: {
                throw new RuntimeException("invalid parameter isRange (" + isRange + ")");
            }
        }
        if (enlist) {
            if (isRange == 1) {
                for (int i = p1; i <= p2; ++i) {
                    this.insertItem(i);
                }
            } else if (isRange == 0) {
                this.insertItem(p1);
            }
        }
        DatagramPacket dp = gdshr.getPacket(this.addr, this.port);
        try {
            this.ds.send(dp);
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.add.Language, 2000);
        }
    }

    private void sendAll() throws ADwinCommunicationError {
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] == 0) continue;
            this.sendRequest(0, this.queue[i], 0, false);
        }
    }

    private void sendAllLessThan(int item) throws ADwinCommunicationError {
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] >= item || this.queue[i] == 0) continue;
            this.sendRequest(0, this.queue[i], 0, false);
        }
    }

    void getArraySH(int totalCount, DataToArrayConverter dtac) throws ADwinCommunicationError {
        int lastReceived = 0;
        int packetCount = totalCount / 336;
        if (totalCount % 336 != 0) {
            ++packetCount;
        }
        this.deleteAll();
        int isRange = 1;
        int p1 = 1;
        int lastPacket = packetCount <= 30 ? packetCount : 30;
        int p2 = lastPacket;
        for (int i = 1; i <= p2; ++i) {
            this.insertItem(i);
        }
        int openPackets = p2;
        int timeoutCounter = 0;
        byte[] bytes = new byte[1500];
        DatagramPacket dp = new DatagramPacket(bytes, 1500);
        while (openPackets > 0) {
            GetDataSHData gdshd;
            try {
                this.ds.setSoTimeout(this.add.MaxPacketDelay);
                this.ds.receive(dp);
                timeoutCounter = 0;
            }
            catch (SocketTimeoutException ste) {
                if (++timeoutCounter > this.add.AllowedErrors) {
                    throw new ADwinCommunicationError("timeout when waiting for the data field", "Timeout beim Warten auf das Data", this.add.Language, 2001);
                }
            }
            catch (IOException ioe) {
                throw new ADwinCommunicationError("I/O error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.add.Language, 2000);
            }
            if (timeoutCounter != 0) {
                this.sendAll();
            } else if (dp.getLength() == 1356 && (gdshd = new GetDataSHData(dp)).getPacketIndex() == this.packetIndex && !this.deleteItem(lastReceived = gdshd.getPacketNumber())) {
                --openPackets;
                dtac.storeBytes(bytes, 12, (lastReceived - 1) * 336, 336);
            }
            if (openPackets != 6 || lastPacket == packetCount) continue;
            p1 = lastPacket + 1;
            if (packetCount - lastPacket >= 24) {
                p2 = lastPacket + 30 - 6;
                openPackets += 24;
            } else if (lastPacket < packetCount) {
                p2 = packetCount;
                openPackets += packetCount - lastPacket;
            }
            this.sendAllLessThan(lastPacket - 6);
            lastPacket = p2;
            isRange = p1 == p2 ? 0 : 1;
            this.sendRequest(isRange, p1, p2, true);
        }
        try {
            this.sendRequest(2, 0, 0, false);
        }
        catch (ADwinCommunicationError aDwinCommunicationError) {
            // empty catch block
        }
    }

    class GetDataSHData {
        static final int PACKAGE_SIZE = 1344;
        static final int PARAM_SIZE = 12;
        static final int PACKET_SIZE = 1356;
        byte[] packetData;
        int packetIndex = 0;

        GetDataSHData(DatagramPacket dp) {
            this.packetData = dp.getData();
        }

        int getPacketIndex() {
            return ADwinDirectDevice.reverseByteOrder(ADwinDirectDevice.extractInt(this.packetData, 0));
        }

        int getPacketNumber() {
            return ADwinDirectDevice.reverseByteOrder(ADwinDirectDevice.extractInt(this.packetData, 4));
        }
    }

    class GetDataSHRequest {
        static final int REQ_SINGLE = 0;
        static final int REQ_RANGE = 1;
        static final int REQ_END = 2;
        int isRange = 0;
        int p1_firstRequested = 0;
        int p2_lastRequested = 0;
        int packetIndex = 0;
        int requestNumber = 0;
        int completePackets = 0;

        GetDataSHRequest() {
        }

        GetDataSHRequest(int packetIndex, int requestNumber, int completePackets, int p1) {
            this.isRange = 0;
            this.p1_firstRequested = p1;
            this.packetIndex = packetIndex;
            this.requestNumber = requestNumber;
            this.completePackets = completePackets;
        }

        GetDataSHRequest(int packetIndex, int requestNumber, int completePackets, int p1, int p2) {
            this.isRange = 1;
            this.p1_firstRequested = p1;
            this.p2_lastRequested = p2;
            this.packetIndex = packetIndex;
            this.requestNumber = requestNumber;
            this.completePackets = completePackets;
        }

        GetDataSHRequest(int packetIndex, int requestNumber) {
            this.isRange = 2;
            this.requestNumber = requestNumber;
            this.packetIndex = packetIndex;
        }

        DatagramPacket getPacket(InetAddress address, int port) {
            byte[] b = new byte[64];
            Arrays.fill(b, (byte)0);
            ADwinDirectDevice.setInteger(b, 0, ADwinDirectDevice.reverseByteOrder(this.packetIndex));
            ADwinDirectDevice.setInteger(b, 4, ADwinDirectDevice.reverseByteOrder(this.requestNumber));
            ADwinDirectDevice.setInteger(b, 8, ADwinDirectDevice.reverseByteOrder(this.completePackets));
            ADwinDirectDevice.setInteger(b, 12, ADwinDirectDevice.reverseByteOrder(this.isRange));
            ADwinDirectDevice.setInteger(b, 16, ADwinDirectDevice.reverseByteOrder(this.p1_firstRequested));
            ADwinDirectDevice.setInteger(b, 20, ADwinDirectDevice.reverseByteOrder(this.p2_lastRequested));
            return new DatagramPacket(b, 64, address, port);
        }
    }
}

