/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinDirectDevice;
import java.net.DatagramPacket;
import java.net.InetAddress;

class ADwinCommand {
    private final byte[] Data;
    private int Version = 0;
    private final int Port;

    public ADwinCommand(int Version, int DLLVersion, int Port) {
        this.Version = Version;
        this.Port = Port;
        this.Data = new byte[Version >= 252 && Version <= 259 || Version >= 264 ? 56 : 52];
        this.setTimeout(1000);
        this.setPwd("");
        if (this.Data.length == 56) {
            for (int n = 0; n < 4; ++n) {
                this.Data[n + 52] = (byte)(DLLVersion << (3 - n) * 8 >>> 24);
            }
        }
        this.Data[44] = 32;
    }

    public int getCommand() {
        return ADwinDirectDevice.extractInt(this.Data, 0);
    }

    public void setCommand(int Command) {
        for (int n = 0; n < 4; ++n) {
            this.Data[n] = (byte)(Command << (3 - n) * 8 >>> 24);
        }
    }

    public void setPacketIndex(int Index) {
        for (int n = 0; n < 4; ++n) {
            this.Data[n + 4] = (byte)(Index << (3 - n) * 8 >>> 24);
        }
    }

    public final void setPwd(String Pwd) {
        int n = 0;
        for (n = 0; n < 9 && n < Pwd.length(); ++n) {
            this.Data[n + 8] = (byte)Pwd.charAt(n);
        }
        this.Data[n + 8] = 0;
    }

    public void setValues(int[] Values2) {
        for (int i = 0; i < 4; ++i) {
            for (int n = 0; n < 4; ++n) {
                this.Data[n + 20 + i * 4] = (byte)(Values2[i] << (3 - n) * 8 >>> 24);
            }
        }
    }

    public void setLink(int Link) {
        for (int n = 0; n < 4; ++n) {
            this.Data[n + 36] = (byte)(Link << (3 - n) * 8 >>> 24);
        }
    }

    public final void setTimeout(int Timeout) {
        for (int n = 0; n < 4; ++n) {
            this.Data[n + 40] = (byte)(Timeout << (3 - n) * 8 >>> 24);
        }
    }

    public DatagramPacket getDatagram(InetAddress addr) {
        return new DatagramPacket(this.Data, this.Version >= 252 && this.Version <= 259 || this.Version >= 264 ? 56 : 52, addr, this.Port);
    }
}

