/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

abstract class DataToArrayConverter {
    static final int DATATYPE_DOUBLE = 6;
    static final int DATATYPE_INT64 = 7;
    protected int SourceType;
    private int offset = 0;
    final int size;

    DataToArrayConverter(int size) {
        this.size = size;
    }

    void setOffset(int offset) {
        this.offset = offset;
    }

    int getOffset() {
        return this.offset;
    }

    void storeBytes(byte[] Bytes, int BytesIndex, int IndexStart, int Amount) {
        int length = Amount;
        int start = IndexStart;
        int BytesPerValue = 4;
        if (this.SourceType == 6) {
            BytesPerValue = 8;
        }
        if (this.offset != 0) {
            start -= this.offset;
        }
        if (start < 0) {
            length += start;
            BytesIndex -= start * BytesPerValue;
            start = 0;
        }
        if (start + length > this.size) {
            length = this.size - start;
        }
        this.storeBytesImpl(Bytes, BytesIndex, start, length);
    }

    abstract void storeBytesImpl(byte[] var1, int var2, int var3, int var4);

    public void setSourceType(int SourceType) {
        if (SourceType == 4) {
            SourceType = 3;
        }
        this.SourceType = SourceType;
    }

    public int getSourceType() {
        return this.SourceType;
    }
}

